/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.openal;

import org.lwjglx.openal.AL;
import org.lwjglx.openal.AL10;
import org.lwjglx.openal.ALC10;
import org.lwjglx.openal.ALCcontext;
import org.lwjglx.openal.ALCdevice;
import org.lwjglx.openal.OpenALException;

public final class Util {
    private Util() {
    }

    public static void checkALCError(ALCdevice device) {
        int err = ALC10.alcGetError(device);
        if (err != 0) {
            throw new OpenALException(ALC10.alcGetString(AL.getDevice(), err));
        }
    }

    public static void checkALError() {
        int err = AL10.alGetError();
        if (err != 0) {
            throw new OpenALException(err);
        }
    }

    public static void checkALCValidDevice(ALCdevice device) {
        if (!device.isValid()) {
            throw new OpenALException("Invalid device: " + device);
        }
    }

    public static void checkALCValidContext(ALCcontext context) {
        if (!context.isValid()) {
            throw new OpenALException("Invalid context: " + context);
        }
    }
}

