/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.openal;

import org.lwjgl.openal.ALC;
import org.lwjgl.openal.EXTEfx;
import org.lwjglx.openal.AL10;
import org.lwjglx.openal.OpenALException;

public final class EFXUtil {
    private static final int EFFECT = 1111;
    private static final int FILTER = 2222;

    private EFXUtil() {
    }

    public static boolean isEfxSupported() {
        return ALC.getCapabilities().ALC_EXT_EFX;
    }

    public static boolean isEffectSupported(int effectType) {
        switch (effectType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 32768: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown or invalid effect type: " + effectType);
            }
        }
        return EFXUtil.testSupportGeneric(1111, effectType);
    }

    public static boolean isFilterSupported(int filterType) {
        switch (filterType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown or invalid filter type: " + filterType);
            }
        }
        return EFXUtil.testSupportGeneric(2222, filterType);
    }

    private static boolean testSupportGeneric(int objectType, int typeValue) {
        switch (objectType) {
            case 1111: 
            case 2222: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid objectType: " + objectType);
            }
        }
        boolean supported = false;
        if (EFXUtil.isEfxSupported()) {
            int genError;
            org.lwjgl.openal.AL10.alGetError();
            int testObject = 0;
            try {
                int n;
                switch (objectType) {
                    case 1111: {
                        n = EXTEfx.alGenEffects();
                        break;
                    }
                    case 2222: {
                        n = EXTEfx.alGenFilters();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid objectType: " + objectType);
                    }
                }
                testObject = n;
                genError = org.lwjgl.openal.AL10.alGetError();
            }
            catch (OpenALException debugBuildException) {
                genError = debugBuildException.getMessage().contains("AL_OUT_OF_MEMORY") ? 40965 : 40964;
            }
            if (genError == 0) {
                int setError;
                org.lwjgl.openal.AL10.alGetError();
                try {
                    switch (objectType) {
                        case 1111: {
                            EXTEfx.alEffecti((int)testObject, (int)32769, (int)typeValue);
                            break;
                        }
                        case 2222: {
                            EXTEfx.alFilteri((int)testObject, (int)32769, (int)typeValue);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Invalid objectType: " + objectType);
                        }
                    }
                    setError = org.lwjgl.openal.AL10.alGetError();
                }
                catch (OpenALException debugBuildException) {
                    setError = 40963;
                }
                if (setError == 0) {
                    supported = true;
                }
                try {
                    switch (objectType) {
                        case 1111: {
                            EXTEfx.alDeleteEffects((int)testObject);
                            break;
                        }
                        case 2222: {
                            EXTEfx.alDeleteFilters((int)testObject);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Invalid objectType: " + objectType);
                        }
                    }
                }
                catch (OpenALException openALException) {}
            } else if (genError == 40965) {
                throw new OpenALException(AL10.alGetString(genError));
            }
        }
        return supported;
    }
}

