/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.input;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.glfw.GLFW;
import org.lwjglx.LWJGLException;
import org.lwjglx.Sys;
import org.lwjglx.input.KeyCodes;
import org.lwjglx.opengl.Display;

public class Keyboard {
    public static final int CHAR_NONE = 0;
    public static final int KEY_NONE = 0;
    public static final int KEY_ESCAPE = 1;
    public static final int KEY_1 = 2;
    public static final int KEY_2 = 3;
    public static final int KEY_3 = 4;
    public static final int KEY_4 = 5;
    public static final int KEY_5 = 6;
    public static final int KEY_6 = 7;
    public static final int KEY_7 = 8;
    public static final int KEY_8 = 9;
    public static final int KEY_9 = 10;
    public static final int KEY_0 = 11;
    public static final int KEY_MINUS = 12;
    public static final int KEY_EQUALS = 13;
    public static final int KEY_BACK = 14;
    public static final int KEY_TAB = 15;
    public static final int KEY_Q = 16;
    public static final int KEY_W = 17;
    public static final int KEY_E = 18;
    public static final int KEY_R = 19;
    public static final int KEY_T = 20;
    public static final int KEY_Y = 21;
    public static final int KEY_U = 22;
    public static final int KEY_I = 23;
    public static final int KEY_O = 24;
    public static final int KEY_P = 25;
    public static final int KEY_LBRACKET = 26;
    public static final int KEY_RBRACKET = 27;
    public static final int KEY_RETURN = 28;
    public static final int KEY_LCONTROL = 29;
    public static final int KEY_A = 30;
    public static final int KEY_S = 31;
    public static final int KEY_D = 32;
    public static final int KEY_F = 33;
    public static final int KEY_G = 34;
    public static final int KEY_H = 35;
    public static final int KEY_J = 36;
    public static final int KEY_K = 37;
    public static final int KEY_L = 38;
    public static final int KEY_SEMICOLON = 39;
    public static final int KEY_APOSTROPHE = 40;
    public static final int KEY_GRAVE = 41;
    public static final int KEY_LSHIFT = 42;
    public static final int KEY_BACKSLASH = 43;
    public static final int KEY_Z = 44;
    public static final int KEY_X = 45;
    public static final int KEY_C = 46;
    public static final int KEY_V = 47;
    public static final int KEY_B = 48;
    public static final int KEY_N = 49;
    public static final int KEY_M = 50;
    public static final int KEY_COMMA = 51;
    public static final int KEY_PERIOD = 52;
    public static final int KEY_SLASH = 53;
    public static final int KEY_RSHIFT = 54;
    public static final int KEY_MULTIPLY = 55;
    public static final int KEY_LMENU = 56;
    public static final int KEY_SPACE = 57;
    public static final int KEY_CAPITAL = 58;
    public static final int KEY_F1 = 59;
    public static final int KEY_F2 = 60;
    public static final int KEY_F3 = 61;
    public static final int KEY_F4 = 62;
    public static final int KEY_F5 = 63;
    public static final int KEY_F6 = 64;
    public static final int KEY_F7 = 65;
    public static final int KEY_F8 = 66;
    public static final int KEY_F9 = 67;
    public static final int KEY_F10 = 68;
    public static final int KEY_NUMLOCK = 69;
    public static final int KEY_SCROLL = 70;
    public static final int KEY_NUMPAD7 = 71;
    public static final int KEY_NUMPAD8 = 72;
    public static final int KEY_NUMPAD9 = 73;
    public static final int KEY_SUBTRACT = 74;
    public static final int KEY_NUMPAD4 = 75;
    public static final int KEY_NUMPAD5 = 76;
    public static final int KEY_NUMPAD6 = 77;
    public static final int KEY_ADD = 78;
    public static final int KEY_NUMPAD1 = 79;
    public static final int KEY_NUMPAD2 = 80;
    public static final int KEY_NUMPAD3 = 81;
    public static final int KEY_NUMPAD0 = 82;
    public static final int KEY_DECIMAL = 83;
    public static final int KEY_F11 = 87;
    public static final int KEY_F12 = 88;
    public static final int KEY_F13 = 100;
    public static final int KEY_F14 = 101;
    public static final int KEY_F15 = 102;
    public static final int KEY_F16 = 103;
    public static final int KEY_F17 = 104;
    public static final int KEY_F18 = 105;
    public static final int KEY_KANA = 112;
    public static final int KEY_F19 = 113;
    public static final int KEY_CONVERT = 121;
    public static final int KEY_NOCONVERT = 123;
    public static final int KEY_YEN = 125;
    public static final int KEY_NUMPADEQUALS = 141;
    public static final int KEY_CIRCUMFLEX = 144;
    public static final int KEY_AT = 145;
    public static final int KEY_COLON = 146;
    public static final int KEY_UNDERLINE = 147;
    public static final int KEY_KANJI = 148;
    public static final int KEY_STOP = 149;
    public static final int KEY_AX = 150;
    public static final int KEY_UNLABELED = 151;
    public static final int KEY_NUMPADENTER = 156;
    public static final int KEY_RCONTROL = 157;
    public static final int KEY_SECTION = 167;
    public static final int KEY_NUMPADCOMMA = 179;
    public static final int KEY_DIVIDE = 181;
    public static final int KEY_SYSRQ = 183;
    public static final int KEY_RMENU = 184;
    public static final int KEY_FUNCTION = 196;
    public static final int KEY_PAUSE = 197;
    public static final int KEY_HOME = 199;
    public static final int KEY_UP = 200;
    public static final int KEY_PRIOR = 201;
    public static final int KEY_LEFT = 203;
    public static final int KEY_RIGHT = 205;
    public static final int KEY_END = 207;
    public static final int KEY_DOWN = 208;
    public static final int KEY_NEXT = 209;
    public static final int KEY_INSERT = 210;
    public static final int KEY_DELETE = 211;
    public static final int KEY_CLEAR = 218;
    public static final int KEY_LMETA = 219;
    public static final int KEY_LWIN = 219;
    public static final int KEY_RMETA = 220;
    public static final int KEY_RWIN = 220;
    public static final int KEY_APPS = 221;
    public static final int KEY_POWER = 222;
    public static final int KEY_SLEEP = 223;
    public static final int keyCount;
    private static boolean doRepeatEvents;
    public static final int KEYBOARD_SIZE = Short.MAX_VALUE;
    public static Queue<KeyEvent> eventQueue;
    private static final String[] keyName;
    private static final Map<String, Integer> keyMap;

    public static void addGlfwKeyEvent(long window, int key, int scancode, int action, int mods, char c) {
        KeyState state;
        switch (action) {
            case 1: {
                state = KeyState.PRESS;
                break;
            }
            case 0: {
                state = KeyState.RELEASE;
                break;
            }
            case 2: {
                state = KeyState.REPEAT;
                if (doRepeatEvents) break;
                return;
            }
            default: {
                state = KeyState.RELEASE;
            }
        }
        try {
            eventQueue.add(new KeyEvent(KeyCodes.glfwToLwjgl(key), c, state, Sys.getNanoTime()));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static void addKeyEvent(int key, boolean pressed) {
        try {
            eventQueue.add(new KeyEvent(key, '\u0000', pressed ? KeyState.PRESS : KeyState.RELEASE, Sys.getNanoTime()));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static void addCharEvent(int key, char c) {
        try {
            eventQueue.add(new KeyEvent(0, c, KeyState.PRESS, Sys.getNanoTime()));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static void create() throws LWJGLException {
    }

    public static boolean isKeyDown(int key) {
        return GLFW.glfwGetKey((long)Display.getWindow(), (int)KeyCodes.lwjglToGlfw(key)) == 1;
    }

    public static void poll() {
    }

    public static void enableRepeatEvents(boolean enable) {
        doRepeatEvents = enable;
    }

    public static boolean areRepeatEventsEnabled() {
        return doRepeatEvents;
    }

    public static int getKeyCount() {
        return keyCount;
    }

    public static int getNumKeyboardEvents() {
        return eventQueue.size();
    }

    public static boolean isRepeatEvent() {
        return Keyboard.eventQueue.peek().state == KeyState.REPEAT;
    }

    public static boolean next() {
        boolean next;
        boolean bl = next = eventQueue.size() > 1;
        if (next) {
            eventQueue.remove();
        }
        return next;
    }

    public static int getEventKey() {
        return Keyboard.eventQueue.peek().key;
    }

    public static char getEventCharacter() {
        return Keyboard.eventQueue.peek().aChar;
    }

    public static boolean getEventKeyState() {
        return Keyboard.eventQueue.peek().state.isPressed;
    }

    public static long getEventNanoseconds() {
        return Keyboard.eventQueue.peek().nano;
    }

    public static String getKeyName(int key) {
        if (key >= 0 && key < keyName.length) {
            return keyName[key];
        }
        return "Key " + key;
    }

    public static int getKeyIndex(String keyName) {
        Integer ret = keyMap.get(keyName);
        if (ret == null) {
            if (keyName.matches("Key -?[0-9]+]")) {
                return Integer.parseInt(StringUtils.removeStart((String)keyName, (String)"Key "));
            }
            return 0;
        }
        return ret;
    }

    public static boolean isCreated() {
        return Display.isCreated();
    }

    public static void destroy() {
    }

    static {
        doRepeatEvents = true;
        eventQueue = new ArrayBlockingQueue<KeyEvent>(256);
        keyName = new String[Short.MAX_VALUE];
        keyMap = new HashMap<String, Integer>(Short.MAX_VALUE);
        Field[] fields = Keyboard.class.getFields();
        int keyCounter = 0;
        try {
            for (Field field : fields) {
                String name;
                if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isPublic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers()) || !field.getType().equals(Integer.TYPE) || !field.getName().startsWith("KEY_") || field.getName().endsWith("WIN")) continue;
                int key = field.getInt(null);
                Keyboard.keyName[key] = name = field.getName().substring(4);
                ++keyCounter;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        keyCount = keyCounter;
        for (int i = 0; i < keyName.length; ++i) {
            if (keyName[i] == null) {
                Keyboard.keyName[i] = "Key " + i;
            }
            keyMap.put(keyName[i], i);
        }
        eventQueue.add(new KeyEvent(0, '\u0000', KeyState.RELEASE, Sys.getNanoTime()));
    }

    public static enum KeyState {
        PRESS(true),
        RELEASE(false),
        REPEAT(true);

        public final boolean isPressed;

        private KeyState(boolean isPressed) {
            this.isPressed = isPressed;
        }
    }

    public static class KeyEvent {
        public int key;
        public char aChar;
        public KeyState state;
        public long nano;

        public KeyEvent(int key, char aChar, KeyState state, long nano) {
            this.key = key;
            this.aChar = aChar;
            this.state = state;
            this.nano = nano;
        }
    }
}

