/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.api.task;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import ru.timeconqueror.lootgames.api.task.ITask;
import ru.timeconqueror.lootgames.utils.future.BlockPos;
import ru.timeconqueror.lootgames.utils.future.WorldExt;

public class TaskCreateExplosion
implements ITask {
    protected double x;
    private double y;
    private double z;
    private float strength;
    private boolean affectBlocks;

    public TaskCreateExplosion() {
    }

    public TaskCreateExplosion(BlockPos pos, float strength, boolean affectBlocks) {
        this(pos.getX(), pos.getY(), pos.getZ(), strength, affectBlocks);
    }

    public TaskCreateExplosion(double x, double y, double z, float strength, boolean affectBlocks) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.strength = strength;
        this.affectBlocks = affectBlocks;
    }

    @Override
    public void run(World world) {
        WorldExt.explode(world, null, this.x, this.y, this.z, this.strength, false);
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound c = new NBTTagCompound();
        c.func_74780_a("x", this.x);
        c.func_74780_a("y", this.y);
        c.func_74780_a("z", this.z);
        c.func_74776_a("strength", this.strength);
        c.func_74757_a("affect_blocks", this.affectBlocks);
        return c;
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        this.x = nbt.func_74769_h("x");
        this.y = nbt.func_74769_h("y");
        this.z = nbt.func_74769_h("z");
        this.strength = nbt.func_74760_g("strength");
        this.affectBlocks = nbt.func_74767_n("affect_blocks");
    }
}

