/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.api.minigame;

import com.google.common.collect.Iterables;
import eu.usrv.legacylootgames.blocks.DungeonBrick;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import ru.timeconqueror.lootgames.api.block.BoardBorderBlock;
import ru.timeconqueror.lootgames.api.block.IGameField;
import ru.timeconqueror.lootgames.api.block.tile.GameMasterTile;
import ru.timeconqueror.lootgames.api.minigame.NotifyColor;
import ru.timeconqueror.lootgames.registry.LGBlocks;
import ru.timeconqueror.lootgames.registry.LGSounds;
import ru.timeconqueror.lootgames.utils.future.BlockPos;
import ru.timeconqueror.lootgames.utils.future.BlockState;
import ru.timeconqueror.lootgames.utils.future.ChatComponentExt;
import ru.timeconqueror.lootgames.utils.future.WorldExt;
import ru.timeconqueror.timecore.api.util.BlockPosUtils;
import ru.timeconqueror.timecore.api.util.CollectionUtils;
import ru.timeconqueror.timecore.api.util.NetworkUtils;
import ru.timeconqueror.timecore.api.util.WorldUtils;

public class FieldManager {
    private boolean fieldUnderBreaking = false;

    public void onFieldBlockBroken(World worldIn, Supplier<BlockPos> masterPosGetter) {
        if (this.tryStartFieldBreaking()) {
            BlockPos masterPos = masterPosGetter.get();
            TileEntity tileEntity = WorldExt.getTileEntity(worldIn, masterPos);
            if (tileEntity instanceof GameMasterTile) {
                ((GameMasterTile)tileEntity).onDestroy();
            }
            this.stopFieldBreaking();
        }
    }

    public boolean tryStartFieldBreaking() {
        if (!this.fieldUnderBreaking) {
            this.fieldUnderBreaking = true;
            return true;
        }
        return false;
    }

    public void stopFieldBreaking() {
        this.fieldUnderBreaking = false;
    }

    public boolean canReplaceAreaWithBoard(World world, BlockPos cornerPos, int xSize, int ySize, int zSize, @Nullable BlockPos except) {
        Iterable positions = Iterables.concat(BlockPosUtils.between(cornerPos, xSize, 1, zSize), BlockPosUtils.between(cornerPos.offset(1, 1, 1), xSize - 2, ySize - 1, zSize - 2));
        return CollectionUtils.allMatch(positions, pos -> {
            BlockState state = WorldExt.getBlockState(world, pos);
            return state.getBlock() == LGBlocks.DUNGEON_WALL && state.getMeta() == DungeonBrick.Type.FLOOR_SHIELDED.ordinal() || state.getBlock().func_149688_o().func_76222_j() || pos.equals(except);
        });
    }

    public GenerationChain trySetupBoard(WorldServer world, BlockPos centerPos, int xSize, int height, int zSize, Block masterBlock, @Nullable EntityPlayer player) {
        int i;
        BlockPos cornerPos = centerPos.offset(-xSize / 2 - 1, 0, -zSize / 2 - 1);
        BlockPos.Mutable borderPos = cornerPos.mutable();
        if (!this.canReplaceAreaWithBoard((World)world, borderPos, xSize + 2, height + 1, zSize + 2, centerPos)) {
            if (player != null) {
                NetworkUtils.sendMessage(player, (IChatComponent)ChatComponentExt.withStyle(new ChatComponentTranslation("msg.lootgames.field.not_enough_space", new Object[]{xSize + 2, height + 1, zSize + 2}), NotifyColor.FAIL.getColor()));
                WorldExt.playSoundServerly((World)world, centerPos, LGSounds.GAME_LOSE, 0.4f, 1.0f);
            }
            return new GenerationChain(null, null, false);
        }
        for (BlockPos pos : BlockPosUtils.between(cornerPos.offset(1, 0, 1), xSize, 1, zSize)) {
            WorldExt.setBlock((World)world, pos, LGBlocks.SMART_SUBORDINATE, 2);
        }
        long end3 = System.currentTimeMillis();
        if (height > 0) {
            BlockPos abovePos = borderPos.offset(1, 1, 1);
            for (BlockPos pos : BlockPosUtils.between(abovePos, xSize, height, zSize)) {
                WorldExt.setBlock((World)world, pos, Blocks.field_150350_a, 0, 2);
            }
        }
        WorldExt.setBlock((World)world, cornerPos, masterBlock, 3);
        borderPos.move(xSize + 1, 0, 0);
        WorldExt.setBlock((World)world, borderPos, LGBlocks.BOARD_BORDER, BoardBorderBlock.Type.TOP_RIGHT.ordinal(), 2);
        borderPos.move(0, 0, zSize + 1);
        WorldExt.setBlock((World)world, borderPos, LGBlocks.BOARD_BORDER, BoardBorderBlock.Type.BOTTOM_RIGHT.ordinal(), 2);
        borderPos.move(-xSize - 1, 0, 0);
        WorldExt.setBlock((World)world, borderPos, LGBlocks.BOARD_BORDER, BoardBorderBlock.Type.BOTTOM_LEFT.ordinal(), 2);
        borderPos.set(cornerPos);
        for (i = 0; i < xSize; ++i) {
            borderPos.move(1, 0, 0);
            WorldExt.setBlock((World)world, borderPos, LGBlocks.BOARD_BORDER, BoardBorderBlock.Type.HORIZONTAL.ordinal(), 2);
            borderPos.move(0, 0, zSize + 1);
            WorldExt.setBlock((World)world, borderPos, LGBlocks.BOARD_BORDER, BoardBorderBlock.Type.HORIZONTAL.ordinal(), 2);
            borderPos.move(0, 0, -zSize - 1);
        }
        borderPos.set(cornerPos);
        for (i = 0; i < xSize; ++i) {
            borderPos.move(0, 0, 1);
            WorldExt.setBlock((World)world, borderPos, LGBlocks.BOARD_BORDER, BoardBorderBlock.Type.VERTICAL.ordinal(), 2);
            borderPos.move(xSize + 1, 0, 0);
            WorldExt.setBlock((World)world, borderPos, LGBlocks.BOARD_BORDER, BoardBorderBlock.Type.VERTICAL.ordinal(), 2);
            borderPos.move(-xSize - 1, 0, 0);
        }
        return new GenerationChain((World)world, cornerPos, true);
    }

    public void clearBoard(WorldServer world, BlockPos start, int sizeX, int sizeZ) {
        Iterable<BlockPos> gameBlocks = BlockPos.betweenClosed(start.offset(-1, 0, -1), start.offset(sizeX + 1, 0, sizeZ + 1));
        for (BlockPos pos : gameBlocks) {
            if (!(WorldExt.getBlock((World)world, pos) instanceof IGameField)) continue;
            WorldExt.setBlockToAir((World)world, pos);
        }
    }

    public static class GenerationChain {
        private final World world;
        private final BlockPos pos;
        private final boolean succeed;

        private GenerationChain(World world, BlockPos masterPos, boolean succeed) {
            this.world = world;
            this.succeed = succeed;
            this.pos = masterPos;
        }

        public <T extends GameMasterTile<?>> GenerationChain forTileIfSucceed(Class<T> tileClass, Consumer<T> action) {
            if (this.succeed) {
                WorldUtils.forTileWithReqt(this.world, this.pos, tileClass, action);
            }
            return this;
        }

        public boolean isSucceed() {
            return this.succeed;
        }
    }
}

