/*
 * Decompiled with CFR 0.152.
 */
package com.jamesswafford.chess4j.board;

import com.jamesswafford.chess4j.Color;
import com.jamesswafford.chess4j.board.AttackDetector;
import com.jamesswafford.chess4j.board.Bitboard;
import com.jamesswafford.chess4j.board.CastlingRights;
import com.jamesswafford.chess4j.board.Move;
import com.jamesswafford.chess4j.board.MyCastlingRights;
import com.jamesswafford.chess4j.board.Undo;
import com.jamesswafford.chess4j.board.squares.File;
import com.jamesswafford.chess4j.board.squares.North;
import com.jamesswafford.chess4j.board.squares.Rank;
import com.jamesswafford.chess4j.board.squares.South;
import com.jamesswafford.chess4j.board.squares.Square;
import com.jamesswafford.chess4j.hash.Zobrist;
import com.jamesswafford.chess4j.pieces.Bishop;
import com.jamesswafford.chess4j.pieces.King;
import com.jamesswafford.chess4j.pieces.Knight;
import com.jamesswafford.chess4j.pieces.Pawn;
import com.jamesswafford.chess4j.pieces.Piece;
import com.jamesswafford.chess4j.pieces.Queen;
import com.jamesswafford.chess4j.pieces.Rook;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Board {
    public static final Board INSTANCE = new Board();
    private List<Undo> undoStack = new ArrayList<Undo>();
    private Map<Square, Piece> pieceMap = new HashMap<Square, Piece>();
    private Map<Piece, Integer> pieceCountsMap = new HashMap<Piece, Integer>();
    private MyCastlingRights castlingRights = new MyCastlingRights();
    private Color playerToMove;
    private Square epSquare;
    private Square whiteKingSquare;
    private Square blackKingSquare;
    private int moveCounter;
    private int fiftyCounter;
    private long whitePawns;
    private long blackPawns;
    private long whiteKnights;
    private long blackKnights;
    private long whiteBishops;
    private long blackBishops;
    private long whiteRooks;
    private long blackRooks;
    private long whiteQueens;
    private long blackQueens;
    private long whitePieces;
    private long blackPieces;
    private long zobristKey;
    private long pawnKey;

    private Board() {
        this.resetBoard();
    }

    public void addCastlingRight(CastlingRights castlingRight) {
        if (castlingRight == CastlingRights.WHITE_KINGSIDE) {
            if (!this.castlingRights.isWhiteKingside()) {
                this.castlingRights.setWhiteKingside();
                this.zobristKey ^= Zobrist.getCastlingKey(castlingRight);
            }
        } else if (castlingRight == CastlingRights.WHITE_QUEENSIDE) {
            if (!this.castlingRights.isWhiteQueenside()) {
                this.castlingRights.setWhiteQueenside();
                this.zobristKey ^= Zobrist.getCastlingKey(castlingRight);
            }
        } else if (castlingRight == CastlingRights.BLACK_KINGSIDE) {
            if (!this.castlingRights.isBlackKingside()) {
                this.castlingRights.setBlackKingside();
                this.zobristKey ^= Zobrist.getCastlingKey(castlingRight);
            }
        } else if (castlingRight == CastlingRights.BLACK_QUEENSIDE) {
            if (!this.castlingRights.isBlackQueenside()) {
                this.castlingRights.setBlackQueenside();
                this.zobristKey ^= Zobrist.getCastlingKey(castlingRight);
            }
        } else {
            throw new IllegalArgumentException("illegal castling right: " + (Object)((Object)castlingRight));
        }
    }

    public void addPiece(Piece p, Square s) {
        if (p != null) {
            this.pieceMap.put(s, p);
            this.pieceCountsMap.put(p, this.pieceCountsMap.get(p) + 1);
            this.zobristKey ^= Zobrist.getPieceKey(s, p);
            long bb = Bitboard.squares[s.value()];
            if (p.isWhite()) {
                this.whitePieces |= bb;
                if (p == Pawn.WHITE_PAWN) {
                    this.whitePawns |= bb;
                    this.pawnKey ^= Zobrist.getPieceKey(s, p);
                } else if (p == Knight.WHITE_KNIGHT) {
                    this.whiteKnights |= bb;
                } else if (p == Bishop.WHITE_BISHOP) {
                    this.whiteBishops |= bb;
                } else if (p == Rook.WHITE_ROOK) {
                    this.whiteRooks |= bb;
                } else if (p == Queen.WHITE_QUEEN) {
                    this.whiteQueens |= bb;
                }
            } else {
                this.blackPieces |= bb;
                if (p == Pawn.BLACK_PAWN) {
                    this.blackPawns |= bb;
                    this.pawnKey ^= Zobrist.getPieceKey(s, p);
                } else if (p == Knight.BLACK_KNIGHT) {
                    this.blackKnights |= bb;
                } else if (p == Bishop.BLACK_BISHOP) {
                    this.blackBishops |= bb;
                } else if (p == Rook.BLACK_ROOK) {
                    this.blackRooks |= bb;
                } else if (p == Queen.BLACK_QUEEN) {
                    this.blackQueens |= bb;
                }
            }
        }
    }

    private void applyKingSpecialCases(Move m) {
        if (this.playerToMove.isWhite()) {
            this.whiteKingSquare = m.to();
            this.clearCastlingRight(CastlingRights.WHITE_KINGSIDE);
            this.clearCastlingRight(CastlingRights.WHITE_QUEENSIDE);
            if (m.from().equals(Square.valueOf(File.FILE_E, Rank.RANK_1))) {
                if (m.to().equals(Square.valueOf(File.FILE_G, Rank.RANK_1))) {
                    this.fiftyCounter = 0;
                    this.movePiece(Square.valueOf(File.FILE_H, Rank.RANK_1), Square.valueOf(File.FILE_F, Rank.RANK_1));
                } else if (m.to().equals(Square.valueOf(File.FILE_C, Rank.RANK_1))) {
                    this.fiftyCounter = 0;
                    this.movePiece(Square.valueOf(File.FILE_A, Rank.RANK_1), Square.valueOf(File.FILE_D, Rank.RANK_1));
                }
            }
        } else {
            this.blackKingSquare = m.to();
            this.clearCastlingRight(CastlingRights.BLACK_KINGSIDE);
            this.clearCastlingRight(CastlingRights.BLACK_QUEENSIDE);
            if (m.from().equals(Square.valueOf(File.FILE_E, Rank.RANK_8))) {
                if (m.to().equals(Square.valueOf(File.FILE_G, Rank.RANK_8))) {
                    this.fiftyCounter = 0;
                    this.movePiece(Square.valueOf(File.FILE_H, Rank.RANK_8), Square.valueOf(File.FILE_F, Rank.RANK_8));
                } else if (m.to().equals(Square.valueOf(File.FILE_C, Rank.RANK_8))) {
                    this.fiftyCounter = 0;
                    this.movePiece(Square.valueOf(File.FILE_A, Rank.RANK_8), Square.valueOf(File.FILE_D, Rank.RANK_8));
                }
            }
        }
    }

    public void applyMove(Move m) {
        assert (this.verify());
        this.undoStack.add(new Undo(m, this.fiftyCounter, this.castlingRights.getValue(), this.epSquare, this.zobristKey));
        ++this.moveCounter;
        if (m.captured() == null) {
            ++this.fiftyCounter;
        } else {
            this.fiftyCounter = 0;
            if (m.to().equals(Square.valueOf(File.FILE_H, Rank.RANK_1))) {
                this.clearCastlingRight(CastlingRights.WHITE_KINGSIDE);
            } else if (m.to().equals(Square.valueOf(File.FILE_A, Rank.RANK_1))) {
                this.clearCastlingRight(CastlingRights.WHITE_QUEENSIDE);
            }
            if (m.to().equals(Square.valueOf(File.FILE_H, Rank.RANK_8))) {
                this.clearCastlingRight(CastlingRights.BLACK_KINGSIDE);
            } else if (m.to().equals(Square.valueOf(File.FILE_A, Rank.RANK_8))) {
                this.clearCastlingRight(CastlingRights.BLACK_QUEENSIDE);
            }
        }
        Piece p = this.clearSquare(m.from());
        Square oldEPSquare = this.clearEPSquare();
        if (p instanceof Pawn) {
            this.applyPawnMove(p, m, oldEPSquare);
        } else {
            if (m.captured() != null) {
                this.clearSquare(m.to());
            }
            this.addPiece(p, m.to());
            if (p instanceof King) {
                this.applyKingSpecialCases(m);
            } else if (p instanceof Rook) {
                this.applyRookSpecialCases(m);
            }
        }
        this.swapPlayer();
        assert (this.verify());
    }

    private void applyPawnMove(Piece p, Move m, Square oldEPSquare) {
        this.fiftyCounter = 0;
        if (p.isWhite()) {
            if (m.from().rank().equals((Object)Rank.RANK_2) && m.to().rank().equals((Object)Rank.RANK_4)) {
                this.addPiece(p, m.to());
                this.epSquare = Square.valueOf(m.to().file(), m.to().rank().south());
                this.zobristKey ^= Zobrist.getEnPassantKey(this.epSquare);
            } else if (m.to().equals(oldEPSquare)) {
                this.clearSquare(Square.valueOf(oldEPSquare.file(), oldEPSquare.rank().south()));
                this.addPiece(p, m.to());
            } else if (m.to().rank().equals((Object)Rank.RANK_8)) {
                this.clearSquare(m.to());
                this.addPiece(m.promotion(), m.to());
            } else {
                this.clearSquare(m.to());
                this.addPiece(p, m.to());
            }
        } else if (m.from().rank().equals((Object)Rank.RANK_7) && m.to().rank().equals((Object)Rank.RANK_5)) {
            this.addPiece(p, m.to());
            this.epSquare = Square.valueOf(m.to().file(), m.to().rank().north());
            this.zobristKey ^= Zobrist.getEnPassantKey(this.epSquare);
        } else if (m.to().equals(oldEPSquare)) {
            this.clearSquare(Square.valueOf(oldEPSquare.file(), oldEPSquare.rank().north()));
            this.addPiece(p, m.to());
        } else if (m.to().rank().equals((Object)Rank.RANK_1)) {
            this.clearSquare(m.to());
            this.addPiece(m.promotion(), m.to());
        } else {
            this.clearSquare(m.to());
            this.addPiece(p, m.to());
        }
    }

    private void applyRookSpecialCases(Move m) {
        if (this.playerToMove.isWhite()) {
            if (m.from().equals(Square.valueOf(File.FILE_H, Rank.RANK_1))) {
                this.fiftyCounter = 0;
                this.clearCastlingRight(CastlingRights.WHITE_KINGSIDE);
            } else if (m.from().equals(Square.valueOf(File.FILE_A, Rank.RANK_1))) {
                this.fiftyCounter = 0;
                this.clearCastlingRight(CastlingRights.WHITE_QUEENSIDE);
            }
        } else if (m.from().equals(Square.valueOf(File.FILE_H, Rank.RANK_8))) {
            this.fiftyCounter = 0;
            this.clearCastlingRight(CastlingRights.BLACK_KINGSIDE);
        } else if (m.from().equals(Square.valueOf(File.FILE_A, Rank.RANK_8))) {
            this.fiftyCounter = 0;
            this.clearCastlingRight(CastlingRights.BLACK_QUEENSIDE);
        }
    }

    private boolean blackCanCastleKingSide() {
        boolean pathIsClear;
        if (!this.hasCastlingRight(CastlingRights.BLACK_KINGSIDE)) {
            return false;
        }
        boolean bl = pathIsClear = this.isEmpty(Square.valueOf(File.FILE_F, Rank.RANK_8)) && this.isEmpty(Square.valueOf(File.FILE_G, Rank.RANK_8));
        if (!pathIsClear) {
            return false;
        }
        Color opponent = Color.swap(this.playerToMove);
        boolean wouldCrossCheck = AttackDetector.attacked(this, Square.valueOf(File.FILE_E, Rank.RANK_8), opponent) || AttackDetector.attacked(this, Square.valueOf(File.FILE_F, Rank.RANK_8), opponent);
        return !wouldCrossCheck;
    }

    private boolean blackCanCastleQueenSide() {
        boolean pathIsClear;
        if (!this.hasCastlingRight(CastlingRights.BLACK_QUEENSIDE)) {
            return false;
        }
        boolean bl = pathIsClear = this.isEmpty(Square.valueOf(File.FILE_D, Rank.RANK_8)) && this.isEmpty(Square.valueOf(File.FILE_C, Rank.RANK_8)) && this.isEmpty(Square.valueOf(File.FILE_B, Rank.RANK_8));
        if (!pathIsClear) {
            return false;
        }
        Color opponent = Color.swap(this.playerToMove);
        boolean wouldCrossCheck = AttackDetector.attacked(this, Square.valueOf(File.FILE_E, Rank.RANK_8), opponent) || AttackDetector.attacked(this, Square.valueOf(File.FILE_D, Rank.RANK_8), opponent);
        return !wouldCrossCheck;
    }

    public boolean canCastle(CastlingRights cr) {
        if (cr.equals((Object)CastlingRights.WHITE_KINGSIDE)) {
            return this.whiteCanCastleKingSide();
        }
        if (cr.equals((Object)CastlingRights.WHITE_QUEENSIDE)) {
            return this.whiteCanCastleQueenSide();
        }
        if (cr.equals((Object)CastlingRights.BLACK_KINGSIDE)) {
            return this.blackCanCastleKingSide();
        }
        return this.blackCanCastleQueenSide();
    }

    public void clearBoard() {
        List<Square> squares = Square.allSquares();
        for (Square sq : squares) {
            this.clearSquare(sq);
        }
        this.clearEPSquare();
        EnumSet<CastlingRights> crs = EnumSet.allOf(CastlingRights.class);
        for (CastlingRights cr : crs) {
            this.clearCastlingRight(cr);
        }
        this.fiftyCounter = 0;
        this.undoStack.clear();
        assert (this.pieceCountsMap.get(Pawn.WHITE_PAWN) == 0);
        assert (this.pieceCountsMap.get(Pawn.BLACK_PAWN) == 0);
        assert (this.pieceCountsMap.get(Queen.WHITE_QUEEN) == 0);
        assert (this.pieceCountsMap.get(Queen.BLACK_QUEEN) == 0);
        assert (this.pieceCountsMap.get(Rook.WHITE_ROOK) == 0);
        assert (this.pieceCountsMap.get(Rook.BLACK_ROOK) == 0);
        assert (this.pieceCountsMap.get(Knight.WHITE_KNIGHT) == 0);
        assert (this.pieceCountsMap.get(Knight.BLACK_KNIGHT) == 0);
        assert (this.pieceCountsMap.get(Bishop.WHITE_BISHOP) == 0);
        assert (this.pieceCountsMap.get(Bishop.BLACK_BISHOP) == 0);
    }

    public void clearCastlingRight(CastlingRights castlingRight) {
        if (castlingRight == CastlingRights.WHITE_KINGSIDE) {
            if (this.castlingRights.isWhiteKingside()) {
                this.castlingRights.removeWhiteKingside();
                this.zobristKey ^= Zobrist.getCastlingKey(castlingRight);
            }
        } else if (castlingRight == CastlingRights.WHITE_QUEENSIDE) {
            if (this.castlingRights.isWhiteQueenside()) {
                this.castlingRights.removeWhiteQueenside();
                this.zobristKey ^= Zobrist.getCastlingKey(castlingRight);
            }
        } else if (castlingRight == CastlingRights.BLACK_KINGSIDE) {
            if (this.castlingRights.isBlackKingside()) {
                this.castlingRights.removeBlackKingside();
                this.zobristKey ^= Zobrist.getCastlingKey(castlingRight);
            }
        } else if (castlingRight == CastlingRights.BLACK_QUEENSIDE) {
            if (this.castlingRights.isBlackQueenside()) {
                this.castlingRights.removeBlackQueenside();
                this.zobristKey ^= Zobrist.getCastlingKey(castlingRight);
            }
        } else {
            throw new IllegalArgumentException("illegal castling right: " + (Object)((Object)castlingRight));
        }
    }

    public Square clearEPSquare() {
        Square sq = this.epSquare;
        if (sq != null) {
            this.zobristKey ^= Zobrist.getEnPassantKey(sq);
            this.epSquare = null;
        }
        return sq;
    }

    private Piece clearSquare(Square s) {
        Piece p = this.getPiece(s);
        if (p != null) {
            this.pieceMap.remove(s);
            this.pieceCountsMap.put(p, this.pieceCountsMap.get(p) - 1);
            this.zobristKey ^= Zobrist.getPieceKey(s, p);
            long bb = Bitboard.squares[s.value()];
            if (p.isWhite()) {
                this.whitePieces ^= bb;
                if (p == Pawn.WHITE_PAWN) {
                    this.whitePawns ^= bb;
                    this.pawnKey ^= Zobrist.getPieceKey(s, p);
                } else if (p == Knight.WHITE_KNIGHT) {
                    this.whiteKnights ^= bb;
                } else if (p == Bishop.WHITE_BISHOP) {
                    this.whiteBishops ^= bb;
                } else if (p == Rook.WHITE_ROOK) {
                    this.whiteRooks ^= bb;
                } else if (p == Queen.WHITE_QUEEN) {
                    this.whiteQueens ^= bb;
                }
            } else {
                this.blackPieces ^= bb;
                if (p == Pawn.BLACK_PAWN) {
                    this.blackPawns ^= bb;
                    this.pawnKey ^= Zobrist.getPieceKey(s, p);
                } else if (p == Knight.BLACK_KNIGHT) {
                    this.blackKnights ^= bb;
                } else if (p == Bishop.BLACK_BISHOP) {
                    this.blackBishops ^= bb;
                } else if (p == Rook.BLACK_ROOK) {
                    this.blackRooks ^= bb;
                } else if (p == Queen.BLACK_QUEEN) {
                    this.blackQueens ^= bb;
                }
            }
        }
        return p;
    }

    public synchronized Board deepCopy() {
        Board b = new Board();
        b.undoStack.clear();
        b.undoStack.addAll(this.undoStack);
        b.pieceMap.clear();
        for (Square sq : this.pieceMap.keySet()) {
            b.pieceMap.put(sq, this.pieceMap.get(sq));
        }
        b.castlingRights.setValue(this.castlingRights.getValue());
        b.playerToMove = this.playerToMove;
        b.epSquare = this.epSquare;
        b.whiteKingSquare = this.whiteKingSquare;
        b.blackKingSquare = this.blackKingSquare;
        b.whitePawns = this.whitePawns;
        b.blackPawns = this.blackPawns;
        b.whiteKnights = this.whiteKnights;
        b.blackKnights = this.blackKnights;
        b.whiteBishops = this.whiteBishops;
        b.blackBishops = this.blackBishops;
        b.whiteRooks = this.whiteRooks;
        b.blackRooks = this.blackRooks;
        b.whiteQueens = this.whiteQueens;
        b.blackQueens = this.blackQueens;
        b.whitePieces = this.whitePieces;
        b.blackPieces = this.blackPieces;
        b.fiftyCounter = this.fiftyCounter;
        b.moveCounter = this.moveCounter;
        b.zobristKey = this.zobristKey;
        b.pawnKey = this.pawnKey;
        for (Piece p : this.pieceCountsMap.keySet()) {
            b.pieceCountsMap.put(p, this.pieceCountsMap.get(p));
        }
        return b;
    }

    public boolean equalExceptMoveHistory(Board otherBoard, boolean strict) {
        if (!this.pieceMap.equals(otherBoard.pieceMap)) {
            return false;
        }
        if (!this.pieceCountsMap.equals(otherBoard.pieceCountsMap)) {
            return false;
        }
        if (!this.castlingRights.equals(otherBoard.castlingRights)) {
            return false;
        }
        if (!this.getPlayerToMove().equals((Object)otherBoard.getPlayerToMove())) {
            return false;
        }
        if (this.epSquare == null ? otherBoard.epSquare != null : !this.epSquare.equals(otherBoard.epSquare)) {
            return false;
        }
        if (this.blackKingSquare == null ? otherBoard.blackKingSquare != null : !this.blackKingSquare.equals(otherBoard.blackKingSquare)) {
            return false;
        }
        if (this.whiteKingSquare == null ? otherBoard.whiteKingSquare != null : !this.whiteKingSquare.equals(otherBoard.whiteKingSquare)) {
            return false;
        }
        if (this.whitePawns != otherBoard.whitePawns) {
            return false;
        }
        if (this.blackPawns != otherBoard.blackPawns) {
            return false;
        }
        if (this.whiteKnights != otherBoard.whiteKnights) {
            return false;
        }
        if (this.blackKnights != otherBoard.blackKnights) {
            return false;
        }
        if (this.whiteBishops != otherBoard.whiteBishops) {
            return false;
        }
        if (this.blackBishops != otherBoard.blackBishops) {
            return false;
        }
        if (this.whiteRooks != otherBoard.whiteRooks) {
            return false;
        }
        if (this.blackRooks != otherBoard.blackRooks) {
            return false;
        }
        if (this.whiteQueens != otherBoard.whiteQueens) {
            return false;
        }
        if (this.blackQueens != otherBoard.blackQueens) {
            return false;
        }
        if (this.whitePieces != otherBoard.whitePieces) {
            return false;
        }
        if (this.blackPieces != otherBoard.blackPieces) {
            return false;
        }
        if (strict) {
            if (this.moveCounter != otherBoard.moveCounter) {
                return false;
            }
            return this.fiftyCounter == otherBoard.fiftyCounter;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Board)) {
            return false;
        }
        Board that = (Board)obj;
        if (!this.equalExceptMoveHistory(that, true)) {
            return false;
        }
        return this.undoStack.equals(that.undoStack);
    }

    private Square findKingSquare(King kingSquare) {
        Square ksq = null;
        List<Square> squares = Square.allSquares();
        for (Square sq : squares) {
            Piece p = this.getPiece(sq);
            if (!kingSquare.equals(p)) continue;
            ksq = sq;
            break;
        }
        assert (ksq != null);
        return ksq;
    }

    public void flipVertical() {
        Piece p;
        List<Square> squares = Square.allSquares();
        HashMap<Square, Piece> myPieceMap = new HashMap<Square, Piece>();
        for (Square sq : squares) {
            p = this.clearSquare(sq);
            myPieceMap.put(sq, p);
        }
        for (Square sq : squares) {
            p = (Piece)myPieceMap.get(sq);
            if (p == null) continue;
            this.addPiece(p.getOppositeColorPiece(), sq.flipVertical());
        }
        this.swapPlayer();
        Square myEP = this.clearEPSquare();
        if (myEP != null) {
            this.setEP(myEP.flipVertical());
        }
        MyCastlingRights myCastlingRights = new MyCastlingRights(this.castlingRights.getValue());
        this.castlingRights.clear();
        if (myCastlingRights.isWhiteKingside()) {
            this.addCastlingRight(CastlingRights.BLACK_KINGSIDE);
        }
        if (myCastlingRights.isWhiteQueenside()) {
            this.addCastlingRight(CastlingRights.BLACK_QUEENSIDE);
        }
        if (myCastlingRights.isBlackKingside()) {
            this.addCastlingRight(CastlingRights.WHITE_KINGSIDE);
        }
        if (myCastlingRights.isBlackQueenside()) {
            this.addCastlingRight(CastlingRights.WHITE_QUEENSIDE);
        }
        this.resetKingSquares();
    }

    private Square getBlackKingSquare() {
        assert (this.blackKingSquare != null);
        assert (this.blackKingSquare.equals(this.findKingSquare(King.BLACK_KING)));
        return this.blackKingSquare;
    }

    public Square getEPSquare() {
        return this.epSquare;
    }

    public int getFiftyCounter() {
        return this.fiftyCounter;
    }

    public void setFiftyCounter(int fiftyCounter) {
        this.fiftyCounter = fiftyCounter;
    }

    public Square getKingSquare(Color player) {
        return player.isWhite() ? this.getWhiteKingSquare() : this.getBlackKingSquare();
    }

    public int getMoveCounter() {
        return this.moveCounter;
    }

    public void setMoveCounter(int moveCounter) {
        this.moveCounter = moveCounter;
    }

    public int getNumPieces(Piece p) {
        return this.pieceCountsMap.get(p);
    }

    public long getPawnKey() {
        assert (this.pawnKey == Zobrist.getPawnKey(this));
        return this.pawnKey;
    }

    public Piece getPiece(Square square) {
        return this.pieceMap.get(square);
    }

    public Color getPlayerToMove() {
        return this.playerToMove;
    }

    public List<Undo> getUndos() {
        return Collections.unmodifiableList(this.undoStack);
    }

    private Square getWhiteKingSquare() {
        assert (this.whiteKingSquare != null);
        assert (this.whiteKingSquare.equals(this.findKingSquare(King.WHITE_KING)));
        return this.whiteKingSquare;
    }

    public long getZobristKey() {
        assert (this.zobristKey == Zobrist.getBoardKey(this));
        return this.zobristKey;
    }

    public boolean hasCastlingRight(CastlingRights cr) {
        if (CastlingRights.WHITE_KINGSIDE == cr) {
            return this.castlingRights.isWhiteKingside();
        }
        if (CastlingRights.WHITE_QUEENSIDE == cr) {
            return this.castlingRights.isWhiteQueenside();
        }
        if (CastlingRights.BLACK_KINGSIDE == cr) {
            return this.castlingRights.isBlackKingside();
        }
        if (CastlingRights.BLACK_QUEENSIDE == cr) {
            return this.castlingRights.isBlackQueenside();
        }
        throw new IllegalArgumentException("unknown castling right: " + (Object)((Object)cr));
    }

    public int hashCode() {
        int hash = this.hashCodeWithoutMoveHistory(true);
        hash = hash * 31 + this.undoStack.hashCode();
        return hash;
    }

    public int hashCodeWithoutMoveHistory(boolean strict) {
        int hash = this.pieceMap.hashCode();
        hash = hash * 17 + this.castlingRights.hashCode();
        hash = hash * 13 + this.playerToMove.hashCode();
        hash = hash * 31 + (this.epSquare == null ? 0 : this.epSquare.hashCode());
        hash = hash * 17 + (this.whiteKingSquare == null ? 0 : this.whiteKingSquare.hashCode());
        hash = hash * 13 + (this.blackKingSquare == null ? 0 : this.blackKingSquare.hashCode());
        hash = hash * 23 + Long.valueOf(this.whitePawns).hashCode();
        hash = hash * 29 + Long.valueOf(this.blackPawns).hashCode();
        hash = hash * 31 + Long.valueOf(this.whiteKnights).hashCode();
        hash = hash * 37 + Long.valueOf(this.blackKnights).hashCode();
        hash = hash * 43 + Long.valueOf(this.whiteBishops).hashCode();
        hash = hash * 47 + Long.valueOf(this.blackBishops).hashCode();
        hash = hash * 53 + Long.valueOf(this.whiteRooks).hashCode();
        hash = hash * 59 + Long.valueOf(this.blackRooks).hashCode();
        hash = hash * 61 + Long.valueOf(this.whiteQueens).hashCode();
        hash = hash * 67 + Long.valueOf(this.blackQueens).hashCode();
        hash = hash * 71 + Long.valueOf(this.whitePieces).hashCode();
        hash = hash * 73 + Long.valueOf(this.blackPieces).hashCode();
        if (strict) {
            hash = hash * 17 + this.moveCounter;
            hash = hash * 13 + this.fiftyCounter;
        }
        return hash;
    }

    public boolean isEmpty(Square square) {
        return this.pieceMap.get(square) == null;
    }

    public boolean isOpponentInCheck() {
        return AttackDetector.attacked(this, this.getKingSquare(Color.swap(this.playerToMove)), this.playerToMove);
    }

    public boolean isPlayerInCheck() {
        return AttackDetector.attacked(this, this.getKingSquare(this.playerToMove), Color.swap(this.playerToMove));
    }

    public void movePiece(Square from, Square to) {
        if (!from.equals(to)) {
            this.addPiece(this.getPiece(from), to);
            this.clearSquare(from);
        }
    }

    public void resetBoard() {
        this.undoStack.clear();
        this.pieceMap.clear();
        this.pieceCountsMap.put(Queen.WHITE_QUEEN, 0);
        this.pieceCountsMap.put(Queen.BLACK_QUEEN, 0);
        this.pieceCountsMap.put(Rook.WHITE_ROOK, 0);
        this.pieceCountsMap.put(Rook.BLACK_ROOK, 0);
        this.pieceCountsMap.put(Knight.WHITE_KNIGHT, 0);
        this.pieceCountsMap.put(Knight.BLACK_KNIGHT, 0);
        this.pieceCountsMap.put(Bishop.WHITE_BISHOP, 0);
        this.pieceCountsMap.put(Bishop.BLACK_BISHOP, 0);
        this.pieceCountsMap.put(King.WHITE_KING, 0);
        this.pieceCountsMap.put(King.BLACK_KING, 0);
        this.pieceCountsMap.put(Pawn.WHITE_PAWN, 0);
        this.pieceCountsMap.put(Pawn.BLACK_PAWN, 0);
        this.blackPawns = 0L;
        this.whitePawns = 0L;
        this.blackKnights = 0L;
        this.whiteKnights = 0L;
        this.blackBishops = 0L;
        this.whiteBishops = 0L;
        this.blackRooks = 0L;
        this.whiteRooks = 0L;
        this.blackQueens = 0L;
        this.whiteQueens = 0L;
        this.blackPieces = 0L;
        this.whitePieces = 0L;
        this.zobristKey = 0L;
        this.pawnKey = 0L;
        this.addPiece(Rook.BLACK_ROOK, Square.valueOf(File.FILE_A, Rank.RANK_8));
        this.addPiece(Knight.BLACK_KNIGHT, Square.valueOf(File.FILE_B, Rank.RANK_8));
        this.addPiece(Bishop.BLACK_BISHOP, Square.valueOf(File.FILE_C, Rank.RANK_8));
        this.addPiece(Queen.BLACK_QUEEN, Square.valueOf(File.FILE_D, Rank.RANK_8));
        this.addPiece(King.BLACK_KING, Square.valueOf(File.FILE_E, Rank.RANK_8));
        this.addPiece(Bishop.BLACK_BISHOP, Square.valueOf(File.FILE_F, Rank.RANK_8));
        this.addPiece(Knight.BLACK_KNIGHT, Square.valueOf(File.FILE_G, Rank.RANK_8));
        this.addPiece(Rook.BLACK_ROOK, Square.valueOf(File.FILE_H, Rank.RANK_8));
        List<Square> squares = Square.rankSquares(Rank.RANK_7);
        for (Square sq : squares) {
            this.addPiece(Pawn.BLACK_PAWN, sq);
        }
        squares = Square.rankSquares(Rank.RANK_2);
        for (Square sq : squares) {
            this.addPiece(Pawn.WHITE_PAWN, sq);
        }
        this.addPiece(Rook.WHITE_ROOK, Square.valueOf(File.FILE_A, Rank.RANK_1));
        this.addPiece(Knight.WHITE_KNIGHT, Square.valueOf(File.FILE_B, Rank.RANK_1));
        this.addPiece(Bishop.WHITE_BISHOP, Square.valueOf(File.FILE_C, Rank.RANK_1));
        this.addPiece(Queen.WHITE_QUEEN, Square.valueOf(File.FILE_D, Rank.RANK_1));
        this.addPiece(King.WHITE_KING, Square.valueOf(File.FILE_E, Rank.RANK_1));
        this.addPiece(Bishop.WHITE_BISHOP, Square.valueOf(File.FILE_F, Rank.RANK_1));
        this.addPiece(Knight.WHITE_KNIGHT, Square.valueOf(File.FILE_G, Rank.RANK_1));
        this.addPiece(Rook.WHITE_ROOK, Square.valueOf(File.FILE_H, Rank.RANK_1));
        this.castlingRights.clear();
        EnumSet<CastlingRights> crs = EnumSet.allOf(CastlingRights.class);
        for (CastlingRights cr : crs) {
            this.addCastlingRight(cr);
        }
        this.playerToMove = Color.WHITE;
        this.zobristKey ^= Zobrist.getPlayerKey(Color.WHITE);
        this.epSquare = null;
        this.whiteKingSquare = Square.valueOf(File.FILE_E, Rank.RANK_1);
        this.blackKingSquare = Square.valueOf(File.FILE_E, Rank.RANK_8);
        this.moveCounter = 0;
        this.fiftyCounter = 0;
    }

    public void resetKingSquares() {
        this.blackKingSquare = this.findKingSquare(King.BLACK_KING);
        this.whiteKingSquare = this.findKingSquare(King.WHITE_KING);
    }

    public void setEP(Square ep) {
        assert (ep != null);
        this.epSquare = ep;
        this.zobristKey ^= Zobrist.getEnPassantKey(ep);
    }

    public void swapPlayer() {
        this.zobristKey ^= Zobrist.getPlayerKey(this.playerToMove);
        this.playerToMove = Color.swap(this.playerToMove);
        this.zobristKey ^= Zobrist.getPlayerKey(this.playerToMove);
    }

    private void undoKingMove(Undo u, Piece p) {
        if (p.isWhite()) {
            this.whiteKingSquare = u.getMove().from();
            if (u.getMove().from().equals(Square.valueOf(File.FILE_E, Rank.RANK_1))) {
                if (u.getMove().to().equals(Square.valueOf(File.FILE_G, Rank.RANK_1))) {
                    this.movePiece(Square.valueOf(File.FILE_F, Rank.RANK_1), Square.valueOf(File.FILE_H, Rank.RANK_1));
                } else if (u.getMove().to().equals(Square.valueOf(File.FILE_C, Rank.RANK_1))) {
                    this.movePiece(Square.valueOf(File.FILE_D, Rank.RANK_1), Square.valueOf(File.FILE_A, Rank.RANK_1));
                }
            }
        } else {
            this.blackKingSquare = u.getMove().from();
            if (u.getMove().from().equals(Square.valueOf(File.FILE_E, Rank.RANK_8))) {
                if (u.getMove().to().equals(Square.valueOf(File.FILE_G, Rank.RANK_8))) {
                    this.movePiece(Square.valueOf(File.FILE_F, Rank.RANK_8), Square.valueOf(File.FILE_H, Rank.RANK_8));
                } else if (u.getMove().to().equals(Square.valueOf(File.FILE_C, Rank.RANK_8))) {
                    this.movePiece(Square.valueOf(File.FILE_D, Rank.RANK_8), Square.valueOf(File.FILE_A, Rank.RANK_8));
                }
            }
        }
    }

    public void undoLastMove() {
        assert (this.verify());
        assert (this.undoStack.size() > 0);
        int ind = this.undoStack.size() - 1;
        Undo u = this.undoStack.remove(ind);
        this.swapPlayer();
        this.epSquare = u.getEpSquare();
        --this.moveCounter;
        this.fiftyCounter = u.getFiftyCounter();
        this.castlingRights.setValue(u.getCastlingRights());
        Piece p = this.clearSquare(u.getMove().to());
        if (u.getMove().promotion() != null) {
            this.undoPromotion(u);
        } else if (p instanceof Pawn) {
            this.undoPawnMove(u, p);
        } else {
            if (p instanceof King) {
                this.undoKingMove(u, p);
            }
            this.addPiece(u.getMove().captured(), u.getMove().to());
            this.addPiece(p, u.getMove().from());
        }
        this.zobristKey = u.getZobristKey();
        assert (this.verify());
    }

    private void undoPawnMove(Undo u, Piece p) {
        if (p.isWhite()) {
            if (u.getMove().to().equals(this.epSquare)) {
                this.addPiece(u.getMove().captured(), Square.valueOf(this.epSquare.file(), this.epSquare.rank().south()));
                this.addPiece(p, u.getMove().from());
            } else {
                this.addPiece(u.getMove().captured(), u.getMove().to());
                this.addPiece(p, u.getMove().from());
            }
        } else if (u.getMove().to().equals(this.epSquare)) {
            this.addPiece(u.getMove().captured(), Square.valueOf(this.epSquare.file(), this.epSquare.rank().north()));
            this.addPiece(p, u.getMove().from());
        } else {
            this.addPiece(u.getMove().captured(), u.getMove().to());
            this.addPiece(p, u.getMove().from());
        }
    }

    private void undoPromotion(Undo u) {
        this.addPiece(u.getMove().captured(), u.getMove().to());
        this.addPiece(this.playerToMove.equals((Object)Color.WHITE) ? Pawn.WHITE_PAWN : Pawn.BLACK_PAWN, u.getMove().from());
    }

    private boolean whiteCanCastleKingSide() {
        boolean pathIsClear;
        if (!this.hasCastlingRight(CastlingRights.WHITE_KINGSIDE)) {
            return false;
        }
        boolean bl = pathIsClear = this.isEmpty(Square.valueOf(File.FILE_F, Rank.RANK_1)) && this.isEmpty(Square.valueOf(File.FILE_G, Rank.RANK_1));
        if (!pathIsClear) {
            return false;
        }
        Color opponent = Color.swap(this.playerToMove);
        boolean wouldCrossCheck = AttackDetector.attacked(this, Square.valueOf(File.FILE_E, Rank.RANK_1), opponent) || AttackDetector.attacked(this, Square.valueOf(File.FILE_F, Rank.RANK_1), opponent);
        return !wouldCrossCheck;
    }

    private boolean whiteCanCastleQueenSide() {
        boolean pathIsClear;
        if (!this.hasCastlingRight(CastlingRights.WHITE_QUEENSIDE)) {
            return false;
        }
        boolean bl = pathIsClear = this.isEmpty(Square.valueOf(File.FILE_D, Rank.RANK_1)) && this.isEmpty(Square.valueOf(File.FILE_C, Rank.RANK_1)) && this.isEmpty(Square.valueOf(File.FILE_B, Rank.RANK_1));
        if (!pathIsClear) {
            return false;
        }
        Color opponent = Color.swap(this.playerToMove);
        boolean wouldCrossCheck = AttackDetector.attacked(this, Square.valueOf(File.FILE_E, Rank.RANK_1), opponent) || AttackDetector.attacked(this, Square.valueOf(File.FILE_D, Rank.RANK_1), opponent);
        return !wouldCrossCheck;
    }

    private boolean verify() {
        Square myWhiteKingSq = null;
        Square myBlackKingSq = null;
        for (Square sq : Square.allSquares()) {
            Piece p = this.getPiece(sq);
            if (p == King.WHITE_KING) {
                assert (myWhiteKingSq == null);
                myWhiteKingSq = sq;
            }
            if (p != King.BLACK_KING) continue;
            assert (myBlackKingSq == null);
            myBlackKingSq = sq;
        }
        assert (myWhiteKingSq != null && myWhiteKingSq == this.whiteKingSquare);
        assert (myBlackKingSq != null && myBlackKingSq == this.blackKingSquare);
        if (this.epSquare != null) {
            if (this.playerToMove == Color.BLACK) {
                assert (this.epSquare.rank() == Rank.RANK_3);
                assert (this.getPiece(North.getInstance().next(this.epSquare)) == Pawn.WHITE_PAWN);
            } else {
                assert (this.epSquare.rank() == Rank.RANK_6);
                assert (this.getPiece(South.getInstance().next(this.epSquare)) == Pawn.BLACK_PAWN);
            }
        }
        long myWhitePawns = 0L;
        long myBlackPawns = 0L;
        long myWhiteKnights = 0L;
        long myBlackKnights = 0L;
        long myWhiteBishops = 0L;
        long myBlackBishops = 0L;
        long myWhiteRooks = 0L;
        long myBlackRooks = 0L;
        long myWhiteQueens = 0L;
        long myBlackQueens = 0L;
        long myWhitePieces = 0L;
        long myBlackPieces = 0L;
        int numWhitePawns = 0;
        int numBlackPawns = 0;
        int numWhiteKnights = 0;
        int numBlackKnights = 0;
        int numWhiteBishops = 0;
        int numBlackBishops = 0;
        int numWhiteRooks = 0;
        int numBlackRooks = 0;
        int numWhiteQueens = 0;
        int numBlackQueens = 0;
        for (Square sq : Square.allSquares()) {
            Piece p = this.getPiece(sq);
            long bb = Bitboard.squares[sq.value()];
            if (p != null) {
                if (p.isWhite()) {
                    myWhitePieces |= bb;
                } else {
                    myBlackPieces |= bb;
                }
            }
            if (Pawn.WHITE_PAWN == p) {
                myWhitePawns |= bb;
                ++numWhitePawns;
                continue;
            }
            if (Pawn.BLACK_PAWN == p) {
                myBlackPawns |= bb;
                ++numBlackPawns;
                continue;
            }
            if (Knight.WHITE_KNIGHT == p) {
                myWhiteKnights |= bb;
                ++numWhiteKnights;
                continue;
            }
            if (Knight.BLACK_KNIGHT == p) {
                myBlackKnights |= bb;
                ++numBlackKnights;
                continue;
            }
            if (Bishop.WHITE_BISHOP == p) {
                myWhiteBishops |= bb;
                ++numWhiteBishops;
                continue;
            }
            if (Bishop.BLACK_BISHOP == p) {
                myBlackBishops |= bb;
                ++numBlackBishops;
                continue;
            }
            if (Rook.WHITE_ROOK == p) {
                myWhiteRooks |= bb;
                ++numWhiteRooks;
                continue;
            }
            if (Rook.BLACK_ROOK == p) {
                myBlackRooks |= bb;
                ++numBlackRooks;
                continue;
            }
            if (Queen.WHITE_QUEEN == p) {
                myWhiteQueens |= bb;
                ++numWhiteQueens;
                continue;
            }
            if (Queen.BLACK_QUEEN != p) continue;
            myBlackQueens |= bb;
            ++numBlackQueens;
        }
        assert (this.whitePawns == myWhitePawns);
        assert (this.blackPawns == myBlackPawns);
        assert (this.whiteKnights == myWhiteKnights);
        assert (this.blackKnights == myBlackKnights);
        assert (this.whiteBishops == myWhiteBishops);
        assert (this.blackBishops == myBlackBishops);
        assert (this.whiteRooks == myWhiteRooks);
        assert (this.blackRooks == myBlackRooks);
        assert (this.whiteQueens == myWhiteQueens);
        assert (this.blackQueens == myBlackQueens);
        assert (this.whitePieces == myWhitePieces);
        assert (this.blackPieces == myBlackPieces);
        assert (this.pieceCountsMap.get(Pawn.WHITE_PAWN) == numWhitePawns);
        assert (this.pieceCountsMap.get(Pawn.BLACK_PAWN) == numBlackPawns);
        assert (this.pieceCountsMap.get(Knight.WHITE_KNIGHT) == numWhiteKnights);
        assert (this.pieceCountsMap.get(Knight.BLACK_KNIGHT) == numBlackKnights);
        assert (this.pieceCountsMap.get(Bishop.WHITE_BISHOP) == numWhiteBishops);
        assert (this.pieceCountsMap.get(Bishop.BLACK_BISHOP) == numBlackBishops);
        assert (this.pieceCountsMap.get(Rook.WHITE_ROOK) == numWhiteRooks);
        assert (this.pieceCountsMap.get(Rook.BLACK_ROOK) == numBlackRooks);
        assert (this.pieceCountsMap.get(Queen.WHITE_QUEEN) == numWhiteQueens);
        assert (this.pieceCountsMap.get(Queen.BLACK_QUEEN) == numBlackQueens);
        return true;
    }

    public long getWhitePawns() {
        return this.whitePawns;
    }

    public long getBlackPawns() {
        return this.blackPawns;
    }

    public long getWhiteKnights() {
        return this.whiteKnights;
    }

    public long getBlackKnights() {
        return this.blackKnights;
    }

    public long getWhiteBishops() {
        return this.whiteBishops;
    }

    public long getBlackBishops() {
        return this.blackBishops;
    }

    public long getWhiteRooks() {
        return this.whiteRooks;
    }

    public long getBlackRooks() {
        return this.blackRooks;
    }

    public long getWhiteQueens() {
        return this.whiteQueens;
    }

    public long getBlackQueens() {
        return this.blackQueens;
    }

    public long getWhitePieces() {
        return this.whitePieces;
    }

    public long getBlackPieces() {
        return this.blackPieces;
    }
}

