/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.common.packet;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import ru.timeconqueror.lootgames.LootGames;
import ru.timeconqueror.lootgames.api.block.tile.GameMasterTile;
import ru.timeconqueror.lootgames.api.minigame.LootGame;
import ru.timeconqueror.lootgames.api.packet.GamePacketRegistry;
import ru.timeconqueror.lootgames.api.packet.IGamePacket;
import ru.timeconqueror.lootgames.utils.future.BlockPos;
import ru.timeconqueror.lootgames.utils.future.ThreeConsumer;
import ru.timeconqueror.lootgames.utils.future.WorldExt;
import ru.timeconqueror.timecore.api.util.client.ClientProxy;

public abstract class PacketGameUpdate<T extends IGamePacket>
implements IMessage {
    private T gamePacket;
    private BlockPos masterPos;

    public <G extends LootGame<?, G>> PacketGameUpdate(LootGame<?, G> game, T gamePacket) {
        this.masterPos = game.getMasterPos();
        this.gamePacket = gamePacket;
    }

    public PacketGameUpdate() {
    }

    public void fromBytes(ByteBuf buf) {
        try {
            IGamePacket gamePacket;
            PacketBuffer buffer = new PacketBuffer(buf);
            BlockPos masterPos = BlockPos.of(buffer.readLong());
            GamePacketRegistry.Key key = new GamePacketRegistry.Key(buffer.func_150789_c(Short.MAX_VALUE), buffer.readInt());
            Class<T> packetClass = this.getStorage().getPacketClass(key);
            try {
                gamePacket = (IGamePacket)packetClass.newInstance();
                gamePacket.decode(buffer);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("Can't decode received game packet, due to lack of public nullary constructor in " + packetClass, e);
            }
            this.setMasterPos(masterPos);
            this.setGamePacket(gamePacket);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void toBytes(ByteBuf buf) {
        try {
            PacketBuffer buffer = new PacketBuffer(buf);
            buffer.writeLong(this.getMasterPos().asLong());
            GamePacketRegistry.Storage<T> storage = this.getStorage();
            GamePacketRegistry.Key info = storage.getKey(this.getGamePacketClass());
            buffer.func_150785_a(info.getModId());
            buffer.writeInt(info.getPacketId());
            this.getGamePacket().encode(buffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public BlockPos getMasterPos() {
        return this.masterPos;
    }

    public T getGamePacket() {
        return this.gamePacket;
    }

    protected void setMasterPos(BlockPos masterPos) {
        this.masterPos = masterPos;
    }

    protected void setGamePacket(T gamePacket) {
        this.gamePacket = gamePacket;
    }

    public Class<? extends T> getGamePacketClass() {
        return this.gamePacket.getClass();
    }

    public abstract GamePacketRegistry.Storage<T> getStorage();

    public static class Handler<T extends IGamePacket, P extends PacketGameUpdate<T>>
    implements IMessageHandler<P, IMessage> {
        private final ThreeConsumer<MessageContext, LootGame<?, ?>, T> gameUpdater;

        public Handler(ThreeConsumer<MessageContext, LootGame<?, ?>, T> gameUpdater) {
            this.gameUpdater = gameUpdater;
        }

        public IMessage onMessage(P packet, MessageContext ctx) {
            World world = this.getWorld(ctx);
            TileEntity te = WorldExt.getTileEntity(world, ((PacketGameUpdate)packet).getMasterPos());
            if (te instanceof GameMasterTile) {
                GameMasterTile master = (GameMasterTile)te;
                this.gameUpdater.accept(ctx, (LootGame<?, ?>)master.getGame(), (MessageContext)((PacketGameUpdate)packet).getGamePacket());
            } else {
                LootGames.LOGGER.error("Something went wrong. Can't find TileEntityMaster on pos " + ((PacketGameUpdate)packet).getMasterPos() + " for packet " + ((PacketGameUpdate)packet).getGamePacketClass().getName());
            }
            return null;
        }

        private World getWorld(MessageContext ctx) {
            return ctx.side == Side.CLIENT ? ClientProxy.world() : ctx.getServerHandler().field_147369_b.field_70170_p;
        }
    }
}

