/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.client.render.tile;

import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import ru.timeconqueror.lootgames.LootGames;
import ru.timeconqueror.lootgames.api.block.tile.BoardGameMasterTile;
import ru.timeconqueror.lootgames.client.render.MSOverlayHandler;
import ru.timeconqueror.lootgames.common.block.tile.MSMasterTile;
import ru.timeconqueror.lootgames.minigame.minesweeper.GameMineSweeper;
import ru.timeconqueror.lootgames.minigame.minesweeper.Mark;
import ru.timeconqueror.lootgames.minigame.minesweeper.Type;
import ru.timeconqueror.timecore.api.util.client.DrawHelper;

public class MSMasterRenderer
extends TileEntitySpecialRenderer {
    private static final ResourceLocation BOARD = LootGames.rl("textures/game/ms_board.png");

    public void func_147500_a(TileEntity teIn, double x, double y, double z, float partialTicks) {
        MSMasterTile te = (MSMasterTile)teIn;
        GameMineSweeper game = (GameMineSweeper)te.getGame();
        int boardSize = game.getCurrentBoardSize();
        Object stage = game.getStage();
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        BoardGameMasterTile.prepareMatrix(te);
        this.func_147499_a(BOARD);
        GL11.glDisable((int)2896);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!game.cIsGenerated) {
            for (int xL = 0; xL < boardSize; ++xL) {
                for (int zL = 0; zL < boardSize; ++zL) {
                    DrawHelper.drawTexturedRectByParts(xL, zL, 1.0f, 1.0f, -0.005f, 0.0f, 0.0f, 1.0f, 1.0f, 4.0f);
                }
            }
        } else {
            for (int xL = 0; xL < boardSize; ++xL) {
                for (int zL = 0; zL < boardSize; ++zL) {
                    int textureY;
                    int textureX;
                    boolean isHidden = game.getBoard().isHidden(xL, zL);
                    Type type = game.getBoard().getType(xL, zL);
                    if (!isHidden && type == Type.BOMB) {
                        int max = stage instanceof GameMineSweeper.StageDetonating ? ((GameMineSweeper.StageDetonating)stage).getDetonationTicks() : 1;
                        int ticks = game.getTicks();
                        float period = 8.0f;
                        float times = (float)max / period;
                        float extendedPeriod = period * (times + 1.0f) / times;
                        double alphaFactor = stage instanceof GameMineSweeper.StageExploding ? 1.0 : Math.abs(Math.sin(Math.toRadians((float)ticks / extendedPeriod * 180.0f)));
                        int alphaColor = DrawHelper.changeAlpha(-1, (int)(alphaFactor * 255.0));
                        DrawHelper.drawTexturedRectByParts(xL, zL, 1.0f, 1.0f, -0.005f, 1.0f, 0.0f, 1.0f, 1.0f, 4.0f);
                        GL11.glEnable((int)3042);
                        GL11.glBlendFunc((int)770, (int)771);
                        GL11.glEnable((int)3008);
                        DrawHelper.drawTexturedRectByParts(xL, zL, 1.0f, 1.0f, -0.005f, 1.0f, 3.0f, 1.0f, 1.0f, 4.0f, alphaColor);
                        GL11.glDisable((int)3042);
                        GL11.glDisable((int)3008);
                        continue;
                    }
                    Mark mark = game.getBoard().getMark(xL, zL);
                    if (isHidden) {
                        if (mark == Mark.NO_MARK) {
                            textureX = 0;
                            textureY = 0;
                        } else if (mark == Mark.FLAG) {
                            textureX = 3;
                            textureY = 0;
                        } else {
                            textureX = 0;
                            textureY = 3;
                        }
                    } else if (type.getId() > 0) {
                        textureX = type.getId() % 4 == 0 ? 3 : type.getId() % 4 - 1;
                        textureY = type.getId() <= 4 ? 1 : 2;
                    } else {
                        textureX = 2;
                        textureY = 0;
                    }
                    DrawHelper.drawTexturedRectByParts(xL, zL, 1.0f, 1.0f, -0.005f, textureX, textureY, 1.0f, 1.0f, 4.0f);
                }
            }
        }
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
        MSOverlayHandler.addSupportedMaster(te);
    }
}

