/*
 * Decompiled with CFR 0.152.
 */
package com.jamesswafford.chess4j.hash;

import com.jamesswafford.chess4j.board.Move;
import com.jamesswafford.chess4j.hash.TranspositionTableEntry;
import com.jamesswafford.chess4j.hash.TranspositionTableEntryType;
import eu.usrv.yamcore.auxiliary.LogHelper;

public class TranspositionTable {
    private static final TranspositionTable INSTANCE = new TranspositionTable();
    private static LogHelper mLog = new LogHelper("LootGames - ChessEngine");
    private static int numEntries;
    private static int mask;
    private TranspositionTableEntry[] table = new TranspositionTableEntry[numEntries];
    private long numProbes = 0L;
    private long numHits = 0L;
    private long numCollisions = 0L;

    private TranspositionTable() {
        this.clear();
        mLog.debug((Object)("# transposition table initialized with  " + numEntries + " entries."));
    }

    public static TranspositionTable getInstance() {
        return INSTANCE;
    }

    public void clear() {
        this.clearStats();
        for (int i = 0; i < numEntries; ++i) {
            this.table[i] = null;
        }
    }

    public void clearStats() {
        this.numProbes = 0L;
        this.numHits = 0L;
        this.numCollisions = 0L;
    }

    private int getMaskedKey(long zobristKey) {
        int iKey = (int)zobristKey & mask;
        return iKey;
    }

    public TranspositionTableEntry probe(long zobristKey) {
        ++this.numProbes;
        TranspositionTableEntry te = this.table[this.getMaskedKey(zobristKey)];
        if (te != null) {
            if (te.getZobristKey() != zobristKey) {
                ++this.numCollisions;
                return null;
            }
            ++this.numHits;
        }
        return te;
    }

    public void store(TranspositionTableEntryType entryType, long zobristKey, int score, int depth, Move move) {
        TranspositionTableEntry te;
        if (this.isMateScore(score)) {
            if (entryType == TranspositionTableEntryType.UPPER_BOUND) {
                entryType = TranspositionTableEntryType.MOVE_ONLY;
            } else {
                entryType = TranspositionTableEntryType.LOWER_BOUND;
                score = this.getCheckMateBound();
            }
        } else if (this.isMatedScore(score)) {
            if (entryType == TranspositionTableEntryType.LOWER_BOUND) {
                entryType = TranspositionTableEntryType.MOVE_ONLY;
            } else {
                entryType = TranspositionTableEntryType.UPPER_BOUND;
                score = this.getCheckMatedBound();
            }
        }
        this.table[this.getMaskedKey((long)zobristKey)] = te = new TranspositionTableEntry(entryType, zobristKey, score, depth, move);
    }

    private boolean isMateScore(int score) {
        return score >= this.getCheckMateBound();
    }

    private boolean isMatedScore(int score) {
        return score <= this.getCheckMatedBound();
    }

    private int getCheckMateBound() {
        return 29500;
    }

    private int getCheckMatedBound() {
        return -this.getCheckMateBound();
    }

    public long getNumProbes() {
        return this.numProbes;
    }

    public long getNumHits() {
        return this.numHits;
    }

    public long getNumCollisions() {
        return this.numCollisions;
    }

    static {
        mask = 1048575;
        numEntries = mask + 1;
        assert ((numEntries & mask) == 0);
    }
}

