/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils.item;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import logisticspipes.asm.addinfo.IAddInfo;
import logisticspipes.asm.addinfo.IAddInfoProvider;
import logisticspipes.items.LogisticsFluidContainer;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.computers.interfaces.ILPCCTypeHolder;
import logisticspipes.renderer.LogisticsRenderPipe;
import logisticspipes.utils.FinalNBTTagCompound;
import logisticspipes.utils.ReflectionHelper;
import logisticspipes.utils.item.DictItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.world.World;

public final class ItemIdentifier
implements Comparable<ItemIdentifier>,
ILPCCTypeHolder {
    private static final ConcurrentHashMap<Item, ItemIdentifier> simpleIdentifiers = new ConcurrentHashMap(4096, 0.5f, 1);
    private static final ConcurrentHashMap<Item, IDamagedIdentifierHolder> damageIdentifiers = new ConcurrentHashMap(4096, 0.5f, 1);
    private static final HashMap<ItemKey, IDReference> keyRefMap = new HashMap(1024, 0.5f);
    private static final HashMap<Item, BitSet> tagIDsets = new HashMap(1024, 0.5f);
    private static final ReferenceQueue<ItemIdentifier> keyRefQueue = new ReferenceQueue();
    private static final ReadWriteLock keyRefLock = new ReentrantReadWriteLock();
    private static final Lock keyRefRlock = keyRefLock.readLock();
    private static final Lock keyRefWlock = keyRefLock.writeLock();
    private static final ItemIdentifierCleanupThread cleanupThread = new ItemIdentifierCleanupThread();
    private Object ccType;
    public final Item item;
    public final int itemDamage;
    public final FinalNBTTagCompound tag;
    public final int uniqueID;
    private int maxStackSize = 0;
    private ItemIdentifier _IDIgnoringNBT = null;
    private ItemIdentifier _IDIgnoringDamage = null;
    private ItemIdentifier _IDIgnoringData = null;
    private DictItemIdentifier _dict;
    private boolean canHaveDict = true;
    private Boolean isRenderListCompatible = null;
    private String modName;
    private String creativeTabName;
    public static boolean allowNullsForTesting;

    private ItemIdentifier(Item item, int itemDamage, FinalNBTTagCompound tag, int uniqueID) {
        this.item = item;
        this.itemDamage = itemDamage;
        this.tag = tag;
        this.uniqueID = uniqueID;
    }

    private static ItemIdentifier getOrCreateSimple(Item item, ItemIdentifier proposal) {
        if (proposal != null && proposal.item == item && proposal.itemDamage == 0 && proposal.tag == null) {
            return proposal;
        }
        ItemIdentifier ret = simpleIdentifiers.get(item);
        if (ret != null) {
            return ret;
        }
        ret = new ItemIdentifier(item, 0, null, 0);
        simpleIdentifiers.put(item, ret);
        return ret;
    }

    private static ItemIdentifier getOrCreateDamage(Item item, int damage, ItemIdentifier proposal) {
        if (proposal != null && proposal.item == item && proposal.itemDamage == damage && proposal.tag == null) {
            return proposal;
        }
        IDamagedIdentifierHolder damages = damageIdentifiers.get(item);
        if (damages == null) {
            damages = item.func_77612_l() < Short.MAX_VALUE ? new ArrayDamagedItentifierHolder(damage) : new MapDamagedItentifierHolder();
            damageIdentifiers.put(item, damages);
        } else {
            damages.ensureCapacity(damage);
        }
        ItemIdentifier ret = damages.get(damage);
        if (ret != null) {
            return ret;
        }
        ret = new ItemIdentifier(item, damage, null, 0);
        damages.set(damage, ret);
        return ret;
    }

    private static ItemIdentifier getOrCreateTag(Item item, int damage, FinalNBTTagCompound tag) {
        int nextUniqueID;
        ItemIdentifier ret;
        ItemKey k = new ItemKey(item, damage, tag);
        keyRefRlock.lock();
        IDReference r = keyRefMap.get(k);
        if (r != null && (ret = (ItemIdentifier)r.get()) != null) {
            keyRefRlock.unlock();
            return ret;
        }
        keyRefRlock.unlock();
        keyRefWlock.lock();
        r = keyRefMap.get(k);
        if (r != null && (ret = (ItemIdentifier)r.get()) != null) {
            keyRefWlock.unlock();
            return ret;
        }
        if (tagIDsets.get(item) == null) {
            tagIDsets.put(item, new BitSet(16));
        }
        if (r == null) {
            nextUniqueID = tagIDsets.get(item).nextClearBit(1);
            tagIDsets.get(item).set(nextUniqueID);
        } else {
            nextUniqueID = r.uniqueID;
        }
        FinalNBTTagCompound finaltag = new FinalNBTTagCompound((NBTTagCompound)tag.func_74737_b());
        ItemKey realKey = new ItemKey(item, damage, finaltag);
        ItemIdentifier ret2 = new ItemIdentifier(item, damage, finaltag, nextUniqueID);
        keyRefMap.put(realKey, new IDReference(realKey, nextUniqueID, ret2));
        keyRefWlock.unlock();
        return ret2;
    }

    public static ItemIdentifier get(Item item, int itemUndamagableDamage, NBTTagCompound tag) {
        return ItemIdentifier.get(item, itemUndamagableDamage, tag, null);
    }

    private static ItemIdentifier get(Item item, int itemUndamagableDamage, NBTTagCompound tag, ItemIdentifier proposal) {
        if (itemUndamagableDamage < 0) {
            throw new IllegalArgumentException("Item Damage out of range");
        }
        if (tag == null && itemUndamagableDamage == 0) {
            return ItemIdentifier.getOrCreateSimple(item, proposal);
        }
        if (tag == null) {
            return ItemIdentifier.getOrCreateDamage(item, itemUndamagableDamage, proposal);
        }
        return ItemIdentifier.getOrCreateTag(item, itemUndamagableDamage, new FinalNBTTagCompound(tag));
    }

    public static ItemIdentifier get(ItemStack itemStack) {
        ItemIdentifier ident;
        ItemStackAddInfo info;
        if (itemStack == null && allowNullsForTesting) {
            return null;
        }
        ItemIdentifier proposal = null;
        IAddInfoProvider prov = null;
        if (itemStack instanceof IAddInfoProvider && !itemStack.func_77942_o() && (info = (prov = (IAddInfoProvider)itemStack).getLogisticsPipesAddInfo(ItemStackAddInfo.class)) != null) {
            proposal = info.ident;
        }
        if ((ident = ItemIdentifier.get(itemStack.func_77973_b(), itemStack.func_77960_j(), itemStack.field_77990_d, proposal)) != proposal && prov != null && !itemStack.func_77942_o()) {
            prov.setLogisticsPipesAddInfo(new ItemStackAddInfo(ident));
        }
        return ident;
    }

    public static List<ItemIdentifier> getMatchingNBTIdentifier(Item item, int itemData) {
        ArrayList<ItemIdentifier> resultlist = new ArrayList<ItemIdentifier>(16);
        keyRefRlock.lock();
        for (IDReference r : keyRefMap.values()) {
            ItemIdentifier t = (ItemIdentifier)r.get();
            if (t == null || t.item != item || t.itemDamage != itemData) continue;
            resultlist.add(t);
        }
        keyRefRlock.unlock();
        return resultlist;
    }

    public ItemIdentifier getUndamaged() {
        if (this._IDIgnoringDamage == null) {
            if (!this.unsafeMakeNormalStack(0).func_77984_f()) {
                this._IDIgnoringDamage = this;
            } else {
                ItemStack tstack = this.makeNormalStack(0);
                tstack.func_77964_b(0);
                this._IDIgnoringDamage = ItemIdentifier.get(tstack);
            }
        }
        return this._IDIgnoringDamage;
    }

    public ItemIdentifier getIgnoringNBT() {
        if (this._IDIgnoringNBT == null) {
            this._IDIgnoringNBT = this.tag == null ? this : ItemIdentifier.get(this.item, this.itemDamage, null, null);
        }
        return this._IDIgnoringNBT;
    }

    public ItemIdentifier getIgnoringData() {
        if (this._IDIgnoringData == null) {
            this._IDIgnoringData = this.itemDamage == 0 ? this : ItemIdentifier.get(this.item, 0, this.tag, null);
        }
        return this._IDIgnoringData;
    }

    public String getDebugName() {
        return this.item.func_77658_a() + "(ID: " + Item.func_150891_b((Item)this.item) + ", Damage: " + this.itemDamage + ")";
    }

    private String getName(ItemStack stack) {
        String name = "???";
        try {
            name = this.item.func_77653_i(stack);
            if (name == null) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            try {
                name = this.item.func_77667_c(stack);
                if (name == null) {
                    throw new Exception();
                }
            }
            catch (Exception e1) {
                try {
                    name = this.item.func_77658_a();
                    if (name == null) {
                        throw new Exception();
                    }
                }
                catch (Exception e2) {
                    name = "???";
                }
            }
        }
        return name;
    }

    public String getFriendlyName() {
        return this.getName(this.unsafeMakeNormalStack(0));
    }

    public String getFriendlyNameCC() {
        return MainProxy.proxy.getName(this);
    }

    public String getModName() {
        if (this.modName == null) {
            GameRegistry.UniqueIdentifier ui = GameRegistry.findUniqueIdentifierFor((Item)this.item);
            this.modName = ui == null ? "UNKNOWN" : ui.modId;
        }
        return this.modName;
    }

    public String getCreativeTabName() {
        if (this.creativeTabName == null) {
            block20: {
                try {
                    Block block;
                    CreativeTabs tab = null;
                    try {
                        tab = ReflectionHelper.getPrivateField(CreativeTabs.class, Item.class, "tabToDisplayOn", this.item);
                    }
                    catch (NoSuchFieldException e1) {
                        try {
                            tab = ReflectionHelper.getPrivateField(CreativeTabs.class, Item.class, "field_77701_a", this.item);
                        }
                        catch (NoSuchFieldException e2) {
                            tab = ReflectionHelper.getPrivateField(CreativeTabs.class, Item.class, "a", this.item);
                        }
                    }
                    if (tab == null && this.item instanceof ItemBlock && (block = Block.func_149634_a((Item)this.item)) != null) {
                        try {
                            tab = ReflectionHelper.getPrivateField(CreativeTabs.class, Block.class, "displayOnCreativeTab", block);
                        }
                        catch (NoSuchFieldException e1) {
                            try {
                                tab = ReflectionHelper.getPrivateField(CreativeTabs.class, Block.class, "field_149772_a", block);
                            }
                            catch (NoSuchFieldException e2) {
                                tab = ReflectionHelper.getPrivateField(CreativeTabs.class, Block.class, "a", block);
                            }
                        }
                    }
                    if (tab == null) break block20;
                    try {
                        this.creativeTabName = ReflectionHelper.getPrivateField(String.class, CreativeTabs.class, "tabLabel", tab);
                    }
                    catch (NoSuchFieldException e1) {
                        try {
                            this.creativeTabName = ReflectionHelper.getPrivateField(String.class, CreativeTabs.class, "field_78034_o", tab);
                        }
                        catch (NoSuchFieldException e2) {
                            this.creativeTabName = ReflectionHelper.getPrivateField(String.class, CreativeTabs.class, "o", tab);
                        }
                    }
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
                catch (SecurityException securityException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            if (this.creativeTabName == null) {
                this.creativeTabName = "UNKNOWN";
            }
        }
        return this.creativeTabName;
    }

    public ItemIdentifierStack makeStack(int stackSize) {
        return new ItemIdentifierStack(this, stackSize);
    }

    public ItemStack unsafeMakeNormalStack(int stackSize) {
        ItemStack stack = new ItemStack(this.item, stackSize, this.itemDamage);
        stack.func_77982_d((NBTTagCompound)this.tag);
        return stack;
    }

    public ItemStack makeNormalStack(int stackSize) {
        ItemStack stack = new ItemStack(this.item, stackSize, this.itemDamage);
        if (this.tag != null) {
            stack.func_77982_d((NBTTagCompound)this.tag.func_74737_b());
        }
        return stack;
    }

    public EntityItem makeEntityItem(int stackSize, World world, double x, double y, double z) {
        return new EntityItem(world, x, y, z, this.makeNormalStack(stackSize));
    }

    public int getMaxStackSize() {
        if (this.maxStackSize == 0) {
            ItemStack tstack = this.unsafeMakeNormalStack(0);
            int tstacksize = tstack.func_77976_d();
            if (tstack.func_77984_f() && tstack.func_77951_h()) {
                tstacksize = 1;
            }
            this.maxStackSize = tstacksize = Math.max(1, Math.min(64, tstacksize));
        }
        return this.maxStackSize;
    }

    private static Map<Integer, Object> getArrayAsMap(int[] array) {
        HashMap<Integer, Object> map = new HashMap<Integer, Object>();
        int i = 0;
        for (int object : array) {
            map.put(i, object);
            ++i;
        }
        return map;
    }

    private static Map<Integer, Object> getArrayAsMap(byte[] array) {
        HashMap<Integer, Object> map = new HashMap<Integer, Object>();
        int i = 1;
        for (byte object : array) {
            map.put(i, object);
            ++i;
        }
        return map;
    }

    public static Map<Object, Object> getNBTBaseAsMap(NBTBase nbt) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        if (nbt == null) {
            return null;
        }
        if (nbt instanceof NBTTagByte) {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            map.put("type", "NBTTagByte");
            map.put("value", ((NBTTagByte)nbt).func_150290_f());
            return map;
        }
        if (nbt instanceof NBTTagByteArray) {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            map.put("type", "NBTTagByteArray");
            map.put("value", ItemIdentifier.getArrayAsMap(((NBTTagByteArray)nbt).func_150292_c()));
            return map;
        }
        if (nbt instanceof NBTTagDouble) {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            map.put("type", "NBTTagDouble");
            map.put("value", ((NBTTagDouble)nbt).func_150286_g());
            return map;
        }
        if (nbt instanceof NBTTagFloat) {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            map.put("type", "NBTTagFloat");
            map.put("value", Float.valueOf(((NBTTagFloat)nbt).func_150288_h()));
            return map;
        }
        if (nbt instanceof NBTTagInt) {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            map.put("type", "NBTTagInt");
            map.put("value", ((NBTTagInt)nbt).func_150287_d());
            return map;
        }
        if (nbt instanceof NBTTagIntArray) {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            map.put("type", "NBTTagIntArray");
            map.put("value", ItemIdentifier.getArrayAsMap(((NBTTagIntArray)nbt).func_150302_c()));
            return map;
        }
        if (nbt instanceof NBTTagList) {
            List internal = ((NBTTagList)nbt).field_74747_a;
            HashMap<Integer, Map<Object, Object>> content = new HashMap<Integer, Map<Object, Object>>();
            int i = 1;
            for (Object object : internal) {
                if (object instanceof NBTBase) {
                    content.put(i, ItemIdentifier.getNBTBaseAsMap((NBTBase)object));
                }
                ++i;
            }
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            map.put("type", "NBTTagList");
            map.put("value", content);
            return map;
        }
        if (nbt instanceof NBTTagCompound) {
            Map internal = ((NBTTagCompound)nbt).field_74784_a;
            HashMap content = new HashMap();
            HashMap keys = new HashMap();
            int i = 1;
            for (Map.Entry object : internal.entrySet()) {
                Map.Entry e = object;
                if (e.getValue() instanceof NBTBase) {
                    content.put(e.getKey(), ItemIdentifier.getNBTBaseAsMap((NBTBase)e.getValue()));
                    keys.put(i, e.getKey());
                }
                ++i;
            }
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            map.put("type", "NBTTagCompound");
            map.put("value", content);
            map.put("keys", keys);
            return map;
        }
        if (nbt instanceof NBTTagLong) {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            map.put("type", "NBTTagLong");
            map.put("value", ((NBTTagLong)nbt).func_150291_c());
            return map;
        }
        if (nbt instanceof NBTTagShort) {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            map.put("type", "NBTTagShort");
            map.put("value", ((NBTTagShort)nbt).func_150287_d());
            return map;
        }
        if (nbt instanceof NBTTagString) {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            map.put("type", "NBTTagString");
            map.put("value", ((NBTTagString)nbt).func_150285_a_());
            return map;
        }
        throw new UnsupportedOperationException("Unsupported NBTBase of type:" + nbt.getClass().getName());
    }

    public String toString() {
        return this.getModName() + ":" + this.getFriendlyName() + ", " + Item.func_150891_b((Item)this.item) + ":" + this.itemDamage;
    }

    @Override
    public int compareTo(ItemIdentifier o) {
        int c = Item.func_150891_b((Item)this.item) - Item.func_150891_b((Item)o.item);
        if (c != 0) {
            return c;
        }
        c = this.itemDamage - o.itemDamage;
        if (c != 0) {
            return c;
        }
        c = this.uniqueID - o.uniqueID;
        return c;
    }

    public boolean equals(Object that) {
        if (that instanceof ItemIdentifierStack) {
            throw new IllegalStateException("Comparison between ItemIdentifierStack and ItemIdentifier -- did you forget a .getItem() in your code?");
        }
        if (!(that instanceof ItemIdentifier)) {
            return false;
        }
        ItemIdentifier i = (ItemIdentifier)that;
        return this.equals(i);
    }

    public boolean equals(ItemIdentifier that) {
        if (that == null) {
            return false;
        }
        return this.item == that.item && this.itemDamage == that.itemDamage && this.uniqueID == that.uniqueID;
    }

    public int hashCode() {
        if (this.tag == null) {
            return this.item.hashCode() + this.itemDamage;
        }
        return this.item.hashCode() + this.itemDamage ^ this.tag.hashCode();
    }

    public boolean equalsForCrafting(ItemIdentifier item) {
        return this.item == item.item && (item.isDamageable() || this.itemDamage == item.itemDamage);
    }

    public boolean equalsWithoutNBT(ItemStack stack) {
        return this.item == stack.func_77973_b() && this.itemDamage == stack.func_77960_j();
    }

    public boolean equalsWithoutNBT(ItemIdentifier item) {
        return this.item == item.item && this.itemDamage == item.itemDamage;
    }

    public boolean isDamageable() {
        return this.unsafeMakeNormalStack(0).func_77984_f();
    }

    public boolean isFluidContainer() {
        return this.item instanceof LogisticsFluidContainer;
    }

    public DictItemIdentifier getDictIdentifiers() {
        if (this._dict == null && this.canHaveDict) {
            this._dict = DictItemIdentifier.getDictItemIdentifier(this);
            this.canHaveDict = false;
        }
        return this._dict;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isRenderListCompatible(LogisticsRenderPipe render) {
        if (this.isRenderListCompatible == null) {
            this.isRenderListCompatible = render.isRenderListCompatible(this.makeNormalStack(1));
        }
        return this.isRenderListCompatible;
    }

    public void debugDumpData(boolean isClient) {
        System.out.println((isClient ? "Client" : "Server") + " Item: " + Item.func_150891_b((Item)this.item) + ":" + this.itemDamage + " uniqueID " + this.uniqueID);
        StringBuilder sb = new StringBuilder();
        sb.append("Tag: ");
        this.debugDumpTag((NBTBase)this.tag, sb);
        System.out.println(sb.toString());
        System.out.println("Damageable: " + this.isDamageable());
        System.out.println("MaxStackSize: " + this.getMaxStackSize());
        if (this.getUndamaged() == this) {
            System.out.println("Undamaged: this");
        } else {
            System.out.println("Undamaged:");
            this.getUndamaged().debugDumpData(isClient);
        }
        System.out.println("Mod: " + this.getModName());
        System.out.println("CreativeTab: " + this.getCreativeTabName());
        if (this.getDictIdentifiers() != null) {
            this.getDictIdentifiers().debugDumpData(isClient);
        }
    }

    private void debugDumpTag(NBTBase nbt, StringBuilder sb) {
        if (nbt == null) {
            sb.append("null");
            return;
        }
        if (nbt instanceof NBTTagByte) {
            sb.append("TagByte(data=" + ((NBTTagByte)nbt).func_150290_f() + ")");
        } else if (nbt instanceof NBTTagShort) {
            sb.append("TagShort(data=" + ((NBTTagShort)nbt).func_150289_e() + ")");
        } else if (nbt instanceof NBTTagInt) {
            sb.append("TagInt(data=" + ((NBTTagInt)nbt).func_150287_d() + ")");
        } else if (nbt instanceof NBTTagLong) {
            sb.append("TagLong(data=" + ((NBTTagLong)nbt).func_150291_c() + ")");
        } else if (nbt instanceof NBTTagFloat) {
            sb.append("TagFloat(data=" + ((NBTTagFloat)nbt).func_150288_h() + ")");
        } else if (nbt instanceof NBTTagDouble) {
            sb.append("TagDouble(data=" + ((NBTTagDouble)nbt).func_150286_g() + ")");
        } else if (nbt instanceof NBTTagString) {
            sb.append("TagString(data=\"" + ((NBTTagString)nbt).func_150285_a_() + "\")");
        } else if (nbt instanceof NBTTagByteArray) {
            sb.append("TagByteArray(data=");
            for (int i = 0; i < ((NBTTagByteArray)nbt).func_150292_c().length; ++i) {
                sb.append(((NBTTagByteArray)nbt).func_150292_c()[i]);
                if (i >= ((NBTTagByteArray)nbt).func_150292_c().length - 1) continue;
                sb.append(",");
            }
            sb.append(")");
        } else if (nbt instanceof NBTTagIntArray) {
            sb.append("TagIntArray(data=");
            for (int i = 0; i < ((NBTTagIntArray)nbt).func_150302_c().length; ++i) {
                sb.append(((NBTTagIntArray)nbt).func_150302_c()[i]);
                if (i >= ((NBTTagIntArray)nbt).func_150302_c().length - 1) continue;
                sb.append(",");
            }
            sb.append(")");
        } else if (nbt instanceof NBTTagList) {
            sb.append("TagList(data=");
            for (int i = 0; i < ((NBTTagList)nbt).field_74747_a.size(); ++i) {
                this.debugDumpTag((NBTBase)((NBTTagList)nbt).field_74747_a.get(i), sb);
                if (i >= ((NBTTagList)nbt).field_74747_a.size() - 1) continue;
                sb.append(",");
            }
            sb.append(")");
        } else if (nbt instanceof NBTTagCompound) {
            sb.append("TagCompound(data=");
            Object[] oe = ((NBTTagCompound)nbt).field_74784_a.entrySet().toArray();
            for (int i = 0; i < oe.length; ++i) {
                Map.Entry e = (Map.Entry)oe[i];
                sb.append("\"" + (String)e.getKey() + "\"=");
                this.debugDumpTag((NBTBase)e.getValue(), sb);
                if (i >= oe.length - 1) continue;
                sb.append(",");
            }
            sb.append(")");
        } else {
            sb.append(nbt.getClass().getName() + "(?)");
        }
    }

    @Override
    public void setCCType(Object type) {
        this.ccType = type;
    }

    @Override
    public Object getCCType() {
        return this.ccType;
    }

    public static class ItemStackAddInfo
    implements IAddInfo {
        private final ItemIdentifier ident;

        public ItemStackAddInfo(ItemIdentifier ident) {
            this.ident = ident;
        }
    }

    private static final class ItemIdentifierCleanupThread
    extends Thread {
        public ItemIdentifierCleanupThread() {
            this.setName("LogisticsPipes ItemIdentifier Cleanup Thread");
            this.setDaemon(true);
            this.start();
        }

        @Override
        public void run() {
            while (true) {
                IDReference r;
                try {
                    r = (IDReference)keyRefQueue.remove();
                }
                catch (InterruptedException e) {
                    continue;
                }
                keyRefWlock.lock();
                do {
                    IDReference current;
                    if (r != (current = (IDReference)keyRefMap.get(r.key))) continue;
                    keyRefMap.remove(r.key);
                    ((BitSet)tagIDsets.get(((IDReference)r).key.item)).clear(r.uniqueID);
                } while ((r = (IDReference)keyRefQueue.poll()) != null);
                keyRefWlock.unlock();
            }
        }
    }

    private static class ArrayDamagedItentifierHolder
    implements IDamagedIdentifierHolder {
        private AtomicReferenceArray<ItemIdentifier> holder;

        public ArrayDamagedItentifierHolder(int damage) {
            this.holder = new AtomicReferenceArray(ArrayDamagedItentifierHolder.getArrayLength(damage));
        }

        private static int getArrayLength(int damage) {
            return 1 << 32 - Integer.numberOfLeadingZeros(damage);
        }

        @Override
        public ItemIdentifier get(int damage) {
            return this.holder.get(damage);
        }

        @Override
        public void set(int damage, ItemIdentifier ident) {
            this.holder.set(damage, ident);
        }

        @Override
        public void ensureCapacity(int damage) {
            if (this.holder.length() <= damage) {
                AtomicReferenceArray<ItemIdentifier> newdamages = new AtomicReferenceArray<ItemIdentifier>(ArrayDamagedItentifierHolder.getArrayLength(damage));
                for (int i = 0; i < this.holder.length(); ++i) {
                    newdamages.set(i, this.holder.get(i));
                }
                this.holder = newdamages;
            }
        }
    }

    private static class MapDamagedItentifierHolder
    implements IDamagedIdentifierHolder {
        private ConcurrentHashMap<Integer, ItemIdentifier> holder = new ConcurrentHashMap(4096, 0.5f, 1);

        @Override
        public ItemIdentifier get(int damage) {
            return this.holder.get(damage);
        }

        @Override
        public void set(int damage, ItemIdentifier item) {
            this.holder.put(damage, item);
        }

        @Override
        public void ensureCapacity(int damage) {
        }
    }

    private static interface IDamagedIdentifierHolder {
        public ItemIdentifier get(int var1);

        public void set(int var1, ItemIdentifier var2);

        public void ensureCapacity(int var1);
    }

    private static class IDReference
    extends WeakReference<ItemIdentifier> {
        private final ItemKey key;
        private final int uniqueID;

        IDReference(ItemKey k, int u, ItemIdentifier id) {
            super(id, keyRefQueue);
            this.key = k;
            this.uniqueID = u;
        }
    }

    private static class ItemKey {
        public final Item item;
        public final int itemDamage;
        public final FinalNBTTagCompound tag;

        public ItemKey(Item i, int d, FinalNBTTagCompound t) {
            this.item = i;
            this.itemDamage = d;
            this.tag = t;
        }

        public boolean equals(Object that) {
            if (!(that instanceof ItemKey)) {
                return false;
            }
            ItemKey i = (ItemKey)that;
            return this.item == i.item && this.itemDamage == i.itemDamage && this.tag.equals((Object)i.tag);
        }

        public int hashCode() {
            return this.item.hashCode() ^ this.itemDamage ^ this.tag.hashCode();
        }
    }
}

