/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.specialconnection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import logisticspipes.interfaces.routing.ISpecialTileConnection;
import logisticspipes.logisticspipes.IRoutedItem;
import net.minecraft.tileentity.TileEntity;

public class SpecialTileConnection {
    private List<ISpecialTileConnection> handler = new ArrayList<ISpecialTileConnection>();

    public void registerHandler(ISpecialTileConnection connectionHandler) {
        if (connectionHandler.init()) {
            this.handler.add(connectionHandler);
        }
    }

    public Collection<TileEntity> getConnectedPipes(TileEntity tile) {
        for (ISpecialTileConnection connectionHandler : this.handler) {
            if (!connectionHandler.isType(tile)) continue;
            return connectionHandler.getConnections(tile);
        }
        return new ArrayList<TileEntity>();
    }

    public boolean needsInformationTransition(TileEntity tile) {
        for (ISpecialTileConnection connectionHandler : this.handler) {
            if (!connectionHandler.isType(tile)) continue;
            return connectionHandler.needsInformationTransition();
        }
        return false;
    }

    public void transmit(TileEntity tile, IRoutedItem arrivingItem) {
        for (ISpecialTileConnection connectionHandler : this.handler) {
            if (!connectionHandler.isType(tile)) continue;
            connectionHandler.transmit(tile, arrivingItem);
            break;
        }
    }

    public boolean isType(TileEntity tile) {
        for (ISpecialTileConnection connectionHandler : this.handler) {
            if (!connectionHandler.isType(tile)) continue;
            return true;
        }
        return false;
    }
}

