/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.pipe;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import logisticspipes.config.Configs;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.packets.pipe.RoutingLaserPacket;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.IPaintPath;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.LaserData;
import logisticspipes.routing.PipeRoutingConnectionType;
import logisticspipes.routing.pathfinder.PathFinder;
import logisticspipes.utils.tuples.LPPosition;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class RequestRoutingLasersPacket
extends CoordinatesPacket {
    private boolean firstPipe = false;

    public RequestRoutingLasersPacket(int id) {
        super(id);
    }

    @Override
    public void processPacket(EntityPlayer player) {
        LogisticsTileGenericPipe tile = this.getPipe(player.field_70170_p);
        if (tile == null) {
            return;
        }
        if (tile.pipe instanceof CoreRoutedPipe) {
            IRouter router = ((CoreRoutedPipe)tile.pipe).getRouter();
            router.forceLsaUpdate();
            List<List<ExitRoute>> exits = router.getRouteTable();
            HashMap routers = new HashMap();
            for (List<ExitRoute> exit : exits) {
                if (exit == null) continue;
                for (ExitRoute e : exit) {
                    if (!routers.containsKey(e.exitOrientation)) {
                        routers.put(e.exitOrientation, new ArrayList());
                    }
                    if (((ArrayList)routers.get(e.exitOrientation)).contains(e)) continue;
                    ((ArrayList)routers.get(e.exitOrientation)).add(e);
                }
            }
            ArrayList<LaserData> lasers = new ArrayList<LaserData>();
            this.firstPipe = true;
            for (final ForgeDirection dir : routers.keySet()) {
                if (dir == ForgeDirection.UNKNOWN) continue;
                this.handleRouteInDirection(tile, dir, (ArrayList)routers.get(dir), lasers, EnumSet.allOf(PipeRoutingConnectionType.class), new Log(){

                    @Override
                    void log(String log) {
                    }
                });
            }
            lasers = this.compressLasers(lasers);
            MainProxy.sendPacketToPlayer(PacketHandler.getPacket(RoutingLaserPacket.class).setLasers(lasers), player);
        }
    }

    private void handleRouteInDirection(LogisticsTileGenericPipe pipeIn, ForgeDirection dirIn, ArrayList<ExitRoute> connectedRoutersIn, List<LaserData> lasersIn, EnumSet<PipeRoutingConnectionType> connectionTypeIn, Log logIn) {
        LinkedList<DataEntry> worklist = new LinkedList<DataEntry>();
        worklist.add(new DataEntry(pipeIn, dirIn, connectedRoutersIn, lasersIn, connectionTypeIn, logIn));
        while (!worklist.isEmpty()) {
            DataEntry entry = (DataEntry)worklist.remove(0);
            final LogisticsTileGenericPipe pipe = entry.pipe;
            ForgeDirection dir = entry.dir;
            ArrayList<ExitRoute> connectedRouters = entry.connectedRouters;
            final List<LaserData> lasers = entry.lasers;
            EnumSet<PipeRoutingConnectionType> connectionType = entry.connectionType;
            final Log log = entry.log;
            lasers.add(new LaserData(pipe.field_145851_c, pipe.field_145848_d, pipe.field_145849_e, dir, connectionType).setStartPipe(this.firstPipe));
            this.firstPipe = false;
            HashMap<CoreRoutedPipe, ExitRoute> map = PathFinder.paintAndgetConnectedRoutingPipes(pipe, dir, Configs.LOGISTICS_DETECTION_COUNT, Configs.LOGISTICS_DETECTION_LENGTH, new IPaintPath(){

                @Override
                public void addLaser(World worldObj, LaserData laser) {
                    if (pipe.getWorld() == worldObj) {
                        lasers.add(laser);
                    }
                }
            }, connectionType);
            for (CoreRoutedPipe connectedPipe : map.keySet()) {
                IRouter iRouter = connectedPipe.getRouter();
                Iterator<ExitRoute> iRoutes = connectedRouters.iterator();
                while (iRoutes.hasNext()) {
                    ExitRoute route = iRoutes.next();
                    if (route.destination != iRouter) continue;
                    iRoutes.remove();
                }
            }
            HashMap sort = new HashMap();
            for (ExitRoute exitRoute : connectedRouters) {
                ExitRoute result = null;
                CoreRoutedPipe resultPipe = null;
                for (Map.Entry<CoreRoutedPipe, ExitRoute> routeCanidate : map.entrySet()) {
                    List<ExitRoute> distances = routeCanidate.getValue().destination.getDistanceTo(exitRoute.destination);
                    for (ExitRoute distance : distances) {
                        if (!distance.isSameWay(exitRoute) || result != null && !(result.distanceToDestination > distance.distanceToDestination)) continue;
                        result = distance;
                        resultPipe = routeCanidate.getKey();
                    }
                }
                if (result == null) continue;
                if (!sort.containsKey(resultPipe)) {
                    sort.put(resultPipe, new ArrayList());
                }
                if (((ArrayList)sort.get(resultPipe)).contains(result)) continue;
                ((ArrayList)sort.get(resultPipe)).add(result);
            }
            for (Map.Entry entry2 : sort.entrySet()) {
                HashMap routers = new HashMap();
                for (ExitRoute exit : (ArrayList)entry2.getValue()) {
                    if (!routers.containsKey(exit.exitOrientation)) {
                        routers.put(exit.exitOrientation, new ArrayList());
                    }
                    if (((ArrayList)routers.get(exit.exitOrientation)).contains(exit)) continue;
                    ((ArrayList)routers.get(exit.exitOrientation)).add(exit);
                }
                for (final ForgeDirection exitDir : routers.keySet()) {
                    if (exitDir == ForgeDirection.UNKNOWN) continue;
                    worklist.add(new DataEntry(((CoreRoutedPipe)entry2.getKey()).container, exitDir, (ArrayList)routers.get(exitDir), lasers, map.get(entry2.getKey()).connectionDetails, new Log(){

                        @Override
                        void log(String logString) {
                        }
                    }));
                }
            }
        }
    }

    private ArrayList<LaserData> compressLasers(ArrayList<LaserData> lasers) {
        ArrayList<LaserData> options = new ArrayList<LaserData>();
        options.addAll(lasers);
        Iterator<LaserData> iLasers = lasers.iterator();
        while (iLasers.hasNext()) {
            boolean compressed = false;
            LaserData data = iLasers.next();
            LPPosition next = new LPPosition(data.getPosX(), data.getPosY(), data.getPosZ());
            next.moveForward(data.getDir(), data.getLength());
            boolean found = false;
            do {
                found = false;
                Iterator iOptions = options.iterator();
                while (iOptions.hasNext()) {
                    LaserData d = (LaserData)iOptions.next();
                    if (d.getPosX() != next.getX() || d.getPosY() != next.getY() || d.getPosZ() != next.getZ()) continue;
                    if (data.getDir().equals((Object)d.getDir()) && data.getConnectionType().equals(d.getConnectionType())) {
                        data.setLength(data.getLength() + d.getLength());
                        next.moveForward(data.getDir(), d.getLength());
                        found = true;
                        iOptions.remove();
                        lasers.remove(d);
                        compressed = true;
                        continue;
                    }
                    if (!data.getDir().equals((Object)d.getDir())) continue;
                    data.setFinalPipe(false);
                }
            } while (found);
            if (!compressed) continue;
            iLasers = lasers.iterator();
        }
        return lasers;
    }

    @Override
    public ModernPacket template() {
        return new RequestRoutingLasersPacket(this.getId());
    }

    private class DataEntry {
        final LogisticsTileGenericPipe pipe;
        final ForgeDirection dir;
        final ArrayList<ExitRoute> connectedRouters;
        final List<LaserData> lasers;
        final EnumSet<PipeRoutingConnectionType> connectionType;
        final Log log;

        public LogisticsTileGenericPipe getPipe() {
            return this.pipe;
        }

        public ForgeDirection getDir() {
            return this.dir;
        }

        public ArrayList<ExitRoute> getConnectedRouters() {
            return this.connectedRouters;
        }

        public List<LaserData> getLasers() {
            return this.lasers;
        }

        public EnumSet<PipeRoutingConnectionType> getConnectionType() {
            return this.connectionType;
        }

        public Log getLog() {
            return this.log;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DataEntry)) {
                return false;
            }
            DataEntry other = (DataEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            LogisticsTileGenericPipe this$pipe = this.getPipe();
            LogisticsTileGenericPipe other$pipe = other.getPipe();
            if (this$pipe == null ? other$pipe != null : !this$pipe.equals(other$pipe)) {
                return false;
            }
            ForgeDirection this$dir = this.getDir();
            ForgeDirection other$dir = other.getDir();
            if (this$dir == null ? other$dir != null : !this$dir.equals(other$dir)) {
                return false;
            }
            ArrayList<ExitRoute> this$connectedRouters = this.getConnectedRouters();
            ArrayList<ExitRoute> other$connectedRouters = other.getConnectedRouters();
            if (this$connectedRouters == null ? other$connectedRouters != null : !((Object)this$connectedRouters).equals(other$connectedRouters)) {
                return false;
            }
            List<LaserData> this$lasers = this.getLasers();
            List<LaserData> other$lasers = other.getLasers();
            if (this$lasers == null ? other$lasers != null : !((Object)this$lasers).equals(other$lasers)) {
                return false;
            }
            EnumSet<PipeRoutingConnectionType> this$connectionType = this.getConnectionType();
            EnumSet<PipeRoutingConnectionType> other$connectionType = other.getConnectionType();
            if (this$connectionType == null ? other$connectionType != null : !((Object)this$connectionType).equals(other$connectionType)) {
                return false;
            }
            Log this$log = this.getLog();
            Log other$log = other.getLog();
            return !(this$log == null ? other$log != null : !this$log.equals(other$log));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DataEntry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            LogisticsTileGenericPipe $pipe = this.getPipe();
            result = result * 59 + ($pipe == null ? 43 : $pipe.hashCode());
            ForgeDirection $dir = this.getDir();
            result = result * 59 + ($dir == null ? 43 : $dir.hashCode());
            ArrayList<ExitRoute> $connectedRouters = this.getConnectedRouters();
            result = result * 59 + ($connectedRouters == null ? 43 : ((Object)$connectedRouters).hashCode());
            List<LaserData> $lasers = this.getLasers();
            result = result * 59 + ($lasers == null ? 43 : ((Object)$lasers).hashCode());
            EnumSet<PipeRoutingConnectionType> $connectionType = this.getConnectionType();
            result = result * 59 + ($connectionType == null ? 43 : ((Object)$connectionType).hashCode());
            Log $log = this.getLog();
            result = result * 59 + ($log == null ? 43 : $log.hashCode());
            return result;
        }

        public String toString() {
            return "RequestRoutingLasersPacket.DataEntry(pipe=" + this.getPipe() + ", dir=" + this.getDir() + ", connectedRouters=" + this.getConnectedRouters() + ", lasers=" + this.getLasers() + ", connectionType=" + this.getConnectionType() + ", log=" + this.getLog() + ")";
        }

        public DataEntry(LogisticsTileGenericPipe pipe, ForgeDirection dir, ArrayList<ExitRoute> connectedRouters, List<LaserData> lasers, EnumSet<PipeRoutingConnectionType> connectionType, Log log) {
            this.pipe = pipe;
            this.dir = dir;
            this.connectedRouters = connectedRouters;
            this.lasers = lasers;
            this.connectionType = connectionType;
            this.log = log;
        }
    }

    private abstract class Log {
        private Log() {
        }

        abstract void log(String var1);
    }
}

