/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.orderer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import logisticspipes.network.IReadListObject;
import logisticspipes.network.IWriteListObject;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.proxy.MainProxy;
import logisticspipes.request.resources.IResource;
import net.minecraft.entity.player.EntityPlayer;

public class ComponentList
extends ModernPacket {
    private Collection<IResource> used = new ArrayList<IResource>();
    private Collection<IResource> missing = new ArrayList<IResource>();

    public ComponentList(int id) {
        super(id);
    }

    @Override
    public ModernPacket template() {
        return new ComponentList(this.getId());
    }

    @Override
    public void processPacket(EntityPlayer player) {
        MainProxy.proxy.processComponentListPacket(this, player);
    }

    @Override
    public void writeData(LPDataOutputStream data) throws IOException {
        data.writeCollection(this.used, new IWriteListObject<IResource>(){

            @Override
            public void writeObject(LPDataOutputStream data, IResource object) throws IOException {
                data.writeIResource(object);
            }
        });
        data.writeCollection(this.missing, new IWriteListObject<IResource>(){

            @Override
            public void writeObject(LPDataOutputStream data, IResource object) throws IOException {
                data.writeIResource(object);
            }
        });
        data.write(0);
    }

    @Override
    public void readData(LPDataInputStream data) throws IOException {
        this.used = data.readList(new IReadListObject<IResource>(){

            @Override
            public IResource readObject(LPDataInputStream data) throws IOException {
                return data.readIResource();
            }
        });
        this.missing = data.readList(new IReadListObject<IResource>(){

            @Override
            public IResource readObject(LPDataInputStream data) throws IOException {
                return data.readIResource();
            }
        });
    }

    public Collection<IResource> getUsed() {
        return this.used;
    }

    public ComponentList setUsed(Collection<IResource> used) {
        this.used = used;
        return this;
    }

    public Collection<IResource> getMissing() {
        return this.missing;
    }

    public ComponentList setMissing(Collection<IResource> missing) {
        this.missing = missing;
        return this;
    }
}

