/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.blocks.powertile;

import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.common.Optional;
import logisticspipes.blocks.powertile.LogisticsPowerProviderTileEntity;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.cofh.subproxies.ICoFHEnergyStorage;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.Interface(modid="CoFHAPI|energy", iface="cofh.api.energy.IEnergyHandler")
public class LogisticsRFPowerProviderTileEntity
extends LogisticsPowerProviderTileEntity
implements IEnergyHandler {
    public static final int MAX_STORAGE = 10000000;
    public static final int MAX_MAXMODE = 8;
    public static final int MAX_PROVIDE_PER_TICK = 10000;
    private ICoFHEnergyStorage storage = SimpleServiceLocator.cofhPowerProxy.getEnergyStorage(10000);

    public void addEnergy(float amount) {
        if (MainProxy.isClient(this.func_145831_w())) {
            return;
        }
        this.internalStorage += amount;
        if (this.internalStorage > 1.0E7f) {
            this.internalStorage = 1.0E7f;
        }
        if (this.internalStorage >= (float)this.getMaxStorage()) {
            this.needMorePowerTriggerCheck = false;
        }
    }

    private void addStoredRF() {
        int space = this.freeSpace();
        int available = this.storage.extractEnergy(space, true);
        if (available > 0 && this.storage.extractEnergy(available, false) == available) {
            this.addEnergy(available);
        }
    }

    public int freeSpace() {
        return (int)((float)this.getMaxStorage() - this.internalStorage);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (MainProxy.isServer(this.field_145850_b) && this.freeSpace() > 0) {
            this.addStoredRF();
        }
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.storage.extractEnergy(maxExtract, simulate);
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public int getMaxStorage() {
        this.maxMode = Math.min(8, Math.max(1, this.maxMode));
        return 10000000 / this.maxMode;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.storage.readFromNBT(nbt);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.storage.writeToNBT(nbt);
    }

    @Override
    public String getBrand() {
        return "RF";
    }

    @Override
    protected float getMaxProvidePerTick() {
        return 10000.0f;
    }

    @Override
    protected void handlePower(CoreRoutedPipe pipe, float toSend) {
        pipe.handleRFPowerArival(toSend);
    }

    @Override
    protected int getLaserColor() {
        return 0xFF0000;
    }
}

