/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes.basic;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import logisticspipes.interfaces.ISubSystemPowerProvider;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.cofh.subproxies.ICoFHEnergyReceiver;
import logisticspipes.utils.AdjacentTile;
import logisticspipes.utils.WorldUtil;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.nbt.NBTTagCompound;

public class PowerSupplierHandler {
    private static final float INTERNAL_RF_BUFFER_MAX = 10000.0f;
    private static final float INTERNAL_IC2_BUFFER_MAX = 8192.0f;
    private final CoreRoutedPipe pipe;
    private float internal_RF_Buffer = 0.0f;
    private float internal_IC2_Buffer = 0.0f;

    public PowerSupplierHandler(CoreRoutedPipe pipe) {
        this.pipe = pipe;
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        if (this.internal_RF_Buffer > 0.0f) {
            nbttagcompound.func_74776_a("bufferRF", this.internal_RF_Buffer);
        }
        if (this.internal_IC2_Buffer > 0.0f) {
            nbttagcompound.func_74776_a("bufferEU", this.internal_IC2_Buffer);
        }
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.internal_RF_Buffer = nbttagcompound.func_74760_g("bufferRF");
        this.internal_IC2_Buffer = nbttagcompound.func_74760_g("bufferEU");
    }

    public void update() {
        int i;
        float[] need;
        float globalNeed;
        LinkedList<AdjacentTile> adjacent;
        WorldUtil worldUtil;
        if (SimpleServiceLocator.cofhPowerProxy.isAvailable() && this.pipe.getUpgradeManager().hasRFPowerSupplierUpgrade()) {
            float f;
            Object pair;
            worldUtil = new WorldUtil(this.pipe.getWorld(), this.pipe.getX(), this.pipe.getY(), this.pipe.getZ());
            adjacent = worldUtil.getAdjacentTileEntities(false);
            globalNeed = 0.0f;
            need = new float[adjacent.size()];
            i = 0;
            for (AdjacentTile adjacentTile : adjacent) {
                ICoFHEnergyReceiver iCoFHEnergyReceiver;
                if (SimpleServiceLocator.cofhPowerProxy.isEnergyReceiver(adjacentTile.tile) && this.pipe.canPipeConnect(adjacentTile.tile, adjacentTile.orientation) && (iCoFHEnergyReceiver = SimpleServiceLocator.cofhPowerProxy.getEnergyReceiver(adjacentTile.tile)).canConnectEnergy(adjacentTile.orientation.getOpposite())) {
                    need[i] = iCoFHEnergyReceiver.getMaxEnergyStored(adjacentTile.orientation.getOpposite()) - iCoFHEnergyReceiver.getEnergyStored(adjacentTile.orientation.getOpposite());
                    globalNeed += need[i];
                }
                ++i;
            }
            if (globalNeed != 0.0f && !Float.isNaN(globalNeed)) {
                float fullfillable = Math.min(1.0f, this.internal_RF_Buffer / globalNeed);
                i = 0;
                for (AdjacentTile adjacentTile : adjacent) {
                    ICoFHEnergyReceiver handler;
                    if (SimpleServiceLocator.cofhPowerProxy.isEnergyReceiver(adjacentTile.tile) && this.pipe.canPipeConnect(adjacentTile.tile, adjacentTile.orientation) && (handler = SimpleServiceLocator.cofhPowerProxy.getEnergyReceiver(adjacentTile.tile)).canConnectEnergy(adjacentTile.orientation.getOpposite())) {
                        if (this.internal_RF_Buffer + 1.0f < need[i] * fullfillable) {
                            return;
                        }
                        int used = handler.receiveEnergy(adjacentTile.orientation.getOpposite(), (int)(need[i] * fullfillable), false);
                        if (used > 0) {
                            this.pipe.container.addLaser(adjacentTile.orientation, 0.5f, 0xFF0000, false, true);
                            this.internal_RF_Buffer -= (float)used;
                        }
                        if (this.internal_RF_Buffer < 0.0f) {
                            this.internal_RF_Buffer = 0.0f;
                            return;
                        }
                    }
                    ++i;
                }
            }
            List<Pair<ISubSystemPowerProvider, List<IFilter>>> provider = this.pipe.getRouter().getSubSystemPowerProvider();
            float f2 = 0.0f;
            Iterator iterator = provider.iterator();
            block2: while (iterator.hasNext()) {
                pair = (Pair)iterator.next();
                for (IFilter filter : (List)((Pair)pair).getValue2()) {
                    if (!filter.blockPower()) continue;
                    continue block2;
                }
                if (((ISubSystemPowerProvider)((Pair)pair).getValue1()).usePaused() || !((ISubSystemPowerProvider)((Pair)pair).getValue1()).getBrand().equals("RF")) continue;
                f2 += ((ISubSystemPowerProvider)((Pair)pair).getValue1()).getPowerLevel();
            }
            if (f2 > 0.0f && (f = 10000.0f - this.internal_RF_Buffer) > 0.0f && this.pipe.useEnergy((int)(f / 100.0f), false)) {
                pair = provider.iterator();
                block4: while (pair.hasNext()) {
                    Pair pair2 = (Pair)pair.next();
                    for (IFilter filter : (List)pair2.getValue2()) {
                        if (!filter.blockPower()) continue;
                        continue block4;
                    }
                    if (((ISubSystemPowerProvider)pair2.getValue1()).usePaused() || !((ISubSystemPowerProvider)pair2.getValue1()).getBrand().equals("RF")) continue;
                    float requestamount = f * (((ISubSystemPowerProvider)pair2.getValue1()).getPowerLevel() / f2);
                    ((ISubSystemPowerProvider)pair2.getValue1()).requestPower(this.pipe.getRouterId(), requestamount);
                }
            }
        }
        if (SimpleServiceLocator.IC2Proxy.hasIC2() && this.pipe.getUpgradeManager().getIC2PowerLevel() > 0) {
            float f;
            worldUtil = new WorldUtil(this.pipe.getWorld(), this.pipe.getX(), this.pipe.getY(), this.pipe.getZ());
            adjacent = worldUtil.getAdjacentTileEntities(false);
            globalNeed = 0.0f;
            need = new float[adjacent.size()];
            i = 0;
            for (AdjacentTile adjacentTile : adjacent) {
                if (SimpleServiceLocator.IC2Proxy.isEnergySink(adjacentTile.tile) && this.pipe.canPipeConnect(adjacentTile.tile, adjacentTile.orientation) && SimpleServiceLocator.IC2Proxy.acceptsEnergyFrom(adjacentTile.tile, this.pipe.container, adjacentTile.orientation.getOpposite())) {
                    need[i] = (float)SimpleServiceLocator.IC2Proxy.demandedEnergyUnits(adjacentTile.tile);
                    globalNeed += need[i];
                }
                ++i;
            }
            if (globalNeed != 0.0f && !Float.isNaN(globalNeed)) {
                float fullfillable = Math.min(1.0f, this.internal_IC2_Buffer / globalNeed);
                i = 0;
                for (AdjacentTile adjacentTile : adjacent) {
                    if (SimpleServiceLocator.IC2Proxy.isEnergySink(adjacentTile.tile) && this.pipe.canPipeConnect(adjacentTile.tile, adjacentTile.orientation) && SimpleServiceLocator.IC2Proxy.acceptsEnergyFrom(adjacentTile.tile, this.pipe.container, adjacentTile.orientation.getOpposite())) {
                        double unUsed;
                        if (this.internal_IC2_Buffer + 1.0f < need[i] * fullfillable) {
                            return;
                        }
                        double toUse = Math.min((float)this.pipe.getUpgradeManager().getIC2PowerLevel(), need[i] * fullfillable);
                        double used = toUse - (unUsed = SimpleServiceLocator.IC2Proxy.injectEnergyUnits(adjacentTile.tile, adjacentTile.orientation.getOpposite(), toUse));
                        if (used > 0.0) {
                            this.pipe.container.addLaser(adjacentTile.orientation, 0.5f, 0xFFFF00, false, true);
                            this.internal_IC2_Buffer = (float)((double)this.internal_IC2_Buffer - used);
                        }
                        if (this.internal_IC2_Buffer < 0.0f) {
                            this.internal_IC2_Buffer = 0.0f;
                            return;
                        }
                    }
                    ++i;
                }
            }
            List<Pair<ISubSystemPowerProvider, List<IFilter>>> provider = this.pipe.getRouter().getSubSystemPowerProvider();
            float f3 = 0.0f;
            block8: for (Pair<ISubSystemPowerProvider, List<IFilter>> pair : provider) {
                for (IFilter filter : pair.getValue2()) {
                    if (!filter.blockPower()) continue;
                    continue block8;
                }
                if (pair.getValue1().usePaused() || !pair.getValue1().getBrand().equals("EU")) continue;
                f3 += pair.getValue1().getPowerLevel();
            }
            if (f3 > 0.0f && (f = 8192.0f - this.internal_IC2_Buffer) > 0.0f && this.pipe.useEnergy((int)(f / 10000.0f), false)) {
                block10: for (Pair<ISubSystemPowerProvider, List<IFilter>> pair : provider) {
                    for (IFilter filter : pair.getValue2()) {
                        if (!filter.blockPower()) continue;
                        continue block10;
                    }
                    if (pair.getValue1().usePaused() || !pair.getValue1().getBrand().equals("EU")) continue;
                    float requestamount = f * (pair.getValue1().getPowerLevel() / f3);
                    pair.getValue1().requestPower(this.pipe.getRouterId(), requestamount);
                }
            }
        }
    }

    public void addRFPower(float toSend) {
        this.internal_RF_Buffer += toSend;
    }

    public void addIC2Power(float toSend) {
        this.internal_IC2_Buffer += toSend;
    }
}

