/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.pipe;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.List;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.transport.LPTravelingItem;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.entity.player.EntityPlayer;

public class PipeContentPacket
extends ModernPacket {
    private ItemIdentifierStack item;
    private int travelId;

    public PipeContentPacket(int id) {
        super(id);
    }

    @Override
    public void readData(LPDataInputStream data) throws IOException {
        this.item = data.readItemIdentifierStack();
        this.travelId = data.readInt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processPacket(EntityPlayer player) {
        WeakReference<LPTravelingItem.LPTravelingItemClient> ref = LPTravelingItem.clientList.get(this.travelId);
        LPTravelingItem.LPTravelingItemClient content = null;
        if (ref != null) {
            content = (LPTravelingItem.LPTravelingItemClient)ref.get();
        }
        if (content == null) {
            content = new LPTravelingItem.LPTravelingItemClient(this.travelId, this.item);
            LPTravelingItem.clientList.put(this.travelId, new WeakReference<LPTravelingItem.LPTravelingItemClient>(content));
            List<Pair<Integer, Object>> list = LPTravelingItem.forceKeep;
            synchronized (list) {
                LPTravelingItem.forceKeep.add(new Pair<Integer, LPTravelingItem.LPTravelingItemClient>(10, content));
            }
        } else {
            content.setItem(this.item);
        }
    }

    @Override
    public void writeData(LPDataOutputStream data) throws IOException {
        data.writeItemIdentifierStack(this.item);
        data.writeInt(this.travelId);
    }

    @Override
    public ModernPacket template() {
        return new PipeContentPacket(this.getId());
    }

    public ItemIdentifierStack getItem() {
        return this.item;
    }

    public PipeContentPacket setItem(ItemIdentifierStack item) {
        this.item = item;
        return this;
    }

    public int getTravelId() {
        return this.travelId;
    }

    public PipeContentPacket setTravelId(int travelId) {
        this.travelId = travelId;
        return this;
    }
}

