/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import logisticspipes.gui.hud.modules.HUDStringBasedItemSink;
import logisticspipes.interfaces.IClientInformationProvider;
import logisticspipes.interfaces.IHUDModuleHandler;
import logisticspipes.interfaces.IHUDModuleRenderer;
import logisticspipes.interfaces.IModuleWatchReciver;
import logisticspipes.interfaces.IStringBasedModule;
import logisticspipes.modules.abstractmodules.LogisticsGuiModule;
import logisticspipes.modules.abstractmodules.LogisticsModule;
import logisticspipes.network.NewGuiHandler;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractguis.ModuleCoordinatesGuiProvider;
import logisticspipes.network.abstractguis.ModuleInHandGuiProvider;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.guis.module.inhand.StringBasedItemSinkModuleGuiInHand;
import logisticspipes.network.guis.module.inpipe.StringBasedItemSinkModuleGuiSlot;
import logisticspipes.network.packets.hud.HUDStartModuleWatchingPacket;
import logisticspipes.network.packets.hud.HUDStopModuleWatchingPacket;
import logisticspipes.network.packets.module.ModuleBasedItemSinkList;
import logisticspipes.pipes.PipeLogisticsChassi;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.item.ItemIdentifier;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public class ModuleModBasedItemSink
extends LogisticsGuiModule
implements IStringBasedModule,
IClientInformationProvider,
IHUDModuleHandler,
IModuleWatchReciver {
    public final List<String> modList = new LinkedList<String>();
    private final Set<String> modIdSet = new HashSet<String>();
    private IHUDModuleRenderer HUD = new HUDStringBasedItemSink(this);
    private final PlayerCollectionList localModeWatchers = new PlayerCollectionList();
    private SinkReply _sinkReply;

    @Override
    public void registerPosition(LogisticsModule.ModulePositionType slot, int positionInt) {
        super.registerPosition(slot, positionInt);
        this._sinkReply = new SinkReply(SinkReply.FixedPriority.ModBasedItemSink, 0, true, false, 5, 0, new PipeLogisticsChassi.ChassiTargetInformation(this.getPositionInt()));
    }

    @Override
    public SinkReply sinksItem(ItemIdentifier item, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit) {
        if (bestPriority > this._sinkReply.fixedPriority.ordinal() || bestPriority == this._sinkReply.fixedPriority.ordinal() && bestCustomPriority >= this._sinkReply.customPriority) {
            return null;
        }
        if (this.modIdSet == null) {
            this.buildModIdSet();
        }
        if (this.modIdSet.contains(item.getModName()) && this._service.canUseEnergy(5)) {
            return this._sinkReply;
        }
        return null;
    }

    @Override
    protected ModuleCoordinatesGuiProvider getPipeGuiProvider() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        return NewGuiHandler.getGui(StringBasedItemSinkModuleGuiSlot.class).setNbt(nbt);
    }

    @Override
    protected ModuleInHandGuiProvider getInHandGuiProvider() {
        return NewGuiHandler.getGui(StringBasedItemSinkModuleGuiInHand.class);
    }

    @Override
    public LogisticsModule getSubModule(int slot) {
        return null;
    }

    private void buildModIdSet() {
        this.modIdSet.clear();
        this.modIdSet.addAll(this.modList);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.modList.clear();
        int limit = nbttagcompound.func_74762_e("listSize");
        for (int i = 0; i < limit; ++i) {
            this.modList.add(nbttagcompound.func_74779_i("Mod" + i));
        }
        this.buildModIdSet();
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("listSize", this.modList.size());
        for (int i = 0; i < this.modList.size(); ++i) {
            nbttagcompound.func_74778_a("Mod" + i, this.modList.get(i));
        }
    }

    @Override
    public void tick() {
    }

    @Override
    public List<String> getClientInformation() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Mods: ");
        list.addAll(this.modList);
        return list;
    }

    @Override
    public void startHUDWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStartModuleWatchingPacket.class).setModulePos(this));
    }

    @Override
    public void stopHUDWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStopModuleWatchingPacket.class).setModulePos(this));
    }

    @Override
    public void startWatching(EntityPlayer player) {
        this.localModeWatchers.add(player);
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(ModuleBasedItemSinkList.class).setNbt(nbt).setModulePos(this), player);
    }

    @Override
    public void stopWatching(EntityPlayer player) {
        this.localModeWatchers.remove(player);
    }

    @Override
    public void listChanged() {
        if (MainProxy.isServer(this._world.getWorld())) {
            NBTTagCompound nbt = new NBTTagCompound();
            this.writeToNBT(nbt);
            MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(ModuleBasedItemSinkList.class).setNbt(nbt).setModulePos(this), this.localModeWatchers);
        } else {
            NBTTagCompound nbt = new NBTTagCompound();
            this.writeToNBT(nbt);
            MainProxy.sendPacketToServer(PacketHandler.getPacket(ModuleBasedItemSinkList.class).setNbt(nbt).setModulePos(this));
        }
    }

    @Override
    public IHUDModuleRenderer getHUDRenderer() {
        return this.HUD;
    }

    @Override
    public boolean hasGenericInterests() {
        return true;
    }

    public List<ItemIdentifier> getSpecificInterests() {
        return null;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIconTexture(IIconRegister register) {
        return register.func_94245_a("logisticspipes:itemModule/ModuleModBasedItemSink");
    }

    @Override
    public List<String> getStringList() {
        return this.modList;
    }

    @Override
    public String getStringForItem(ItemIdentifier ident) {
        return ident.getModName();
    }
}

