/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.asm;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import cpw.mods.fml.common.versioning.VersionParser;
import cpw.mods.fml.common.versioning.VersionRange;
import cpw.mods.fml.relauncher.Side;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import logisticspipes.LPConstants;
import logisticspipes.asm.ParamProfiler;
import logisticspipes.asm.td.ClassRenderDuctItemsHandler;
import logisticspipes.asm.td.ClassTileMultiBlockHandler;
import logisticspipes.asm.td.ClassTravelingItemHandler;
import logisticspipes.utils.ModStatusHelper;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class LogisticsClassTransformer
implements IClassTransformer {
    public List<String> interfacesToClearA = new ArrayList<String>();
    public List<String> interfacesToClearB = new ArrayList<String>();
    private LaunchClassLoader cl = (LaunchClassLoader)LogisticsClassTransformer.class.getClassLoader();
    private Field negativeResourceCache;
    private Field invalidClasses;
    public static LogisticsClassTransformer instance;

    public LogisticsClassTransformer() {
        instance = this;
        try {
            this.negativeResourceCache = LaunchClassLoader.class.getDeclaredField("negativeResourceCache");
            this.negativeResourceCache.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.invalidClasses = LaunchClassLoader.class.getDeclaredField("invalidClasses");
            this.invalidClasses.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        Thread thread = Thread.currentThread();
        if (thread.getName().equals("Minecraft main thread") || thread.getName().equals("main") || thread.getName().equals("Server thread")) {
            this.clearNegativeInterfaceCache();
        }
        if (bytes == null) {
            return null;
        }
        if (transformedName.startsWith("logisticspipes.") || transformedName.startsWith("net.minecraft") || LPConstants.DEBUG) {
            return ParamProfiler.handleClass(this.applyLPTransforms(transformedName, bytes));
        }
        byte[] tmp = (byte[])bytes.clone();
        if (!Arrays.equals(bytes = this.applyLPTransforms(transformedName, bytes), tmp)) {
            ClassReader reader = new ClassReader(bytes);
            ClassNode node = new ClassNode();
            reader.accept((ClassVisitor)node, 0);
            node.sourceFile = "[LP|ASM] " + node.sourceFile;
            ClassWriter writer = new ClassWriter(0);
            node.accept((ClassVisitor)writer);
            bytes = writer.toByteArray();
        }
        return ParamProfiler.handleClass(bytes);
    }

    private byte[] applyLPTransforms(String name, byte[] bytes) {
        try {
            if (name.equals("net.minecraft.tileentity.TileEntity")) {
                return this.handleTileEntityClass(bytes);
            }
            if (name.equals("net.minecraft.world.World")) {
                return this.handleWorldClass(bytes);
            }
            if (name.equals("net.minecraft.item.ItemStack")) {
                return this.handleItemStackClass(bytes);
            }
            if (name.equals("net.minecraftforge.fluids.FluidStack")) {
                return this.handleFluidStackClass(bytes);
            }
            if (name.equals("net.minecraftforge.fluids.Fluid")) {
                return this.handleFluidClass(bytes);
            }
            if (name.equals("dan200.computercraft.core.lua.LuaJLuaMachine")) {
                return this.handleCCLuaJLuaMachine(bytes);
            }
            if (name.equals("cofh.thermaldynamics.block.TileTDBase")) {
                return ClassTileMultiBlockHandler.handleTileMultiBlockClass(bytes);
            }
            if (name.equals("cofh.thermaldynamics.duct.item.TravelingItem")) {
                return ClassTravelingItemHandler.handleTravelingItemClass(bytes);
            }
            if (name.equals("cofh.thermaldynamics.render.RenderDuctItems")) {
                return ClassRenderDuctItemsHandler.handleRenderDuctItemsClass(bytes);
            }
            if (!name.startsWith("logisticspipes.")) {
                return bytes;
            }
            return this.handleLPTransformation(bytes);
        }
        catch (Exception e) {
            if (LPConstants.DEBUG) {
                e.printStackTrace();
                return bytes;
            }
            throw new RuntimeException(e);
        }
    }

    public void clearNegativeInterfaceCache() {
        if (this.negativeResourceCache != null && !this.interfacesToClearA.isEmpty()) {
            this.handleField(this.negativeResourceCache, this.interfacesToClearA);
        }
        if (this.invalidClasses != null && !this.interfacesToClearB.isEmpty()) {
            this.handleField(this.invalidClasses, this.interfacesToClearB);
        }
    }

    private void handleField(Field field, List<String> toClear) {
        block3: {
            try {
                Set set = (Set)field.get(this.cl);
                Iterator<String> it = toClear.iterator();
                while (it.hasNext()) {
                    String content = it.next();
                    if (!set.contains(content)) continue;
                    set.remove(content);
                    it.remove();
                }
            }
            catch (Exception e) {
                if (!LPConstants.DEBUG) break block3;
                e.printStackTrace();
            }
        }
    }

    private byte[] handleLPTransformation(byte[] bytes) {
        final ClassNode node = new ClassNode();
        ClassReader reader = new ClassReader(bytes);
        reader.accept((ClassVisitor)node, 0);
        boolean changed = false;
        if (node.visibleAnnotations != null) {
            for (Object a : node.visibleAnnotations) {
                if (!((AnnotationNode)a).desc.equals("Llogisticspipes/asm/ModDependentInterface;")) continue;
                if (((AnnotationNode)a).values.size() == 4 && ((AnnotationNode)a).values.get(0).equals("modId") && ((AnnotationNode)a).values.get(2).equals("interfacePath")) {
                    List modId = (List)((AnnotationNode)a).values.get(1);
                    List interfacePath = (List)((AnnotationNode)a).values.get(3);
                    if (modId.size() != interfacePath.size()) {
                        throw new RuntimeException("The Arrays have to be of the same size.");
                    }
                    block1: for (int i = 0; i < modId.size(); ++i) {
                        if (ModStatusHelper.isModLoaded((String)modId.get(i))) continue;
                        this.interfacesToClearA.add((String)interfacePath.get(i));
                        this.interfacesToClearB.add((String)interfacePath.get(i));
                        for (String inter : node.interfaces) {
                            if (!inter.replace("/", ".").equals(interfacePath.get(i))) continue;
                            node.interfaces.remove(inter);
                            changed = true;
                            continue block1;
                        }
                    }
                    continue;
                }
                throw new UnsupportedOperationException("Can't parse the annotations correctly");
            }
        }
        ArrayList<Object> methodsToRemove = new ArrayList<Object>();
        block3: for (Object m : node.methods) {
            if (((MethodNode)m).visibleAnnotations == null) continue;
            for (AnnotationNode a : ((MethodNode)m).visibleAnnotations) {
                String modId;
                if (a.desc.equals("Llogisticspipes/asm/ModDependentMethod;")) {
                    if (a.values.size() == 2 && a.values.get(0).equals("modId")) {
                        modId = a.values.get(1).toString();
                        if (ModStatusHelper.isModLoaded(modId)) continue;
                        methodsToRemove.add(m);
                        continue block3;
                    }
                    throw new UnsupportedOperationException("Can't parse the annotation correctly");
                }
                if (a.desc.equals("Llogisticspipes/asm/ClientSideOnlyMethodContent;")) {
                    if (!FMLCommonHandler.instance().getSide().equals((Object)Side.SERVER)) continue;
                    ((MethodNode)m).instructions.clear();
                    ((MethodNode)m).localVariables.clear();
                    ((MethodNode)m).tryCatchBlocks.clear();
                    m.visitCode();
                    Label l0 = new Label();
                    m.visitLabel(l0);
                    m.visitMethodInsn(184, "logisticspipes/asm/LogisticsASMHookClass", "callingClearedMethod", "()V");
                    Label l1 = new Label();
                    m.visitLabel(l1);
                    m.visitInsn(177);
                    Label l2 = new Label();
                    m.visitLabel(l2);
                    m.visitLocalVariable("this", "Llogisticspipes/network/packets/DummyPacket;", null, l0, l2, 0);
                    m.visitLocalVariable("player", "Lnet/minecraft/entity/player/EntityPlayer;", null, l0, l2, 1);
                    m.visitMaxs(0, 2);
                    m.visitEnd();
                    changed = true;
                    continue block3;
                }
                if (!a.desc.equals("Llogisticspipes/asm/ModDependentMethodName;")) continue;
                if (a.values.size() == 6 && a.values.get(0).equals("modId") && a.values.get(2).equals("newName") && a.values.get(4).equals("version")) {
                    modId = a.values.get(1).toString();
                    final String newName = a.values.get(3).toString();
                    String version = a.values.get(5).toString();
                    boolean loaded = ModStatusHelper.isModLoaded(modId);
                    if (loaded && !version.equals("")) {
                        ModContainer mod = (ModContainer)Loader.instance().getIndexedModList().get(modId);
                        if (mod != null) {
                            VersionRange range = VersionParser.parseRange((String)version);
                            DefaultArtifactVersion artifactVersion = new DefaultArtifactVersion("Version", mod.getVersion());
                            loaded = range.containsVersion((ArtifactVersion)artifactVersion);
                        } else {
                            loaded = false;
                        }
                    }
                    if (!loaded) continue;
                    final String oldName = ((MethodNode)m).name;
                    ((MethodNode)m).name = newName;
                    MethodNode newM = new MethodNode(262144, ((MethodNode)m).access, ((MethodNode)m).name, ((MethodNode)m).desc, ((MethodNode)m).signature, ((MethodNode)m).exceptions.toArray(new String[0])){

                        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                            if (name.equals(oldName) && owner.equals(node.superName)) {
                                super.visitMethodInsn(opcode, owner, newName, desc);
                            } else {
                                super.visitMethodInsn(opcode, owner, name, desc);
                            }
                        }
                    };
                    m.accept((MethodVisitor)newM);
                    node.methods.set(node.methods.indexOf(m), newM);
                    changed = true;
                    continue block3;
                }
                throw new UnsupportedOperationException("Can't parse the annotation correctly");
            }
        }
        for (Object m : methodsToRemove) {
            node.methods.remove(m);
        }
        ArrayList<FieldNode> fieldsToRemove = new ArrayList<FieldNode>();
        block6: for (FieldNode f : node.fields) {
            if (f.visibleAnnotations == null) continue;
            for (AnnotationNode a : f.visibleAnnotations) {
                if (!a.desc.equals("Llogisticspipes/asm/ModDependentField;")) continue;
                if (a.values.size() == 2 && a.values.get(0).equals("modId")) {
                    String modId = a.values.get(1).toString();
                    if (ModStatusHelper.isModLoaded(modId)) continue;
                    fieldsToRemove.add(f);
                    continue block6;
                }
                throw new UnsupportedOperationException("Can't parse the annotation correctly");
            }
        }
        for (FieldNode f : fieldsToRemove) {
            node.fields.remove(f);
        }
        if (!changed && methodsToRemove.isEmpty() && fieldsToRemove.isEmpty()) {
            return bytes;
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] handleCCLuaJLuaMachine(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        for (MethodNode m : node.methods) {
            MethodNode mv;
            if (m.name.equals("wrapLuaObject") && m.desc.equals("(Ldan200/computercraft/api/lua/ILuaObject;)Lorg/luaj/vm2/LuaTable;")) {
                mv = new MethodNode(262144, m.access, m.name, m.desc, m.signature, m.exceptions.toArray(new String[0])){

                    public void visitInsn(int opcode) {
                        if (opcode == 176) {
                            super.visitVarInsn(25, 1);
                            super.visitMethodInsn(184, "logisticspipes/proxy/cc/LPASMHookCC", "onCCWrappedILuaObject", "(Lorg/luaj/vm2/LuaTable;Ldan200/computercraft/api/lua/ILuaObject;)Lorg/luaj/vm2/LuaTable;");
                        }
                        super.visitInsn(opcode);
                    }

                    public void visitCode() {
                        super.visitCode();
                        Label l0 = new Label();
                        super.visitLabel(l0);
                        super.visitVarInsn(25, 1);
                        super.visitMethodInsn(184, "logisticspipes/proxy/cc/LPASMHookCC", "handleCCWrappedILuaObject", "(Ldan200/computercraft/api/lua/ILuaObject;)Z");
                        Label l1 = new Label();
                        super.visitJumpInsn(153, l1);
                        Label l2 = new Label();
                        super.visitLabel(l2);
                        super.visitVarInsn(25, 1);
                        super.visitMethodInsn(184, "logisticspipes/proxy/cc/LPASMHookCC", "returnCCWrappedILuaObject", "(Ldan200/computercraft/api/lua/ILuaObject;)Lorg/luaj/vm2/LuaTable;");
                        super.visitInsn(176);
                        super.visitLabel(l1);
                    }
                };
                m.accept((MethodVisitor)mv);
                node.methods.set(node.methods.indexOf(m), mv);
            }
            if (!m.name.equals("toObject") || !m.desc.equals("(Lorg/luaj/vm2/LuaValue;)Ljava/lang/Object;")) continue;
            mv = new MethodNode(262144, m.access, m.name, m.desc, m.signature, m.exceptions.toArray(new String[0])){
                boolean added;
                {
                    this.added = false;
                }

                public void visitLineNumber(int line, Label start) {
                    if (!this.added) {
                        this.added = true;
                        super.visitVarInsn(25, 1);
                        super.visitMethodInsn(184, "logisticspipes/proxy/cc/LPASMHookCC", "handleCCToObject", "(Lorg/luaj/vm2/LuaValue;)Z");
                        start = new Label();
                        super.visitJumpInsn(153, start);
                        Label l5 = new Label();
                        super.visitLabel(l5);
                        super.visitVarInsn(25, 1);
                        super.visitMethodInsn(184, "logisticspipes/proxy/cc/LPASMHookCC", "returnCCToObject", "(Lorg/luaj/vm2/LuaValue;)Ljava/lang/Object;");
                        super.visitInsn(176);
                        super.visitLabel(start);
                    }
                    super.visitLineNumber(line, start);
                }
            };
            m.accept((MethodVisitor)mv);
            node.methods.set(node.methods.indexOf(m), mv);
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] handleTileEntityClass(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        node.interfaces.add("logisticspipes/asm/te/ILPTEInformation");
        node.visitField(2, "informationObjectLogisticsPipes", "Llogisticspipes/asm/te/LPTileEntityObject;", null, null);
        for (MethodNode m : node.methods) {
            MethodNode mv;
            if (m.name.equals("validate") || m.name.equals("func_145829_t") || m.name.equals("t") && m.desc.equals("()V")) {
                mv = new MethodNode(262144, m.access, m.name, m.desc, m.signature, m.exceptions.toArray(new String[0])){

                    public void visitCode() {
                        super.visitCode();
                        Label l0 = new Label();
                        this.visitLabel(l0);
                        this.visitVarInsn(25, 0);
                        this.visitMethodInsn(184, "logisticspipes/asm/LogisticsASMHookClass", "validate", "(Lnet/minecraft/tileentity/TileEntity;)V");
                    }
                };
                m.accept((MethodVisitor)mv);
                node.methods.set(node.methods.indexOf(m), mv);
            }
            if (!m.name.equals("invalidate") && !m.name.equals("func_145843_s") && (!m.name.equals("s") || !m.desc.equals("()V"))) continue;
            mv = new MethodNode(262144, m.access, m.name, m.desc, m.signature, m.exceptions.toArray(new String[0])){

                public void visitCode() {
                    super.visitCode();
                    Label l0 = new Label();
                    this.visitLabel(l0);
                    this.visitVarInsn(25, 0);
                    this.visitMethodInsn(184, "logisticspipes/asm/LogisticsASMHookClass", "invalidate", "(Lnet/minecraft/tileentity/TileEntity;)V");
                }
            };
            m.accept((MethodVisitor)mv);
            node.methods.set(node.methods.indexOf(m), mv);
        }
        MethodVisitor mv = node.visitMethod(1, "getObject", "()Llogisticspipes/asm/te/LPTileEntityObject;", null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "net/minecraft/tileentity/TileEntity", "informationObjectLogisticsPipes", "Llogisticspipes/asm/te/LPTileEntityObject;");
        mv.visitInsn(176);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = node.visitMethod(1, "setObject", "(Llogisticspipes/asm/te/LPTileEntityObject;)V", null, null);
        mv.visitCode();
        l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, "net/minecraft/tileentity/TileEntity", "informationObjectLogisticsPipes", "Llogisticspipes/asm/te/LPTileEntityObject;");
        l1 = new Label();
        mv.visitLabel(l1);
        mv.visitInsn(177);
        Label l2 = new Label();
        mv.visitLabel(l2);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        ClassWriter writer = new ClassWriter(1);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] handleWorldClass(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        for (MethodNode m : node.methods) {
            MethodNode mv;
            if (m.name.equals("notifyBlocksOfNeighborChange") || m.name.equals("func_147459_d") || m.name.equals("d") && m.desc.equals("(IIILaji;)V")) {
                mv = new MethodNode(262144, m.access, m.name, m.desc, m.signature, m.exceptions.toArray(new String[0])){

                    public void visitCode() {
                        super.visitCode();
                        Label l0 = new Label();
                        this.visitLabel(l0);
                        this.visitVarInsn(25, 0);
                        this.visitVarInsn(21, 1);
                        this.visitVarInsn(21, 2);
                        this.visitVarInsn(21, 3);
                        this.visitMethodInsn(184, "logisticspipes/asm/LogisticsASMHookClass", "notifyBlocksOfNeighborChange_Start", "(Lnet/minecraft/world/World;III)V");
                    }

                    public void visitInsn(int opcode) {
                        if (opcode == 177) {
                            this.visitVarInsn(25, 0);
                            this.visitVarInsn(21, 1);
                            this.visitVarInsn(21, 2);
                            this.visitVarInsn(21, 3);
                            this.visitMethodInsn(184, "logisticspipes/asm/LogisticsASMHookClass", "notifyBlocksOfNeighborChange_Stop", "(Lnet/minecraft/world/World;III)V");
                            Label l0 = new Label();
                            this.visitLabel(l0);
                        }
                        super.visitInsn(opcode);
                    }
                };
                m.accept((MethodVisitor)mv);
                node.methods.set(node.methods.indexOf(m), mv);
            }
            if (!m.name.equals("notifyBlockOfNeighborChange") && !m.name.equals("func_147460_e") && (!m.name.equals("e") || !m.desc.equals("(IIILaji;)V"))) continue;
            mv = new MethodNode(262144, m.access, m.name, m.desc, m.signature, m.exceptions.toArray(new String[0])){
                boolean done;
                {
                    this.done = false;
                }

                public void visitLabel(Label label) {
                    if (!this.done) {
                        this.done = true;
                        Label l0 = new Label();
                        this.visitLabel(l0);
                        this.visitVarInsn(25, 0);
                        this.visitVarInsn(21, 1);
                        this.visitVarInsn(21, 2);
                        this.visitVarInsn(21, 3);
                        this.visitMethodInsn(184, "logisticspipes/asm/LogisticsASMHookClass", "notifyBlockOfNeighborChange", "(Lnet/minecraft/world/World;III)V");
                    }
                    super.visitLabel(label);
                }
            };
            m.accept((MethodVisitor)mv);
            node.methods.set(node.methods.indexOf(m), mv);
        }
        ClassWriter writer = new ClassWriter(1);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] handleItemStackClass(byte[] bytes) {
        return this.addAddInfoPart(bytes, "net/minecraft/item/ItemStack");
    }

    private byte[] handleFluidStackClass(byte[] bytes) {
        return this.addAddInfoPart(bytes, "net/minecraftforge/fluids/FluidStack");
    }

    private byte[] handleFluidClass(byte[] bytes) {
        return this.addAddInfoPart(bytes, "net/minecraftforge/fluids/Fluid");
    }

    private byte[] addAddInfoPart(byte[] bytes, String className) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        node.interfaces.add("logisticspipes/asm/addinfo/IAddInfoProvider");
        FieldVisitor fv = node.visitField(2, "logisticsPipesAdditionalInformation", "Ljava/util/ArrayList;", "Ljava/util/ArrayList<Llogisticspipes/asm/addinfo/IAddInfo;>;", null);
        fv.visitEnd();
        MethodVisitor mv = node.visitMethod(1, "getLogisticsPipesAddInfo", "(Ljava/lang/Class;)Llogisticspipes/asm/addinfo/IAddInfo;", "<T::Llogisticspipes/asm/addinfo/IAddInfo;>(Ljava/lang/Class<TT;>;)TT;", null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(11, l0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, className, "logisticsPipesAdditionalInformation", "Ljava/util/ArrayList;");
        Label l1 = new Label();
        mv.visitJumpInsn(199, l1);
        Label l2 = new Label();
        mv.visitLabel(l2);
        mv.visitLineNumber(12, l2);
        mv.visitInsn(1);
        mv.visitInsn(176);
        mv.visitLabel(l1);
        mv.visitLineNumber(14, l1);
        mv.visitFrame(3, 0, null, 0, null);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, className, "logisticsPipesAdditionalInformation", "Ljava/util/ArrayList;");
        mv.visitMethodInsn(182, "java/util/ArrayList", "iterator", "()Ljava/util/Iterator;", false);
        mv.visitVarInsn(58, 2);
        Label l3 = new Label();
        mv.visitLabel(l3);
        mv.visitFrame(1, 1, new Object[]{"java/util/Iterator"}, 0, null);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(185, "java/util/Iterator", "hasNext", "()Z", true);
        Label l4 = new Label();
        mv.visitJumpInsn(153, l4);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(185, "java/util/Iterator", "next", "()Ljava/lang/Object;", true);
        mv.visitTypeInsn(192, "logisticspipes/asm/addinfo/IAddInfo");
        mv.visitVarInsn(58, 3);
        Label l5 = new Label();
        mv.visitLabel(l5);
        mv.visitLineNumber(15, l5);
        mv.visitVarInsn(25, 3);
        Label l6 = new Label();
        mv.visitJumpInsn(199, l6);
        mv.visitJumpInsn(167, l3);
        mv.visitLabel(l6);
        mv.visitLineNumber(16, l6);
        mv.visitFrame(1, 1, new Object[]{"logisticspipes/asm/addinfo/IAddInfo"}, 0, null);
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;", false);
        mv.visitVarInsn(25, 1);
        Label l7 = new Label();
        mv.visitJumpInsn(166, l7);
        Label l8 = new Label();
        mv.visitLabel(l8);
        mv.visitLineNumber(17, l8);
        mv.visitVarInsn(25, 3);
        mv.visitInsn(176);
        mv.visitLabel(l7);
        mv.visitLineNumber(19, l7);
        mv.visitFrame(2, 1, null, 0, null);
        mv.visitJumpInsn(167, l3);
        mv.visitLabel(l4);
        mv.visitLineNumber(20, l4);
        mv.visitFrame(2, 1, null, 0, null);
        mv.visitInsn(1);
        mv.visitInsn(176);
        Label l9 = new Label();
        mv.visitLabel(l9);
        mv.visitLocalVariable("info", "Llogisticspipes/asm/addinfo/IAddInfo;", null, l5, l7, 3);
        mv.visitLocalVariable("this", "L" + className + ";", null, l0, l9, 0);
        mv.visitLocalVariable("clazz", "Ljava/lang/Class;", "Ljava/lang/Class<TT;>;", l0, l9, 1);
        mv.visitMaxs(2, 4);
        mv.visitEnd();
        mv = node.visitMethod(1, "setLogisticsPipesAddInfo", "(Llogisticspipes/asm/addinfo/IAddInfo;)V", null, null);
        mv.visitCode();
        l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(25, l0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, className, "logisticsPipesAdditionalInformation", "Ljava/util/ArrayList;");
        l1 = new Label();
        mv.visitJumpInsn(199, l1);
        l2 = new Label();
        mv.visitLabel(l2);
        mv.visitLineNumber(26, l2);
        mv.visitVarInsn(25, 0);
        mv.visitTypeInsn(187, "java/util/ArrayList");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/util/ArrayList", "<init>", "()V", false);
        mv.visitFieldInsn(181, className, "logisticsPipesAdditionalInformation", "Ljava/util/ArrayList;");
        mv.visitLabel(l1);
        mv.visitLineNumber(28, l1);
        mv.visitFrame(3, 0, null, 0, null);
        mv.visitInsn(3);
        mv.visitVarInsn(54, 2);
        l3 = new Label();
        mv.visitLabel(l3);
        mv.visitFrame(1, 1, new Object[]{Opcodes.INTEGER}, 0, null);
        mv.visitVarInsn(21, 2);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, className, "logisticsPipesAdditionalInformation", "Ljava/util/ArrayList;");
        mv.visitMethodInsn(182, "java/util/ArrayList", "size", "()I", false);
        l4 = new Label();
        mv.visitJumpInsn(162, l4);
        l5 = new Label();
        mv.visitLabel(l5);
        mv.visitLineNumber(29, l5);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, className, "logisticsPipesAdditionalInformation", "Ljava/util/ArrayList;");
        mv.visitVarInsn(21, 2);
        mv.visitMethodInsn(182, "java/util/ArrayList", "get", "(I)Ljava/lang/Object;", false);
        l6 = new Label();
        mv.visitJumpInsn(199, l6);
        l7 = new Label();
        mv.visitJumpInsn(167, l7);
        mv.visitLabel(l6);
        mv.visitLineNumber(30, l6);
        mv.visitFrame(3, 0, null, 0, null);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, className, "logisticsPipesAdditionalInformation", "Ljava/util/ArrayList;");
        mv.visitVarInsn(21, 2);
        mv.visitMethodInsn(182, "java/util/ArrayList", "get", "(I)Ljava/lang/Object;", false);
        mv.visitTypeInsn(192, "logisticspipes/asm/addinfo/IAddInfo");
        mv.visitMethodInsn(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;", false);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;", false);
        mv.visitJumpInsn(166, l7);
        l8 = new Label();
        mv.visitLabel(l8);
        mv.visitLineNumber(31, l8);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, className, "logisticsPipesAdditionalInformation", "Ljava/util/ArrayList;");
        mv.visitVarInsn(21, 2);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, "java/util/ArrayList", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", false);
        mv.visitInsn(87);
        l9 = new Label();
        mv.visitLabel(l9);
        mv.visitLineNumber(32, l9);
        mv.visitInsn(177);
        mv.visitLabel(l7);
        mv.visitLineNumber(28, l7);
        mv.visitFrame(3, 0, null, 0, null);
        mv.visitIincInsn(2, 1);
        mv.visitJumpInsn(167, l3);
        mv.visitLabel(l4);
        mv.visitLineNumber(35, l4);
        mv.visitFrame(2, 1, null, 0, null);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, className, "logisticsPipesAdditionalInformation", "Ljava/util/ArrayList;");
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, "java/util/ArrayList", "add", "(Ljava/lang/Object;)Z", false);
        mv.visitInsn(87);
        Label l10 = new Label();
        mv.visitLabel(l10);
        mv.visitLineNumber(36, l10);
        mv.visitInsn(177);
        Label l11 = new Label();
        mv.visitLabel(l11);
        mv.visitLocalVariable("i", "I", null, l3, l4, 2);
        mv.visitLocalVariable("this", "L" + className + ";", null, l0, l11, 0);
        mv.visitLocalVariable("info", "Llogisticspipes/asm/addinfo/IAddInfo;", null, l0, l11, 1);
        mv.visitMaxs(3, 3);
        mv.visitEnd();
        ClassWriter writer = new ClassWriter(1);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

