/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.renderer.state;

import java.io.IOException;
import logisticspipes.config.Configs;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.CoreUnroutedPipe;
import net.minecraftforge.common.util.ForgeDirection;

public class TextureMatrix {
    private final int[] iconIndexes = new int[7];
    private int textureIndex;
    private boolean isRouted;
    private boolean[] isRoutedInDir = new boolean[6];
    private boolean[] isSubPowerInDir = new boolean[6];
    private boolean hasPowerUpgrade;
    private boolean hasPower;
    private boolean isFluid;
    private ForgeDirection pointedOrientation;
    private boolean dirty = false;

    public int getTextureIndex(ForgeDirection direction) {
        return this.iconIndexes[direction.ordinal()];
    }

    public void setIconIndex(ForgeDirection direction, int value) {
        if (this.iconIndexes[direction.ordinal()] != value) {
            this.iconIndexes[direction.ordinal()] = value;
            this.dirty = true;
        }
    }

    public void refreshStates(CoreUnroutedPipe pipe) {
        if (this.textureIndex != pipe.getTextureIndex()) {
            this.dirty = true;
        }
        this.textureIndex = pipe.getTextureIndex();
        if (this.isRouted != pipe.isRoutedPipe()) {
            this.dirty = true;
        }
        this.isRouted = pipe.isRoutedPipe();
        if (this.isRouted) {
            int i;
            CoreRoutedPipe cPipe = (CoreRoutedPipe)pipe;
            for (i = 0; i < 6; ++i) {
                if (this.isRoutedInDir[i] != cPipe.getRouter().isRoutedExit(ForgeDirection.getOrientation((int)i))) {
                    this.dirty = true;
                }
                this.isRoutedInDir[i] = cPipe.getRouter().isRoutedExit(ForgeDirection.getOrientation((int)i));
            }
            for (i = 0; i < 6; ++i) {
                if (this.isSubPowerInDir[i] != cPipe.getRouter().isSubPoweredExit(ForgeDirection.getOrientation((int)i))) {
                    this.dirty = true;
                }
                this.isSubPowerInDir[i] = cPipe.getRouter().isSubPoweredExit(ForgeDirection.getOrientation((int)i));
            }
            if (this.hasPowerUpgrade != (cPipe.getUpgradeManager().hasRFPowerSupplierUpgrade() || cPipe.getUpgradeManager().getIC2PowerLevel() > 0)) {
                this.dirty = true;
            }
            this.hasPowerUpgrade = cPipe.getUpgradeManager().hasRFPowerSupplierUpgrade() || cPipe.getUpgradeManager().getIC2PowerLevel() > 0;
            if (this.hasPower != (cPipe._textureBufferPowered || Configs.LOGISTICS_POWER_USAGE_DISABLED)) {
                this.dirty = true;
            }
            boolean bl = this.hasPower = cPipe._textureBufferPowered || Configs.LOGISTICS_POWER_USAGE_DISABLED;
            if (this.isFluid != cPipe.isFluidPipe()) {
                this.dirty = true;
            }
            this.isFluid = cPipe.isFluidPipe();
            if (this.pointedOrientation != cPipe.getPointedOrientation()) {
                this.dirty = true;
            }
            this.pointedOrientation = cPipe.getPointedOrientation();
        } else {
            this.isRoutedInDir = new boolean[6];
        }
    }

    public boolean isRoutedInDir(ForgeDirection dir) {
        if (dir == ForgeDirection.UNKNOWN) {
            return false;
        }
        return this.isRoutedInDir[dir.ordinal()];
    }

    public boolean isSubPowerInDir(ForgeDirection dir) {
        if (dir == ForgeDirection.UNKNOWN) {
            return false;
        }
        return this.isSubPowerInDir[dir.ordinal()];
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void clean() {
        this.dirty = false;
    }

    public void writeData(LPDataOutputStream data) throws IOException {
        for (int iconIndexe : this.iconIndexes) {
            data.writeByte(iconIndexe);
        }
        data.writeInt(this.textureIndex);
        data.writeBoolean(this.isRouted);
        data.writeBooleanArray(this.isRoutedInDir);
        data.writeBooleanArray(this.isSubPowerInDir);
        data.writeBoolean(this.hasPowerUpgrade);
        data.writeBoolean(this.hasPower);
        data.writeBoolean(this.isFluid);
        data.writeForgeDirection(this.pointedOrientation);
    }

    public void readData(LPDataInputStream data) throws IOException {
        for (int i = 0; i < this.iconIndexes.length; ++i) {
            byte icon = data.readByte();
            if (this.iconIndexes[i] == icon) continue;
            this.iconIndexes[i] = icon;
            this.dirty = true;
        }
        this.textureIndex = data.readInt();
        this.isRouted = data.readBoolean();
        this.isRoutedInDir = data.readBooleanArray();
        this.isSubPowerInDir = data.readBooleanArray();
        this.hasPowerUpgrade = data.readBoolean();
        this.hasPower = data.readBoolean();
        this.isFluid = data.readBoolean();
        this.pointedOrientation = data.readForgeDirection();
    }

    public int getTextureIndex() {
        return this.textureIndex;
    }

    public boolean isRouted() {
        return this.isRouted;
    }

    public boolean isHasPowerUpgrade() {
        return this.hasPowerUpgrade;
    }

    public boolean isHasPower() {
        return this.hasPower;
    }

    public boolean isFluid() {
        return this.isFluid;
    }

    public ForgeDirection getPointedOrientation() {
        return this.pointedOrientation;
    }
}

