/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.renderer.newpipe;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import logisticspipes.LogisticsPipes;
import logisticspipes.config.PlayerConfig;
import logisticspipes.pipes.PipeBlockRequestTable;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.object3d.interfaces.I3DOperation;
import logisticspipes.proxy.object3d.interfaces.IIconTransformation;
import logisticspipes.proxy.object3d.interfaces.IModel3D;
import logisticspipes.proxy.object3d.interfaces.IVec3;
import logisticspipes.proxy.object3d.operation.LPScale;
import logisticspipes.proxy.object3d.operation.LPTranslation;
import logisticspipes.proxy.object3d.operation.LPUVTransformationList;
import logisticspipes.proxy.object3d.operation.LPUVTranslation;
import logisticspipes.renderer.state.PipeRenderState;
import logisticspipes.textures.Textures;
import logisticspipes.utils.tuples.LPPosition;
import logisticspipes.utils.tuples.Pair;
import logisticspipes.utils.tuples.Quartet;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class LogisticsNewRenderPipe {
    static Map<ForgeDirection, List<IModel3D>> sideNormal = new HashMap<ForgeDirection, List<IModel3D>>();
    static Map<ForgeDirection, List<IModel3D>> sideBC = new HashMap<ForgeDirection, List<IModel3D>>();
    static Map<Edge, IModel3D> edges = new HashMap<Edge, IModel3D>();
    static Map<Corner, List<IModel3D>> corners_M = new HashMap<Corner, List<IModel3D>>();
    static Map<Corner, List<IModel3D>> corners_I3 = new HashMap<Corner, List<IModel3D>>();
    static Map<Turn_Corner, IModel3D> corners_I = new HashMap<Turn_Corner, IModel3D>();
    static Map<Support, IModel3D> supports = new HashMap<Support, IModel3D>();
    static Map<Turn_Corner, IModel3D> spacers = new HashMap<Turn_Corner, IModel3D>();
    static Map<Mount, IModel3D> mounts = new HashMap<Mount, IModel3D>();
    static Map<ForgeDirection, List<IModel3D>> texturePlate_Inner = new HashMap<ForgeDirection, List<IModel3D>>();
    static Map<ForgeDirection, List<IModel3D>> texturePlate_Outer = new HashMap<ForgeDirection, List<IModel3D>>();
    static Map<ForgeDirection, Quartet<List<IModel3D>, List<IModel3D>, List<IModel3D>, List<IModel3D>>> sideTexturePlate = new HashMap<ForgeDirection, Quartet<List<IModel3D>, List<IModel3D>, List<IModel3D>, List<IModel3D>>>();
    static Map<Mount, List<IModel3D>> textureConnectorPlate = new HashMap<Mount, List<IModel3D>>();
    static Map<ScaleObject, IModel3D> scaleMap = new HashMap<ScaleObject, IModel3D>();
    static IModel3D innerTransportBox;
    public static IIconTransformation basicTexture;
    public static IIconTransformation inactiveTexture;
    public static IIconTransformation glassCenterTexture;
    public static IIconTransformation innerBoxTexture;
    public static IIconTransformation statusTexture;
    public static IIconTransformation statusBCTexture;
    private static final ResourceLocation BLOCKS;
    private final PlayerConfig config = LogisticsPipes.getClientPlayerConfig();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void loadModels() {
        if (!SimpleServiceLocator.cclProxy.isActivated()) {
            return;
        }
        try {
            String grp;
            Map<String, IModel3D> pipePartModels = SimpleServiceLocator.cclProxy.parseObjModels(LogisticsPipes.class.getResourceAsStream("/logisticspipes/models/PipeModel_moved.obj"), 7, new LPScale(0.01f));
            for (ForgeDirection forgeDirection : ForgeDirection.VALID_DIRECTIONS) {
                sideNormal.put(forgeDirection, new ArrayList());
                grp = "Side_" + LogisticsNewRenderPipe.getDirAsString_Type1(forgeDirection);
                for (Map.Entry<String, IModel3D> entry : pipePartModels.entrySet()) {
                    if (!entry.getKey().contains(" " + grp + " ") && !entry.getKey().endsWith(" " + grp)) continue;
                    sideNormal.get(forgeDirection).add(LogisticsNewRenderPipe.compute(entry.getValue().backfacedCopy().apply(new LPTranslation(0.0, 0.0, 1.0))));
                }
                if (sideNormal.get(forgeDirection).size() == 4) continue;
                throw new RuntimeException("Couldn't load " + forgeDirection.name() + " (" + grp + "). Only loaded " + sideNormal.get(forgeDirection).size());
            }
            for (ForgeDirection forgeDirection : ForgeDirection.VALID_DIRECTIONS) {
                sideBC.put(forgeDirection, new ArrayList());
                grp = "Side_BC_" + LogisticsNewRenderPipe.getDirAsString_Type1(forgeDirection);
                for (Map.Entry<String, IModel3D> entry : pipePartModels.entrySet()) {
                    if (!entry.getKey().contains(" " + grp + " ") && !entry.getKey().endsWith(" " + grp)) continue;
                    sideBC.get(forgeDirection).add(LogisticsNewRenderPipe.compute(entry.getValue().backfacedCopy().apply(new LPTranslation(0.0, 0.0, 1.0))));
                }
                if (sideBC.get(forgeDirection).size() == 8) continue;
                throw new RuntimeException("Couldn't load " + forgeDirection.name() + " (" + grp + "). Only loaded " + sideBC.get(forgeDirection).size());
            }
            for (Edge edge : Edge.values()) {
                grp = edge.part1 == ForgeDirection.UP || edge.part1 == ForgeDirection.DOWN ? "Edge_M_" + LogisticsNewRenderPipe.getDirAsString_Type1(edge.part1) + "_" + LogisticsNewRenderPipe.getDirAsString_Type1(edge.part2) : "Edge_M_S_" + LogisticsNewRenderPipe.getDirAsString_Type1(edge.part1) + LogisticsNewRenderPipe.getDirAsString_Type1(edge.part2);
                for (Map.Entry<String, IModel3D> entry : pipePartModels.entrySet()) {
                    if (!entry.getKey().contains(" " + grp + " ") && !entry.getKey().endsWith(" " + grp)) continue;
                    edges.put(edge, LogisticsNewRenderPipe.compute(entry.getValue().backfacedCopy().apply(new LPTranslation(0.0, 0.0, 1.0))));
                    break;
                }
                if (edges.get((Object)edge) != null) continue;
                throw new RuntimeException("Couldn't load " + edge.name() + " (" + grp + ")");
            }
            for (Corner corner : Corner.values()) {
                corners_M.put(corner, new ArrayList());
                grp = "Corner_M_" + corner.ud.s + "_" + corner.ns.s + corner.ew.s;
                for (Map.Entry<String, IModel3D> entry : pipePartModels.entrySet()) {
                    if (!entry.getKey().contains(" " + grp + " ") && !entry.getKey().endsWith(" " + grp)) continue;
                    corners_M.get((Object)corner).add(LogisticsNewRenderPipe.compute(entry.getValue().backfacedCopy().apply(new LPTranslation(0.0, 0.0, 1.0))));
                }
                if (corners_M.get((Object)corner).size() == 2) continue;
                throw new RuntimeException("Couldn't load " + corner.name() + " (" + grp + "). Only loaded " + corners_M.get((Object)corner).size());
            }
            for (Corner corner : Corner.values()) {
                corners_I3.put(corner, new ArrayList());
                grp = "Corner_I3_" + corner.ud.s + "_" + corner.ns.s + corner.ew.s;
                for (Map.Entry<String, IModel3D> entry : pipePartModels.entrySet()) {
                    if (!entry.getKey().contains(" " + grp + " ") && !entry.getKey().endsWith(" " + grp)) continue;
                    corners_I3.get((Object)corner).add(LogisticsNewRenderPipe.compute(entry.getValue().backfacedCopy().apply(new LPTranslation(0.0, 0.0, 1.0))));
                }
                if (corners_I3.get((Object)corner).size() == 2) continue;
                throw new RuntimeException("Couldn't load " + corner.name() + " (" + grp + "). Only loaded " + corners_I3.get((Object)corner).size());
            }
            for (Support support : Support.values()) {
                grp = "Support_" + LogisticsNewRenderPipe.getDirAsString_Type1(support.dir) + "_" + support.ori.s;
                for (Map.Entry<String, IModel3D> entry : pipePartModels.entrySet()) {
                    if (!entry.getKey().contains(" " + grp + " ") && !entry.getKey().endsWith(" " + grp)) continue;
                    supports.put(support, LogisticsNewRenderPipe.compute(entry.getValue().backfacedCopy().apply(new LPTranslation(0.0, 0.0, 1.0))));
                    break;
                }
                if (supports.get((Object)support) != null) continue;
                throw new RuntimeException("Couldn't load " + support.name() + " (" + grp + ")");
            }
            for (Turn_Corner turn_Corner : Turn_Corner.values()) {
                grp = "Corner_I_" + turn_Corner.corner.ud.s + "_" + turn_Corner.corner.ns.s + turn_Corner.corner.ew.s;
                for (Map.Entry<String, IModel3D> entry : pipePartModels.entrySet()) {
                    if (!entry.getKey().contains(" " + grp)) continue;
                    char c = ' ';
                    if (!entry.getKey().endsWith(" " + grp)) {
                        c = entry.getKey().charAt(entry.getKey().indexOf(" " + grp) + (" " + grp).length());
                    }
                    if (Character.isDigit(c)) {
                        if (c == '2') {
                            if (turn_Corner.turn != Turn.NORTH_SOUTH) {
                                continue;
                            }
                        } else {
                            if (c != 49) throw new UnsupportedOperationException();
                            if (turn_Corner.turn != Turn.EAST_WEST) {
                                continue;
                            }
                        }
                    } else if (turn_Corner.turn != Turn.UP_DOWN) continue;
                    corners_I.put(turn_Corner, LogisticsNewRenderPipe.compute(entry.getValue().backfacedCopy().apply(new LPTranslation(0.0, 0.0, 1.0))));
                    break;
                }
                if (corners_I.get((Object)turn_Corner) != null) continue;
                throw new RuntimeException("Couldn't load " + turn_Corner.name() + " (" + grp + ")");
            }
            for (Turn_Corner turn_Corner : Turn_Corner.values()) {
                grp = "Spacer" + turn_Corner.number;
                for (Map.Entry<String, IModel3D> entry : pipePartModels.entrySet()) {
                    if (!entry.getKey().contains(" " + grp + " ") && !entry.getKey().endsWith(" " + grp)) continue;
                    spacers.put(turn_Corner, LogisticsNewRenderPipe.compute(entry.getValue().backfacedCopy().apply(new LPTranslation(0.0, 0.0, 1.0))));
                    break;
                }
                if (spacers.get((Object)turn_Corner) != null) continue;
                throw new RuntimeException("Couldn't load " + turn_Corner.name() + " (" + grp + ")");
            }
            for (Mount mount : Mount.values()) {
                grp = "Mount_" + LogisticsNewRenderPipe.getDirAsString_Type1(mount.dir) + "_" + LogisticsNewRenderPipe.getDirAsString_Type1(mount.side);
                for (Map.Entry<String, IModel3D> entry : pipePartModels.entrySet()) {
                    if (!entry.getKey().contains(" " + grp + " ") && !entry.getKey().endsWith(" " + grp)) continue;
                    mounts.put(mount, LogisticsNewRenderPipe.compute(entry.getValue().backfacedCopy().apply(new LPTranslation(0.0, 0.0, 1.0))));
                    break;
                }
                if (mounts.get((Object)mount) != null) continue;
                throw new RuntimeException("Couldn't load " + mount.name() + " (" + grp + ")");
            }
            for (ForgeDirection forgeDirection : ForgeDirection.VALID_DIRECTIONS) {
                texturePlate_Inner.put(forgeDirection, new ArrayList());
                grp = "Inner_Plate_" + LogisticsNewRenderPipe.getDirAsString_Type1(forgeDirection);
                for (Map.Entry<String, IModel3D> entry : pipePartModels.entrySet()) {
                    if (!entry.getKey().contains(" " + grp)) continue;
                    texturePlate_Inner.get(forgeDirection).add(LogisticsNewRenderPipe.compute(entry.getValue().backfacedCopy().apply(new LPTranslation(0.0, 0.0, 1.0))));
                }
                if (texturePlate_Inner.get(forgeDirection).size() == 2) continue;
                throw new RuntimeException("Couldn't load " + forgeDirection.name() + " (" + grp + "). Only loaded " + texturePlate_Inner.get(forgeDirection).size());
            }
            for (ForgeDirection forgeDirection : ForgeDirection.VALID_DIRECTIONS) {
                texturePlate_Outer.put(forgeDirection, new ArrayList());
                grp = "Texture_Plate_" + LogisticsNewRenderPipe.getDirAsString_Type1(forgeDirection);
                for (Map.Entry<String, IModel3D> entry : pipePartModels.entrySet()) {
                    if (!entry.getKey().contains(" " + grp)) continue;
                    texturePlate_Outer.get(forgeDirection).add(LogisticsNewRenderPipe.compute(entry.getValue().backfacedCopy().apply(new LPTranslation(0.0, 0.0, 1.0)).apply(new LPTranslation(-0.5, -0.5, -0.5)).apply(new LPScale(1.001)).apply(new LPTranslation(0.5, 0.5, 0.5))));
                }
                if (texturePlate_Outer.get(forgeDirection).size() == 2) continue;
                throw new RuntimeException("Couldn't load " + forgeDirection.name() + " (" + grp + "). Only loaded " + texturePlate_Outer.get(forgeDirection).size());
            }
            for (ForgeDirection forgeDirection : ForgeDirection.VALID_DIRECTIONS) {
                sideTexturePlate.put(forgeDirection, new Quartet(new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList()));
                grp = "Texture_Side_" + LogisticsNewRenderPipe.getDirAsString_Type1(forgeDirection);
                for (Map.Entry<String, IModel3D> entry : pipePartModels.entrySet()) {
                    if (!entry.getKey().contains(" " + grp)) continue;
                    IModel3D model = LogisticsNewRenderPipe.compute(entry.getValue().backfacedCopy().apply(new LPTranslation(0.0, 0.0, 1.0)));
                    double sizeA = model.bounds().max().x() - model.bounds().min().x() + (model.bounds().max().y() - model.bounds().min().y()) + (model.bounds().max().z() - model.bounds().min().z());
                    double dis = Math.pow(model.bounds().min().x() - 0.5, 2.0) + Math.pow(model.bounds().min().y() - 0.5, 2.0) + Math.pow(model.bounds().min().z() - 0.5, 2.0);
                    if (sizeA < 0.5) {
                        if (dis > 0.22 && dis < 0.24 || dis > 0.38 && dis < 0.4) {
                            sideTexturePlate.get(forgeDirection).getValue4().add(model);
                            continue;
                        }
                        if (!(dis < 0.2 && dis > 0.18) && (!(dis < 0.36) || !(dis > 0.34))) throw new UnsupportedOperationException("Dis: " + dis);
                        ((List)sideTexturePlate.get(forgeDirection).getValue2()).add(model);
                        continue;
                    }
                    if (dis > 0.22 && dis < 0.24 || dis > 0.38 && dis < 0.4) {
                        ((List)sideTexturePlate.get(forgeDirection).getValue3()).add(model);
                        continue;
                    }
                    if (!(dis < 0.2 && dis > 0.18) && (!(dis < 0.36) || !(dis > 0.34))) throw new UnsupportedOperationException("Dis: " + dis);
                    ((List)sideTexturePlate.get(forgeDirection).getValue1()).add(model);
                }
                if (((List)sideTexturePlate.get(forgeDirection).getValue1()).size() != 8) {
                    throw new RuntimeException("Couldn't load " + forgeDirection.name() + " (" + grp + "). Only loaded " + ((List)sideTexturePlate.get(forgeDirection).getValue1()).size());
                }
                if (((List)sideTexturePlate.get(forgeDirection).getValue2()).size() != 8) {
                    throw new RuntimeException("Couldn't load " + forgeDirection.name() + " (" + grp + "). Only loaded " + ((List)sideTexturePlate.get(forgeDirection).getValue2()).size());
                }
                if (((List)sideTexturePlate.get(forgeDirection).getValue3()).size() != 8) {
                    throw new RuntimeException("Couldn't load " + forgeDirection.name() + " (" + grp + "). Only loaded " + ((List)sideTexturePlate.get(forgeDirection).getValue3()).size());
                }
                if (sideTexturePlate.get(forgeDirection).getValue4().size() == 8) continue;
                throw new RuntimeException("Couldn't load " + forgeDirection.name() + " (" + grp + "). Only loaded " + sideTexturePlate.get(forgeDirection).getValue4().size());
            }
            for (Mount mount : Mount.values()) {
                textureConnectorPlate.put(mount, new ArrayList());
                grp = "Texture_Connector_" + LogisticsNewRenderPipe.getDirAsString_Type1(mount.dir) + "_" + LogisticsNewRenderPipe.getDirAsString_Type1(mount.side);
                for (Map.Entry<String, IModel3D> entry : pipePartModels.entrySet()) {
                    if (!entry.getKey().contains(" " + grp + " ") && !entry.getKey().endsWith(" " + grp)) continue;
                    textureConnectorPlate.get((Object)mount).add(LogisticsNewRenderPipe.compute(entry.getValue().backfacedCopy().apply(new LPTranslation(0.0, 0.0, 1.0))));
                }
                if (textureConnectorPlate.get((Object)mount).size() == 4) continue;
                throw new RuntimeException("Couldn't load " + mount.name() + " (" + grp + "). Only loaded " + textureConnectorPlate.get((Object)mount).size());
            }
            pipePartModels = SimpleServiceLocator.cclProxy.parseObjModels(LogisticsPipes.class.getResourceAsStream("/logisticspipes/models/PipeModel_Transport_Box.obj"), 7, new LPScale(0.01f));
            innerTransportBox = LogisticsNewRenderPipe.compute(pipePartModels.get("InnerTransportBox").backfacedCopy().apply(new LPTranslation(0.0, 0.0, 1.0)).apply(new LPTranslation(-0.5, -0.5, -0.5)).apply(new LPScale(0.99)).apply(new LPTranslation(0.5, 0.5, 0.5)));
            return;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static String getDirAsString_Type1(ForgeDirection dir) {
        switch (dir) {
            case NORTH: {
                return "N";
            }
            case SOUTH: {
                return "S";
            }
            case EAST: {
                return "E";
            }
            case WEST: {
                return "W";
            }
            case UP: {
                return "U";
            }
            case DOWN: {
                return "D";
            }
        }
        return "UNKNWON";
    }

    private static IModel3D compute(IModel3D m) {
        m.computeNormals();
        m.computeStandardLighting();
        return m;
    }

    public static void registerTextures(IIconRegister iconRegister) {
        if (basicTexture == null) {
            basicTexture = SimpleServiceLocator.cclProxy.createIconTransformer(iconRegister.func_94245_a("logisticspipes:pipes/PipeModel"));
            inactiveTexture = SimpleServiceLocator.cclProxy.createIconTransformer(iconRegister.func_94245_a("logisticspipes:pipes/PipeModel-inactive"));
            innerBoxTexture = SimpleServiceLocator.cclProxy.createIconTransformer(iconRegister.func_94245_a("logisticspipes:pipes/InnerBox"));
            glassCenterTexture = SimpleServiceLocator.cclProxy.createIconTransformer(iconRegister.func_94245_a("logisticspipes:pipes/Glass_Texture_Center"));
            statusTexture = SimpleServiceLocator.cclProxy.createIconTransformer(iconRegister.func_94245_a("logisticspipes:pipes/PipeModel-status"));
            statusBCTexture = SimpleServiceLocator.cclProxy.createIconTransformer(iconRegister.func_94245_a("logisticspipes:pipes/PipeModel-status-BC"));
        } else {
            basicTexture.update(iconRegister.func_94245_a("logisticspipes:pipes/PipeModel"));
            inactiveTexture.update(iconRegister.func_94245_a("logisticspipes:pipes/PipeModel-inactive"));
            innerBoxTexture.update(iconRegister.func_94245_a("logisticspipes:pipes/InnerBox"));
            glassCenterTexture.update(iconRegister.func_94245_a("logisticspipes:pipes/Glass_Texture_Center"));
            statusTexture.update(iconRegister.func_94245_a("logisticspipes:pipes/PipeModel-status"));
            statusBCTexture.update(iconRegister.func_94245_a("logisticspipes:pipes/PipeModel-status-BC"));
        }
    }

    public void renderTileEntityAt(LogisticsTileGenericPipe pipeTile, double x, double y, double z, float partialTickTime, double distance) {
        if (pipeTile.pipe instanceof PipeBlockRequestTable) {
            return;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(BLOCKS);
        PipeRenderState renderState = pipeTile.renderState;
        if (renderState.renderList != null && renderState.renderList.isInvalid()) {
            renderState.renderList = null;
        }
        if (distance > (double)(this.config.getRenderPipeDistance() * this.config.getRenderPipeDistance())) {
            if (this.config.isUseFallbackRenderer()) {
                renderState.forceRenderOldPipe = true;
            }
            return;
        }
        if (renderState.renderList == null) {
            renderState.renderList = SimpleServiceLocator.renderListHandler.getNewRenderList();
        }
        renderState.forceRenderOldPipe = false;
        boolean recalculateList = false;
        if (renderState.cachedRenderer == null) {
            ArrayList<Pair<IModel3D, I3DOperation[]>> objectsToRender = new ArrayList<Pair<IModel3D, I3DOperation[]>>();
            this.fillObjectsToRenderList(objectsToRender, pipeTile, renderState);
            renderState.cachedRenderer = objectsToRender;
            recalculateList = true;
        }
        if (!renderState.renderList.isFilled() || recalculateList) {
            renderState.renderList.startListCompile();
            Tessellator tess = Tessellator.field_78398_a;
            SimpleServiceLocator.cclProxy.getRenderState().reset();
            SimpleServiceLocator.cclProxy.getRenderState().setUseNormals(true);
            SimpleServiceLocator.cclProxy.getRenderState().setAlphaOverride(255);
            int brightness = pipeTile.func_145838_q().func_149677_c((IBlockAccess)pipeTile.func_145831_w(), pipeTile.field_145851_c, pipeTile.field_145848_d, pipeTile.field_145849_e);
            tess.func_78386_a(1.0f, 1.0f, 1.0f);
            tess.func_78380_c(brightness);
            tess.func_78382_b();
            for (Pair<IModel3D, I3DOperation[]> model : renderState.cachedRenderer) {
                if (model == null) {
                    SimpleServiceLocator.cclProxy.getRenderState().setAlphaOverride(160);
                    continue;
                }
                model.getValue1().render(model.getValue2());
            }
            SimpleServiceLocator.cclProxy.getRenderState().setAlphaOverride(255);
            tess.func_78381_a();
            renderState.renderList.stopCompile();
        }
        if (renderState.renderList != null) {
            GL11.glPushAttrib((int)24576);
            GL11.glPushMatrix();
            GL11.glTranslated((double)x, (double)y, (double)z);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)1, (int)0);
            renderState.renderList.render();
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
            GL11.glPopAttrib();
        }
    }

    /*
     * Could not resolve type clashes
     */
    private void fillObjectsToRenderList(List<Pair<IModel3D, I3DOperation[]>> objectsToRender, LogisticsTileGenericPipe pipeTile, PipeRenderState renderState) {
        ArrayList<Edge> edgesToRender = new ArrayList<Edge>(Arrays.asList(Edge.values()));
        HashMap<I3DOperation, Integer> connectionAtCorner = new HashMap<I3DOperation, Integer>();
        ArrayList<Mount> mountCanidates = new ArrayList<Mount>(Arrays.asList(Mount.values()));
        int connectionCount = 0;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            Object[] texture;
            if (!renderState.pipeConnectionMatrix.isConnected(dir)) continue;
            ++connectionCount;
            if (renderState.pipeConnectionMatrix.isBCConnected(dir)) {
                texture = new I3DOperation[]{basicTexture};
                if (renderState.textureMatrix.isRouted()) {
                    texture = renderState.textureMatrix.isRoutedInDir(dir) ? (renderState.textureMatrix.isSubPowerInDir(dir) ? new I3DOperation[]{new LPUVTransformationList(new LPUVTranslation(0.0f, 0.23f), statusBCTexture)} : new I3DOperation[]{statusBCTexture}) : new I3DOperation[]{new LPUVTransformationList(new LPUVTranslation(0.0f, -0.23f), statusBCTexture)};
                }
                for (IModel3D model : sideBC.get(dir)) {
                    objectsToRender.add(new Pair<IModel3D, I3DOperation[]>(model, (I3DOperation[])texture));
                }
            } else {
                texture = new I3DOperation[]{basicTexture};
                if (renderState.textureMatrix.isRouted()) {
                    texture = renderState.textureMatrix.isRoutedInDir(dir) ? (renderState.textureMatrix.isSubPowerInDir(dir) ? new I3DOperation[]{new LPUVTransformationList(new LPUVTranslation(-0.25f, 0.0f), statusTexture)} : new I3DOperation[]{statusTexture}) : (renderState.textureMatrix.isHasPowerUpgrade() ? (renderState.textureMatrix.getPointedOrientation() == dir ? new I3DOperation[]{new LPUVTransformationList(new LPUVTranslation(0.25f, 0.0f), statusTexture)} : new I3DOperation[]{new LPUVTransformationList(new LPUVTranslation(-0.25f, 0.37f), statusTexture)}) : (renderState.textureMatrix.getPointedOrientation() == dir ? new I3DOperation[]{new LPUVTransformationList(new LPUVTranslation(0.25f, 0.37f), statusTexture)} : new I3DOperation[]{new LPUVTransformationList(new LPUVTranslation(0.0f, 0.37f), statusTexture)}));
                }
                for (IModel3D model : sideNormal.get(dir)) {
                    Block block;
                    double[] bounds;
                    double bound;
                    ScaleObject key = new ScaleObject(model, bound = (bounds = new double[]{(block = pipeTile.getWorld().func_147439_a(pipeTile.field_145851_c + dir.offsetX, pipeTile.field_145848_d + dir.offsetY, pipeTile.field_145849_e + dir.offsetZ)).func_149665_z(), block.func_149706_B(), block.func_149704_x(), block.func_149669_A(), block.func_149693_C(), block.func_149753_y()})[dir.ordinal() / 2 + (dir.ordinal() % 2 == 0 ? 3 : 0)]);
                    IModel3D model2 = scaleMap.get(key);
                    if (model2 == null) {
                        double toAdd;
                        model2 = model.copy();
                        IVec3 min = model2.bounds().min();
                        model2.apply(new LPTranslation(min).inverse());
                        if (dir.ordinal() % 2 == 1) {
                            toAdd = 1.0 + bound / 0.1875;
                            model2.apply(new LPScale(dir.offsetX != 0 ? toAdd : 1.0, dir.offsetY != 0 ? toAdd : 1.0, dir.offsetZ != 0 ? toAdd : 1.0));
                        } else {
                            bound = 1.0 - bound;
                            toAdd = 1.0 + bound / 0.1875;
                            model2.apply(new LPScale(dir.offsetX != 0 ? toAdd : 1.0, dir.offsetY != 0 ? toAdd : 1.0, dir.offsetZ != 0 ? toAdd : 1.0));
                            model2.apply(new LPTranslation((double)dir.offsetX * bound, (double)dir.offsetY * bound, (double)dir.offsetZ * bound));
                        }
                        model2.apply(new LPTranslation(min));
                        scaleMap.put(key, model2);
                    }
                    objectsToRender.add(new Pair<IModel3D, I3DOperation[]>(model2, (I3DOperation[])texture));
                }
            }
            for (I3DOperation edge : Edge.values()) {
                if (((Edge)((Object)edge)).part1 != dir && ((Edge)((Object)edge)).part2 != dir) continue;
                edgesToRender.remove(edge);
                for (Mount mount : Mount.values()) {
                    if ((mount.dir != ((Edge)((Object)edge)).part1 || mount.side != ((Edge)((Object)edge)).part2) && (mount.dir != ((Edge)((Object)edge)).part2 || mount.side != ((Edge)((Object)edge)).part1)) continue;
                    mountCanidates.remove((Object)mount);
                }
            }
            for (I3DOperation corner : Corner.values()) {
                if (((Corner)((Object)corner)).ew.dir != dir && ((Corner)((Object)corner)).ns.dir != dir && ((Corner)((Object)corner)).ud.dir != dir) continue;
                if (!connectionAtCorner.containsKey(corner)) {
                    connectionAtCorner.put(corner, 1);
                    continue;
                }
                connectionAtCorner.put(corner, (Integer)connectionAtCorner.get(corner) + 1);
            }
        }
        block11: for (ForgeDirection corner : Corner.values()) {
            Object cornerTexture = basicTexture;
            if (!renderState.textureMatrix.isHasPower() && renderState.textureMatrix.isRouted()) {
                cornerTexture = inactiveTexture;
            } else if (!renderState.textureMatrix.isRouted() && connectionCount > 2) {
                cornerTexture = inactiveTexture;
            }
            int count = connectionAtCorner.getOrDefault(corner, 0);
            if (count == 0) {
                for (IModel3D model : corners_M.get(corner)) {
                    objectsToRender.add(new Pair<IModel3D, I3DOperation[]>(model, new I3DOperation[]{cornerTexture}));
                }
                continue;
            }
            if (count == 1) {
                for (Object turn : Turn_Corner.values()) {
                    if (((Turn_Corner)((Object)turn)).corner != corner || !renderState.pipeConnectionMatrix.isConnected(((Turn_Corner)((Object)turn)).getPointer())) continue;
                    objectsToRender.add(new Pair<IModel3D, I3DOperation[]>(spacers.get(turn), new I3DOperation[]{cornerTexture}));
                    continue block11;
                }
                continue;
            }
            if (count == 2) {
                for (Object turn : Turn_Corner.values()) {
                    if (((Turn_Corner)((Object)turn)).corner != corner || renderState.pipeConnectionMatrix.isConnected(((Turn_Corner)((Object)turn)).getPointer())) continue;
                    objectsToRender.add(new Pair<IModel3D, I3DOperation[]>(corners_I.get(turn), new I3DOperation[]{cornerTexture}));
                    continue block11;
                }
                continue;
            }
            if (count != 3) continue;
            for (IModel3D model : corners_I3.get(corner)) {
                objectsToRender.add(new Pair<IModel3D, I3DOperation[]>(model, new I3DOperation[]{cornerTexture}));
            }
        }
        for (Edge edge : edgesToRender) {
            objectsToRender.add(new Pair<IModel3D, I3DOperation[]>(edges.get((Object)edge), new I3DOperation[]{basicTexture}));
        }
        block17: for (int i = 0; i < 6; i += 2) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)i);
            ArrayList<ForgeDirection> list = new ArrayList<ForgeDirection>(Arrays.asList(ForgeDirection.VALID_DIRECTIONS));
            list.remove(dir);
            list.remove(dir.getOpposite());
            if (!renderState.pipeConnectionMatrix.isConnected(dir) || !renderState.pipeConnectionMatrix.isConnected(dir.getOpposite())) continue;
            boolean found = false;
            for (ForgeDirection dir2 : list) {
                if (!renderState.pipeConnectionMatrix.isConnected(dir2)) continue;
                found = true;
                break;
            }
            if (found) continue;
            switch (dir) {
                case DOWN: {
                    objectsToRender.add(new Pair<IModel3D, I3DOperation[]>(supports.get((Object)Support.EAST_SIDE), new I3DOperation[]{basicTexture}));
                    objectsToRender.add(new Pair<IModel3D, I3DOperation[]>(supports.get((Object)Support.WEST_SIDE), new I3DOperation[]{basicTexture}));
                    objectsToRender.add(new Pair<IModel3D, I3DOperation[]>(supports.get((Object)Support.NORTH_SIDE), new I3DOperation[]{basicTexture}));
                    objectsToRender.add(new Pair<IModel3D, I3DOperation[]>(supports.get((Object)Support.SOUTH_SIDE), new I3DOperation[]{basicTexture}));
                    continue block17;
                }
                case NORTH: {
                    objectsToRender.add(new Pair<IModel3D, I3DOperation[]>(supports.get((Object)Support.EAST_UP), new I3DOperation[]{basicTexture}));
                    objectsToRender.add(new Pair<IModel3D, I3DOperation[]>(supports.get((Object)Support.WEST_UP), new I3DOperation[]{basicTexture}));
                    objectsToRender.add(new Pair<IModel3D, I3DOperation[]>(supports.get((Object)Support.UP_SIDE), new I3DOperation[]{basicTexture}));
                    objectsToRender.add(new Pair<IModel3D, I3DOperation[]>(supports.get((Object)Support.DOWN_SIDE), new I3DOperation[]{basicTexture}));
                    continue block17;
                }
                case WEST: {
                    objectsToRender.add(new Pair<IModel3D, I3DOperation[]>(supports.get((Object)Support.UP_UP), new I3DOperation[]{basicTexture}));
                    objectsToRender.add(new Pair<IModel3D, I3DOperation[]>(supports.get((Object)Support.DOWN_UP), new I3DOperation[]{basicTexture}));
                    objectsToRender.add(new Pair<IModel3D, I3DOperation[]>(supports.get((Object)Support.NORTH_UP), new I3DOperation[]{basicTexture}));
                    objectsToRender.add(new Pair<IModel3D, I3DOperation[]>(supports.get((Object)Support.SOUTH_UP), new I3DOperation[]{basicTexture}));
                    continue block17;
                }
            }
        }
        boolean[] solidSides = new boolean[6];
        for (Object dir : ForgeDirection.VALID_DIRECTIONS) {
            LPPosition pos = new LPPosition(pipeTile);
            pos.moveForward((ForgeDirection)dir);
            Block blockSide = pos.getBlock((IBlockAccess)pipeTile.func_145831_w());
            if (blockSide == null || !blockSide.isSideSolid((IBlockAccess)pipeTile.func_145831_w(), pos.getX(), pos.getY(), pos.getZ(), dir.getOpposite()) || renderState.pipeConnectionMatrix.isConnected((ForgeDirection)dir)) {
                mountCanidates.removeIf(arg_0 -> LogisticsNewRenderPipe.lambda$fillObjectsToRenderList$0((ForgeDirection)dir, arg_0));
                continue;
            }
            solidSides[dir.ordinal()] = true;
        }
        if (!mountCanidates.isEmpty()) {
            if (solidSides[ForgeDirection.DOWN.ordinal()]) {
                this.findOponentOnSameSide(mountCanidates, ForgeDirection.DOWN);
            } else if (solidSides[ForgeDirection.UP.ordinal()]) {
                this.findOponentOnSameSide(mountCanidates, ForgeDirection.UP);
            } else {
                this.removeFromSide(mountCanidates, ForgeDirection.DOWN);
                this.removeFromSide(mountCanidates, ForgeDirection.UP);
                if (mountCanidates.size() > 2) {
                    this.removeIfHasOponentSide(mountCanidates);
                }
                if (mountCanidates.size() > 2) {
                    this.removeIfHasConnectedSide(mountCanidates);
                }
                if (mountCanidates.size() > 2) {
                    this.findOponentOnSameSide(mountCanidates, ((Mount)((Object)mountCanidates.get((int)0))).dir);
                }
            }
            for (Mount mount : mountCanidates) {
                objectsToRender.add(new Pair<IModel3D, I3DOperation[]>(mounts.get((Object)mount), new I3DOperation[]{basicTexture}));
            }
        }
        for (Object dir : ForgeDirection.VALID_DIRECTIONS) {
            if (renderState.pipeConnectionMatrix.isConnected((ForgeDirection)dir)) continue;
            for (IModel3D model : texturePlate_Outer.get(dir)) {
                IIconTransformation icon = Textures.LPnewPipeIconProvider.getIcon(renderState.textureMatrix.getTextureIndex());
                if (icon == null) continue;
                objectsToRender.add(new Pair<IModel3D, I3DOperation[]>(model, new I3DOperation[]{icon}));
            }
        }
        if (renderState.textureMatrix.isFluid()) {
            for (Object dir : ForgeDirection.VALID_DIRECTIONS) {
                if (!renderState.pipeConnectionMatrix.isConnected((ForgeDirection)dir)) {
                    for (IModel3D model : texturePlate_Inner.get(dir)) {
                        objectsToRender.add(new Pair<IModel3D, I3DOperation[]>(model, new I3DOperation[]{glassCenterTexture}));
                    }
                    continue;
                }
                if (renderState.textureMatrix.isRoutedInDir((ForgeDirection)dir)) continue;
                for (IModel3D model : (List)sideTexturePlate.get(dir).getValue1()) {
                    objectsToRender.add(new Pair<IModel3D, I3DOperation[]>(model, new I3DOperation[]{basicTexture}));
                }
            }
        }
    }

    private void findOponentOnSameSide(List<Mount> mountCanidates, ForgeDirection dir) {
        boolean[] sides = new boolean[6];
        Iterator<Mount> iter = mountCanidates.iterator();
        while (iter.hasNext()) {
            Mount mount = iter.next();
            if (mount.dir != dir) {
                iter.remove();
                continue;
            }
            sides[mount.side.ordinal()] = true;
        }
        if (mountCanidates.size() <= 2) {
            return;
        }
        ArrayList<ForgeDirection> keep = new ArrayList<ForgeDirection>();
        if (sides[2] && sides[3]) {
            keep.add(ForgeDirection.NORTH);
            keep.add(ForgeDirection.SOUTH);
        } else if (sides[4] && sides[5]) {
            keep.add(ForgeDirection.EAST);
            keep.add(ForgeDirection.WEST);
        } else if (sides[0] && sides[1]) {
            keep.add(ForgeDirection.UP);
            keep.add(ForgeDirection.DOWN);
        }
        iter = mountCanidates.iterator();
        while (iter.hasNext()) {
            Mount mount = iter.next();
            if (keep.contains(mount.side)) continue;
            iter.remove();
        }
    }

    private void removeFromSide(List<Mount> mountCanidates, ForgeDirection dir) {
        mountCanidates.removeIf(mount -> mount.dir == dir);
    }

    private void reduceToOnePerSide(List<Mount> mountCanidates, ForgeDirection dir, ForgeDirection pref) {
        boolean found = false;
        for (Mount mount : mountCanidates) {
            if (mount.dir != dir || mount.side != pref) continue;
            found = true;
            break;
        }
        if (!found) {
            this.reduceToOnePerSide(mountCanidates, dir);
        } else {
            Iterator<Mount> iter = mountCanidates.iterator();
            while (iter.hasNext()) {
                Mount mount;
                mount = iter.next();
                if (mount.dir != dir || mount.side == pref) continue;
                iter.remove();
            }
        }
    }

    private void reduceToOnePerSide(List<Mount> mountCanidates, ForgeDirection dir) {
        boolean found = false;
        Iterator<Mount> iter = mountCanidates.iterator();
        while (iter.hasNext()) {
            Mount mount = iter.next();
            if (mount.dir != dir) continue;
            if (found) {
                iter.remove();
                continue;
            }
            found = true;
        }
    }

    private void removeIfHasOponentSide(List<Mount> mountCanidates) {
        boolean[] sides = new boolean[6];
        for (Mount mount : mountCanidates) {
            sides[mount.dir.ordinal()] = true;
        }
        if (sides[2] && sides[3]) {
            this.removeFromSide(mountCanidates, ForgeDirection.EAST);
            this.removeFromSide(mountCanidates, ForgeDirection.WEST);
            this.reduceToOnePerSide(mountCanidates, ForgeDirection.NORTH);
            this.reduceToOnePerSide(mountCanidates, ForgeDirection.SOUTH);
        } else if (sides[4] && sides[5]) {
            this.removeFromSide(mountCanidates, ForgeDirection.NORTH);
            this.removeFromSide(mountCanidates, ForgeDirection.SOUTH);
            this.reduceToOnePerSide(mountCanidates, ForgeDirection.EAST);
            this.reduceToOnePerSide(mountCanidates, ForgeDirection.WEST);
        }
    }

    private void removeIfHasConnectedSide(List<Mount> mountCanidates) {
        boolean[] sides = new boolean[6];
        for (Mount mount : mountCanidates) {
            sides[mount.dir.ordinal()] = true;
        }
        for (int i = 2; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)i);
            ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
            if (!sides[dir.ordinal()] || !sides[rot.ordinal()]) continue;
            this.reduceToOnePerSide(mountCanidates, dir, dir.getRotation(ForgeDirection.DOWN));
            this.reduceToOnePerSide(mountCanidates, rot, rot.getRotation(ForgeDirection.UP));
        }
    }

    private static /* synthetic */ boolean lambda$fillObjectsToRenderList$0(ForgeDirection dir, Mount mount) {
        return mount.dir == dir;
    }

    static {
        BLOCKS = new ResourceLocation("textures/atlas/blocks.png");
        LogisticsNewRenderPipe.loadModels();
    }

    private static class ScaleObject {
        private final IModel3D original;
        private final double scale;

        public IModel3D getOriginal() {
            return this.original;
        }

        public double getScale() {
            return this.scale;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScaleObject)) {
                return false;
            }
            ScaleObject other = (ScaleObject)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getScale(), other.getScale()) != 0) {
                return false;
            }
            IModel3D this$original = this.getOriginal();
            IModel3D other$original = other.getOriginal();
            return !(this$original == null ? other$original != null : !this$original.equals(other$original));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ScaleObject;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $scale = Double.doubleToLongBits(this.getScale());
            result = result * 59 + (int)($scale >>> 32 ^ $scale);
            IModel3D $original = this.getOriginal();
            result = result * 59 + ($original == null ? 43 : $original.hashCode());
            return result;
        }

        public String toString() {
            return "LogisticsNewRenderPipe.ScaleObject(original=" + this.getOriginal() + ", scale=" + this.getScale() + ")";
        }

        public ScaleObject(IModel3D original, double scale) {
            this.original = original;
            this.scale = scale;
        }
    }

    static enum Mount {
        UP_NORTH(ForgeDirection.UP, ForgeDirection.NORTH),
        UP_SOUTH(ForgeDirection.UP, ForgeDirection.SOUTH),
        UP_EAST(ForgeDirection.UP, ForgeDirection.EAST),
        UP_WEST(ForgeDirection.UP, ForgeDirection.WEST),
        DOWN_NORTH(ForgeDirection.DOWN, ForgeDirection.NORTH),
        DOWN_SOUTH(ForgeDirection.DOWN, ForgeDirection.SOUTH),
        DOWN_EAST(ForgeDirection.DOWN, ForgeDirection.EAST),
        DOWN_WEST(ForgeDirection.DOWN, ForgeDirection.WEST),
        NORTH_UP(ForgeDirection.NORTH, ForgeDirection.UP),
        NORTH_DOWN(ForgeDirection.NORTH, ForgeDirection.DOWN),
        NORTH_EAST(ForgeDirection.NORTH, ForgeDirection.EAST),
        NORTH_WEST(ForgeDirection.NORTH, ForgeDirection.WEST),
        SOUTH_UP(ForgeDirection.SOUTH, ForgeDirection.UP),
        SOUTH_DOWN(ForgeDirection.SOUTH, ForgeDirection.DOWN),
        SOUTH_EAST(ForgeDirection.SOUTH, ForgeDirection.EAST),
        SOUTH_WEST(ForgeDirection.SOUTH, ForgeDirection.WEST),
        EAST_UP(ForgeDirection.EAST, ForgeDirection.UP),
        EAST_DOWN(ForgeDirection.EAST, ForgeDirection.DOWN),
        EAST_NORTH(ForgeDirection.EAST, ForgeDirection.NORTH),
        EAST_SOUTH(ForgeDirection.EAST, ForgeDirection.SOUTH),
        WEST_UP(ForgeDirection.WEST, ForgeDirection.UP),
        WEST_DOWN(ForgeDirection.WEST, ForgeDirection.DOWN),
        WEST_NORTH(ForgeDirection.WEST, ForgeDirection.NORTH),
        WEST_SOUTH(ForgeDirection.WEST, ForgeDirection.SOUTH);

        ForgeDirection dir;
        ForgeDirection side;

        private Mount(ForgeDirection dir, ForgeDirection side) {
            this.dir = dir;
            this.side = side;
        }
    }

    static enum Support {
        UP_UP(ForgeDirection.UP, SupportOri.UP_DOWN),
        UP_SIDE(ForgeDirection.UP, SupportOri.SIDE),
        DOWN_UP(ForgeDirection.DOWN, SupportOri.UP_DOWN),
        DOWN_SIDE(ForgeDirection.DOWN, SupportOri.SIDE),
        NORTH_UP(ForgeDirection.NORTH, SupportOri.UP_DOWN),
        NORTH_SIDE(ForgeDirection.NORTH, SupportOri.SIDE),
        SOUTH_UP(ForgeDirection.SOUTH, SupportOri.UP_DOWN),
        SOUTH_SIDE(ForgeDirection.SOUTH, SupportOri.SIDE),
        EAST_UP(ForgeDirection.EAST, SupportOri.UP_DOWN),
        EAST_SIDE(ForgeDirection.EAST, SupportOri.SIDE),
        WEST_UP(ForgeDirection.WEST, SupportOri.UP_DOWN),
        WEST_SIDE(ForgeDirection.WEST, SupportOri.SIDE);

        final ForgeDirection dir;
        final SupportOri ori;

        private Support(ForgeDirection dir, SupportOri ori) {
            this.dir = dir;
            this.ori = ori;
        }
    }

    static enum SupportOri {
        UP_DOWN("U"),
        SIDE("S");

        final String s;

        private SupportOri(String s) {
            this.s = s;
        }
    }

    static enum Turn_Corner {
        UP_NORTH_WEST_TURN_NORTH_SOUTH(Corner.UP_NORTH_WEST, Turn.NORTH_SOUTH, 1),
        UP_NORTH_WEST_TURN_EAST_WEST(Corner.UP_NORTH_WEST, Turn.EAST_WEST, 14),
        UP_NORTH_WEST_TURN_UP_DOWN(Corner.UP_NORTH_WEST, Turn.UP_DOWN, 23),
        UP_NORTH_EAST_TURN_NORTH_SOUTH(Corner.UP_NORTH_EAST, Turn.NORTH_SOUTH, 2),
        UP_NORTH_EAST_TURN_EAST_WEST(Corner.UP_NORTH_EAST, Turn.EAST_WEST, 9),
        UP_NORTH_EAST_TURN_UP_DOWN(Corner.UP_NORTH_EAST, Turn.UP_DOWN, 22),
        UP_SOUTH_WEST_TURN_NORTH_SOUTH(Corner.UP_SOUTH_WEST, Turn.NORTH_SOUTH, 6),
        UP_SOUTH_WEST_TURN_EAST_WEST(Corner.UP_SOUTH_WEST, Turn.EAST_WEST, 13),
        UP_SOUTH_WEST_TURN_UP_DOWN(Corner.UP_SOUTH_WEST, Turn.UP_DOWN, 24),
        UP_SOUTH_EAST_TURN_NORTH_SOUTH(Corner.UP_SOUTH_EAST, Turn.NORTH_SOUTH, 5),
        UP_SOUTH_EAST_TURN_EAST_WEST(Corner.UP_SOUTH_EAST, Turn.EAST_WEST, 10),
        UP_SOUTH_EAST_TURN_UP_DOWN(Corner.UP_SOUTH_EAST, Turn.UP_DOWN, 21),
        DOWN_NORTH_WEST_TURN_NORTH_SOUTH(Corner.DOWN_NORTH_WEST, Turn.NORTH_SOUTH, 4),
        DOWN_NORTH_WEST_TURN_EAST_WEST(Corner.DOWN_NORTH_WEST, Turn.EAST_WEST, 15),
        DOWN_NORTH_WEST_TURN_UP_DOWN(Corner.DOWN_NORTH_WEST, Turn.UP_DOWN, 20),
        DOWN_NORTH_EAST_TURN_NORTH_SOUTH(Corner.DOWN_NORTH_EAST, Turn.NORTH_SOUTH, 3),
        DOWN_NORTH_EAST_TURN_EAST_WEST(Corner.DOWN_NORTH_EAST, Turn.EAST_WEST, 12),
        DOWN_NORTH_EAST_TURN_UP_DOWN(Corner.DOWN_NORTH_EAST, Turn.UP_DOWN, 17),
        DOWN_SOUTH_WEST_TURN_NORTH_SOUTH(Corner.DOWN_SOUTH_WEST, Turn.NORTH_SOUTH, 7),
        DOWN_SOUTH_WEST_TURN_EAST_WEST(Corner.DOWN_SOUTH_WEST, Turn.EAST_WEST, 16),
        DOWN_SOUTH_WEST_TURN_UP_DOWN(Corner.DOWN_SOUTH_WEST, Turn.UP_DOWN, 19),
        DOWN_SOUTH_EAST_TURN_NORTH_SOUTH(Corner.DOWN_SOUTH_EAST, Turn.NORTH_SOUTH, 8),
        DOWN_SOUTH_EAST_TURN_EAST_WEST(Corner.DOWN_SOUTH_EAST, Turn.EAST_WEST, 11),
        DOWN_SOUTH_EAST_TURN_UP_DOWN(Corner.DOWN_SOUTH_EAST, Turn.UP_DOWN, 18);

        final Corner corner;
        final Turn turn;
        final int number;

        private Turn_Corner(Corner corner, Turn turn, int number) {
            this.corner = corner;
            this.turn = turn;
            this.number = number;
        }

        public ForgeDirection getPointer() {
            ArrayList<ForgeDirection> canidates = new ArrayList<ForgeDirection>();
            canidates.add(this.corner.ew.dir);
            canidates.add(this.corner.ns.dir);
            canidates.add(this.corner.ud.dir);
            if (canidates.contains(this.turn.dir1)) {
                return this.turn.dir1;
            }
            if (canidates.contains(this.turn.dir2)) {
                return this.turn.dir2;
            }
            throw new UnsupportedOperationException(this.name());
        }
    }

    static enum Turn {
        NORTH_SOUTH(ForgeDirection.NORTH, ForgeDirection.SOUTH),
        EAST_WEST(ForgeDirection.EAST, ForgeDirection.WEST),
        UP_DOWN(ForgeDirection.UP, ForgeDirection.DOWN);

        final ForgeDirection dir1;
        final ForgeDirection dir2;

        private Turn(ForgeDirection dir1, ForgeDirection dir2) {
            this.dir1 = dir1;
            this.dir2 = dir2;
        }
    }

    static enum Corner {
        UP_NORTH_WEST(UpDown.UP, NorthSouth.NORTH, EastWest.WEST),
        UP_NORTH_EAST(UpDown.UP, NorthSouth.NORTH, EastWest.EAST),
        UP_SOUTH_WEST(UpDown.UP, NorthSouth.SOUTH, EastWest.WEST),
        UP_SOUTH_EAST(UpDown.UP, NorthSouth.SOUTH, EastWest.EAST),
        DOWN_NORTH_WEST(UpDown.DOWN, NorthSouth.NORTH, EastWest.WEST),
        DOWN_NORTH_EAST(UpDown.DOWN, NorthSouth.NORTH, EastWest.EAST),
        DOWN_SOUTH_WEST(UpDown.DOWN, NorthSouth.SOUTH, EastWest.WEST),
        DOWN_SOUTH_EAST(UpDown.DOWN, NorthSouth.SOUTH, EastWest.EAST);

        final UpDown ud;
        final NorthSouth ns;
        final EastWest ew;

        private Corner(UpDown ud, NorthSouth ns, EastWest ew) {
            this.ud = ud;
            this.ns = ns;
            this.ew = ew;
        }
    }

    static enum EastWest {
        EAST("E", ForgeDirection.EAST),
        WEST("W", ForgeDirection.WEST);

        final String s;
        final ForgeDirection dir;

        private EastWest(String s, ForgeDirection dir) {
            this.s = s;
            this.dir = dir;
        }
    }

    static enum NorthSouth {
        NORTH("N", ForgeDirection.NORTH),
        SOUTH("S", ForgeDirection.SOUTH);

        final String s;
        final ForgeDirection dir;

        private NorthSouth(String s, ForgeDirection dir) {
            this.s = s;
            this.dir = dir;
        }
    }

    static enum UpDown {
        UP("U", ForgeDirection.UP),
        DOWN("D", ForgeDirection.DOWN);

        final String s;
        final ForgeDirection dir;

        private UpDown(String s, ForgeDirection dir) {
            this.s = s;
            this.dir = dir;
        }
    }

    static enum Edge {
        Upper_North(ForgeDirection.UP, ForgeDirection.NORTH),
        Upper_South(ForgeDirection.UP, ForgeDirection.SOUTH),
        Upper_East(ForgeDirection.UP, ForgeDirection.EAST),
        Upper_West(ForgeDirection.UP, ForgeDirection.WEST),
        Lower_North(ForgeDirection.DOWN, ForgeDirection.NORTH),
        Lower_South(ForgeDirection.DOWN, ForgeDirection.SOUTH),
        Lower_East(ForgeDirection.DOWN, ForgeDirection.EAST),
        Lower_West(ForgeDirection.DOWN, ForgeDirection.WEST),
        Middle_North_West(ForgeDirection.NORTH, ForgeDirection.WEST),
        Middle_North_East(ForgeDirection.NORTH, ForgeDirection.EAST),
        Lower_South_East(ForgeDirection.SOUTH, ForgeDirection.EAST),
        Lower_South_West(ForgeDirection.SOUTH, ForgeDirection.WEST);

        final ForgeDirection part1;
        final ForgeDirection part2;

        private Edge(ForgeDirection part1, ForgeDirection part2) {
            this.part1 = part1;
            this.part2 = part2;
        }
    }
}

