/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.renderer.newpipe;

import java.util.HashMap;
import java.util.Map;
import logisticspipes.LogisticsPipes;
import logisticspipes.blocks.LogisticsSolidBlock;
import logisticspipes.blocks.LogisticsSolidTileEntity;
import logisticspipes.pipes.basic.LogisticsBlockGenericPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.object3d.interfaces.IIconTransformation;
import logisticspipes.proxy.object3d.interfaces.IModel3D;
import logisticspipes.proxy.object3d.operation.LPRotation;
import logisticspipes.proxy.object3d.operation.LPScale;
import logisticspipes.proxy.object3d.operation.LPTranslation;
import logisticspipes.proxy.object3d.operation.LPUVScale;
import logisticspipes.utils.tuples.LPPosition;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class LogisticsNewSolidBlockWorldRenderer {
    static Map<BlockRotation, IModel3D> block = new HashMap<BlockRotation, IModel3D>();
    static Map<CoverSides, Map<BlockRotation, IModel3D>> texturePlate_Inner = new HashMap<CoverSides, Map<BlockRotation, IModel3D>>();
    static Map<CoverSides, Map<BlockRotation, IModel3D>> texturePlate_Outer = new HashMap<CoverSides, Map<BlockRotation, IModel3D>>();

    public static void loadModels() {
        if (!SimpleServiceLocator.cclProxy.isActivated()) {
            return;
        }
        try {
            Map<String, IModel3D> blockPartModels = SimpleServiceLocator.cclProxy.parseObjModels(LogisticsPipes.class.getResourceAsStream("/logisticspipes/models/BlockModel_result.obj"), 7, new LPScale(0.01f));
            block = null;
            for (Map.Entry<String, IModel3D> entry : blockPartModels.entrySet()) {
                if (!entry.getKey().contains(" Block ")) continue;
                if (block != null) {
                    throw new UnsupportedOperationException();
                }
                block = LogisticsNewSolidBlockWorldRenderer.computeRotated(entry.getValue().backfacedCopy().apply(new LPTranslation(0.0, 0.0, 1.0)));
            }
            texturePlate_Outer.clear();
            texturePlate_Inner.clear();
            for (CoverSides side : CoverSides.values()) {
                String grp_Outer = "OutSide_" + side.getLetter();
                String grp_Inside = "Inside_" + side.getLetter();
                for (Map.Entry<String, IModel3D> entry : blockPartModels.entrySet()) {
                    if (entry.getKey().contains(" " + grp_Outer + " ")) {
                        texturePlate_Outer.put(side, LogisticsNewSolidBlockWorldRenderer.computeRotated(entry.getValue().backfacedCopy().apply(new LPTranslation(0.0, 0.0, 1.0))));
                    }
                    if (!entry.getKey().contains(" " + grp_Inside + " ")) continue;
                    texturePlate_Inner.put(side, LogisticsNewSolidBlockWorldRenderer.computeRotated(entry.getValue().backfacedCopy().apply(new LPTranslation(0.0, 0.0, 1.0))));
                }
                if (texturePlate_Outer.get((Object)side) == null) {
                    throw new RuntimeException("Couldn't load OutSide " + side.name() + " (" + grp_Outer + ").");
                }
                if (texturePlate_Inner.get((Object)side) != null) continue;
                throw new RuntimeException("Couldn't load OutSide " + side.name() + " (" + grp_Outer + ").");
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static Map<BlockRotation, IModel3D> computeRotated(IModel3D m) {
        m.apply(new LPUVScale(1.0, 0.75));
        HashMap<BlockRotation, IModel3D> map = new HashMap<BlockRotation, IModel3D>();
        for (BlockRotation rot : BlockRotation.values()) {
            IModel3D model = m.copy();
            switch (rot.getInteger()) {
                case 0: {
                    model.apply(LPRotation.sideOrientation(0, 3));
                    model.apply(new LPTranslation(0.0, 0.0, 1.0));
                    break;
                }
                case 1: {
                    model.apply(LPRotation.sideOrientation(0, 1));
                    model.apply(new LPTranslation(1.0, 0.0, 0.0));
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    model.apply(LPRotation.sideOrientation(0, 2));
                    model.apply(new LPTranslation(1.0, 0.0, 1.0));
                }
            }
            model.computeNormals();
            model.computeStandardLighting();
            map.put(rot, model);
        }
        return map;
    }

    public void renderWorldBlock(LogisticsSolidTileEntity blockTile, RenderBlocks renderer, int x, int y, int z) {
        Tessellator tess = Tessellator.field_78398_a;
        SimpleServiceLocator.cclProxy.getRenderState().reset();
        SimpleServiceLocator.cclProxy.getRenderState().setUseNormals(true);
        SimpleServiceLocator.cclProxy.getRenderState().setAlphaOverride(255);
        BlockRotation rotation = BlockRotation.getRotation(blockTile.getRotation());
        int brightness = new LPPosition(blockTile).getBlock((IBlockAccess)blockTile.func_145831_w()).func_149677_c((IBlockAccess)blockTile.func_145831_w(), blockTile.field_145851_c, blockTile.field_145848_d, blockTile.field_145849_e);
        tess.func_78386_a(1.0f, 1.0f, 1.0f);
        tess.func_78380_c(brightness);
        IIconTransformation icon = SimpleServiceLocator.cclProxy.createIconTransformer(LogisticsSolidBlock.getNewIcon((IBlockAccess)blockTile.func_145831_w(), blockTile.field_145851_c, blockTile.field_145848_d, blockTile.field_145849_e));
        block.get((Object)rotation).render(new LPTranslation(x, y, z), icon);
        LPPosition pos = new LPPosition(blockTile);
        for (CoverSides side : CoverSides.values()) {
            boolean render = true;
            LPPosition newPos = pos.copy();
            newPos.moveForward(side.getDir(rotation));
            TileEntity sideTile = newPos.getTileEntity(blockTile.func_145831_w());
            if (sideTile instanceof LogisticsTileGenericPipe) {
                LogisticsTileGenericPipe tilePipe = (LogisticsTileGenericPipe)sideTile;
                if (tilePipe.renderState.pipeConnectionMatrix.isConnected(side.getDir(rotation).getOpposite())) {
                    render = false;
                }
            }
            if (!render) continue;
            texturePlate_Outer.get((Object)side).get((Object)rotation).render(new LPTranslation(x, y, z), icon);
            texturePlate_Inner.get((Object)side).get((Object)rotation).render(new LPTranslation(x, y, z), icon);
        }
    }

    public void renderInventoryBlock(Block block2, int metadata) {
        GL11.glPushAttrib((int)16384);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3042);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        LogisticsBlockGenericPipe block = LogisticsPipes.LogisticsPipeBlock;
        Tessellator tess = Tessellator.field_78398_a;
        BlockRotation rotation = BlockRotation.ZERO;
        tess.func_78382_b();
        IIconTransformation icon = SimpleServiceLocator.cclProxy.createIconTransformer(LogisticsSolidBlock.getNewIcon(metadata));
        LogisticsNewSolidBlockWorldRenderer.block.get((Object)rotation).render(icon);
        for (CoverSides side : CoverSides.values()) {
            texturePlate_Outer.get((Object)side).get((Object)rotation).render(icon);
        }
        tess.func_78381_a();
        block.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        GL11.glPopAttrib();
    }

    static {
        LogisticsNewSolidBlockWorldRenderer.loadModels();
    }

    static enum BlockRotation {
        ZERO(0),
        ONE(1),
        TWO(2),
        THREE(3);

        private final int integer;

        private BlockRotation(int rot) {
            this.integer = rot;
        }

        static BlockRotation getRotation(int from) {
            for (BlockRotation rot : BlockRotation.values()) {
                if (rot.getInteger() != from) continue;
                return rot;
            }
            return null;
        }

        public int getInteger() {
            return this.integer;
        }
    }

    static enum CoverSides {
        DOWN(ForgeDirection.DOWN, "D"),
        NORTH(ForgeDirection.NORTH, "N"),
        SOUTH(ForgeDirection.SOUTH, "S"),
        WEST(ForgeDirection.WEST, "W"),
        EAST(ForgeDirection.EAST, "E");

        private final ForgeDirection dir;
        private final String letter;

        private CoverSides(ForgeDirection dir, String letter) {
            this.dir = dir;
            this.letter = letter;
        }

        public ForgeDirection getDir(BlockRotation rot) {
            ForgeDirection result = this.dir;
            switch (rot.getInteger()) {
                case 0: {
                    result = result.getRotation(ForgeDirection.UP);
                }
                case 3: {
                    result = result.getRotation(ForgeDirection.UP);
                }
                case 1: {
                    result = result.getRotation(ForgeDirection.UP);
                }
            }
            return result;
        }

        public String getLetter() {
            return this.letter;
        }
    }
}

