/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils.item;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import logisticspipes.LogisticsPipes;
import logisticspipes.utils.Color;
import logisticspipes.utils.gui.GuiGraphics;
import logisticspipes.utils.gui.IItemSearch;
import logisticspipes.utils.gui.SimpleGraphics;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.string.StringUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPane;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import org.lwjgl.opengl.GL11;

public class ItemStackRenderer {
    private RenderManager renderManager;
    private RenderBlocks renderBlocks;
    private RenderItem renderItem;
    private TextureManager texManager;
    private FontRenderer fontRenderer;
    private ItemIdentifierStack itemIdentifierStack;
    private int posX;
    private int posY;
    private float zLevel;
    private float scaleX;
    private float scaleY;
    private float scaleZ;
    private DisplayAmount displayAmount;
    private boolean renderEffects;
    private boolean ignoreDepth;
    private boolean renderInColor;
    private World worldObj;
    private float partialTickTime;
    private final Map<ItemIdentifier, EntityItem> entityCache = new HashMap<ItemIdentifier, EntityItem>();

    public ItemStackRenderer(int posX, int posY, float zLevel, boolean renderEffects, boolean ignoreDepth, boolean renderInColor) {
        this.posX = posX;
        this.posY = posY;
        this.zLevel = zLevel;
        this.renderEffects = renderEffects;
        this.ignoreDepth = ignoreDepth;
        this.renderInColor = renderInColor;
        this.renderManager = RenderManager.field_78727_a;
        this.fontRenderer = this.renderManager.func_78716_a();
        if (this.fontRenderer == null) {
            this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
        }
        this.worldObj = this.renderManager.field_78722_g;
        this.texManager = this.renderManager.field_78724_e;
        if (this.texManager == null) {
            this.texManager = Minecraft.func_71410_x().func_110434_K();
        }
        this.renderBlocks = RenderBlocks.getInstance();
        this.renderItem = RenderItem.getInstance();
        this.scaleX = 1.0f;
        this.scaleY = 1.0f;
        this.scaleZ = 1.0f;
    }

    public static void renderItemIdentifierStackListIntoGui(List<ItemIdentifierStack> _allItems, IItemSearch IItemSearch2, int page, int left, int top, int columns, int items, int xSize, int ySize, float zLevel, DisplayAmount displayAmount) {
        ItemStackRenderer.renderItemIdentifierStackListIntoGui(_allItems, IItemSearch2, page, left, top, columns, items, xSize, ySize, zLevel, displayAmount, true, true, false);
    }

    public static void renderItemIdentifierStackListIntoGui(List<ItemIdentifierStack> _allItems, IItemSearch IItemSearch2, int page, int left, int top, int columns, int items, int xSize, int ySize, float zLevel, DisplayAmount displayAmount, boolean renderInColor, boolean renderEffect, boolean ignoreDepth) {
        ItemStackRenderer itemStackRenderer = new ItemStackRenderer(0, 0, zLevel, renderEffect, ignoreDepth, renderInColor);
        itemStackRenderer.setDisplayAmount(displayAmount);
        ItemStackRenderer.renderItemIdentifierStackListIntoGui(_allItems, IItemSearch2, page, left, top, columns, items, xSize, ySize, itemStackRenderer);
    }

    public static void renderItemIdentifierStackListIntoGui(List<ItemIdentifierStack> _allItems, IItemSearch IItemSearch2, int page, int left, int top, int columns, int items, int xSize, int ySize, ItemStackRenderer itemStackRenderer) {
        int ppi = 0;
        int column = 0;
        int row = 0;
        for (ItemIdentifierStack itemIdentifierStack : _allItems) {
            if (itemIdentifierStack == null) {
                if (++column >= columns) {
                    ++row;
                    column = 0;
                }
                ++ppi;
                continue;
            }
            ItemIdentifier item = itemIdentifierStack.getItem();
            if (IItemSearch2 != null && !IItemSearch2.itemSearched(item) || ++ppi <= items * page || ppi > items * (page + 1)) continue;
            int x = left + xSize * column;
            int y = top + ySize * row + 1;
            itemStackRenderer.setItemIdentifierStack(itemIdentifierStack).setPosX(x).setPosY(y);
            itemStackRenderer.renderInGui();
            if (++column < columns) continue;
            ++row;
            column = 0;
        }
    }

    public void renderInGui() {
        assert (this.itemIdentifierStack != null);
        assert (this.displayAmount != null);
        assert (this.renderBlocks != null);
        assert (this.renderItem != null);
        assert (this.texManager != null);
        assert (this.fontRenderer != null);
        assert (this.scaleX != 0.0f);
        assert (this.scaleY != 0.0f);
        assert (this.scaleZ != 0.0f);
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)2977);
        GL11.glScalef((float)(1.0f / this.scaleX), (float)(1.0f / this.scaleY), (float)(1.0f / this.scaleZ));
        RenderHelper.func_74520_c();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GL11.glScalef((float)this.scaleX, (float)this.scaleY, (float)this.scaleZ);
        if (this.ignoreDepth) {
            GL11.glDisable((int)2929);
        } else {
            GL11.glEnable((int)2929);
        }
        ItemStack itemStack = this.itemIdentifierStack.makeNormalStack();
        if (!ForgeHooksClient.renderInventoryItem((RenderBlocks)this.renderBlocks, (TextureManager)this.texManager, (ItemStack)itemStack, (boolean)this.renderInColor, (float)this.zLevel, (float)this.posX, (float)this.posY)) {
            this.renderItem.field_77023_b += this.zLevel;
            this.renderItem.renderItemIntoGUI(this.fontRenderer, this.texManager, itemStack, this.posX, this.posY, this.renderEffects);
            this.renderItem.field_77023_b -= this.zLevel;
        }
        RenderHelper.func_74518_a();
        if (this.ignoreDepth) {
            GL11.glDisable((int)2929);
        } else {
            GL11.glEnable((int)2929);
        }
        GuiGraphics.drawDurabilityBar(itemStack, this.posX, this.posY, this.zLevel + 20.0f);
        if (this.displayAmount != DisplayAmount.NEVER) {
            if (this.ignoreDepth) {
                GL11.glDisable((int)2929);
            } else {
                GL11.glEnable((int)2929);
            }
            FontRenderer specialFontRenderer = this.itemIdentifierStack.getItem().item.getFontRenderer(itemStack);
            if (specialFontRenderer != null) {
                this.fontRenderer = specialFontRenderer;
            }
            GL11.glDisable((int)2896);
            String amountString = StringUtils.getFormatedStackSize(this.itemIdentifierStack.getStackSize(), this.displayAmount == DisplayAmount.ALWAYS);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(this.zLevel + 40.0f));
            SimpleGraphics.drawStringWithTranslatedShadow(this.fontRenderer, amountString, this.posX + 17 - this.fontRenderer.func_78256_a(amountString), this.posY + 9, Color.getValue(Color.WHITE));
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(-(this.zLevel + 40.0f)));
        }
        GL11.glPopAttrib();
    }

    public void renderInWorld() {
        boolean changeColor;
        assert (this.renderManager != null);
        assert (this.renderItem != null);
        ItemIdentifier itemId = this.itemIdentifierStack.getItem();
        EntityItem entityItem = this.entityCache.get(itemId);
        if (entityItem == null) {
            entityItem = new EntityItem(this.worldObj, 0.0, 0.0, 0.0, itemId.makeNormalStack(1));
            entityItem.field_70290_d = 0.0f;
            this.entityCache.put(itemId, entityItem);
        }
        boolean bl = changeColor = this.renderItem.field_77024_a != this.renderInColor;
        if (changeColor) {
            this.renderItem.field_77024_a = this.renderInColor;
        }
        if (itemId.item instanceof ItemBlock) {
            Block block = ((ItemBlock)itemId.item).field_150939_a;
            if (block instanceof BlockPane) {
                GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
            }
        } else if (itemId.item == LogisticsPipes.logisticsRequestTable) {
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        }
        this.renderManager.func_147940_a((Entity)entityItem, (double)this.posX, (double)this.posY, (double)this.zLevel, 0.0f, this.partialTickTime);
        if (changeColor) {
            this.renderItem.field_77024_a = !this.renderInColor;
        }
    }

    public RenderManager getRenderManager() {
        return this.renderManager;
    }

    public RenderBlocks getRenderBlocks() {
        return this.renderBlocks;
    }

    public RenderItem getRenderItem() {
        return this.renderItem;
    }

    public TextureManager getTexManager() {
        return this.texManager;
    }

    public FontRenderer getFontRenderer() {
        return this.fontRenderer;
    }

    public ItemIdentifierStack getItemIdentifierStack() {
        return this.itemIdentifierStack;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public float getZLevel() {
        return this.zLevel;
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public float getScaleZ() {
        return this.scaleZ;
    }

    public DisplayAmount getDisplayAmount() {
        return this.displayAmount;
    }

    public boolean isRenderEffects() {
        return this.renderEffects;
    }

    public boolean isIgnoreDepth() {
        return this.ignoreDepth;
    }

    public boolean isRenderInColor() {
        return this.renderInColor;
    }

    public World getWorldObj() {
        return this.worldObj;
    }

    public float getPartialTickTime() {
        return this.partialTickTime;
    }

    public Map<ItemIdentifier, EntityItem> getEntityCache() {
        return this.entityCache;
    }

    public ItemStackRenderer setRenderManager(RenderManager renderManager) {
        this.renderManager = renderManager;
        return this;
    }

    public ItemStackRenderer setRenderBlocks(RenderBlocks renderBlocks) {
        this.renderBlocks = renderBlocks;
        return this;
    }

    public ItemStackRenderer setRenderItem(RenderItem renderItem) {
        this.renderItem = renderItem;
        return this;
    }

    public ItemStackRenderer setTexManager(TextureManager texManager) {
        this.texManager = texManager;
        return this;
    }

    public ItemStackRenderer setFontRenderer(FontRenderer fontRenderer) {
        this.fontRenderer = fontRenderer;
        return this;
    }

    public ItemStackRenderer setItemIdentifierStack(ItemIdentifierStack itemIdentifierStack) {
        this.itemIdentifierStack = itemIdentifierStack;
        return this;
    }

    public ItemStackRenderer setPosX(int posX) {
        this.posX = posX;
        return this;
    }

    public ItemStackRenderer setPosY(int posY) {
        this.posY = posY;
        return this;
    }

    public ItemStackRenderer setZLevel(float zLevel) {
        this.zLevel = zLevel;
        return this;
    }

    public ItemStackRenderer setScaleX(float scaleX) {
        this.scaleX = scaleX;
        return this;
    }

    public ItemStackRenderer setScaleY(float scaleY) {
        this.scaleY = scaleY;
        return this;
    }

    public ItemStackRenderer setScaleZ(float scaleZ) {
        this.scaleZ = scaleZ;
        return this;
    }

    public ItemStackRenderer setDisplayAmount(DisplayAmount displayAmount) {
        this.displayAmount = displayAmount;
        return this;
    }

    public ItemStackRenderer setRenderEffects(boolean renderEffects) {
        this.renderEffects = renderEffects;
        return this;
    }

    public ItemStackRenderer setIgnoreDepth(boolean ignoreDepth) {
        this.ignoreDepth = ignoreDepth;
        return this;
    }

    public ItemStackRenderer setRenderInColor(boolean renderInColor) {
        this.renderInColor = renderInColor;
        return this;
    }

    public ItemStackRenderer setWorldObj(World worldObj) {
        this.worldObj = worldObj;
        return this;
    }

    public ItemStackRenderer setPartialTickTime(float partialTickTime) {
        this.partialTickTime = partialTickTime;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ItemStackRenderer)) {
            return false;
        }
        ItemStackRenderer other = (ItemStackRenderer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPosX() != other.getPosX()) {
            return false;
        }
        if (this.getPosY() != other.getPosY()) {
            return false;
        }
        if (Float.compare(this.getZLevel(), other.getZLevel()) != 0) {
            return false;
        }
        if (Float.compare(this.getScaleX(), other.getScaleX()) != 0) {
            return false;
        }
        if (Float.compare(this.getScaleY(), other.getScaleY()) != 0) {
            return false;
        }
        if (Float.compare(this.getScaleZ(), other.getScaleZ()) != 0) {
            return false;
        }
        if (this.isRenderEffects() != other.isRenderEffects()) {
            return false;
        }
        if (this.isIgnoreDepth() != other.isIgnoreDepth()) {
            return false;
        }
        if (this.isRenderInColor() != other.isRenderInColor()) {
            return false;
        }
        if (Float.compare(this.getPartialTickTime(), other.getPartialTickTime()) != 0) {
            return false;
        }
        RenderManager this$renderManager = this.getRenderManager();
        RenderManager other$renderManager = other.getRenderManager();
        if (this$renderManager == null ? other$renderManager != null : !this$renderManager.equals(other$renderManager)) {
            return false;
        }
        RenderBlocks this$renderBlocks = this.getRenderBlocks();
        RenderBlocks other$renderBlocks = other.getRenderBlocks();
        if (this$renderBlocks == null ? other$renderBlocks != null : !this$renderBlocks.equals(other$renderBlocks)) {
            return false;
        }
        RenderItem this$renderItem = this.getRenderItem();
        RenderItem other$renderItem = other.getRenderItem();
        if (this$renderItem == null ? other$renderItem != null : !this$renderItem.equals(other$renderItem)) {
            return false;
        }
        TextureManager this$texManager = this.getTexManager();
        TextureManager other$texManager = other.getTexManager();
        if (this$texManager == null ? other$texManager != null : !this$texManager.equals(other$texManager)) {
            return false;
        }
        FontRenderer this$fontRenderer = this.getFontRenderer();
        FontRenderer other$fontRenderer = other.getFontRenderer();
        if (this$fontRenderer == null ? other$fontRenderer != null : !this$fontRenderer.equals(other$fontRenderer)) {
            return false;
        }
        ItemIdentifierStack this$itemIdentifierStack = this.getItemIdentifierStack();
        ItemIdentifierStack other$itemIdentifierStack = other.getItemIdentifierStack();
        if (this$itemIdentifierStack == null ? other$itemIdentifierStack != null : !((Object)this$itemIdentifierStack).equals(other$itemIdentifierStack)) {
            return false;
        }
        DisplayAmount this$displayAmount = this.getDisplayAmount();
        DisplayAmount other$displayAmount = other.getDisplayAmount();
        if (this$displayAmount == null ? other$displayAmount != null : !((Object)((Object)this$displayAmount)).equals((Object)other$displayAmount)) {
            return false;
        }
        World this$worldObj = this.getWorldObj();
        World other$worldObj = other.getWorldObj();
        if (this$worldObj == null ? other$worldObj != null : !this$worldObj.equals(other$worldObj)) {
            return false;
        }
        Map<ItemIdentifier, EntityItem> this$entityCache = this.getEntityCache();
        Map<ItemIdentifier, EntityItem> other$entityCache = other.getEntityCache();
        return !(this$entityCache == null ? other$entityCache != null : !((Object)this$entityCache).equals(other$entityCache));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ItemStackRenderer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPosX();
        result = result * 59 + this.getPosY();
        result = result * 59 + Float.floatToIntBits(this.getZLevel());
        result = result * 59 + Float.floatToIntBits(this.getScaleX());
        result = result * 59 + Float.floatToIntBits(this.getScaleY());
        result = result * 59 + Float.floatToIntBits(this.getScaleZ());
        result = result * 59 + (this.isRenderEffects() ? 79 : 97);
        result = result * 59 + (this.isIgnoreDepth() ? 79 : 97);
        result = result * 59 + (this.isRenderInColor() ? 79 : 97);
        result = result * 59 + Float.floatToIntBits(this.getPartialTickTime());
        RenderManager $renderManager = this.getRenderManager();
        result = result * 59 + ($renderManager == null ? 43 : $renderManager.hashCode());
        RenderBlocks $renderBlocks = this.getRenderBlocks();
        result = result * 59 + ($renderBlocks == null ? 43 : $renderBlocks.hashCode());
        RenderItem $renderItem = this.getRenderItem();
        result = result * 59 + ($renderItem == null ? 43 : $renderItem.hashCode());
        TextureManager $texManager = this.getTexManager();
        result = result * 59 + ($texManager == null ? 43 : $texManager.hashCode());
        FontRenderer $fontRenderer = this.getFontRenderer();
        result = result * 59 + ($fontRenderer == null ? 43 : $fontRenderer.hashCode());
        ItemIdentifierStack $itemIdentifierStack = this.getItemIdentifierStack();
        result = result * 59 + ($itemIdentifierStack == null ? 43 : ((Object)$itemIdentifierStack).hashCode());
        DisplayAmount $displayAmount = this.getDisplayAmount();
        result = result * 59 + ($displayAmount == null ? 43 : ((Object)((Object)$displayAmount)).hashCode());
        World $worldObj = this.getWorldObj();
        result = result * 59 + ($worldObj == null ? 43 : $worldObj.hashCode());
        Map<ItemIdentifier, EntityItem> $entityCache = this.getEntityCache();
        result = result * 59 + ($entityCache == null ? 43 : ((Object)$entityCache).hashCode());
        return result;
    }

    public String toString() {
        return "ItemStackRenderer(renderManager=" + this.getRenderManager() + ", renderBlocks=" + this.getRenderBlocks() + ", renderItem=" + this.getRenderItem() + ", texManager=" + this.getTexManager() + ", fontRenderer=" + this.getFontRenderer() + ", itemIdentifierStack=" + this.getItemIdentifierStack() + ", posX=" + this.getPosX() + ", posY=" + this.getPosY() + ", zLevel=" + this.getZLevel() + ", scaleX=" + this.getScaleX() + ", scaleY=" + this.getScaleY() + ", scaleZ=" + this.getScaleZ() + ", displayAmount=" + (Object)((Object)this.getDisplayAmount()) + ", renderEffects=" + this.isRenderEffects() + ", ignoreDepth=" + this.isIgnoreDepth() + ", renderInColor=" + this.isRenderInColor() + ", worldObj=" + this.getWorldObj() + ", partialTickTime=" + this.getPartialTickTime() + ", entityCache=" + this.getEntityCache() + ")";
    }

    public static enum DisplayAmount {
        HIDE_ONE,
        ALWAYS,
        NEVER;

    }
}

