/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.logisticspipes;

import java.util.ArrayList;
import java.util.List;
import logisticspipes.logisticspipes.IAdjacentWorldAccess;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.logisticspipes.ITrackStatistics;
import logisticspipes.logisticspipes.TransportLayer;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.routing.IRouter;
import logisticspipes.utils.AdjacentTile;
import net.minecraftforge.common.util.ForgeDirection;

public class PipeTransportLayer
extends TransportLayer {
    private final IAdjacentWorldAccess _worldAccess;
    private final ITrackStatistics _trackStatistics;
    private final IRouter _router;

    public PipeTransportLayer(IAdjacentWorldAccess worldAccess, ITrackStatistics trackStatistics, IRouter router) {
        this._worldAccess = worldAccess;
        this._trackStatistics = trackStatistics;
        this._router = router;
    }

    @Override
    public ForgeDirection itemArrived(IRoutedItem item, ForgeDirection denyed) {
        CoreRoutedPipe pipe;
        if (item.getItemIdentifierStack() != null) {
            this._trackStatistics.recievedItem(item.getItemIdentifierStack().getStackSize());
        }
        List<AdjacentTile> adjacentEntities = this._worldAccess.getConnectedEntities();
        ArrayList<ForgeDirection> possibleForgeDirection = new ArrayList<ForgeDirection>();
        for (AdjacentTile tile : adjacentEntities) {
            if (SimpleServiceLocator.pipeInformationManager.isItemPipe(tile.tile) || this._router.isRoutedExit(tile.orientation) || denyed != null && denyed.equals((Object)tile.orientation) || (pipe = this._router.getPipe()) != null && pipe.isLockedExit(tile.orientation)) continue;
            possibleForgeDirection.add(tile.orientation);
        }
        if (possibleForgeDirection.size() != 0) {
            return (ForgeDirection)possibleForgeDirection.get(this._worldAccess.getRandomInt(possibleForgeDirection.size()));
        }
        for (AdjacentTile tile : adjacentEntities) {
            if (this._router.isRoutedExit(tile.orientation) || (pipe = this._router.getPipe()) != null && pipe.isLockedExit(tile.orientation)) continue;
            possibleForgeDirection.add(tile.orientation);
        }
        if (possibleForgeDirection.size() == 0) {
            return null;
        }
        return (ForgeDirection)possibleForgeDirection.get(this._worldAccess.getRandomInt(possibleForgeDirection.size()));
    }

    @Override
    public boolean stillWantItem(IRoutedItem item) {
        return true;
    }
}

