/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.routingdebug;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.routing.PipeRoutingConnectionType;
import logisticspipes.routing.debug.ClientViewController;
import logisticspipes.utils.tuples.LPPosition;
import net.minecraft.entity.player.EntityPlayer;

public class RoutingUpdateDebugFilters
extends ModernPacket {
    private LPPosition pos;
    private EnumMap<PipeRoutingConnectionType, List<List<IFilter>>> filters;
    private EnumMap<PipeRoutingConnectionType, List<List<LPPosition>>> filterPositions;

    public RoutingUpdateDebugFilters(int id) {
        super(id);
    }

    @Override
    public void readData(LPDataInputStream data) throws IOException {
        short id;
        this.pos = data.readLPPosition();
        this.filterPositions = new EnumMap(PipeRoutingConnectionType.class);
        while ((id = data.readShort()) != -1) {
            int length;
            PipeRoutingConnectionType type = PipeRoutingConnectionType.values[id];
            ArrayList typeFilters = new ArrayList();
            while ((length = data.readShort()) != -1) {
                ArrayList<LPPosition> linkedFilter = new ArrayList<LPPosition>();
                for (int i = 0; i < length; ++i) {
                    linkedFilter.add(data.readLPPosition());
                }
                typeFilters.add(linkedFilter);
            }
            this.filterPositions.put(type, typeFilters);
        }
    }

    @Override
    public void processPacket(EntityPlayer player) {
        ClientViewController.instance().handlePacket(this);
    }

    @Override
    public void writeData(LPDataOutputStream data) throws IOException {
        data.writeLPPosition(this.pos);
        for (PipeRoutingConnectionType type : this.filters.keySet()) {
            data.writeShort(type.ordinal());
            for (List<IFilter> linkedFilter : this.filters.get((Object)type)) {
                data.writeShort(linkedFilter.size());
                for (IFilter filter : linkedFilter) {
                    data.writeLPPosition(filter.getLPPosition());
                }
            }
            data.writeShort(-1);
        }
        data.writeShort(-1);
    }

    @Override
    public ModernPacket template() {
        return new RoutingUpdateDebugFilters(this.getId());
    }

    @Override
    public boolean isCompressable() {
        return true;
    }

    public LPPosition getPos() {
        return this.pos;
    }

    public RoutingUpdateDebugFilters setPos(LPPosition pos) {
        this.pos = pos;
        return this;
    }

    public RoutingUpdateDebugFilters setFilters(EnumMap<PipeRoutingConnectionType, List<List<IFilter>>> filters) {
        this.filters = filters;
        return this;
    }

    public EnumMap<PipeRoutingConnectionType, List<List<LPPosition>>> getFilterPositions() {
        return this.filterPositions;
    }
}

