/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.PlayerConfigToServerPacket;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.PlayerIdentifier;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class PlayerConfig {
    private static final Lock fileAccesLock = new ReentrantLock();
    private final PlayerIdentifier playerIdent;
    private boolean useNewRenderer = true;
    private boolean useFallbackRenderer = true;
    private int renderPipeDistance = 48;
    private int renderPipeContentDistance = 24;
    private boolean isUninitialised;

    public PlayerConfig(PlayerIdentifier ident) {
        this(false, ident);
    }

    public PlayerConfig(boolean uninitialised, PlayerIdentifier ident) {
        this.isUninitialised = uninitialised;
        this.playerIdent = ident;
    }

    public void setUseNewRenderer(boolean flag) {
        this.useNewRenderer = flag;
    }

    public void setUseFallbackRenderer(boolean flag) {
        this.useFallbackRenderer = flag;
    }

    public void setRenderPipeDistance(int dist) {
        this.renderPipeDistance = dist;
    }

    public void setRenderPipeContentDistance(int dist) {
        this.renderPipeContentDistance = dist;
    }

    public void sendUpdate() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(PlayerConfigToServerPacket.class).setConfig(this));
    }

    public void writeData(LPDataOutputStream data) throws IOException {
        data.writeBoolean(this.useNewRenderer);
        data.writeBoolean(this.useFallbackRenderer);
        data.writeInt(this.renderPipeDistance);
        data.writeInt(this.renderPipeContentDistance);
    }

    public void readData(LPDataInputStream data) throws IOException {
        this.useNewRenderer = data.readBoolean();
        this.useFallbackRenderer = data.readBoolean();
        this.renderPipeDistance = data.readInt();
        this.renderPipeContentDistance = data.readInt();
        this.isUninitialised = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFromFile() {
        File file;
        File lookup;
        WorldServer world = DimensionManager.getWorld((int)0);
        if (world == null) {
            new UnsupportedOperationException("Dimension 0 doesn't have a world? Couldn't load LP's player config.").printStackTrace();
            return;
        }
        File worldDir = world.func_72860_G().func_75765_b();
        File lpData = new File(worldDir, "logisticspipes");
        File lpNameLookup = new File(lpData, "names");
        NBTTagCompound lpUserData = null;
        lpNameLookup.mkdirs();
        if (this.playerIdent.getId() == null && (lookup = new File(lpNameLookup, this.playerIdent.getUsername() + ".info")).exists()) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(lookup))));
            String uid = reader.readLine();
            reader.close();
            UUID uuid = UUID.fromString(uid);
            if (uuid != null) {
                this.playerIdent.setID(uuid);
            }
        }
        if (this.playerIdent.getUsername() != null && !this.playerIdent.getUsername().isEmpty() && (file = new File(lpData, this.playerIdent.getUsername() + ".info")).exists()) {
            fileAccesLock.lock();
            try {
                lpUserData = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file));
            }
            catch (IOException iOException) {
            }
            finally {
                fileAccesLock.unlock();
            }
            file.delete();
        }
        if (lpUserData == null && this.playerIdent.getId() != null && (file = new File(lpData, this.playerIdent.getId().toString() + ".info")).exists()) {
            fileAccesLock.lock();
            try {
                lpUserData = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file));
            }
            catch (IOException iOException) {
            }
            finally {
                fileAccesLock.unlock();
            }
        }
        if (lpUserData == null) {
            return;
        }
        this.useNewRenderer = lpUserData.func_74767_n("useNewRenderer");
        this.renderPipeDistance = lpUserData.func_74762_e("renderPipeDistance");
        this.renderPipeContentDistance = lpUserData.func_74762_e("renderPipeContentDistance");
        this.useFallbackRenderer = lpUserData.func_74767_n("useFallbackRenderer");
        this.isUninitialised = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToFile() {
        block21: {
            File file;
            WorldServer world = DimensionManager.getWorld((int)0);
            if (world == null) {
                new UnsupportedOperationException("Dimension 0 doesn't have a world? Couldn't load LP's player config.").printStackTrace();
                return;
            }
            File worldDir = world.func_72860_G().func_75765_b();
            File lpData = new File(worldDir, "logisticspipes");
            File lpNameLookup = new File(lpData, "names");
            NBTTagCompound lpUserData = new NBTTagCompound();
            lpUserData.func_74757_a("useNewRenderer", this.useNewRenderer);
            lpUserData.func_74757_a("useFallbackRenderer", this.useFallbackRenderer);
            lpUserData.func_74768_a("renderPipeDistance", this.renderPipeDistance);
            lpUserData.func_74768_a("renderPipeContentDistance", this.renderPipeContentDistance);
            if (this.playerIdent.getId() != null && this.playerIdent.getUsername() != null && !this.playerIdent.getUsername().isEmpty()) {
                File lookup = new File(lpNameLookup, this.playerIdent.getUsername() + ".info");
                if (lookup.exists()) {
                    lookup.delete();
                }
                PrintWriter writer = new PrintWriter(new GZIPOutputStream(new FileOutputStream(lookup)));
                writer.println(this.playerIdent.getId().toString());
                writer.close();
            }
            if (this.playerIdent.getId() != null) {
                file = new File(lpData, this.playerIdent.getId().toString() + ".info");
                if (file.exists()) {
                    file.delete();
                }
                fileAccesLock.lock();
                try {
                    CompressedStreamTools.func_74799_a((NBTTagCompound)lpUserData, (OutputStream)new FileOutputStream(file));
                }
                catch (IOException iOException) {
                }
                finally {
                    fileAccesLock.unlock();
                }
                lpUserData = null;
            }
            if (lpUserData == null) break block21;
            file = new File(lpData, this.playerIdent.getUsername() + ".info");
            if (file.exists()) {
                file.delete();
            }
            fileAccesLock.lock();
            try {
                CompressedStreamTools.func_74799_a((NBTTagCompound)lpUserData, (OutputStream)new FileOutputStream(file));
            }
            catch (IOException iOException) {
            }
            finally {
                fileAccesLock.unlock();
            }
            lpUserData = null;
        }
    }

    public void applyTo(PlayerConfig playerConfig) {
        playerConfig.renderPipeContentDistance = this.renderPipeContentDistance;
        playerConfig.renderPipeDistance = this.renderPipeDistance;
        playerConfig.useNewRenderer = this.useNewRenderer;
        playerConfig.useFallbackRenderer = this.useFallbackRenderer;
        playerConfig.isUninitialised = false;
    }

    public boolean isUseNewRenderer() {
        return this.useNewRenderer && SimpleServiceLocator.cclProxy.isActivated();
    }

    public boolean isUseFallbackRenderer() {
        return this.useFallbackRenderer;
    }

    public int getRenderPipeDistance() {
        return this.renderPipeDistance;
    }

    public int getRenderPipeContentDistance() {
        return this.renderPipeContentDistance;
    }

    public boolean isUninitialised() {
        return this.isUninitialised;
    }
}

