/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.commands.abstracts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import logisticspipes.commands.abstracts.ICommandHandler;
import logisticspipes.commands.chathelper.MorePageDisplay;
import logisticspipes.commands.exception.CommandNotFoundException;
import logisticspipes.commands.exception.DublicatedCommandException;
import logisticspipes.commands.exception.MissingArgumentException;
import logisticspipes.commands.exception.PermissionDeniedException;
import logisticspipes.utils.string.ChatColor;
import net.minecraft.command.ICommandSender;

public abstract class SubCommandHandler
implements ICommandHandler {
    private final List<ICommandHandler> subCommands = new ArrayList<ICommandHandler>();

    public SubCommandHandler() {
        this.registerSubCommands();
    }

    public abstract void registerSubCommands();

    protected final void registerSubCommand(ICommandHandler newHandler) {
        List<String> newCommands = Arrays.asList(newHandler.getNames());
        for (ICommandHandler handler : this.subCommands) {
            for (String command : handler.getNames()) {
                if (!newCommands.contains(command)) continue;
                throw new DublicatedCommandException();
            }
        }
        this.subCommands.add(newHandler);
    }

    public final void displayHelp(ICommandSender sender) {
        MorePageDisplay display = new MorePageDisplay(new String[]{"|< Help - " + this.getNames()[0] + " - Page: %/$ >|"}, sender);
        for (ICommandHandler command : this.subCommands) {
            if (command.getDescription()[0].startsWith("#")) continue;
            boolean first = true;
            String prefix = (Object)((Object)(command instanceof SubCommandHandler ? ChatColor.BLUE : ChatColor.YELLOW)) + command.getNames()[0] + (Object)((Object)ChatColor.RESET) + ": ";
            for (int d = 0; d < command.getDescription().length; ++d) {
                display.append(prefix + command.getDescription()[d], !first);
                prefix = "    ";
                first = false;
            }
            if (command instanceof SubCommandHandler) {
                display.append("      " + (Object)((Object)ChatColor.GRAY) + "- add " + (Object)((Object)ChatColor.YELLOW) + "help" + (Object)((Object)ChatColor.GRAY) + " to see the subcommands", true);
            }
            first = true;
            if (command.getNames().length > 1) {
                for (int i = 1; i < command.getNames().length; ++i) {
                    display.append((first ? "  alias: - " : "         - ") + (Object)((Object)ChatColor.GOLD) + command.getNames()[i] + "", true);
                    first = false;
                }
            }
            display.append("", true);
        }
        display.display(sender);
    }

    @Override
    public final void executeCommand(ICommandSender sender, String[] args) {
        if (args.length < 1) {
            throw new MissingArgumentException();
        }
        String command = args[0];
        if (command.equalsIgnoreCase("help")) {
            this.displayHelp(sender);
            return;
        }
        for (ICommandHandler handler : this.subCommands) {
            if (!Arrays.asList(handler.getNames()).contains(command)) continue;
            if (!handler.isCommandUsableBy(sender)) {
                throw new PermissionDeniedException();
            }
            String[] newArgs = Arrays.copyOfRange(args, 1, args.length);
            handler.executeCommand(sender, newArgs);
            return;
        }
        throw new CommandNotFoundException();
    }
}

