/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.abstractpackets;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import logisticspipes.network.abstractpackets.ModernPacket;

public abstract class GenericPacket
extends ModernPacket {
    private Object[] args;

    public GenericPacket(int id) {
        super(id);
    }

    @Override
    public void readData(LPDataInputStream data) throws IOException {
        int size = data.readInt();
        this.args = new Object[size];
        for (int i = 0; i < size; ++i) {
            int arraySize = data.readInt();
            byte[] bytes = new byte[arraySize];
            data.read(bytes);
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            ObjectInputStream in = new ObjectInputStream(bis);
            try {
                Object o;
                this.args[i] = o = in.readObject();
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public void writeData(LPDataOutputStream data) throws IOException {
        data.writeInt(this.args.length);
        for (Object arg : this.args) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(arg);
            byte[] bytes = bos.toByteArray();
            data.writeInt(bytes.length);
            data.write(bytes);
        }
    }

    public GenericPacket setArgs(Object ... input) {
        this.args = input;
        return this;
    }

    public Object[] getArgs() {
        return this.args;
    }
}

