/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import logisticspipes.interfaces.IPipeServiceProvider;
import logisticspipes.interfaces.IWorldProvider;
import logisticspipes.items.LogisticsItem;
import logisticspipes.logisticspipes.ItemModuleInformationManager;
import logisticspipes.modules.ModuleActiveSupplier;
import logisticspipes.modules.ModuleAdvancedExtractor;
import logisticspipes.modules.ModuleAdvancedExtractorMK2;
import logisticspipes.modules.ModuleAdvancedExtractorMK3;
import logisticspipes.modules.ModuleApiaristAnalyser;
import logisticspipes.modules.ModuleApiaristRefiller;
import logisticspipes.modules.ModuleApiaristSink;
import logisticspipes.modules.ModuleApiaristTerminus;
import logisticspipes.modules.ModuleCCBasedItemSink;
import logisticspipes.modules.ModuleCCBasedQuickSort;
import logisticspipes.modules.ModuleCrafter;
import logisticspipes.modules.ModuleCrafterMK2;
import logisticspipes.modules.ModuleCrafterMK3;
import logisticspipes.modules.ModuleCreativeTabBasedItemSink;
import logisticspipes.modules.ModuleElectricBuffer;
import logisticspipes.modules.ModuleElectricManager;
import logisticspipes.modules.ModuleEnchantmentSink;
import logisticspipes.modules.ModuleEnchantmentSinkMK2;
import logisticspipes.modules.ModuleExtractor;
import logisticspipes.modules.ModuleExtractorMk2;
import logisticspipes.modules.ModuleExtractorMk3;
import logisticspipes.modules.ModuleItemSink;
import logisticspipes.modules.ModuleModBasedItemSink;
import logisticspipes.modules.ModuleOreDictItemSink;
import logisticspipes.modules.ModulePassiveSupplier;
import logisticspipes.modules.ModulePolymorphicItemSink;
import logisticspipes.modules.ModuleProvider;
import logisticspipes.modules.ModuleProviderMk2;
import logisticspipes.modules.ModuleQuickSort;
import logisticspipes.modules.ModuleTerminus;
import logisticspipes.modules.ModuleThaumicAspectSink;
import logisticspipes.modules.ModuleTypeFilterItemSink;
import logisticspipes.modules.abstractmodules.LogisticsGuiModule;
import logisticspipes.modules.abstractmodules.LogisticsModule;
import logisticspipes.pipes.basic.CoreUnroutedPipe;
import logisticspipes.pipes.basic.LogisticsBlockGenericPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.item.ItemIdentifierInventory;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.string.StringUtils;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class ItemModule
extends LogisticsItem {
    public static final int BLANK = 0;
    public static final int ITEMSINK = 1;
    public static final int PASSIVE_SUPPLIER = 2;
    public static final int EXTRACTOR = 3;
    public static final int POLYMORPHIC_ITEMSINK = 4;
    public static final int QUICKSORT = 5;
    public static final int TERMINUS = 6;
    public static final int ADVANCED_EXTRACTOR = 7;
    public static final int BEEANALYZER = 8;
    public static final int BEESINK = 9;
    public static final int APIARISTREFILLER = 10;
    public static final int APIARISTTERMINUS = 11;
    public static final int MODBASEDITEMSINK = 12;
    public static final int OREDICTITEMSINK = 13;
    public static final int CC_BASED_QUICKSORT = 14;
    public static final int CC_BASED_ITEMSINK = 15;
    public static final int CREATIVETABBASEDITEMSINK = 16;
    public static final int GT_TYPEFILTER_ITEMSINK = 17;
    public static final int THAUMICASPECTSINK = 30;
    public static final int ENCHANTMENTSINK = 31;
    public static final int EXTRACTOR_MK2 = 103;
    public static final int ADVANCED_EXTRACTOR_MK2 = 107;
    public static final int ENCHANTMENTSINK_MK2 = 131;
    public static final int EXTRACTOR_MK3 = 203;
    public static final int ADVANCED_EXTRACTOR_MK3 = 207;
    public static final int ELECTRICMANAGER = 300;
    public static final int ELECTRICBUFFER = 301;
    public static final int PROVIDER = 500;
    public static final int PROVIDER_MK2 = 501;
    public static final int ACTIVE_SUPPLIER = 502;
    public static final int CRAFTER = 600;
    public static final int CRAFTER_MK2 = 601;
    public static final int CRAFTER_MK3 = 602;
    private final List<Module> modules = new ArrayList<Module>();

    public ItemModule() {
        this.field_77787_bX = true;
    }

    public void loadModules() {
        this.registerModule(0, null);
        this.registerModule(1, ModuleItemSink.class);
        this.registerModule(2, ModulePassiveSupplier.class);
        this.registerModule(3, ModuleExtractor.class);
        this.registerModule(4, ModulePolymorphicItemSink.class);
        this.registerModule(5, ModuleQuickSort.class);
        this.registerModule(6, ModuleTerminus.class);
        this.registerModule(7, ModuleAdvancedExtractor.class);
        this.registerModule(103, ModuleExtractorMk2.class);
        this.registerModule(107, ModuleAdvancedExtractorMK2.class);
        this.registerModule(203, ModuleExtractorMk3.class);
        this.registerModule(207, ModuleAdvancedExtractorMK3.class);
        this.registerModule(500, ModuleProvider.class);
        this.registerModule(501, ModuleProviderMk2.class);
        this.registerModule(300, ModuleElectricManager.class);
        this.registerModule(301, ModuleElectricBuffer.class);
        this.registerModule(8, ModuleApiaristAnalyser.class);
        this.registerModule(9, ModuleApiaristSink.class);
        this.registerModule(10, ModuleApiaristRefiller.class);
        this.registerModule(11, ModuleApiaristTerminus.class);
        this.registerModule(12, ModuleModBasedItemSink.class);
        this.registerModule(13, ModuleOreDictItemSink.class);
        this.registerModule(30, ModuleThaumicAspectSink.class);
        this.registerModule(31, ModuleEnchantmentSink.class);
        this.registerModule(131, ModuleEnchantmentSinkMK2.class);
        this.registerModule(14, ModuleCCBasedQuickSort.class);
        this.registerModule(15, ModuleCCBasedItemSink.class);
        this.registerModule(600, ModuleCrafter.class);
        this.registerModule(601, ModuleCrafterMK2.class);
        this.registerModule(602, ModuleCrafterMK3.class);
        this.registerModule(502, ModuleActiveSupplier.class);
        this.registerModule(16, ModuleCreativeTabBasedItemSink.class);
        this.registerModule(17, ModuleTypeFilterItemSink.class);
    }

    public void registerModule(int id, Class<? extends LogisticsModule> moduleClass) {
        boolean flag = true;
        for (Module module : this.modules) {
            if (module.getId() != id) continue;
            flag = false;
            break;
        }
        if (!flag) {
            if (!flag) {
                throw new UnsupportedOperationException("Someting went wrong while registering a new Logistics Pipe Module. (Id " + id + " already in use)");
            }
            throw new UnsupportedOperationException("Someting went wrong while registering a new Logistics Pipe Module. (No name given)");
        }
        this.modules.add(new Module(id, moduleClass));
    }

    public int[] getRegisteredModulesIDs() {
        int[] array = new int[this.modules.size()];
        int i = 0;
        for (Module module : this.modules) {
            array[i++] = module.getId();
        }
        return array;
    }

    public CreativeTabs func_77640_w() {
        return CreativeTabs.field_78028_d;
    }

    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (Module module : this.modules) {
            par3List.add(new ItemStack((Item)this, 1, module.getId()));
        }
    }

    private void openConfigGui(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, World par3World) {
        LogisticsModule module = this.getModuleForItem(par1ItemStack, null, null, null);
        if (module != null && module.hasGui() && par1ItemStack != null && par1ItemStack.field_77994_a > 0) {
            ItemModuleInformationManager.readInformation(par1ItemStack, module);
            module.registerPosition(LogisticsModule.ModulePositionType.IN_HAND, par2EntityPlayer.field_71071_by.field_70461_c);
            ((LogisticsGuiModule)module).getInHandGuiProviderForModule().open(par2EntityPlayer);
        }
    }

    public boolean func_77636_d(ItemStack par1ItemStack) {
        LogisticsModule module = this.getModuleForItem(par1ItemStack, null, null, null);
        if (module != null && par1ItemStack != null && par1ItemStack.field_77994_a > 0) {
            return module.hasEffect();
        }
        return false;
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (MainProxy.isServer(par3EntityPlayer.field_70170_p)) {
            this.openConfigGui(par1ItemStack, par3EntityPlayer, par2World);
        }
        return super.func_77659_a(par1ItemStack, par2World, par3EntityPlayer);
    }

    public boolean func_77648_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, World par3World, int par4, int par5, int par6, int par7, float par8, float par9, float par10) {
        if (MainProxy.isServer(par2EntityPlayer.field_70170_p)) {
            TileEntity tile = par3World.func_147438_o(par4, par5, par6);
            if (tile instanceof LogisticsTileGenericPipe) {
                CoreUnroutedPipe pipe;
                if (par2EntityPlayer.getDisplayName().equals("ComputerCraft") && LogisticsBlockGenericPipe.isValid(pipe = LogisticsBlockGenericPipe.getPipe((IBlockAccess)par3World, par4, par5, par6))) {
                    pipe.blockActivated(par2EntityPlayer);
                }
                return true;
            }
            this.openConfigGui(par1ItemStack, par2EntityPlayer, par3World);
        }
        return true;
    }

    public LogisticsModule getModuleForItem(ItemStack itemStack, LogisticsModule currentModule, IWorldProvider world, IPipeServiceProvider service) {
        if (itemStack == null) {
            return null;
        }
        if (itemStack.func_77973_b() != this) {
            return null;
        }
        for (Module module : this.modules) {
            if (itemStack.func_77960_j() != module.getId()) continue;
            if (module.getILogisticsModuleClass() == null) {
                return null;
            }
            if (currentModule != null && module.getILogisticsModuleClass().equals(currentModule.getClass())) {
                return currentModule;
            }
            LogisticsModule newmodule = module.getILogisticsModule();
            if (newmodule == null) {
                return null;
            }
            newmodule.registerHandler(world, service);
            return newmodule;
        }
        return null;
    }

    public String func_77667_c(ItemStack itemstack) {
        for (Module module : this.modules) {
            if (itemstack.func_77960_j() != module.getId()) continue;
            if (module.getILogisticsModuleClass() == null) {
                return "item.ModuleBlank";
            }
            return "item." + module.getILogisticsModuleClass().getSimpleName();
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IIconRegister) {
        if (this.modules.size() <= 0) {
            return;
        }
        for (Module module : this.modules) {
            module.registerModuleIcon(par1IIconRegister);
        }
    }

    public IIcon func_77617_a(int i) {
        for (Module module : this.modules) {
            if (module.getId() != i || module.getIcon() == null) continue;
            return module.getIcon();
        }
        return null;
    }

    @Override
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean flag) {
        if (itemStack.func_77942_o()) {
            NBTTagCompound nbt = itemStack.func_77978_p();
            if (nbt.func_74764_b("informationList")) {
                if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                    NBTTagList nbttaglist = nbt.func_150295_c("informationList", 8);
                    for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                        Object nbttag = nbttaglist.field_74747_a.get(i);
                        String data = ((NBTTagString)nbttag).func_150285_a_();
                        if (data.equals("<inventory>") && i + 1 < nbttaglist.func_74745_c()) {
                            nbttag = nbttaglist.field_74747_a.get(i + 1);
                            data = ((NBTTagString)nbttag).func_150285_a_();
                            if (data.startsWith("<that>")) {
                                String prefix = data.substring(6);
                                NBTTagCompound module = nbt.func_74775_l("moduleInformation");
                                int size = module.func_150295_c(prefix + "items", (int)module.func_74732_a()).func_74745_c();
                                if (module.func_74764_b(prefix + "itemsCount")) {
                                    size = module.func_74762_e(prefix + "itemsCount");
                                }
                                ItemIdentifierInventory inv = new ItemIdentifierInventory(size, "InformationTempInventory", Integer.MAX_VALUE);
                                inv.readFromNBT(module, prefix);
                                for (int pos = 0; pos < inv.func_70302_i_(); ++pos) {
                                    ItemIdentifierStack stack = inv.getIDStackInSlot(pos);
                                    if (stack == null) continue;
                                    if (stack.getStackSize() > 1) {
                                        list.add("  " + stack.getStackSize() + "x " + stack.getFriendlyName());
                                        continue;
                                    }
                                    list.add("  " + stack.getFriendlyName());
                                }
                            }
                            ++i;
                            continue;
                        }
                        list.add(data);
                    }
                } else {
                    list.add(StringUtils.translate("misc.holdshift"));
                }
            } else {
                StringUtils.addShiftAddition(itemStack, list);
            }
        } else {
            StringUtils.addShiftAddition(itemStack, list);
        }
    }

    private class Module {
        private final int id;
        private final Class<? extends LogisticsModule> moduleClass;
        private IIcon moduleIcon = null;

        private Module(int id, Class<? extends LogisticsModule> moduleClass) {
            this.id = id;
            this.moduleClass = moduleClass;
        }

        private LogisticsModule getILogisticsModule() {
            if (this.moduleClass == null) {
                return null;
            }
            try {
                return this.moduleClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
        }

        private Class<? extends LogisticsModule> getILogisticsModuleClass() {
            return this.moduleClass;
        }

        private int getId() {
            return this.id;
        }

        private IIcon getIcon() {
            return this.moduleIcon;
        }

        @SideOnly(value=Side.CLIENT)
        private void registerModuleIcon(IIconRegister par1IIconRegister) {
            if (this.moduleClass == null) {
                this.moduleIcon = par1IIconRegister.func_94245_a("logisticspipes:" + ItemModule.this.func_77658_a().replace("item.", "") + "/blank");
            } else {
                try {
                    LogisticsModule instance = this.moduleClass.newInstance();
                    this.moduleIcon = instance.getIconTexture(par1IIconRegister);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

