/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.small;

import com.creativemd.littletiles.common.utils.small.LittleTileVec;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;

public class LittleTileCoord {
    private ChunkCoordinates coord;
    public LittleTileVec position;

    public LittleTileCoord(TileEntity te, ChunkCoordinates coord, LittleTileVec position) {
        this(te.field_145851_c, te.field_145848_d, te.field_145849_e, coord, position);
    }

    public LittleTileCoord(ChunkCoordinates origin, ChunkCoordinates coord, LittleTileVec position) {
        this(origin.field_71574_a, origin.field_71572_b, origin.field_71573_c, coord, position);
    }

    public LittleTileCoord(int baseX, int baseY, int baseZ, ChunkCoordinates coord, LittleTileVec position) {
        this(coord.field_71574_a - baseX, coord.field_71572_b - baseY, coord.field_71573_c - baseZ, position);
    }

    protected LittleTileCoord(int relativeX, int relativeY, int relativeZ, LittleTileVec position) {
        this.coord = new ChunkCoordinates(relativeX, relativeY, relativeZ);
        this.position = position;
    }

    public LittleTileCoord(String id, NBTTagCompound nbt) {
        this.coord = new ChunkCoordinates(nbt.func_74762_e(id + "coordX"), nbt.func_74762_e(id + "coordY"), nbt.func_74762_e(id + "coordZ"));
        this.position = new LittleTileVec(id + "pos", nbt);
    }

    public LittleTileCoord(NBTTagCompound nbt) {
        this("", nbt);
    }

    public ChunkCoordinates getAbsolutePosition(TileEntity te) {
        return this.getAbsolutePosition(te.field_145851_c, te.field_145848_d, te.field_145849_e);
    }

    public ChunkCoordinates getAbsolutePosition(ChunkCoordinates origin) {
        return this.getAbsolutePosition(origin.field_71574_a, origin.field_71572_b, origin.field_71573_c);
    }

    public ChunkCoordinates getAbsolutePosition(int x, int y, int z) {
        return new ChunkCoordinates(this.coord.field_71574_a + x, this.coord.field_71572_b + y, this.coord.field_71573_c + z);
    }

    public void writeToNBT(String id, NBTTagCompound nbt) {
        nbt.func_74768_a(id + "coordX", this.coord.field_71574_a);
        nbt.func_74768_a(id + "coordY", this.coord.field_71572_b);
        nbt.func_74768_a(id + "coordZ", this.coord.field_71573_c);
        this.position.writeToNBT(id + "pos", nbt);
    }

    public void writeToNBT(NBTTagCompound nbt) {
        this.writeToNBT("", nbt);
    }

    public String toString() {
        return "coord:[" + this.coord.field_71574_a + "," + this.coord.field_71572_b + "," + this.coord.field_71573_c + "]|position:" + this.position;
    }

    public LittleTileCoord copy() {
        return new LittleTileCoord(this.coord.field_71574_a, this.coord.field_71572_b, this.coord.field_71573_c, this.position.copy());
    }
}

