/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils;

import com.creativemd.littletiles.common.blocks.BlockTile;
import com.creativemd.littletiles.common.blocks.ILittleTile;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.utils.LittleTilePreview;
import com.creativemd.littletiles.common.utils.small.LittleTileBox;
import com.creativemd.littletiles.common.utils.small.LittleTileSize;
import com.creativemd.littletiles.common.utils.small.LittleTileVec;
import com.creativemd.littletiles.utils.InsideShiftHandler;
import com.creativemd.littletiles.utils.PreviewTile;
import com.creativemd.littletiles.utils.ShiftHandler;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class PlacementHelper {
    private static PlacementHelper instance;
    public EntityPlayer player;
    public World world;

    public static PlacementHelper getInstance(EntityPlayer player) {
        if (instance == null) {
            instance = new PlacementHelper(player);
        } else {
            PlacementHelper.instance.player = player;
            PlacementHelper.instance.world = player.field_70170_p;
        }
        return instance;
    }

    public PlacementHelper(EntityPlayer player) {
        this.player = player;
        this.world = player.field_70170_p;
    }

    public static ILittleTile getLittleInterface(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        if (stack.func_77973_b() instanceof ILittleTile) {
            return (ILittleTile)stack.func_77973_b();
        }
        if (Block.func_149634_a((Item)stack.func_77973_b()) instanceof ILittleTile) {
            return (ILittleTile)Block.func_149634_a((Item)stack.func_77973_b());
        }
        return null;
    }

    public static boolean isLittleBlock(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.func_77973_b() instanceof ILittleTile) {
            return ((ILittleTile)stack.func_77973_b()).getLittlePreview(stack) != null;
        }
        if (Block.func_149634_a((Item)stack.func_77973_b()) instanceof ILittleTile) {
            return ((ILittleTile)Block.func_149634_a((Item)stack.func_77973_b())).getLittlePreview(stack) != null;
        }
        return false;
    }

    public ArrayList<PreviewTile> getPreviewTiles(ItemStack stack, MovingObjectPosition moving, boolean customPlacement) {
        return this.getPreviewTiles(stack, moving.field_72311_b, moving.field_72312_c, moving.field_72309_d, this.player.func_70666_h(1.0f), moving.field_72307_f, ForgeDirection.getOrientation((int)moving.field_72310_e), customPlacement);
    }

    public static LittleTileVec getInternalOffset(ArrayList<LittleTilePreview> tiles) {
        int minX = 16;
        int minY = 16;
        int minZ = 16;
        for (int i = 0; i < tiles.size(); ++i) {
            LittleTilePreview tile = tiles.get(i);
            if (tile == null) {
                return new LittleTileVec(0, 0, 0);
            }
            if (tile.box == null) continue;
            minX = (byte)Math.min(minX, tile.box.minX);
            minY = (byte)Math.min(minY, tile.box.minY);
            minZ = (byte)Math.min(minZ, tile.box.minZ);
        }
        return new LittleTileVec(minX, minY, minZ);
    }

    public static LittleTileSize getSize(ArrayList<LittleTilePreview> tiles) {
        int minX = 16;
        int minY = 16;
        int minZ = 16;
        int maxX = 0;
        int maxY = 0;
        int maxZ = 0;
        LittleTileSize size = new LittleTileSize(0, 0, 0);
        for (int i = 0; i < tiles.size(); ++i) {
            LittleTilePreview tile = tiles.get(i);
            if (tile == null) {
                return new LittleTileSize(0, 0, 0);
            }
            if (tile.box != null) {
                minX = (byte)Math.min(minX, tile.box.minX);
                minY = (byte)Math.min(minY, tile.box.minY);
                minZ = (byte)Math.min(minZ, tile.box.minZ);
                maxX = (byte)Math.max(maxX, tile.box.maxX);
                maxY = (byte)Math.max(maxY, tile.box.maxY);
                maxZ = (byte)Math.max(maxZ, tile.box.maxZ);
                continue;
            }
            size.max(tile.size);
        }
        return new LittleTileSize(maxX - minX, maxY - minY, maxZ - minZ).max(size);
    }

    public ArrayList<PreviewTile> getPreviewTiles(ItemStack stack, int x, int y, int z, Vec3 playerPos, Vec3 hitVec, ForgeDirection side, boolean customPlacement) {
        return this.getPreviewTiles(stack, x, y, z, playerPos, hitVec, side, customPlacement, false);
    }

    public ArrayList<PreviewTile> getPreviewTiles(ItemStack stack, int x, int y, int z, Vec3 playerPos, Vec3 hitVec, ForgeDirection side, boolean customPlacement, boolean inside) {
        ArrayList<ShiftHandler> shifthandlers = new ArrayList<ShiftHandler>();
        ArrayList<PreviewTile> preview = new ArrayList<PreviewTile>();
        ArrayList<LittleTilePreview> tiles = null;
        Object tempPreview = null;
        ILittleTile iTile = PlacementHelper.getLittleInterface(stack);
        if (iTile != null) {
            tiles = iTile.getLittlePreview(stack);
        }
        if (tiles != null) {
            int i;
            LittleTileSize size = PlacementHelper.getSize(tiles);
            if (tiles.size() == 1) {
                shifthandlers.addAll(tiles.get((int)0).shifthandlers);
            }
            shifthandlers.add(new InsideShiftHandler());
            LittleTileBox box = this.getTilesBox(size, hitVec, x, y, z, side, customPlacement, inside);
            LittleTileVec internalOffset = PlacementHelper.getInternalOffset(tiles);
            internalOffset.invert();
            boolean canPlaceNormal = false;
            if (!customPlacement && this.player.func_70093_af()) {
                Block block;
                if (!inside && !this.canBePlacedInside(x, y, z, hitVec, side)) {
                    switch (side) {
                        case EAST: {
                            ++x;
                            break;
                        }
                        case WEST: {
                            --x;
                            break;
                        }
                        case UP: {
                            ++y;
                            break;
                        }
                        case DOWN: {
                            --y;
                            break;
                        }
                        case SOUTH: {
                            ++z;
                            break;
                        }
                        case NORTH: {
                            --z;
                            break;
                        }
                    }
                }
                if (tiles.size() > 0 && tiles.get((int)0).box != null && ((block = this.world.func_147439_a(x, y, z)).isReplaceable((IBlockAccess)this.world, x, y, z) || block instanceof BlockTile)) {
                    TileEntity te = this.world.func_147438_o(x, y, z);
                    canPlaceNormal = true;
                    if (te instanceof TileEntityLittleTiles) {
                        TileEntityLittleTiles teTiles = (TileEntityLittleTiles)te;
                        for (i = 0; i < tiles.size(); ++i) {
                            LittleTilePreview tile = tiles.get(i);
                            if (teTiles.isSpaceForLittleTile(tile.box)) continue;
                            canPlaceNormal = false;
                            break;
                        }
                    }
                }
                if (!canPlaceNormal) {
                    for (int i2 = 0; i2 < shifthandlers.size(); ++i2) {
                        ((ShiftHandler)shifthandlers.get(i2)).init(this.world, x, y, z);
                    }
                    LittleTileVec hit = this.getHitVec(hitVec, x, y, z, side, customPlacement, inside);
                    ShiftHandler handler = null;
                    double distance = 2.0;
                    for (int i3 = 0; i3 < shifthandlers.size(); ++i3) {
                        double tempDistance = ((ShiftHandler)shifthandlers.get(i3)).getDistance(hit);
                        if (!(tempDistance < distance)) continue;
                        distance = tempDistance;
                        handler = (ShiftHandler)shifthandlers.get(i3);
                    }
                    if (handler != null) {
                        box = handler.getNewPosition(this.world, x, y, z, box);
                    }
                }
            }
            LittleTileVec offset = box.getMinVec();
            offset.addVec(internalOffset);
            for (int i4 = 0; i4 < tiles.size(); ++i4) {
                LittleTilePreview tile = tiles.get(i4);
                if (tile == null) continue;
                if (tile.box == null) {
                    preview.add(new PreviewTile(box.copy(), tile));
                    continue;
                }
                if (!canPlaceNormal) {
                    tile.box.addOffset(offset);
                }
                preview.add(new PreviewTile(tile.box, tile));
            }
            LittleStructure structure = iTile.getLittleStructure(stack);
            if (structure != null) {
                ArrayList<PreviewTile> newBoxes = structure.getSpecialTiles();
                for (i = 0; i < newBoxes.size(); ++i) {
                    if (canPlaceNormal) continue;
                    newBoxes.get((int)i).box.addOffset(offset);
                }
                preview.addAll(newBoxes);
            }
        }
        return preview;
    }

    public LittleTileBox getTilesBox(LittleTileSize size, Vec3 hitVec, int x, int y, int z, ForgeDirection side, boolean customPlacement, boolean inside) {
        LittleTileVec hit = this.getHitVec(hitVec, x, y, z, side, customPlacement, inside);
        LittleTileVec center = size.calculateCenter();
        LittleTileVec centerInv = size.calculateInvertedCenter();
        switch (side) {
            case EAST: {
                hit.x += center.x;
                break;
            }
            case WEST: {
                hit.x -= centerInv.x;
                break;
            }
            case UP: {
                hit.y += center.y;
                break;
            }
            case DOWN: {
                hit.y -= centerInv.y;
                break;
            }
            case SOUTH: {
                hit.z += center.z;
                break;
            }
            case NORTH: {
                hit.z -= centerInv.z;
                break;
            }
        }
        return new LittleTileBox(hit, size);
    }

    public boolean canBePlacedInsideBlock(int x, int y, int z) {
        TileEntity tileEntity = this.player.field_70170_p.func_147438_o(x, y, z);
        return tileEntity instanceof TileEntityLittleTiles;
    }

    public boolean canBePlacedInside(int x, int y, int z, Vec3 hitVec, ForgeDirection side) {
        TileEntity tileEntity = this.player.field_70170_p.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntityLittleTiles) {
            switch (side) {
                case EAST: 
                case WEST: {
                    return (double)((int)hitVec.field_72450_a) != hitVec.field_72450_a;
                }
                case UP: 
                case DOWN: {
                    return (double)((int)hitVec.field_72448_b) != hitVec.field_72448_b;
                }
                case SOUTH: 
                case NORTH: {
                    return (double)((int)hitVec.field_72449_c) != hitVec.field_72449_c;
                }
            }
            return false;
        }
        return false;
    }

    public LittleTileVec getHitVec(Vec3 hitVec, int x, int y, int z, ForgeDirection side, boolean customPlacement, boolean isInside) {
        if (customPlacement && !isInside) {
            double posX = hitVec.field_72450_a - (double)x;
            double posY = hitVec.field_72448_b - (double)y;
            double posZ = hitVec.field_72449_c - (double)z;
            LittleTileVec vec = new LittleTileVec((int)(posX * 16.0), (int)(posY * 16.0), (int)(posZ * 16.0));
            if (!this.canBePlacedInside(x, y, z, hitVec, side)) {
                switch (side) {
                    case EAST: {
                        vec.x -= 16;
                        break;
                    }
                    case WEST: {
                        vec.x += 16;
                        break;
                    }
                    case UP: {
                        vec.y -= 16;
                        break;
                    }
                    case DOWN: {
                        vec.y += 16;
                        break;
                    }
                    case SOUTH: {
                        vec.z -= 16;
                        break;
                    }
                    case NORTH: {
                        vec.z += 16;
                        break;
                    }
                }
            }
            return vec;
        }
        double posX = hitVec.field_72450_a - (double)x;
        double posY = hitVec.field_72448_b - (double)y;
        double posZ = hitVec.field_72449_c - (double)z;
        LittleTileVec vec = new LittleTileVec((int)(posX * 16.0), (int)(posY * 16.0), (int)(posZ * 16.0));
        if (!customPlacement && !this.canBePlacedInside(x, y, z, hitVec, side)) {
            switch (side) {
                case EAST: {
                    vec.x = 0;
                    break;
                }
                case WEST: {
                    vec.x = 16;
                    break;
                }
                case UP: {
                    vec.y = 0;
                    break;
                }
                case DOWN: {
                    vec.y = 16;
                    break;
                }
                case SOUTH: {
                    vec.z = 0;
                    break;
                }
                case NORTH: {
                    vec.z = 16;
                    break;
                }
            }
        }
        return vec;
    }
}

