/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure;

import com.creativemd.creativecore.common.entity.EntitySit;
import com.creativemd.creativecore.common.gui.SubGui;
import com.creativemd.creativecore.common.utils.HashMapList;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.utils.LittleTile;
import com.creativemd.littletiles.common.utils.small.LittleTileBox;
import com.creativemd.littletiles.common.utils.small.LittleTileVec;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class LittleChair
extends LittleStructure {
    @Override
    protected void loadFromNBTExtra(NBTTagCompound nbt) {
    }

    @Override
    protected void writeToNBTExtra(NBTTagCompound nbt) {
    }

    public LittleTileVec getHighestCenterPoint() {
        int minYPos = Integer.MAX_VALUE;
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxYPos = Integer.MIN_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        HashMapList<ChunkCoordinates, LittleTile> coords = this.getTilesSortedPerBlock();
        if (coords.sizeOfValues() == 0) {
            return null;
        }
        for (int i = 0; i < coords.size(); ++i) {
            ChunkCoordinates coord = (ChunkCoordinates)coords.getKey(i);
            for (int j = 0; j < coords.getValues(i).size(); ++j) {
                for (int h = 0; h < ((LittleTile)coords.getValues((int)i).get((int)j)).boundingBoxes.size(); ++h) {
                    LittleTileBox box = ((LittleTile)coords.getValues((int)i).get((int)j)).boundingBoxes.get(h);
                    minX = Math.min(minX, coord.field_71574_a * 16 + box.minX);
                    minY = Math.min(minY, coord.field_71572_b * 16 + box.minY);
                    minZ = Math.min(minZ, coord.field_71573_c * 16 + box.minZ);
                    maxX = Math.max(maxX, coord.field_71574_a * 16 + box.maxX);
                    maxY = Math.max(maxY, coord.field_71572_b * 16 + box.maxY);
                    maxZ = Math.max(maxZ, coord.field_71573_c * 16 + box.maxZ);
                }
                minYPos = Math.min(minYPos, coord.field_71572_b);
                maxYPos = Math.max(maxYPos, coord.field_71572_b);
            }
        }
        int centerX = (int)Math.floor((double)(minX + maxX) / 16.0 / 2.0);
        int centerY = (int)Math.floor((double)(minY + maxY) / 16.0 / 2.0);
        int centerZ = (int)Math.floor((double)(minZ + maxZ) / 16.0 / 2.0);
        int centerTileX = (int)(Math.floor(minX + maxX) / 2.0) - centerX * 16;
        int centerTileY = (int)(Math.floor(minY + maxY) / 2.0) - centerY * 16;
        int centerTileZ = (int)(Math.floor(minZ + maxZ) / 2.0) - centerZ * 16;
        LittleTileVec position = new LittleTileVec((minX + maxX) / 2, minYPos * 16, (minZ + maxZ) / 2);
        for (int y = minYPos; y <= maxYPos; ++y) {
            ArrayList tilesInCenter = coords.getValues((Object)new ChunkCoordinates(centerX, y, centerZ));
            if (tilesInCenter == null) continue;
            LittleTileBox box = new LittleTileBox(centerTileX, 0, centerTileZ, centerTileX + 1, 16, centerTileZ + 1);
            for (int i = 0; i < tilesInCenter.size(); ++i) {
                for (int j = 0; j < ((LittleTile)tilesInCenter.get((int)i)).boundingBoxes.size(); ++j) {
                    LittleTileBox littleBox = ((LittleTile)tilesInCenter.get((int)i)).boundingBoxes.get(j);
                    if (!box.intersectsWith(littleBox)) continue;
                    position.y = Math.max(y * 16 + littleBox.maxY, position.y);
                }
            }
        }
        return position;
    }

    @Override
    public boolean onBlockActivated(World world, LittleTile tile, int x, int y, int z, EntityPlayer player, int side, float moveX, float moveY, float moveZ) {
        LittleTileVec vec;
        if (!world.field_72995_K && (vec = this.getHighestCenterPoint()) != null) {
            EntitySit sit = new EntitySit(world, vec.getPosX(), vec.getPosY(), vec.getPosZ());
            player.func_70078_a((Entity)sit);
            world.func_72838_d((Entity)sit);
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void createControls(SubGui gui, LittleStructure structure) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public LittleStructure parseStructure(SubGui gui) {
        return new LittleChair();
    }
}

