/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.packet;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.utils.ColorUtils;
import com.creativemd.creativecore.common.utils.WorldUtils;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.blocks.BlockTile;
import com.creativemd.littletiles.common.items.ItemColorTube;
import com.creativemd.littletiles.common.items.ItemTileContainer;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.utils.LittleTile;
import com.creativemd.littletiles.common.utils.LittleTileBlock;
import com.creativemd.littletiles.common.utils.LittleTileBlockColored;
import com.creativemd.littletiles.common.utils.small.LittleTileBox;
import com.creativemd.littletiles.utils.TileList;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class LittleBlockPacket
extends CreativeCorePacket {
    public int x;
    public int y;
    public int z;
    public Vec3 pos;
    public Vec3 look;
    public int action;
    public NBTTagCompound nbt;

    public LittleBlockPacket() {
    }

    public LittleBlockPacket(int x, int y, int z, EntityPlayer player, int action) {
        this(x, y, z, player, action, new NBTTagCompound());
    }

    public LittleBlockPacket(int x, int y, int z, EntityPlayer player, int action, NBTTagCompound nbt) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.action = action;
        this.pos = player.func_70666_h(1.0f);
        double d0 = player.field_71075_bZ.field_75098_d ? 5.0 : 4.5;
        Vec3 look = player.func_70676_i(1.0f);
        this.look = this.pos.func_72441_c(look.field_72450_a * d0, look.field_72448_b * d0, look.field_72449_c * d0);
        this.nbt = nbt;
    }

    public void writeBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        LittleBlockPacket.writeVec3((Vec3)this.pos, (ByteBuf)buf);
        LittleBlockPacket.writeVec3((Vec3)this.look, (ByteBuf)buf);
        buf.writeInt(this.action);
        LittleBlockPacket.writeNBT((ByteBuf)buf, (NBTTagCompound)this.nbt);
    }

    public void readBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.pos = LittleBlockPacket.readVec3((ByteBuf)buf);
        this.look = LittleBlockPacket.readVec3((ByteBuf)buf);
        this.action = buf.readInt();
        this.nbt = LittleBlockPacket.readNBT((ByteBuf)buf);
    }

    @SideOnly(value=Side.CLIENT)
    public void executeClient(EntityPlayer player) {
    }

    public void executeServer(EntityPlayer player) {
        TileEntity tileEntity = player.field_70170_p.func_147438_o(this.x, this.y, this.z);
        if (tileEntity instanceof TileEntityLittleTiles) {
            TileEntityLittleTiles littleEntity = (TileEntityLittleTiles)tileEntity;
            MovingObjectPosition moving = littleEntity.getMoving(this.pos, this.look, true);
            LittleTile tile = littleEntity.loadedTile;
            if (tile != null) {
                switch (this.action) {
                    case 0: {
                        if (!tile.onBlockActivated(player.field_70170_p, this.x, this.y, this.z, player, moving.field_72310_e, (float)moving.field_72307_f.field_72450_a, (float)moving.field_72307_f.field_72448_b, (float)moving.field_72307_f.field_72449_c)) break;
                        BlockTile.cancelNext = true;
                        break;
                    }
                    case 1: {
                        tile.destroy();
                        if (!player.field_71075_bZ.field_75098_d) {
                            WorldUtils.dropItem((World)player.field_70170_p, tile.getDrops(), (int)this.x, (int)this.y, (int)this.z);
                        }
                        TileList<LittleTile> tiles = littleEntity.getTiles();
                        for (int i = 0; i < tiles.size(); ++i) {
                            tiles.get(i).onNeighborChangeInside();
                        }
                        littleEntity.update();
                        break;
                    }
                    case 2: {
                        try {
                            int side = this.nbt.func_74762_e("side");
                            ForgeDirection direction = ForgeDirection.getOrientation((int)side);
                            TileEntityLittleTiles te = (TileEntityLittleTiles)tileEntity;
                            if (!te.updateLoadedTileServer(this.pos, this.look) || !te.loadedTile.canSawResizeTile(direction, player)) break;
                            LittleTileBox box = null;
                            box = player.func_70093_af() ? te.loadedTile.boundingBoxes.get(0).shrink(direction) : te.loadedTile.boundingBoxes.get(0).expand(direction);
                            if (!box.isBoxInsideBlock() || !box.isValidBox() || !te.isSpaceForLittleTile(box.getBox(), te.loadedTile)) break;
                            float ammount = te.loadedTile.boundingBoxes.get(0).getSize().getPercentVolume() - box.getSize().getPercentVolume();
                            boolean success = false;
                            if (player.func_70093_af()) {
                                if (ItemTileContainer.addBlock(player, ((LittleTileBlock)te.loadedTile).block, ((LittleTileBlock)te.loadedTile).meta, ammount)) {
                                    success = true;
                                }
                            } else if (ItemTileContainer.drainBlock(player, ((LittleTileBlock)te.loadedTile).block, ((LittleTileBlock)te.loadedTile).meta, -ammount)) {
                                success = true;
                            }
                            if (!player.field_71075_bZ.field_75098_d && !success) break;
                            te.loadedTile.boundingBoxes.set(0, box);
                            te.loadedTile.updateCorner();
                            te.update();
                        }
                        catch (Exception e) {
                            System.out.println("Failed to use saw!");
                            e.printStackTrace();
                        }
                        break;
                    }
                    case 3: {
                        try {
                            TileEntityLittleTiles te = (TileEntityLittleTiles)tileEntity;
                            if (!te.updateLoadedTileServer(this.pos, this.look) || te.loadedTile.getClass() != LittleTileBlock.class && !(te.loadedTile instanceof LittleTileBlockColored)) break;
                            int color = this.nbt.func_74762_e("color");
                            LittleTile currentTile = te.loadedTile;
                            int index = te.getTiles().indexOf(currentTile);
                            if (player.func_70093_af()) {
                                color = ColorUtils.WHITE;
                                if (currentTile instanceof LittleTileBlockColored) {
                                    color = ((LittleTileBlockColored)currentTile).color;
                                }
                                ItemColorTube.setColor(player.func_71045_bC(), color);
                                break;
                            }
                            LittleTileBlock newTile = LittleTileBlockColored.setColor((LittleTileBlock)currentTile, color);
                            if (newTile != null) {
                                te.getTiles().set(index, newTile);
                            }
                            te.update();
                        }
                        catch (Exception e) {
                            System.out.println("Failed to use color tube!");
                            e.printStackTrace();
                        }
                        break;
                    }
                    case 4: {
                        TileEntityLittleTiles te = (TileEntityLittleTiles)tileEntity;
                        ArrayList<LittleTile> newTiles = new ArrayList<LittleTile>();
                        if (!te.updateLoadedTileServer(this.pos, this.look) || te.loadedTile.getClass() != LittleTileBlock.class && !(te.loadedTile instanceof LittleTileBlockColored) || te.loadedTile.structure != null) break;
                        LittleTile oldTile = te.loadedTile;
                        for (int j = 0; j < oldTile.boundingBoxes.size(); ++j) {
                            LittleTileBox box = oldTile.boundingBoxes.get(j);
                            for (int littleX = box.minX; littleX < box.maxX; ++littleX) {
                                for (int littleY = box.minY; littleY < box.maxY; ++littleY) {
                                    for (int littleZ = box.minZ; littleZ < box.maxZ; ++littleZ) {
                                        tile = oldTile.copy();
                                        tile.boundingBoxes.clear();
                                        tile.boundingBoxes.add(new LittleTileBox(littleX, littleY, littleZ, littleX + 1, littleY + 1, littleZ + 1));
                                        tile.updateCorner();
                                        tile.te = te;
                                        newTiles.add(tile);
                                    }
                                }
                            }
                        }
                        if (LittleTiles.maxNewTiles >= newTiles.size() - 1) {
                            te.removeTile(oldTile);
                            te.addTiles(newTiles);
                            te.update();
                            break;
                        }
                        player.func_146105_b((IChatComponent)new ChatComponentText("Too much new tiles! Limit=" + LittleTiles.maxNewTiles));
                    }
                }
            }
        }
    }
}

