/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.items;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.utils.CubeObject;
import com.creativemd.creativecore.common.utils.HashMapList;
import com.creativemd.creativecore.common.utils.WorldUtils;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.render.ITilesRenderer;
import com.creativemd.littletiles.client.render.PreviewRenderer;
import com.creativemd.littletiles.common.blocks.BlockTile;
import com.creativemd.littletiles.common.blocks.ILittleTile;
import com.creativemd.littletiles.common.items.ItemTileContainer;
import com.creativemd.littletiles.common.packet.LittlePlacePacket;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.utils.LittleTile;
import com.creativemd.littletiles.common.utils.LittleTileBlock;
import com.creativemd.littletiles.common.utils.LittleTilePreview;
import com.creativemd.littletiles.common.utils.PlacementHelper;
import com.creativemd.littletiles.common.utils.small.LittleTileBox;
import com.creativemd.littletiles.common.utils.small.LittleTileCoord;
import com.creativemd.littletiles.common.utils.small.LittleTileSize;
import com.creativemd.littletiles.common.utils.small.LittleTileVec;
import com.creativemd.littletiles.utils.PreviewTile;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemBlockTiles
extends ItemBlock
implements ILittleTile,
ITilesRenderer {
    public ItemBlockTiles(Block block) {
        super(block);
        this.field_77787_bX = true;
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(ItemStack stack) {
        String result = super.func_77653_i(stack);
        if (stack.field_77990_d != null) {
            result = result + " (x=" + stack.field_77990_d.func_74771_c("sizex") + ",y=" + stack.field_77990_d.func_74771_c("sizey") + "z=" + stack.field_77990_d.func_74771_c("sizez") + ")";
        }
        return result;
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77667_c(ItemStack stack) {
        if (stack.field_77990_d != null) {
            Block block = Block.func_149684_b((String)stack.field_77990_d.func_74779_i("block"));
            return block.func_149739_a();
        }
        return super.func_77667_c(stack);
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float offsetX, float offsetY, float offsetZ) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            return false;
        }
        PlacementHelper helper = PlacementHelper.getInstance(player);
        MovingObjectPosition moving = Minecraft.func_71410_x().field_71476_x;
        if (PreviewRenderer.markedHit != null) {
            moving = PreviewRenderer.markedHit;
        }
        x = moving.field_72311_b;
        y = moving.field_72312_c;
        z = moving.field_72309_d;
        side = moving.field_72310_e;
        if (PreviewRenderer.markedHit == null && !helper.canBePlacedInside(x, y, z, moving.field_72307_f, ForgeDirection.getOrientation((int)side))) {
            if (side == 0) {
                --y;
            }
            if (side == 1) {
                ++y;
            }
            if (side == 2) {
                --z;
            }
            if (side == 3) {
                ++z;
            }
            if (side == 4) {
                --x;
            }
            if (side == 5) {
                ++x;
            }
        }
        if (stack.field_77994_a == 0) {
            return false;
        }
        if (!player.func_82247_a(x, y, z, side, stack)) {
            return false;
        }
        if (y == 255) {
            return false;
        }
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            PacketHandler.sendPacketToServer((CreativeCorePacket)new LittlePlacePacket(stack, player.func_70666_h(1.0f), moving.field_72307_f, x, y, z, side, PreviewRenderer.markedHit != null));
        }
        if (this.placeBlockAt(player, stack, world, player.func_70666_h(1.0f), moving.field_72307_f, helper, x, y, z, side, PreviewRenderer.markedHit != null)) {
            PreviewRenderer.markedHit = null;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconregister) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item stack, CreativeTabs tab, List list) {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_150936_a(World world, int x, int y, int z, int side, EntityPlayer player, ItemStack stack) {
        Block block = world.func_147439_a(x, y, z);
        Minecraft mc = Minecraft.func_71410_x();
        MovingObjectPosition moving = Minecraft.func_71410_x().field_71476_x;
        if (PreviewRenderer.markedHit != null) {
            moving = PreviewRenderer.markedHit;
        }
        x = moving.field_72311_b;
        y = moving.field_72312_c;
        z = moving.field_72309_d;
        if (block == Blocks.field_150431_aC) {
            side = 1;
        } else if (block != Blocks.field_150395_bd && block != Blocks.field_150329_H && block != Blocks.field_150330_I && !block.isReplaceable((IBlockAccess)world, x, y, z) && !PlacementHelper.getInstance(player).canBePlacedInside(x, y, z, moving.field_72307_f, ForgeDirection.getOrientation((int)side))) {
            if (side == 0) {
                --y;
            }
            if (side == 1) {
                ++y;
            }
            if (side == 2) {
                --z;
            }
            if (side == 3) {
                ++z;
            }
            if (side == 4) {
                --x;
            }
            if (side == 5) {
                ++x;
            }
        }
        block = world.func_147439_a(x, y, z);
        return block.isReplaceable((IBlockAccess)world, x, y, z) || PlacementHelper.getInstance(player).canBePlacedInsideBlock(x, y, z);
    }

    public static HashMapList<ChunkCoordinates, PreviewTile> getSplittedTiles(ArrayList<PreviewTile> tiles, int x, int y, int z) {
        HashMapList splitted = new HashMapList();
        for (int i = 0; i < tiles.size(); ++i) {
            if (tiles.get(i).split((HashMapList<ChunkCoordinates, PreviewTile>)splitted, x, y, z)) continue;
            return null;
        }
        return splitted;
    }

    public static boolean canPlaceTiles(World world, HashMapList<ChunkCoordinates, PreviewTile> splitted, ArrayList<ChunkCoordinates> coordsToCheck) {
        for (int i = 0; i < coordsToCheck.size(); ++i) {
            ChunkCoordinates coord = coordsToCheck.get(i);
            TileEntity mainTile = world.func_147438_o(coord.field_71574_a, coord.field_71572_b, coord.field_71573_c);
            if (mainTile instanceof TileEntityLittleTiles) {
                ArrayList tiles = splitted.getValues((Object)coord);
                if (tiles == null) continue;
                for (int j = 0; j < tiles.size(); ++j) {
                    if (!((PreviewTile)tiles.get(j)).needsCollisionTest() || ((TileEntityLittleTiles)mainTile).isSpaceForLittleTile(((PreviewTile)tiles.get((int)j)).box)) continue;
                    return false;
                }
                continue;
            }
            if (world.func_147439_a(coord.field_71574_a, coord.field_71572_b, coord.field_71573_c) instanceof BlockTile || world.func_147439_a(coord.field_71574_a, coord.field_71572_b, coord.field_71573_c).func_149688_o().func_76222_j()) continue;
            return false;
        }
        return true;
    }

    public static boolean placeTiles(World world, EntityPlayer player, ArrayList<PreviewTile> previews, LittleStructure structure, int x, int y, int z, ItemStack stack, ArrayList<LittleTile> unplaceableTiles) {
        HashMapList<ChunkCoordinates, PreviewTile> splitted = ItemBlockTiles.getSplittedTiles(previews, x, y, z);
        if (splitted == null) {
            return false;
        }
        ArrayList<ChunkCoordinates> coordsToCheck = null;
        if (structure != null) {
            coordsToCheck = splitted.getKeys();
        } else {
            coordsToCheck = new ArrayList<ChunkCoordinates>();
            coordsToCheck.add(new ChunkCoordinates(x, y, z));
        }
        ArrayList<Block.SoundType> soundsToBePlayed = new ArrayList<Block.SoundType>();
        if (ItemBlockTiles.canPlaceTiles(world, splitted, coordsToCheck)) {
            int i;
            LittleTile.LittleTilePosition pos = null;
            for (i = 0; i < splitted.size(); ++i) {
                TileEntity te;
                ChunkCoordinates coord = (ChunkCoordinates)splitted.getKey(i);
                ArrayList placeTiles = splitted.getValues(i);
                boolean hascollideBlock = false;
                for (int j = 0; j < placeTiles.size(); ++j) {
                    if (!((PreviewTile)placeTiles.get(j)).needsCollisionTest()) continue;
                    hascollideBlock = true;
                    break;
                }
                if (!hascollideBlock) continue;
                if (!(world.func_147439_a(coord.field_71574_a, coord.field_71572_b, coord.field_71573_c) instanceof BlockTile) && world.func_147439_a(coord.field_71574_a, coord.field_71572_b, coord.field_71573_c).func_149688_o().func_76222_j()) {
                    world.func_147465_d(coord.field_71574_a, coord.field_71572_b, coord.field_71573_c, (Block)LittleTiles.blockTile, 0, 3);
                }
                if (!((te = world.func_147438_o(coord.field_71574_a, coord.field_71572_b, coord.field_71573_c)) instanceof TileEntityLittleTiles)) continue;
                TileEntityLittleTiles teLT = (TileEntityLittleTiles)te;
                for (int j = 0; j < placeTiles.size(); ++j) {
                    LittleTile LT = ((PreviewTile)placeTiles.get(j)).placeTile(player, stack, teLT, structure, unplaceableTiles);
                    if (LT == null) continue;
                    if (!soundsToBePlayed.contains(LT.getSound())) {
                        soundsToBePlayed.add(LT.getSound());
                    }
                    if (structure == null) continue;
                    if (pos == null) {
                        structure.mainTile = LT;
                        LT.isMainBlock = true;
                        LT.updateCorner();
                        pos = new LittleTile.LittleTilePosition(coord, LT.cornerVec.copy());
                        continue;
                    }
                    LT.coord = new LittleTileCoord(teLT, pos.coord, pos.position);
                }
                if (structure == null) continue;
                teLT.combineTiles(structure);
            }
            for (i = 0; i < soundsToBePlayed.size(); ++i) {
                world.func_72908_a((double)((float)player.field_70165_t), (double)((float)player.field_70163_u), (double)((float)player.field_70161_v), ((Block.SoundType)soundsToBePlayed.get(i)).func_150496_b(), (((Block.SoundType)soundsToBePlayed.get(i)).func_150497_c() + 1.0f) / 2.0f, ((Block.SoundType)soundsToBePlayed.get(i)).func_150494_d() * 0.8f);
            }
            return true;
        }
        return false;
    }

    public boolean placeBlockAt(EntityPlayer player, ItemStack stack, World world, Vec3 playerPos, Vec3 hitVec, PlacementHelper helper, int x, int y, int z, int side, boolean customPlacement) {
        ArrayList<LittleTile> unplaceableTiles;
        ArrayList<PreviewTile> previews = helper.getPreviewTiles(stack, x, y, z, playerPos, hitVec, ForgeDirection.getOrientation((int)side), customPlacement, true);
        LittleStructure structure = null;
        if (stack.func_77973_b() instanceof ILittleTile) {
            structure = ((ILittleTile)stack.func_77973_b()).getLittleStructure(stack);
        } else if (Block.func_149634_a((Item)stack.func_77973_b()) instanceof ILittleTile) {
            structure = ((ILittleTile)Block.func_149634_a((Item)stack.func_77973_b())).getLittleStructure(stack);
        }
        if (structure != null) {
            structure.dropStack = stack.func_77946_l();
            structure.setTiles(new ArrayList<LittleTile>());
        }
        if (ItemBlockTiles.placeTiles(world, player, previews, structure, x, y, z, stack, unplaceableTiles = new ArrayList<LittleTile>())) {
            if (!player.field_71075_bZ.field_75098_d) {
                --player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c].field_77994_a;
                if (player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c].field_77994_a == 0) {
                    player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
                }
            }
            if (!world.field_72995_K) {
                for (int j = 0; j < unplaceableTiles.size(); ++j) {
                    if (unplaceableTiles.get(j) instanceof LittleTileBlock || ItemTileContainer.addBlock(player, ((LittleTileBlock)unplaceableTiles.get((int)j)).block, ((LittleTileBlock)unplaceableTiles.get((int)j)).meta, (float)((LittleTileBlock)unplaceableTiles.get(j)).getPercentVolume())) continue;
                    WorldUtils.dropItem((World)world, unplaceableTiles.get(j).getDrops(), (int)x, (int)y, (int)z);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public ArrayList<LittleTilePreview> getLittlePreview(ItemStack stack) {
        ArrayList<LittleTilePreview> previews = new ArrayList<LittleTilePreview>();
        previews.add(LittleTilePreview.getPreviewFromNBT(stack.field_77990_d));
        return previews;
    }

    @Override
    public void rotateLittlePreview(ItemStack stack, ForgeDirection direction) {
        LittleTilePreview.rotatePreview(stack.field_77990_d, direction);
    }

    @Override
    public ArrayList<CubeObject> getRenderingCubes(ItemStack stack) {
        ArrayList<CubeObject> cubes = new ArrayList<CubeObject>();
        Block block = Block.func_149684_b((String)stack.field_77990_d.func_74779_i("block"));
        int meta = stack.field_77990_d.func_74762_e("meta");
        LittleTileSize size = new LittleTileSize("size", stack.field_77990_d);
        if (!(block instanceof BlockAir)) {
            CubeObject cube = new LittleTileBox(new LittleTileVec(8, 8, 8), size).getCube();
            cube.block = block;
            cube.meta = meta;
            if (stack.field_77990_d.func_74764_b("color")) {
                cube.color = stack.field_77990_d.func_74762_e("color");
            }
            cubes.add(cube);
        }
        return cubes;
    }

    @Override
    public boolean hasBackground(ItemStack stack) {
        return false;
    }

    @Override
    public LittleStructure getLittleStructure(ItemStack stack) {
        return null;
    }

    @Override
    public void flipLittlePreview(ItemStack stack, ForgeDirection direction) {
    }
}

