/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.multiblock;

import com.creativemd.creativecore.common.multiblock.ConnectionStructure;
import com.creativemd.creativecore.common.multiblock.IMultiBlock;
import java.util.ArrayList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class MultiBlockStructure {
    public static ArrayList<MultiBlockStructure> allstructures = new ArrayList();
    public ConnectionStructure structure;
    public ArrayList<TileEntity> connections = new ArrayList();
    public TileEntity masterBlock = null;
    private boolean valid;

    public MultiBlockStructure(ConnectionStructure structure) {
        allstructures.add(this);
        this.structure = structure;
        this.structure.multiblock = this;
    }

    public boolean canConnectToBlock(World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof IMultiBlock && (((IMultiBlock)tileEntity).getStructure() == null || ((IMultiBlock)tileEntity).getStructure() == this)) {
            return this.canBlockBelongtoStructure(world, x, y, z);
        }
        return false;
    }

    protected abstract boolean canBlockBelongtoStructure(World var1, int var2, int var3, int var4);

    public void writeToNBT(NBTTagCompound nbt) {
    }

    public void readFromNBT(NBTTagCompound nbt) {
    }

    public abstract void updateTick();

    public void caculateUpdate(TileEntity tileEntity) {
        int i;
        ArrayList<TileEntity> newconnections = this.structure.caculateAllConnectedBlocks(tileEntity);
        if (newconnections.size() > this.structure.getMaxConnections()) {
            this.valid = false;
        } else {
            for (i = 0; i < this.connections.size(); ++i) {
                if (((IMultiBlock)this.connections.get(i)).getStructure() != this || newconnections.contains(this.connections)) continue;
                ((IMultiBlock)this.connections.get(i)).setStructure(null);
            }
            this.connections = newconnections;
            if (!this.structure.isStructureValid(this.connections)) {
                this.valid = false;
            }
        }
        if (this.valid) {
            this.masterBlock = this.structure.caculateMasterBlock(this.connections);
            for (i = 0; i < this.connections.size(); ++i) {
                ((IMultiBlock)this.connections.get(i)).setMaster(this.masterBlock == this.connections.get(i));
            }
        }
    }

    public boolean isValid() {
        return this.valid;
    }
}

