/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils;

import com.creativemd.littletiles.common.utils.small.LittleTileVec;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.common.util.ForgeDirection;

public class LittleTileBlockPos {
    private int posX;
    private int posY;
    private int posZ;
    private int subX;
    private int subY;
    private int subZ;
    private final ForgeDirection side;

    public LittleTileBlockPos(int posX, int posY, int posZ, int subX, int subY, int subZ, ForgeDirection side) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.side = side;
        this.moveSubX(subX);
        this.moveSubY(subY);
        this.moveSubZ(subZ);
    }

    public static LittleTileBlockPos fromMovingObjectPosition(MovingObjectPosition pos) {
        ForgeDirection side = ForgeDirection.getOrientation((int)pos.field_72310_e);
        double x = pos.field_72307_f.field_72450_a;
        double y = pos.field_72307_f.field_72448_b;
        double z = pos.field_72307_f.field_72449_c;
        if (side == ForgeDirection.WEST) {
            x -= 0.0625;
        }
        if (side == ForgeDirection.DOWN) {
            y -= 0.0625;
        }
        if (side == ForgeDirection.NORTH) {
            z -= 0.0625;
        }
        int subX = (int)Math.floor((x - Math.floor(x)) * 16.0);
        int subY = (int)Math.floor((y - Math.floor(y)) * 16.0);
        int subZ = (int)Math.floor((z - Math.floor(z)) * 16.0);
        return new LittleTileBlockPos((int)Math.floor(x), (int)Math.floor(y), (int)Math.floor(z), subX, subY, subZ, side);
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public int getPosZ() {
        return this.posZ;
    }

    public int getSubX() {
        return this.subX;
    }

    public int getSubY() {
        return this.subY;
    }

    public int getSubZ() {
        return this.subZ;
    }

    public ForgeDirection getSide() {
        return this.side;
    }

    public void moveSubX(int count) {
        this.subX += count;
        while (this.subX > 15) {
            this.subX -= 16;
            ++this.posX;
        }
        while (this.subX < 0) {
            this.subX += 16;
            --this.posX;
        }
    }

    public void moveSubY(int count) {
        this.subY += count;
        while (this.subY > 15) {
            this.subY -= 16;
            ++this.posY;
        }
        while (this.subY < 0) {
            this.subY += 16;
            --this.posY;
        }
    }

    public void moveSubZ(int count) {
        this.subZ += count;
        while (this.subZ > 15) {
            this.subZ -= 16;
            ++this.posZ;
        }
        while (this.subZ < 0) {
            this.subZ += 16;
            --this.posZ;
        }
    }

    public void moveInDirection(ForgeDirection direction, int count) {
        this.moveSubX(direction.offsetX * count);
        this.moveSubY(direction.offsetY * count);
        this.moveSubZ(direction.offsetZ * count);
    }

    public LittleTileVec toHitVecRelative() {
        return new LittleTileVec(this.subX, this.subY, this.subZ);
    }
}

