/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.items;

import com.creativemd.creativecore.common.container.SubContainer;
import com.creativemd.creativecore.common.gui.IGuiCreator;
import com.creativemd.creativecore.common.gui.SubGui;
import com.creativemd.creativecore.common.utils.CubeObject;
import com.creativemd.creativecore.core.CreativeCore;
import com.creativemd.littletiles.client.render.ITilesRenderer;
import com.creativemd.littletiles.common.gui.SubContainerStructure;
import com.creativemd.littletiles.common.gui.SubGuiStructure;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.utils.LittleTile;
import com.creativemd.littletiles.common.utils.LittleTilePreview;
import com.creativemd.littletiles.common.utils.small.LittleTileSize;
import com.creativemd.littletiles.common.utils.small.LittleTileVec;
import com.creativemd.littletiles.utils.TileList;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemRecipe
extends Item
implements ITilesRenderer,
IGuiCreator {
    public ItemRecipe() {
        this.func_77637_a(CreativeTabs.field_78040_i);
        this.field_77787_bX = true;
    }

    @SideOnly(value=Side.CLIENT)
    protected String func_111208_A() {
        return "littletiles:LTRecipe";
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!(world.field_72995_K || player.func_70093_af() || stack.field_77990_d == null || stack.field_77990_d.func_74764_b("x"))) {
            player.openGui((Object)CreativeCore.instance, 1, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }
        return stack;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            if (!world.field_72995_K) {
                stack.field_77990_d = null;
            }
            return true;
        }
        if (stack.field_77990_d != null && stack.field_77990_d.func_74764_b("x")) {
            if (!world.field_72995_K) {
                int firstX = stack.field_77990_d.func_74762_e("x");
                int firstY = stack.field_77990_d.func_74762_e("y");
                int firstZ = stack.field_77990_d.func_74762_e("z");
                int minX = Math.min(firstX, x);
                int maxX = Math.max(firstX, x);
                int minY = Math.min(firstY, y);
                int maxY = Math.max(firstY, y);
                int minZ = Math.min(firstZ, z);
                int maxZ = Math.max(firstZ, z);
                ArrayList<LittleTile> tiles = new ArrayList<LittleTile>();
                stack.field_77990_d.func_82580_o("x");
                stack.field_77990_d.func_82580_o("y");
                stack.field_77990_d.func_82580_o("z");
                for (int posX = minX; posX <= maxX; ++posX) {
                    for (int posY = minY; posY <= maxY; ++posY) {
                        for (int posZ = minZ; posZ <= maxZ; ++posZ) {
                            TileEntity tileEntity = world.func_147438_o(posX, posY, posZ);
                            if (!(tileEntity instanceof TileEntityLittleTiles)) continue;
                            LittleTileVec offset = new LittleTileVec((posX - minX) * 16, (posY - minY) * 16, (posZ - minZ) * 16);
                            TileEntityLittleTiles littleEntity = (TileEntityLittleTiles)tileEntity;
                            TileList<LittleTile> teTiles = littleEntity.getTiles();
                            for (LittleTile teTile : teTiles) {
                                LittleTile tile = teTile.copy();
                                for (int j = 0; j < tile.boundingBoxes.size(); ++j) {
                                    tile.boundingBoxes.get(j).addOffset(offset);
                                }
                                tiles.add(tile);
                            }
                        }
                    }
                }
                player.func_145747_a((IChatComponent)new ChatComponentText("Second position: x=" + x + ",y=" + y + ",z=" + z));
                ItemRecipe.saveTiles(world, tiles, stack);
            }
            return true;
        }
        if (stack.field_77990_d == null) {
            if (!world.field_72995_K) {
                stack.field_77990_d = new NBTTagCompound();
                stack.field_77990_d.func_74768_a("x", x);
                stack.field_77990_d.func_74768_a("y", y);
                stack.field_77990_d.func_74768_a("z", z);
                player.func_145747_a((IChatComponent)new ChatComponentText("First position: x=" + x + ",y=" + y + ",z=" + z));
            }
            return true;
        }
        return false;
    }

    public static void flipPreview(ItemStack stack, ForgeDirection direction) {
        int tiles = stack.field_77990_d.func_74762_e("tiles");
        for (int i = 0; i < tiles; ++i) {
            NBTTagCompound nbt = stack.field_77990_d.func_74775_l("tile" + i);
            LittleTilePreview.flipPreview(nbt, direction);
            stack.field_77990_d.func_74782_a("tile" + i, (NBTBase)nbt);
        }
    }

    public static void rotatePreview(ItemStack stack, ForgeDirection direction) {
        int tiles = stack.field_77990_d.func_74762_e("tiles");
        for (int i = 0; i < tiles; ++i) {
            NBTTagCompound nbt = stack.field_77990_d.func_74775_l("tile" + i);
            LittleTilePreview.rotatePreview(nbt, direction);
            stack.field_77990_d.func_74782_a("tile" + i, (NBTBase)nbt);
        }
    }

    public static ArrayList<LittleTilePreview> getPreview(ItemStack stack) {
        ArrayList<LittleTilePreview> result = new ArrayList<LittleTilePreview>();
        int tiles = stack.field_77990_d.func_74762_e("tiles");
        for (int i = 0; i < tiles; ++i) {
            NBTTagCompound nbt = stack.field_77990_d.func_74775_l("tile" + i);
            LittleTilePreview preview = LittleTilePreview.getPreviewFromNBT(nbt);
            if (preview == null) continue;
            result.add(preview);
        }
        return result;
    }

    public static LittleTileSize getSize(ItemStack stack) {
        ArrayList<LittleTilePreview> tiles = ItemRecipe.getPreview(stack);
        int minX = 16;
        int minY = 16;
        int minZ = 16;
        int maxX = 0;
        int maxY = 0;
        int maxZ = 0;
        for (LittleTilePreview tile : tiles) {
            minX = (byte)Math.min(minX, tile.box.minX);
            minY = (byte)Math.min(minY, tile.box.minY);
            minZ = (byte)Math.min(minZ, tile.box.minZ);
            maxX = (byte)Math.max(maxX, tile.box.maxX);
            maxY = (byte)Math.max(maxY, tile.box.maxY);
            maxZ = (byte)Math.max(maxZ, tile.box.maxZ);
        }
        return new LittleTileSize(maxX - minX, maxY - minY, maxZ - minZ);
    }

    public static ArrayList<LittleTile> loadTiles(TileEntityLittleTiles te, ItemStack stack) {
        ArrayList<LittleTile> result = new ArrayList<LittleTile>();
        int tiles = stack.field_77990_d.func_74762_e("tiles");
        for (int i = 0; i < tiles; ++i) {
            NBTTagCompound nbt = stack.field_77990_d.func_74775_l("tile" + i);
            LittleTile tile = LittleTile.CreateandLoadTile(te, te.func_145831_w(), nbt);
            result.add(tile);
        }
        return result;
    }

    public static void saveTiles(World world, ArrayList<LittleTile> tiles, ItemStack stack) {
        stack.field_77990_d = new NBTTagCompound();
        stack.field_77990_d.func_74768_a("tiles", tiles.size());
        for (int i = 0; i < tiles.size(); ++i) {
            NBTTagCompound nbt = new NBTTagCompound();
            tiles.get((int)i).boundingBoxes.get(0).writeToNBT("bBox", nbt);
            tiles.get(i).saveTile(nbt);
            stack.field_77990_d.func_74782_a("tile" + i, (NBTBase)nbt);
        }
    }

    public static ArrayList<CubeObject> getCubes(ItemStack stack) {
        ArrayList<LittleTilePreview> preview = ItemRecipe.getPreview(stack);
        ArrayList<CubeObject> cubes = new ArrayList<CubeObject>();
        for (LittleTilePreview littleTilePreview : preview) {
            cubes.add(littleTilePreview.getCubeBlock());
        }
        return cubes;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
        if (stack.field_77990_d != null) {
            if (stack.field_77990_d.func_74764_b("x")) {
                list.add("First pos: x=" + stack.field_77990_d.func_74762_e("x") + ",y=" + stack.field_77990_d.func_74762_e("y") + ",z=" + stack.field_77990_d.func_74762_e("z"));
            } else {
                String id = "none";
                if (stack.field_77990_d.func_74764_b("structure")) {
                    id = stack.field_77990_d.func_74775_l("structure").func_74779_i("id");
                }
                list.add("structure: " + id);
                list.add("contains " + stack.field_77990_d.func_74762_e("tiles") + " tiles");
            }
        }
    }

    @Override
    public boolean hasBackground(ItemStack stack) {
        return true;
    }

    @Override
    public ArrayList<CubeObject> getRenderingCubes(ItemStack stack) {
        if (stack.field_77990_d != null && !stack.field_77990_d.func_74764_b("x")) {
            return ItemRecipe.getCubes(stack);
        }
        return new ArrayList<CubeObject>();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public SubGui getGui(EntityPlayer player, ItemStack stack, World world, int x, int y, int z) {
        return new SubGuiStructure(stack);
    }

    @Override
    public SubContainer getContainer(EntityPlayer player, ItemStack stack, World world, int x, int y, int z) {
        return new SubContainerStructure(player, stack);
    }
}

