/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.render;

import com.creativemd.creativecore.client.rendering.RenderHelper3D;
import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.utils.CubeObject;
import com.creativemd.littletiles.client.LittleTilesClient;
import com.creativemd.littletiles.common.packet.LittleFlipPacket;
import com.creativemd.littletiles.common.packet.LittleRotatePacket;
import com.creativemd.littletiles.common.utils.PlacementHelper;
import com.creativemd.littletiles.common.utils.small.LittleTileBox;
import com.creativemd.littletiles.common.utils.small.LittleTileVec;
import com.creativemd.littletiles.utils.PreviewTile;
import com.creativemd.littletiles.utils.ShiftHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class PreviewRenderer {
    public static Minecraft mc = Minecraft.func_71410_x();
    public static MovingObjectPosition markedHit = null;

    public void processKey(ForgeDirection direction) {
        LittleRotatePacket packet = new LittleRotatePacket(direction);
        packet.executeClient((EntityPlayer)PreviewRenderer.mc.field_71439_g);
        PacketHandler.sendPacketToServer((CreativeCorePacket)packet);
    }

    public static void moveMarkedHit(ForgeDirection direction) {
        int posX = (int)PreviewRenderer.markedHit.field_72307_f.field_72450_a;
        int posY = (int)PreviewRenderer.markedHit.field_72307_f.field_72448_b;
        int posZ = (int)PreviewRenderer.markedHit.field_72307_f.field_72449_c;
        double move = 0.0625;
        if (GuiScreen.func_146271_m()) {
            move = 1.0;
        }
        switch (direction) {
            case EAST: {
                PreviewRenderer.markedHit.field_72307_f.field_72450_a += move;
                break;
            }
            case WEST: {
                PreviewRenderer.markedHit.field_72307_f.field_72450_a -= move;
                break;
            }
            case UP: {
                PreviewRenderer.markedHit.field_72307_f.field_72448_b += move;
                break;
            }
            case DOWN: {
                PreviewRenderer.markedHit.field_72307_f.field_72448_b -= move;
                break;
            }
            case SOUTH: {
                PreviewRenderer.markedHit.field_72307_f.field_72449_c += move;
                break;
            }
            case NORTH: {
                PreviewRenderer.markedHit.field_72307_f.field_72449_c -= move;
                break;
            }
        }
        if (posX != (int)PreviewRenderer.markedHit.field_72307_f.field_72450_a) {
            PreviewRenderer.markedHit.field_72311_b += (int)PreviewRenderer.markedHit.field_72307_f.field_72450_a - posX;
        }
        if (posY != (int)PreviewRenderer.markedHit.field_72307_f.field_72448_b) {
            PreviewRenderer.markedHit.field_72312_c += (int)PreviewRenderer.markedHit.field_72307_f.field_72448_b - posY;
        }
        if (posZ != (int)PreviewRenderer.markedHit.field_72307_f.field_72449_c) {
            PreviewRenderer.markedHit.field_72309_d += (int)PreviewRenderer.markedHit.field_72307_f.field_72449_c - posZ;
        }
    }

    @SubscribeEvent
    public void tick(RenderHandEvent event) {
        if (PreviewRenderer.mc.field_71439_g != null && PreviewRenderer.mc.field_71415_G) {
            if (PlacementHelper.isLittleBlock(PreviewRenderer.mc.field_71439_g.func_70694_bm())) {
                if (GameSettings.func_100015_a((KeyBinding)LittleTilesClient.flip) && !LittleTilesClient.pressedFlip) {
                    LittleTilesClient.pressedFlip = true;
                    int i4 = MathHelper.func_76128_c((double)((double)(PreviewRenderer.mc.field_71439_g.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
                    ForgeDirection direction = null;
                    switch (i4) {
                        case 0: {
                            direction = ForgeDirection.SOUTH;
                            break;
                        }
                        case 1: {
                            direction = ForgeDirection.WEST;
                            break;
                        }
                        case 2: {
                            direction = ForgeDirection.NORTH;
                            break;
                        }
                        case 3: {
                            direction = ForgeDirection.EAST;
                        }
                    }
                    if (PreviewRenderer.mc.field_71439_g.field_70125_A > 45.0f) {
                        direction = ForgeDirection.DOWN;
                    }
                    if (PreviewRenderer.mc.field_71439_g.field_70125_A < -45.0f) {
                        direction = ForgeDirection.UP;
                    }
                    LittleFlipPacket packet = new LittleFlipPacket(direction);
                    packet.executeClient((EntityPlayer)PreviewRenderer.mc.field_71439_g);
                    PacketHandler.sendPacketToServer((CreativeCorePacket)packet);
                } else if (!GameSettings.func_100015_a((KeyBinding)LittleTilesClient.flip)) {
                    LittleTilesClient.pressedFlip = false;
                }
                MovingObjectPosition look = PreviewRenderer.mc.field_71476_x;
                if (markedHit != null) {
                    look = markedHit;
                }
                if (look != null && look.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && PreviewRenderer.mc.field_71439_g.func_70694_bm() != null) {
                    PlacementHelper helper = PlacementHelper.getInstance((EntityPlayer)PreviewRenderer.mc.field_71439_g);
                    int posX = look.field_72311_b;
                    int posY = look.field_72312_c;
                    int posZ = look.field_72309_d;
                    double x = (double)posX - TileEntityRendererDispatcher.field_147554_b;
                    double y = (double)posY - TileEntityRendererDispatcher.field_147555_c;
                    double z = (double)posZ - TileEntityRendererDispatcher.field_147552_d;
                    ForgeDirection side = ForgeDirection.getOrientation((int)look.field_72310_e);
                    if (!helper.canBePlacedInside(posX, posY, posZ, look.field_72307_f, side)) {
                        switch (side) {
                            case EAST: {
                                x += 1.0;
                                break;
                            }
                            case WEST: {
                                x -= 1.0;
                                break;
                            }
                            case UP: {
                                y += 1.0;
                                break;
                            }
                            case DOWN: {
                                y -= 1.0;
                                break;
                            }
                            case SOUTH: {
                                z += 1.0;
                                break;
                            }
                            case NORTH: {
                                z -= 1.0;
                                break;
                            }
                        }
                    }
                    if (GameSettings.func_100015_a((KeyBinding)LittleTilesClient.mark) && !LittleTilesClient.pressedMark) {
                        LittleTilesClient.pressedMark = true;
                        if (markedHit == null) {
                            LittleTileVec vec = helper.getHitVec(look.field_72307_f, look.field_72311_b, look.field_72312_c, look.field_72309_d, side, false, false);
                            Vec3 hitVec = Vec3.func_72443_a((double)vec.getPosX(), (double)vec.getPosY(), (double)vec.getPosZ());
                            int newX = look.field_72311_b;
                            int newY = look.field_72312_c;
                            int newZ = look.field_72309_d;
                            if (!helper.canBePlacedInside(newX, newY, newZ, look.field_72307_f, side)) {
                                switch (side) {
                                    case EAST: {
                                        ++newX;
                                        break;
                                    }
                                    case WEST: {
                                        --newX;
                                        break;
                                    }
                                    case UP: {
                                        ++newY;
                                        break;
                                    }
                                    case DOWN: {
                                        --newY;
                                        break;
                                    }
                                    case SOUTH: {
                                        ++newZ;
                                        break;
                                    }
                                    case NORTH: {
                                        --newZ;
                                        break;
                                    }
                                }
                            }
                            hitVec = hitVec.func_72441_c((double)newX, (double)newY, (double)newZ);
                            markedHit = new MovingObjectPosition(newX, newY, newZ, look.field_72310_e, hitVec);
                            return;
                        }
                        markedHit = null;
                    } else if (!GameSettings.func_100015_a((KeyBinding)LittleTilesClient.mark)) {
                        LittleTilesClient.pressedMark = false;
                    }
                    if (GameSettings.func_100015_a((KeyBinding)LittleTilesClient.up) && !LittleTilesClient.pressedUp) {
                        LittleTilesClient.pressedUp = true;
                        if (markedHit != null) {
                            PreviewRenderer.moveMarkedHit(PreviewRenderer.mc.field_71439_g.func_70093_af() ? ForgeDirection.UP : ForgeDirection.EAST);
                        } else {
                            this.processKey(ForgeDirection.UP);
                        }
                    } else if (!GameSettings.func_100015_a((KeyBinding)LittleTilesClient.up)) {
                        LittleTilesClient.pressedUp = false;
                    }
                    if (GameSettings.func_100015_a((KeyBinding)LittleTilesClient.down) && !LittleTilesClient.pressedDown) {
                        LittleTilesClient.pressedDown = true;
                        if (markedHit != null) {
                            PreviewRenderer.moveMarkedHit(PreviewRenderer.mc.field_71439_g.func_70093_af() ? ForgeDirection.DOWN : ForgeDirection.WEST);
                        } else {
                            this.processKey(ForgeDirection.DOWN);
                        }
                    } else if (!GameSettings.func_100015_a((KeyBinding)LittleTilesClient.down)) {
                        LittleTilesClient.pressedDown = false;
                    }
                    if (GameSettings.func_100015_a((KeyBinding)LittleTilesClient.right) && !LittleTilesClient.pressedRight) {
                        LittleTilesClient.pressedRight = true;
                        if (markedHit != null) {
                            PreviewRenderer.moveMarkedHit(ForgeDirection.SOUTH);
                        } else {
                            this.processKey(ForgeDirection.SOUTH);
                        }
                    } else if (!GameSettings.func_100015_a((KeyBinding)LittleTilesClient.right)) {
                        LittleTilesClient.pressedRight = false;
                    }
                    if (GameSettings.func_100015_a((KeyBinding)LittleTilesClient.left) && !LittleTilesClient.pressedLeft) {
                        LittleTilesClient.pressedLeft = true;
                        if (markedHit != null) {
                            PreviewRenderer.moveMarkedHit(ForgeDirection.NORTH);
                        } else {
                            this.processKey(ForgeDirection.NORTH);
                        }
                    } else if (!GameSettings.func_100015_a((KeyBinding)LittleTilesClient.left)) {
                        LittleTilesClient.pressedLeft = false;
                    }
                    GL11.glEnable((int)3042);
                    OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                    GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                    GL11.glLineWidth((float)2.0f);
                    GL11.glDisable((int)3553);
                    GL11.glDepthMask((boolean)false);
                    ArrayList<PreviewTile> previews = helper.getPreviewTiles(PreviewRenderer.mc.field_71439_g.func_70694_bm(), look, markedHit != null);
                    for (PreviewTile previewTile : previews) {
                        GL11.glPushMatrix();
                        LittleTileBox previewBox = previewTile.getPreviewBox();
                        CubeObject cube = previewBox.getCube();
                        Vec3 size = previewBox.getSizeD();
                        double cubeX = x + cube.minX + size.field_72450_a / 2.0;
                        double cubeY = y + cube.minY + size.field_72448_b / 2.0;
                        double cubeZ = z + cube.minZ + size.field_72449_c / 2.0;
                        Vec3 color = previewTile.getPreviewColor();
                        RenderHelper3D.renderBlock((double)cubeX, (double)cubeY, (double)cubeZ, (double)size.field_72450_a, (double)size.field_72448_b, (double)size.field_72449_c, (double)0.0, (double)0.0, (double)0.0, (double)color.field_72450_a, (double)color.field_72448_b, (double)color.field_72449_c, (double)(Math.sin((double)System.nanoTime() / 2.0E8) * 0.2 + 0.5));
                        GL11.glPopMatrix();
                    }
                    if (markedHit == null && PreviewRenderer.mc.field_71439_g.func_70093_af()) {
                        ArrayList<ShiftHandler> shifthandlers = new ArrayList<ShiftHandler>();
                        for (PreviewTile preview : previews) {
                            if (preview.preview == null) continue;
                            shifthandlers.addAll(preview.preview.shifthandlers);
                        }
                        for (ShiftHandler shifthandler : shifthandlers) {
                            shifthandler.handleRendering(mc, x, y, z);
                        }
                    }
                    GL11.glDepthMask((boolean)true);
                    GL11.glEnable((int)3553);
                    GL11.glDisable((int)3042);
                }
            } else {
                markedHit = null;
            }
        }
    }
}

