/*
 * Decompiled with CFR 0.152.
 */
package kubatech.config;

import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class Config {
    public static File configFile;
    public static File configDirectory;

    public static void init(File configFile) {
        configDirectory = new File(configFile, "kubatech");
        Config.configFile = new File(configDirectory, "kubatech.cfg");
    }

    public static File getConfigFile(String file) {
        return new File(configDirectory, file);
    }

    public static void synchronizeConfiguration() {
        Configuration configuration = new Configuration(configFile);
        configuration.load();
        MobHandler.load(configuration);
        Debug.load(configuration);
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    public static class Debug {
        public static boolean showRenderErrors = false;

        private static void load(Configuration configuration) {
            Category category = Category.DEBUG;
            showRenderErrors = configuration.get(category.get(), "ShowRenderErrors", false).getBoolean();
        }
    }

    public static class MobHandler {
        public static boolean mobHandlerEnabled = true;
        public static _CacheRegenerationTrigger regenerationTrigger = _CacheRegenerationTrigger.ModAdditionRemovalChange;
        public static boolean includeEmptyMobs = true;
        public static String[] mobBlacklist;

        private static void load(Configuration configuration) {
            Category category = Category.MOB_HANDLER;
            mobHandlerEnabled = configuration.get(category.get(), "Enabled", true, "Enable \"Mob Drops\" NEI page and Extreme Extermination Chamber").getBoolean();
            StringBuilder c = new StringBuilder("When will cache regeneration trigger? ");
            for (_CacheRegenerationTrigger value : _CacheRegenerationTrigger.values()) {
                c.append(value.ordinal()).append(" - ").append(value.name()).append(", ");
            }
            regenerationTrigger = _CacheRegenerationTrigger.get(configuration.get(category.get(), "CacheRegenerationTrigger", _CacheRegenerationTrigger.ModAdditionRemovalChange.ordinal(), c.toString()).getInt());
            includeEmptyMobs = configuration.get(category.get(), "IncludeEmptyMobs", true, "Include mobs that have no drops in NEI").getBoolean();
            mobBlacklist = configuration.get(category.get(), "MobBlacklist", new String[]{"Giant", "Thaumcraft.TravelingTrunk", "chisel.snowman", "OpenBlocks.Luggage", "OpenBlocks.MiniMe", "SpecialMobs.SpecialCreeper", "SpecialMobs.SpecialZombie", "SpecialMobs.SpecialPigZombie", "SpecialMobs.SpecialSlime", "SpecialMobs.SpecialSkeleton", "SpecialMobs.SpecialEnderman", "SpecialMobs.SpecialCaveSpider", "SpecialMobs.SpecialGhast", "SpecialMobs.SpecialWitch", "SpecialMobs.SpecialSpider", "TwilightForest.HydraHead", "TwilightForest.RovingCube", "TwilightForest.Harbinger Cube", "TwilightForest.Adherent", "SpecialMobs.SpecialSilverfish"}, "These mobs will be skipped when generating recipe map").getStringList();
        }

        public static enum _CacheRegenerationTrigger {
            Never,
            ModAdditionRemoval,
            ModAdditionRemovalChange,
            Always;


            public static _CacheRegenerationTrigger get(int oridinal) {
                return _CacheRegenerationTrigger.values()[oridinal];
            }
        }
    }

    private static enum Category {
        MOB_HANDLER("MobHandler"),
        DEBUG("Debug");

        final String categoryName;

        private Category(String s) {
            this.categoryName = s;
        }

        public String get() {
            return this.categoryName;
        }

        public String toString() {
            return this.get();
        }
    }
}

