/*
 * Decompiled with CFR 0.152.
 */
package kubatech.api.helpers;

import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import kubatech.api.Variables;
import kubatech.api.implementations.KubaTechGTMultiBlockBase;

public class GTHelper {
    public static long getMaxInputEU(GT_MetaTileEntity_MultiBlockBase mte) {
        if (mte instanceof KubaTechGTMultiBlockBase) {
            return ((KubaTechGTMultiBlockBase)mte).getMaxInputEu();
        }
        long rEU = 0L;
        for (GT_MetaTileEntity_Hatch_Energy tHatch : mte.mEnergyHatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            rEU += tHatch.maxEUInput() * tHatch.maxAmperesIn();
        }
        return rEU;
    }

    public static double getVoltageTierD(long voltage) {
        return Math.log((double)voltage / 8.0) / Variables.ln4;
    }

    public static double getVoltageTierD(GT_MetaTileEntity_MultiBlockBase mte) {
        return Math.log((double)GTHelper.getMaxInputEU(mte) / 8.0) / Variables.ln4;
    }

    public static int getVoltageTier(long voltage) {
        return (int)GTHelper.getVoltageTierD(voltage);
    }

    public static int getVoltageTier(GT_MetaTileEntity_MultiBlockBase mte) {
        return (int)GTHelper.getVoltageTierD(mte);
    }
}

