/*
 * Decompiled with CFR 0.152.
 */
package kubatech.api;

import cpw.mods.fml.common.registry.GameRegistry;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;

public class ConstructableItemStack {
    public final GameRegistry.UniqueIdentifier itemIdentifier;
    public final int meta;
    public final int size;
    public final NBTTagCompound tagCompound;
    private static final ByteBuf BufHelper = Unpooled.buffer();

    private ConstructableItemStack(GameRegistry.UniqueIdentifier itemIdentifier, int meta, int size, NBTTagCompound tagCompound) {
        this.itemIdentifier = itemIdentifier;
        this.meta = meta;
        this.size = size;
        this.tagCompound = tagCompound;
    }

    public ConstructableItemStack(ItemStack stack) {
        this.itemIdentifier = GameRegistry.findUniqueIdentifierFor((Item)stack.func_77973_b());
        this.meta = stack.func_77960_j();
        this.size = stack.field_77994_a;
        this.tagCompound = stack.field_77990_d;
    }

    public ItemStack construct() {
        if (this.itemIdentifier == null) {
            return null;
        }
        Item it = GameRegistry.findItem((String)this.itemIdentifier.modId, (String)this.itemIdentifier.name);
        if (it == null) {
            return null;
        }
        ItemStack stack = new ItemStack(it, this.size, this.meta);
        stack.field_77990_d = this.tagCompound;
        return stack;
    }

    public boolean isSame(ConstructableItemStack stack, boolean ignoreSize) {
        if (!stack.itemIdentifier.modId.equals(this.itemIdentifier.modId)) {
            return false;
        }
        if (!stack.itemIdentifier.name.equals(this.itemIdentifier.name)) {
            return false;
        }
        return ignoreSize || stack.size == this.size;
    }

    public void writeToByteBuf(ByteBuf byteBuf) {
        BufHelper.clear();
        byte[] bytes = this.itemIdentifier.modId.getBytes(StandardCharsets.UTF_8);
        BufHelper.writeInt(bytes.length);
        BufHelper.writeBytes(bytes);
        bytes = this.itemIdentifier.name.getBytes(StandardCharsets.UTF_8);
        BufHelper.writeInt(bytes.length);
        BufHelper.writeBytes(bytes);
        BufHelper.writeInt(this.meta);
        BufHelper.writeInt(this.size);
        BufHelper.writeBoolean(this.tagCompound != null);
        if (this.tagCompound != null) {
            try {
                bytes = CompressedStreamTools.func_74798_a((NBTTagCompound)this.tagCompound);
            }
            catch (Exception ignored) {
                bytes = new byte[]{};
            }
            BufHelper.writeInt(bytes.length);
            BufHelper.writeBytes(bytes);
        }
        byteBuf.writeInt(BufHelper.readableBytes());
        byteBuf.writeBytes(BufHelper);
    }

    public static ConstructableItemStack readFromByteBuf(ByteBuf byteBuf) {
        int size = byteBuf.readInt();
        byte[] bytes = new byte[byteBuf.readInt()];
        byteBuf.readBytes(bytes);
        String modid = new String(bytes, StandardCharsets.UTF_8);
        bytes = new byte[byteBuf.readInt()];
        byteBuf.readBytes(bytes);
        String name = new String(bytes, StandardCharsets.UTF_8);
        int meta = byteBuf.readInt();
        int stacksize = byteBuf.readInt();
        NBTTagCompound nbtTagCompound = null;
        if (byteBuf.readBoolean()) {
            bytes = new byte[byteBuf.readInt()];
            byteBuf.readBytes(bytes);
            try {
                nbtTagCompound = CompressedStreamTools.func_152457_a((byte[])bytes, (NBTSizeTracker)new NBTSizeTracker(0x200000L));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new ConstructableItemStack(new GameRegistry.UniqueIdentifier(modid + ":" + name), meta, stacksize, nbtTagCompound);
    }
}

