/*
 * Decompiled with CFR 0.152.
 */
package kubatech.loaders;

import atomicstryker.infernalmobs.common.InfernalMobsCore;
import atomicstryker.infernalmobs.common.MobModifier;
import atomicstryker.infernalmobs.common.mods.api.ModifierLoader;
import com.google.common.io.Files;
import com.google.gson.Gson;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.util.GT_Utility;
import gregtech.common.GT_DummyWorld;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import kubatech.api.LoaderReference;
import kubatech.api.helpers.EnderIOHelper;
import kubatech.api.helpers.InfernalHelper;
import kubatech.api.mobhandler.MobDrop;
import kubatech.api.network.LoadConfigPacket;
import kubatech.api.utils.GSONUtils;
import kubatech.api.utils.ModUtils;
import kubatech.config.Config;
import kubatech.config.OverridesConfig;
import kubatech.nei.Mob_Handler;
import kubatech.tileentity.gregtech.multiblock.GT_MetaTileEntity_ExtremeExterminationChamber;
import minetweaker.MineTweakerAPI;
import minetweaker.api.entity.IEntityDefinition;
import minetweaker.api.item.IItemStack;
import minetweaker.mc1710.item.MCItemStack;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.IMob;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import stanhebben.zenscript.value.IntRange;
import thaumcraft.common.items.wands.ItemWandCasting;

public class MobRecipeLoader {
    private static final Logger LOG = LogManager.getLogger((String)"kubatech[Mob Recipe Loader]");
    public static final MobRecipeLoader instance = new MobRecipeLoader();
    private static final String dropFewItemsName = ModUtils.isDeobfuscatedEnvironment ? "dropFewItems" : "func_70628_a";
    private static final String dropRareDropName = ModUtils.isDeobfuscatedEnvironment ? "dropRareDrop" : "func_70600_l";
    private static final String setSlimeSizeName = ModUtils.isDeobfuscatedEnvironment ? "setSlimeSize" : "func_70799_a";
    private static final String addRandomArmorName = ModUtils.isDeobfuscatedEnvironment ? "addRandomArmor" : "func_82164_bB";
    private static final String enchantEquipmentName = ModUtils.isDeobfuscatedEnvironment ? "enchantEquipment" : "func_82162_bC";
    private static final String randName = ModUtils.isDeobfuscatedEnvironment ? "rand" : "field_70146_Z";
    private static boolean alreadyGenerated = false;
    public static boolean isInGenerationProcess = false;
    public static final String randomEnchantmentDetectedString = "RandomEnchantmentDetected";
    public static final HashMap<String, GeneralMappedMob> GeneralMobList = new HashMap();

    @SubscribeEvent
    public void onOpenGui(GuiOpenEvent event) {
        MobRecipeLoader.generateMobRecipeMap();
        MinecraftForge.EVENT_BUS.unregister((Object)instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateMobRecipeMap() {
        boolean registeringWitherSkeleton;
        Field rand;
        Method enchantEquipment;
        Method addRandomArmor;
        Method dropRareDrop;
        Method dropFewItems;
        Method setSlimeSize;
        if (alreadyGenerated) {
            return;
        }
        alreadyGenerated = true;
        if (!Config.MobHandler.mobHandlerEnabled) {
            return;
        }
        GT_DummyWorld f = new GT_DummyWorld(){

            public boolean func_72899_e(int p_72899_1_, int p_72899_2_, int p_72899_3_) {
                return false;
            }

            public List func_72872_a(Class p_72872_1_, AxisAlignedBB p_72872_2_) {
                return new ArrayList();
            }

            public Block func_147439_a(int aX, int aY, int aZ) {
                if (LoaderReference.TwilightForest && new Throwable().getStackTrace()[1].getClassName().equals("twilightforest.client.renderer.entity.RenderTFSnowQueenIceShield")) {
                    return Blocks.field_150403_cj;
                }
                return super.func_147439_a(aX, aY, aZ);
            }
        };
        f.field_72995_K = true;
        fakeRand frand = new fakeRand();
        f.field_73012_v = frand;
        File cache = Config.getConfigFile("MobRecipeLoader.cache");
        Gson gson = GSONUtils.GSON_BUILDER.create();
        String modlistversion = Config.MobHandler.regenerationTrigger == Config.MobHandler._CacheRegenerationTrigger.ModAdditionRemoval ? ModUtils.getModListVersionIgnoringModVersions() : ModUtils.getModListVersion();
        if (Config.MobHandler.regenerationTrigger != Config.MobHandler._CacheRegenerationTrigger.Always && cache.exists()) {
            LOG.info("Parsing Cached map");
            BufferedReader reader = null;
            try {
                reader = Files.newReader((File)cache, (Charset)StandardCharsets.UTF_8);
                MobRecipeLoaderCacheStructure s = (MobRecipeLoaderCacheStructure)gson.fromJson((Reader)reader, MobRecipeLoaderCacheStructure.class);
                if (Config.MobHandler.regenerationTrigger == Config.MobHandler._CacheRegenerationTrigger.Never || s.version.equals(modlistversion)) {
                    for (Map.Entry<String, ArrayList<MobDrop>> entry : s.moblist.entrySet()) {
                        try {
                            EntitySkeleton e;
                            String mobName = entry.getKey();
                            if (mobName.equals("witherSkeleton") && !EntityList.field_75625_b.containsKey("witherSkeleton")) {
                                e = new EntitySkeleton((World)f);
                                e.func_82201_a(1);
                            } else {
                                e = (EntityLiving)((Class)EntityList.field_75625_b.get(mobName)).getConstructor(World.class).newInstance(f);
                            }
                            ArrayList<MobDrop> drops = entry.getValue();
                            drops.forEach(MobDrop::reconstructStack);
                            GeneralMobList.put(mobName, new GeneralMappedMob((EntityLiving)e, MobRecipe.generateMobRecipe((EntityLiving)e, mobName, drops), drops));
                        }
                        catch (Exception e) {}
                    }
                    LOG.info("Parsed cached map, skipping generation");
                    return;
                }
                LOG.info("Cached map version mismatch, generating a new one");
            }
            catch (Exception ignored) {
                LOG.warn("There was an exception while parsing cached map, generating a new one");
            }
            finally {
                if (reader != null) {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Exception exception) {}
                }
            }
        } else {
            LOG.info("Cached map doesn't exist or config option forced, generating a new one");
        }
        isInGenerationProcess = true;
        LOG.info("Generating Recipe Map for Mob Handler and EEC");
        long time = System.currentTimeMillis();
        try {
            setSlimeSize = EntitySlime.class.getDeclaredMethod(setSlimeSizeName, Integer.TYPE);
            setSlimeSize.setAccessible(true);
            dropFewItems = EntityLivingBase.class.getDeclaredMethod(dropFewItemsName, Boolean.TYPE, Integer.TYPE);
            dropFewItems.setAccessible(true);
            dropRareDrop = EntityLivingBase.class.getDeclaredMethod(dropRareDropName, Integer.TYPE);
            dropRareDrop.setAccessible(true);
            addRandomArmor = EntityLiving.class.getDeclaredMethod(addRandomArmorName, new Class[0]);
            addRandomArmor.setAccessible(true);
            enchantEquipment = EntityLiving.class.getDeclaredMethod(enchantEquipmentName, new Class[0]);
            enchantEquipment.setAccessible(true);
            rand = Entity.class.getDeclaredField(randName);
            rand.setAccessible(true);
        }
        catch (Exception ex) {
            LOG.error("Failed to obtain methods");
            isInGenerationProcess = false;
            return;
        }
        dropCollector collector = new dropCollector();
        Map stringToClassMapping = EntityList.field_75625_b;
        boolean bl = registeringWitherSkeleton = !stringToClassMapping.containsKey("witherSkeleton");
        if (registeringWitherSkeleton) {
            stringToClassMapping.put("witherSkeleton", EntitySkeleton.class);
        }
        stringToClassMapping.forEach((arg_0, arg_1) -> MobRecipeLoader.lambda$generateMobRecipeMap$0((World)f, registeringWitherSkeleton, setSlimeSize, rand, frand, collector, dropFewItems, dropRareDrop, addRandomArmor, enchantEquipment, arg_0, arg_1));
        if (registeringWitherSkeleton) {
            stringToClassMapping.remove("witherSkeleton");
        }
        time -= System.currentTimeMillis();
        time = -time;
        LOG.info("Recipe map generated ! It took " + time + "ms");
        isInGenerationProcess = false;
        LOG.info("Saving generated map to file");
        MobRecipeLoaderCacheStructure s = new MobRecipeLoaderCacheStructure();
        s.version = modlistversion;
        s.moblist = new HashMap<String, ArrayList<MobDrop>>();
        GeneralMobList.forEach((k, v) -> s.moblist.put((String)k, v.drops));
        BufferedWriter writer = null;
        try {
            writer = Files.newWriter((File)cache, (Charset)StandardCharsets.UTF_8);
            gson.toJson((Object)s, (Appendable)writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    ((Writer)writer).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void processMobRecipeMap() {
        LOG.info("Loading config");
        OverridesConfig.LoadConfig();
        if (ModUtils.isClientSided) {
            Mob_Handler.clearRecipes();
        }
        GT_MetaTileEntity_ExtremeExterminationChamber.MobNameToRecipeMap.clear();
        LoadConfigPacket.instance.mobsToLoad.clear();
        LoadConfigPacket.instance.mobsOverrides.clear();
        for (Map.Entry<String, GeneralMappedMob> entry : GeneralMobList.entrySet()) {
            OverridesConfig.MobOverride override;
            String k = entry.getKey();
            GeneralMappedMob v = entry.getValue();
            if (Arrays.asList(Config.MobHandler.mobBlacklist).contains(k)) {
                LOG.info("Entity " + k + " is blacklisted, skipping");
                continue;
            }
            MobRecipe recipe = v.recipe;
            recipe = recipe.copy();
            ArrayList drops = (ArrayList)v.drops.clone();
            if (LoaderReference.MineTweaker) {
                Optionals.parseMTAdditions(k, drops, recipe);
            }
            if ((override = OverridesConfig.overrides.get(k)) != null) {
                if (override.removeAll) {
                    drops.clear();
                    recipe.mOutputs.clear();
                } else {
                    for (OverridesConfig.MobDropSimplified removal : override.removals) {
                        drops.removeIf(removal::isMatching);
                        recipe.mOutputs.removeIf(removal::isMatching);
                    }
                }
                drops.addAll(override.additions);
                recipe.mOutputs.addAll(override.additions);
                LoadConfigPacket.instance.mobsOverrides.put(k, override);
            }
            recipe.refresh();
            if (drops.isEmpty()) {
                LOG.info("Entity " + k + " doesn't drop any items, skipping EEC map");
                if (!Config.MobHandler.includeEmptyMobs) continue;
                LoadConfigPacket.instance.mobsToLoad.add(k);
                LOG.info("Registered " + k);
                continue;
            }
            if (v.recipe.mOutputs.size() > 0) {
                GT_MetaTileEntity_ExtremeExterminationChamber.MobNameToRecipeMap.put(k, recipe);
            }
            LoadConfigPacket.instance.mobsToLoad.add(k);
            LOG.info("Registered " + k);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void processMobRecipeMap(HashSet<String> mobs, HashMap<String, OverridesConfig.MobOverride> overrides) {
        if (ModUtils.isClientSided) {
            Mob_Handler.clearRecipes();
        }
        GT_MetaTileEntity_ExtremeExterminationChamber.MobNameToRecipeMap.clear();
        mobs.forEach(k -> {
            OverridesConfig.MobOverride override;
            GeneralMappedMob v = GeneralMobList.get(k);
            MobRecipe recipe = v.recipe;
            recipe = recipe.copy();
            ArrayList drops = (ArrayList)v.drops.clone();
            if (LoaderReference.MineTweaker) {
                Optionals.parseMTAdditions(k, drops, recipe);
            }
            if ((override = (OverridesConfig.MobOverride)overrides.get(k)) != null) {
                if (override.removeAll) {
                    drops.clear();
                    recipe.mOutputs.clear();
                } else {
                    for (OverridesConfig.MobDropSimplified removal : override.removals) {
                        drops.removeIf(removal::isMatching);
                        recipe.mOutputs.removeIf(removal::isMatching);
                    }
                }
                drops.addAll(override.additions);
                recipe.mOutputs.addAll(override.additions);
                drops.sort(Comparator.comparing(d -> d.type));
            }
            recipe.refresh();
            Mob_Handler.addRecipe(v.mob, drops);
            if (recipe.mOutputs.size() > 0) {
                GT_MetaTileEntity_ExtremeExterminationChamber.MobNameToRecipeMap.put((String)k, recipe);
            }
            LOG.info("Registered " + k);
        });
        LOG.info("Sorting NEI map");
        Mob_Handler.sortCachedRecipes();
    }

    private static /* synthetic */ void lambda$generateMobRecipeMap$0(World f, boolean registeringWitherSkeleton, Method setSlimeSize, Field rand, fakeRand frand, dropCollector collector, Method dropFewItems, Method dropRareDrop, Method addRandomArmor, Method enchantEquipment, String k, Class v) {
        int chance;
        EntityLiving e;
        if (v == null) {
            return;
        }
        if (Modifier.isAbstract(v.getModifiers())) {
            LOG.info("Entity " + k + " is abstract, skipping");
            return;
        }
        try {
            e = (EntityLiving)v.getConstructor(World.class).newInstance(f);
        }
        catch (ClassCastException ex) {
            LOG.info("Entity " + k + " is not a LivingEntity, skipping");
            return;
        }
        catch (NoSuchMethodException ex) {
            LOG.info("Entity " + k + " doesn't have constructor, skipping");
            return;
        }
        catch (NoClassDefFoundError ex) {
            LOG.info("Entity " + k + " is using undefined classes, skipping");
            return;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return;
        }
        if (registeringWitherSkeleton && e instanceof EntitySkeleton && k.equals("witherSkeleton")) {
            ((EntitySkeleton)e).func_82201_a(1);
        } else if (StatCollector.func_74838_a((String)("entity." + k + ".name")).equals("entity." + k + ".name")) {
            LOG.info("Entity " + k + " does't have localized name, skipping");
            return;
        }
        e.captureDrops = true;
        if (e instanceof EntitySlime) {
            try {
                setSlimeSize.invoke((Object)e, 1);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
        }
        try {
            rand.set(e, frand);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        droplist drops = new droplist();
        droplist raredrops = new droplist();
        droplist superraredrops = new droplist();
        droplist additionaldrops = new droplist();
        droplist dropslooting = new droplist();
        frand.newRound();
        collector.newRound();
        if (v.getName().startsWith("com.emoniph.witchery")) {
            try {
                dropFewItems.invoke((Object)e, true, 0);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
            frand.newRound();
            frand.exceptionOnEnchantTry = true;
            boolean enchantmentDetected = false;
            try {
                dropFewItems.invoke((Object)e, true, 0);
            }
            catch (Exception ex) {
                enchantmentDetected = true;
            }
            int w = frand.walkCounter;
            frand.newRound();
            if (enchantmentDetected) {
                frand.maxWalkCount = w;
                collector.booksAlwaysRandomlyEnchanted = true;
            }
            e.capturedDrops.clear();
        }
        boolean second = false;
        do {
            try {
                dropFewItems.invoke((Object)e, true, 0);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
            collector.addDrop(drops, e.capturedDrops, frand.chance);
            if (second && frand.chance < 1.0E-7) {
                LOG.warn("Skipping " + k + " normal dropmap because it's too randomized");
                break;
            }
            second = true;
        } while (frand.nextRound());
        frand.newRound();
        collector.newRound();
        if (v.getName().startsWith("com.emoniph.witchery")) {
            try {
                dropFewItems.invoke((Object)e, true, 0);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
            frand.newRound();
            frand.exceptionOnEnchantTry = true;
            boolean enchantmentDetected = false;
            try {
                dropFewItems.invoke((Object)e, true, 0);
            }
            catch (Exception ex) {
                enchantmentDetected = true;
            }
            int w = frand.walkCounter;
            frand.newRound();
            if (enchantmentDetected) {
                frand.maxWalkCount = w;
                collector.booksAlwaysRandomlyEnchanted = true;
            }
            e.capturedDrops.clear();
        }
        second = false;
        do {
            try {
                dropFewItems.invoke((Object)e, true, 1);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
            collector.addDrop(dropslooting, e.capturedDrops, frand.chance);
            if (second && frand.chance < 1.0E-7) {
                LOG.warn("Skipping " + k + " normal dropmap because it's too randomized");
                break;
            }
            second = true;
        } while (frand.nextRound());
        frand.newRound();
        collector.newRound();
        second = false;
        do {
            try {
                dropRareDrop.invoke((Object)e, 0);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
            collector.addDrop(raredrops, e.capturedDrops, frand.chance);
            if (second && frand.chance < 1.0E-7) {
                LOG.warn("Skipping " + k + " rare dropmap because it's too randomized");
                break;
            }
            second = true;
        } while (frand.nextRound());
        frand.newRound();
        collector.newRound();
        second = false;
        do {
            try {
                dropRareDrop.invoke((Object)e, 1);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
            collector.addDrop(superraredrops, e.capturedDrops, frand.chance);
            if (second && frand.chance < 1.0E-7) {
                LOG.warn("Skipping " + k + " rare dropmap because it's too randomized");
                break;
            }
            second = true;
        } while (frand.nextRound());
        frand.newRound();
        collector.newRound();
        if (registeringWitherSkeleton && e instanceof EntitySkeleton && k.equals("witherSkeleton")) {
            dropinstance i = new dropinstance(new ItemStack(Items.field_151052_q), additionaldrops);
            i.isDamageRandomized = true;
            int maxdamage = i.stack.func_77958_k();
            int max = Math.max(maxdamage - 25, 1);
            for (int d = Math.min(max, 25); d <= max; ++d) {
                i.damagesPossible.put(d, 1);
            }
            additionaldrops.add(i, 1.0);
        } else {
            try {
                boolean detectedException;
                Class<?> cl = e.getClass();
                do {
                    detectedException = false;
                    try {
                        cl.getDeclaredMethod(addRandomArmorName, new Class[0]);
                    }
                    catch (Exception ex) {
                        detectedException = true;
                        cl = cl.getSuperclass();
                    }
                } while (detectedException && !cl.equals(Entity.class));
                if (cl.equals(EntityLiving.class) || cl.equals(Entity.class)) {
                    throw new Exception();
                }
                cl = e.getClass();
                do {
                    detectedException = false;
                    try {
                        cl.getDeclaredMethod(enchantEquipmentName, new Class[0]);
                    }
                    catch (Exception ex) {
                        detectedException = true;
                        cl = cl.getSuperclass();
                    }
                } while (detectedException && !cl.equals(EntityLiving.class));
                boolean usingVanillaEnchantingMethod = cl.equals(EntityLiving.class);
                double chanceModifierLocal = 1.0;
                if (v.getName().startsWith("twilightforest.entity")) {
                    frand.forceFloatValue = 0.0f;
                    chanceModifierLocal = 0.25;
                }
                second = false;
                do {
                    addRandomArmor.invoke((Object)e, new Object[0]);
                    if (!usingVanillaEnchantingMethod) {
                        enchantEquipment.invoke((Object)e, new Object[0]);
                    }
                    ItemStack[] lastActiveItems = e.func_70035_c();
                    int lastActiveItemsLength = lastActiveItems.length;
                    for (int j = 0; j < lastActiveItemsLength; ++j) {
                        ItemStack stack = lastActiveItems[j];
                        if (stack == null || LoaderReference.Thaumcraft && stack.func_77973_b() instanceof ItemWandCasting) continue;
                        int randomenchant = -1;
                        if (stack.func_77942_o() && stack.field_77990_d.func_74764_b(randomEnchantmentDetectedString)) {
                            randomenchant = stack.field_77990_d.func_74762_e(randomEnchantmentDetectedString);
                            stack.field_77990_d.func_82580_o("ench");
                        }
                        dropinstance i = additionaldrops.add(new dropinstance(stack.func_77946_l(), additionaldrops), frand.chance * chanceModifierLocal * (usingVanillaEnchantingMethod ? (j == 0 ? 0.75 : 0.5) : 1.0));
                        if (!i.isDamageRandomized && i.stack.func_77984_f()) {
                            i.isDamageRandomized = true;
                            int maxdamage = i.stack.func_77958_k();
                            int max = Math.max(maxdamage - 25, 1);
                            for (int d = Math.min(max, 25); d <= max; ++d) {
                                i.damagesPossible.put(d, 1);
                            }
                        }
                        if (!i.isEnchatmentRandomized && randomenchant != -1) {
                            i.isEnchatmentRandomized = true;
                            i.enchantmentLevel = randomenchant;
                        }
                        if (!usingVanillaEnchantingMethod) continue;
                        if (!stack.func_77942_o()) {
                            stack.field_77990_d = new NBTTagCompound();
                        }
                        stack.field_77990_d.func_74768_a(randomEnchantmentDetectedString, 14);
                        dropinstance newdrop = additionaldrops.add(new dropinstance(stack.func_77946_l(), additionaldrops), frand.chance * chanceModifierLocal * (j == 0 ? 0.25 : 0.5));
                        newdrop.isEnchatmentRandomized = true;
                        newdrop.enchantmentLevel = 14;
                        newdrop.isDamageRandomized = i.isDamageRandomized;
                        newdrop.damagesPossible = (HashMap)i.damagesPossible.clone();
                    }
                    Arrays.fill(e.func_70035_c(), null);
                    if (second && frand.chance < 1.0E-7) {
                        LOG.warn("Skipping " + k + " additional dropmap because it's too randomized");
                        break;
                    }
                    second = true;
                } while (frand.nextRound());
            }
            catch (Exception cl) {
                // empty catch block
            }
        }
        frand.newRound();
        collector.newRound();
        if (drops.isEmpty() && raredrops.isEmpty() && additionaldrops.isEmpty()) {
            ArrayList<MobDrop> arr = new ArrayList<MobDrop>();
            GeneralMobList.put(k, new GeneralMappedMob(e, MobRecipe.generateMobRecipe(e, k, arr), arr));
            LOG.info("Mapped " + k);
            return;
        }
        ArrayList<MobDrop> moboutputs = new ArrayList<MobDrop>(drops.size() + raredrops.size() + additionaldrops.size());
        for (dropinstance drop : drops.drops) {
            ItemStack stack = drop.stack;
            if (stack.func_77942_o()) {
                stack.field_77990_d.func_82580_o(randomEnchantmentDetectedString);
            }
            if ((chance = drop.getchance(10000)) > 10000) {
                int div = (int)Math.ceil((double)chance / 10000.0);
                stack.field_77994_a *= div;
                chance /= div;
            }
            if (chance == 0) {
                LOG.warn("Detected 0% loot, setting to 0.01%");
                chance = 1;
            }
            dropinstance dlooting = dropslooting.get(drop);
            moboutputs.add(new MobDrop(stack, MobDrop.DropType.Normal, chance, drop.isEnchatmentRandomized ? Integer.valueOf(drop.enchantmentLevel) : null, drop.isDamageRandomized ? drop.damagesPossible : null, dlooting != null && dlooting.dropcount > drop.dropcount, false));
        }
        for (dropinstance drop : raredrops.drops) {
            ItemStack stack = drop.stack;
            if (stack.func_77942_o()) {
                stack.field_77990_d.func_82580_o(randomEnchantmentDetectedString);
            }
            if ((chance = drop.getchance(250)) > 10000) {
                int div = (int)Math.ceil((double)chance / 10000.0);
                stack.field_77994_a *= div;
                chance /= div;
            }
            if (chance == 0) {
                LOG.warn("Detected 0% loot, setting to 0.01%");
                chance = 1;
            }
            moboutputs.add(new MobDrop(stack, MobDrop.DropType.Rare, chance, drop.isEnchatmentRandomized ? Integer.valueOf(drop.enchantmentLevel) : null, drop.isDamageRandomized ? drop.damagesPossible : null, false, false));
        }
        for (dropinstance drop : superraredrops.drops) {
            if (raredrops.contains(drop)) continue;
            ItemStack stack = drop.stack;
            if (stack.func_77942_o()) {
                stack.field_77990_d.func_82580_o(randomEnchantmentDetectedString);
            }
            if ((chance = drop.getchance(50)) > 10000) {
                int div = (int)Math.ceil((double)chance / 10000.0);
                stack.field_77994_a *= div;
                chance /= div;
            }
            if (chance == 0) {
                LOG.warn("Detected 0% loot, setting to 0.01%");
                chance = 1;
            }
            moboutputs.add(new MobDrop(stack, MobDrop.DropType.Rare, chance, drop.isEnchatmentRandomized ? Integer.valueOf(drop.enchantmentLevel) : null, drop.isDamageRandomized ? drop.damagesPossible : null, false, false));
        }
        for (dropinstance drop : additionaldrops.drops) {
            ItemStack stack = drop.stack;
            if (stack.func_77942_o()) {
                stack.field_77990_d.func_82580_o(randomEnchantmentDetectedString);
            }
            if ((chance = drop.getchance(850)) > 10000) {
                int div = (int)Math.ceil((double)chance / 10000.0);
                stack.field_77994_a *= div;
                chance /= div;
            }
            if (chance == 0) {
                LOG.warn("Detected 0% loot, setting to 0.01%");
                chance = 1;
            }
            moboutputs.add(new MobDrop(stack, MobDrop.DropType.Additional, chance, drop.isEnchatmentRandomized ? Integer.valueOf(drop.enchantmentLevel) : null, drop.isDamageRandomized ? drop.damagesPossible : null, false, false));
        }
        GeneralMobList.put(k, new GeneralMappedMob(e, MobRecipe.generateMobRecipe(e, k, moboutputs), moboutputs));
        LOG.info("Mapped " + k);
    }

    private static class Optionals {
        private Optionals() {
        }

        private static void parseMTAdditions(String k, ArrayList<MobDrop> drops, MobRecipe recipe) {
            IEntityDefinition ie = MineTweakerAPI.game.getEntity(k);
            if (ie != null) {
                MobDrop drop;
                ItemStack stack;
                double b;
                double chance;
                IntRange r;
                for (Map.Entry entry : ie.getDropsToAdd().entrySet()) {
                    r = (IntRange)entry.getValue();
                    if (r.getFrom() == 0 && r.getTo() == 0) {
                        chance = 1.0;
                    } else {
                        double a = r.getFrom();
                        b = r.getTo();
                        chance = (b * b + b - a * a + a) / (2.0 * (b - a + 1.0));
                    }
                    stack = ((ItemStack)((IItemStack)entry.getKey()).getInternal()).func_77946_l();
                    drop = new MobDrop(stack, MobDrop.DropType.Normal, (int)(chance * 10000.0), null, null, false, false);
                    drops.add(drop);
                    recipe.mOutputs.add(drop);
                }
                for (Map.Entry entry : ie.getDropsToAddPlayerOnly().entrySet()) {
                    r = (IntRange)entry.getValue();
                    if (r.getFrom() == 0 && r.getTo() == 0) {
                        chance = 1.0;
                    } else {
                        double a = r.getFrom();
                        b = r.getTo();
                        chance = (b * b + b - a * a + a) / (2.0 * (b - a + 1.0));
                    }
                    stack = ((ItemStack)((IItemStack)entry.getKey()).getInternal()).func_77946_l();
                    drop = new MobDrop(stack, MobDrop.DropType.Normal, (int)(chance * 10000.0), null, null, false, true);
                    drops.add(drop);
                }
                for (IItemStack istack : ie.getDropsToRemove()) {
                    List toRemove = drops.stream().filter(d -> istack.matches((IItemStack)new MCItemStack(d.stack))).collect(Collectors.toList());
                    drops.removeAll(toRemove);
                    recipe.mOutputs.removeAll(toRemove);
                }
            }
        }
    }

    private static class MobRecipeLoaderCacheStructure {
        String version;
        Map<String, ArrayList<MobDrop>> moblist;

        private MobRecipeLoaderCacheStructure() {
        }
    }

    public static class GeneralMappedMob {
        public final EntityLiving mob;
        public final MobRecipe recipe;
        public final ArrayList<MobDrop> drops;

        public GeneralMappedMob(EntityLiving mob, MobRecipe recipe, ArrayList<MobDrop> drops) {
            this.mob = mob;
            this.recipe = recipe;
            this.drops = drops;
        }
    }

    private static class dropCollector {
        final HashMap<GT_Utility.ItemId, Integer> damagableChecker = new HashMap();
        private boolean booksAlwaysRandomlyEnchanted = false;

        private dropCollector() {
        }

        public void addDrop(droplist fdrops, ArrayList<EntityItem> listToParse, double chance) {
            for (EntityItem entityItem : listToParse) {
                ItemStack ostack = entityItem.func_92059_d();
                if (ostack == null) continue;
                boolean randomchomenchantdetected = ostack.func_77942_o() && ostack.field_77990_d.func_74764_b(MobRecipeLoader.randomEnchantmentDetectedString);
                int randomenchantmentlevel = 0;
                if (randomchomenchantdetected) {
                    randomenchantmentlevel = ostack.field_77990_d.func_74762_e(MobRecipeLoader.randomEnchantmentDetectedString);
                    ostack.field_77990_d.func_82580_o("ench");
                    ostack.field_77990_d.func_74768_a(MobRecipeLoader.randomEnchantmentDetectedString, 0);
                }
                if ((this.booksAlwaysRandomlyEnchanted || randomchomenchantdetected) && Items.field_151134_bR == ostack.func_77973_b()) {
                    NBTTagCompound tagCompound = (NBTTagCompound)ostack.field_77990_d.func_74737_b();
                    tagCompound.func_82580_o("StoredEnchantments");
                    ostack = new ItemStack(Items.field_151122_aG, ostack.field_77994_a, 0);
                    if (!tagCompound.func_82582_d()) {
                        ostack.field_77990_d = tagCompound;
                    }
                    if (randomenchantmentlevel == 0) {
                        randomenchantmentlevel = 1;
                    }
                    randomchomenchantdetected = true;
                }
                boolean randomdamagedetected = false;
                int newdamage = -1;
                if (ostack.func_77984_f()) {
                    int odamage = ostack.func_77960_j();
                    ostack.func_77964_b(1);
                    GT_Utility.ItemId id = GT_Utility.ItemId.createNoCopy((ItemStack)ostack);
                    this.damagableChecker.putIfAbsent(id, odamage);
                    int check = this.damagableChecker.get(id);
                    if (check != odamage) {
                        randomdamagedetected = true;
                        newdamage = odamage;
                        ostack.func_77964_b(check);
                    } else {
                        ostack.func_77964_b(odamage);
                    }
                }
                dropinstance drop = fdrops.add(new dropinstance(ostack.func_77946_l(), fdrops), chance);
                if (!drop.isEnchatmentRandomized && randomchomenchantdetected) {
                    drop.isEnchatmentRandomized = true;
                    drop.enchantmentLevel = randomenchantmentlevel;
                }
                if (drop.isDamageRandomized && !randomdamagedetected) {
                    drop.damagesPossible.merge(drop.stack.func_77960_j(), 1, Integer::sum);
                }
                if (!randomdamagedetected) continue;
                if (!drop.isDamageRandomized) {
                    drop.isDamageRandomized = true;
                    drop.damagesPossible.merge(drop.stack.func_77960_j(), drop.dropcount - 1, Integer::sum);
                }
                if (newdamage == -1) {
                    newdamage = drop.stack.func_77960_j();
                }
                drop.damagesPossible.merge(newdamage, 1, Integer::sum);
            }
            listToParse.clear();
        }

        public void newRound() {
            this.damagableChecker.clear();
            this.booksAlwaysRandomlyEnchanted = false;
        }
    }

    public static class droplist {
        private final ArrayList<dropinstance> drops = new ArrayList();
        private final HashMap<GT_Utility.ItemId, Integer> dropschecker = new HashMap();

        public dropinstance add(dropinstance i, double chance) {
            if (this.contains(i)) {
                int ssize = i.stack.field_77994_a;
                dropinstance dropinstance2 = i = this.get(this.dropschecker.get(i.itemId));
                dropinstance2.dropchance = dropinstance2.dropchance + chance * (double)ssize;
                dropinstance2 = i;
                dropinstance2.dropcount = dropinstance2.dropcount + ssize;
                return i;
            }
            this.drops.add(i);
            dropinstance dropinstance3 = i;
            dropinstance3.dropchance = dropinstance3.dropchance + chance * (double)i.stack.field_77994_a;
            dropinstance3 = i;
            dropinstance3.dropcount = dropinstance3.dropcount + (i.stack.field_77994_a - 1);
            i.stack.field_77994_a = 1;
            this.dropschecker.put(i.itemId, this.drops.size() - 1);
            return i;
        }

        public dropinstance get(int index) {
            return this.drops.get(index);
        }

        public dropinstance get(dropinstance i) {
            if (!this.contains(i)) {
                return null;
            }
            return this.get(this.dropschecker.get(i.itemId));
        }

        public boolean contains(dropinstance i) {
            return this.dropschecker.containsKey(i.itemId);
        }

        public boolean contains(ItemStack stack) {
            return this.dropschecker.containsKey(GT_Utility.ItemId.createNoCopy((ItemStack)stack));
        }

        public boolean isEmpty() {
            return this.drops.isEmpty();
        }

        public int size() {
            return this.drops.size();
        }

        public int indexOf(dropinstance i) {
            if (!this.contains(i)) {
                return -1;
            }
            return this.dropschecker.get(i.itemId);
        }
    }

    private static class dropinstance {
        public boolean isDamageRandomized = false;
        public HashMap<Integer, Integer> damagesPossible = new HashMap();
        public boolean isEnchatmentRandomized = false;
        public int enchantmentLevel = 0;
        public final ItemStack stack;
        public final GT_Utility.ItemId itemId;
        private double dropchance = 0.0;
        private int dropcount = 1;
        private final droplist owner;

        public dropinstance(ItemStack s, droplist owner) {
            this.owner = owner;
            this.stack = s;
            this.itemId = GT_Utility.ItemId.createNoCopy((ItemStack)this.stack);
        }

        public int getchance(int chancemodifier) {
            this.dropchance = (double)Math.round(this.dropchance * 100000.0) / 100000.0;
            return (int)(this.dropchance * (double)chancemodifier);
        }

        public int hashCode() {
            return this.itemId.hashCode();
        }
    }

    public static class fakeRand
    extends Random {
        private final ArrayList<nexter> nexts = new ArrayList();
        private int walkCounter = 0;
        private double chance;
        private boolean exceptionOnEnchantTry = false;
        private int maxWalkCount = -1;
        private float forceFloatValue = -1.0f;

        @Override
        public int nextInt(int bound) {
            if (this.exceptionOnEnchantTry && bound == Enchantment.field_92090_c.length) {
                return -1;
            }
            if (this.nexts.size() <= this.walkCounter) {
                if (this.maxWalkCount == this.walkCounter) {
                    return 0;
                }
                this.nexts.add(new nexter(0, bound));
                ++this.walkCounter;
                this.chance /= (double)bound;
                return 0;
            }
            this.chance /= (double)bound;
            return this.nexts.get(this.walkCounter++).getInt();
        }

        @Override
        public float nextFloat() {
            if (this.forceFloatValue != -1.0f) {
                return this.forceFloatValue;
            }
            if (this.nexts.size() <= this.walkCounter) {
                if (this.maxWalkCount == this.walkCounter) {
                    return 0.0f;
                }
                this.nexts.add(new nexter(2, 10));
                ++this.walkCounter;
                this.chance /= 10.0;
                return 0.0f;
            }
            this.chance /= 10.0;
            return this.nexts.get(this.walkCounter++).getFloat();
        }

        @Override
        public boolean nextBoolean() {
            if (this.nexts.size() <= this.walkCounter) {
                if (this.maxWalkCount == this.walkCounter) {
                    return false;
                }
                this.nexts.add(new nexter(1, 2));
                ++this.walkCounter;
                this.chance /= 2.0;
                return false;
            }
            this.chance /= 2.0;
            return this.nexts.get(this.walkCounter++).getBoolean();
        }

        public void newRound() {
            this.walkCounter = 0;
            this.nexts.clear();
            this.chance = 1.0;
            this.maxWalkCount = -1;
            this.exceptionOnEnchantTry = false;
            this.forceFloatValue = -1.0f;
        }

        public boolean nextRound() {
            this.walkCounter = 0;
            this.chance = 1.0;
            while (this.nexts.size() > 0 && this.nexts.get(this.nexts.size() - 1).next()) {
                this.nexts.remove(this.nexts.size() - 1);
            }
            return this.nexts.size() > 0;
        }

        private static class nexter {
            private final int type;
            private final int bound;
            private int next = 0;

            public nexter(int type, int bound) {
                this.bound = bound;
                this.type = type;
            }

            private int getType() {
                return this.type;
            }

            private boolean getBoolean() {
                return this.next == 1;
            }

            private int getInt() {
                return this.next;
            }

            private float getFloat() {
                return (float)this.next * 0.1f;
            }

            private boolean next() {
                ++this.next;
                return this.next >= this.bound;
            }
        }
    }

    public static class MobRecipe {
        public final ArrayList<MobDrop> mOutputs;
        public final int mEUt = 2000;
        public final int mDuration;
        public int mMaxDamageChance;
        public final boolean infernalityAllowed;
        public final boolean alwaysinfernal;
        public static droplist infernaldrops;
        public final boolean isPeacefulAllowed;
        public final EntityLiving entity;
        public final float maxEntityHealth;
        public final boolean isUsable;

        public MobRecipe copy() {
            return new MobRecipe((ArrayList)this.mOutputs.clone(), this.mDuration, this.mMaxDamageChance, this.infernalityAllowed, this.alwaysinfernal, this.isPeacefulAllowed, this.entity, this.maxEntityHealth, this.isUsable);
        }

        private MobRecipe(ArrayList<MobDrop> mOutputs, int mDuration, int mMaxDamageChance, boolean infernalityAllowed, boolean alwaysinfernal, boolean isPeacefulAllowed, EntityLiving entity, float maxEntityHealth, boolean isUsable) {
            this.mOutputs = mOutputs;
            this.mDuration = mDuration;
            this.mMaxDamageChance = mMaxDamageChance;
            this.infernalityAllowed = infernalityAllowed;
            this.alwaysinfernal = alwaysinfernal;
            this.isPeacefulAllowed = isPeacefulAllowed;
            this.entity = entity;
            this.maxEntityHealth = maxEntityHealth;
            this.isUsable = isUsable;
        }

        public static MobRecipe generateMobRecipe(EntityLiving e, String entityID, ArrayList<MobDrop> outputs) {
            return new MobRecipe(e, entityID, outputs);
        }

        private MobRecipe(EntityLiving e, String entityID, ArrayList<MobDrop> outputs) {
            if (infernaldrops == null && LoaderReference.InfernalMobs) {
                infernaldrops = new droplist();
                LOG.info("Generating Infernal drops");
                ArrayList modifierLoaders = (ArrayList)InfernalHelper.getModifierLoaders().clone();
                int i = 0;
                for (ModifierLoader modifierLoader : modifierLoaders) {
                    MobModifier nextMod = modifierLoader.make(null);
                    if (nextMod.getBlackListMobClasses() != null) {
                        for (Class cl : nextMod.getBlackListMobClasses()) {
                            if (e.getClass().isAssignableFrom(cl)) break;
                        }
                    }
                    ++i;
                }
                if (i > 0) {
                    double chance = InfernalHelper.checkEntityClassForced((EntityLivingBase)e) ? 1.0 : 1.0 / (double)InfernalHelper.getEliteRarity();
                    ArrayList<ItemStack> elitelist = InfernalHelper.getDropIdListElite();
                    for (ItemStack stack : elitelist) {
                        dropinstance instance = infernaldrops.add(new dropinstance(stack.func_77946_l(), infernaldrops), chance / (double)elitelist.size());
                        instance.isEnchatmentRandomized = true;
                        instance.enchantmentLevel = stack.func_77973_b().func_77619_b();
                    }
                    ArrayList<ItemStack> ultralist = InfernalHelper.getDropIdListUltra();
                    chance *= 1.0 / (double)InfernalHelper.getUltraRarity();
                    for (ItemStack stack : ultralist) {
                        dropinstance instance = infernaldrops.add(new dropinstance(stack.func_77946_l(), infernaldrops), chance / (double)ultralist.size());
                        instance.isEnchatmentRandomized = true;
                        instance.enchantmentLevel = stack.func_77973_b().func_77619_b();
                    }
                    ArrayList<ItemStack> infernallist = InfernalHelper.getDropIdListInfernal();
                    chance *= 1.0 / (double)InfernalHelper.getInfernoRarity();
                    for (ItemStack stack : infernallist) {
                        dropinstance instance = infernaldrops.add(new dropinstance(stack.func_77946_l(), infernaldrops), chance / (double)infernallist.size());
                        instance.isEnchatmentRandomized = true;
                        instance.enchantmentLevel = stack.func_77973_b().func_77619_b();
                    }
                }
            } else if (infernaldrops == null) {
                infernaldrops = new droplist();
            }
            this.infernalityAllowed = InfernalHelper.isClassAllowed((EntityLivingBase)e);
            this.alwaysinfernal = InfernalHelper.checkEntityClassForced((EntityLivingBase)e);
            this.isPeacefulAllowed = !(e instanceof IMob);
            this.mOutputs = (ArrayList)outputs.clone();
            int maxdamagechance = 0;
            for (MobDrop o : this.mOutputs) {
                if (o.damages == null) continue;
                for (int v : o.damages.values()) {
                    maxdamagechance += v;
                }
            }
            this.mMaxDamageChance = maxdamagechance;
            this.maxEntityHealth = e.func_110138_aP();
            this.mDuration = Math.max(55, (int)((double)this.maxEntityHealth / 9.0 * 10.0));
            this.entity = e;
            this.isUsable = EnderIOHelper.canEntityBeCapturedWithSoulVial((Entity)e, entityID);
        }

        public void refresh() {
            int maxdamagechance = 0;
            for (MobDrop o : this.mOutputs) {
                if (o.damages == null) continue;
                for (int v : o.damages.values()) {
                    maxdamagechance += v;
                }
            }
            this.mMaxDamageChance = maxdamagechance;
        }

        public ItemStack[] generateOutputs(Random rnd, GT_MetaTileEntity_ExtremeExterminationChamber MTE, double attackDamage, int lootinglevel, boolean preferInfernalDrops) {
            MTE.lEUt = 2000L;
            MTE.mMaxProgresstime = Math.max(55, (int)((double)this.maxEntityHealth / attackDamage * 10.0));
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(this.mOutputs.size());
            for (MobDrop o : this.mOutputs) {
                int chance = o.chance;
                if (o.playerOnly && (chance = (int)((double)chance * Config.MobHandler.playerOnlyDropsModifier)) < 1) {
                    chance = 1;
                }
                int amount = o.stack.field_77994_a;
                if (o.lootable && lootinglevel > 0 && (chance += lootinglevel * 5000) > 10000) {
                    int div = (int)Math.ceil((double)chance / 10000.0);
                    amount *= div;
                    chance /= div;
                }
                if (chance != 10000 && rnd.nextInt(10000) >= chance) continue;
                ItemStack s = o.stack.func_77946_l();
                s.field_77994_a = amount;
                if (o.enchantable != null) {
                    EnchantmentHelper.func_77504_a((Random)rnd, (ItemStack)s, (int)o.enchantable);
                }
                if (o.damages != null) {
                    int rChance = rnd.nextInt(this.mMaxDamageChance);
                    int cChance = 0;
                    for (Map.Entry<Integer, Integer> damage : o.damages.entrySet()) {
                        if (rChance > (cChance += damage.getValue().intValue())) continue;
                        s.func_77964_b(damage.getKey().intValue());
                        break;
                    }
                }
                stacks.add(s);
            }
            if (this.infernalityAllowed && 16000L < MTE.getMaxInputVoltage() && !InfernalHelper.getDimensionBlackList().contains(MTE.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g)) {
                int p = 0;
                int mods = 0;
                if (this.alwaysinfernal || preferInfernalDrops && rnd.nextInt(InfernalHelper.getEliteRarity()) == 0) {
                    p = 1;
                    if (rnd.nextInt(InfernalHelper.getUltraRarity()) == 0) {
                        p = 2;
                        if (rnd.nextInt(InfernalHelper.getInfernoRarity()) == 0) {
                            p = 3;
                        }
                    }
                }
                ArrayList<ItemStack> infernalstacks = null;
                if (p > 0) {
                    if (p == 1) {
                        infernalstacks = InfernalHelper.getDropIdListElite();
                        mods = InfernalHelper.getMinEliteModifiers();
                    } else if (p == 2) {
                        infernalstacks = InfernalHelper.getDropIdListUltra();
                        mods = InfernalHelper.getMinUltraModifiers();
                    } else if (p == 3) {
                        infernalstacks = InfernalHelper.getDropIdListInfernal();
                        mods = InfernalHelper.getMinInfernoModifiers();
                    }
                }
                if (infernalstacks != null) {
                    ItemStack infernalstack = infernalstacks.get(rnd.nextInt(infernalstacks.size())).func_77946_l();
                    EnchantmentHelper.func_77504_a((Random)rnd, (ItemStack)infernalstack, (int)infernalstack.func_77973_b().func_77619_b());
                    stacks.add(infernalstack);
                    MTE.mEUt = (int)((long)MTE.mEUt * 8L);
                    MTE.mMaxProgresstime = (int)((double)MTE.mMaxProgresstime * ((double)mods * InfernalMobsCore.instance().getMobModHealthFactor()));
                }
            }
            return stacks.toArray(new ItemStack[0]);
        }
    }
}

