/*
 * Decompiled with CFR 0.152.
 */
package kubatech.api.implementations;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.widget.Widget;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_ExtendedPowerMultiBlockBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Function;
import kubatech.api.Variables;
import net.minecraft.item.ItemStack;

public abstract class KubaTechGTMultiBlockBase<T extends GT_MetaTileEntity_ExtendedPowerMultiBlockBase<T>>
extends GT_MetaTileEntity_ExtendedPowerMultiBlockBase<T> {
    protected final Function<Widget, Boolean> isFixed = widget -> this.getIdealStatus() == this.getRepairStatus() && this.mMachine;
    protected static final Function<Integer, IDrawable[]> toggleButtonBackgroundGetter = val -> {
        if (val == 0) {
            return new IDrawable[]{GT_UITextures.BUTTON_STANDARD, GT_UITextures.OVERLAY_BUTTON_CROSS};
        }
        return new IDrawable[]{GT_UITextures.BUTTON_STANDARD, GT_UITextures.OVERLAY_BUTTON_CHECKMARK};
    };

    protected KubaTechGTMultiBlockBase(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    protected KubaTechGTMultiBlockBase(String aName) {
        super(aName);
    }

    protected boolean isOverclockingInfinite() {
        return false;
    }

    protected int getOverclockTimeLimit() {
        return 1;
    }

    protected void calculateOverclockedNessMultiInternal(long aEUt, int aDuration, int mAmperage, long maxInputVoltage, boolean perfectOC) {
        this.calculateOverclock(aEUt, aDuration, this.getMaxInputEu(), perfectOC);
    }

    protected int calculateOverclock(long aEUt, int aDuration, long maxInputEU, boolean isPerfect) {
        int minDuration = this.getOverclockTimeLimit();
        int tiers = (int)(Math.log((double)maxInputEU / (double)aEUt) / Variables.ln4);
        if (tiers <= 0) {
            this.lEUt = aEUt;
            this.mMaxProgresstime = aDuration;
            return 0;
        }
        int durationTiers = (int)Math.ceil(Math.log((double)aDuration / (double)minDuration) / (isPerfect ? Variables.ln4 : Variables.ln2));
        if (durationTiers < 0) {
            durationTiers = 0;
        }
        if (durationTiers > tiers) {
            durationTiers = tiers;
        }
        if (!this.isOverclockingInfinite()) {
            tiers = durationTiers;
            if (tiers == 0) {
                this.lEUt = aEUt;
                this.mMaxProgresstime = aDuration;
                return 0;
            }
            this.lEUt = aEUt << (tiers << 1);
            if ((aDuration >>= isPerfect ? tiers << 1 : tiers) < minDuration) {
                aDuration = minDuration;
            }
            this.mMaxProgresstime = aDuration;
            return tiers;
        }
        this.lEUt = aEUt << (tiers << 1);
        aDuration >>= isPerfect ? durationTiers << 1 : durationTiers;
        int dMulti = tiers - durationTiers;
        if (dMulti > 0) {
            dMulti = 1 << (isPerfect ? dMulti << 1 : dMulti);
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(Arrays.asList(this.mOutputItems));
            for (ItemStack itemStack : this.mOutputItems) {
                itemStack.field_77994_a *= dMulti;
                int maxSize = itemStack.func_77976_d();
                while (itemStack.field_77994_a > maxSize) {
                    stacks.add(itemStack.func_77979_a(Math.min(itemStack.field_77994_a - maxSize, maxSize)));
                }
            }
            if (stacks.size() != this.mOutputItems.length) {
                this.mOutputItems = stacks.toArray(new ItemStack[0]);
            }
            for (ItemStack itemStack : this.mOutputFluids) {
                itemStack.amount *= dMulti;
            }
        }
        if (aDuration < minDuration) {
            aDuration = minDuration;
        }
        this.mMaxProgresstime = aDuration;
        return tiers;
    }

    protected int calculateOverclock(long aEUt, int aDuration, boolean isPerfect) {
        return this.calculateOverclock(aEUt, aDuration, this.getMaxInputEu(), isPerfect);
    }

    protected int calculateOverclock(long aEUt, int aDuration) {
        return this.calculateOverclock(aEUt, aDuration, false);
    }

    protected int calculatePerfectOverclock(long aEUt, int aDuration) {
        return this.calculateOverclock(aEUt, aDuration, true);
    }

    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }
}

