/*
 * Decompiled with CFR 0.152.
 */
package kubatech.api.helpers;

import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.function.Function;

public class ReflectionHelper {
    private static final HashMap<String, _FieldsMethods> classes = new HashMap();

    public static <T> T getField(Object obj, String fieldName, T defaultvalue) {
        Class<?> cl = obj.getClass();
        String clName = cl.getName();
        HashMap<String, Field> classmap = ReflectionHelper.classes.computeIfAbsent((String)clName, (Function<String, _FieldsMethods>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getField$0(java.lang.String ), (Ljava/lang/String;)Lkubatech/api/helpers/ReflectionHelper$_FieldsMethods;)()).fields;
        try {
            if (classmap.containsKey(fieldName)) {
                Field f = classmap.get(fieldName);
                if (f == null) {
                    return defaultvalue;
                }
                return (T)f.get(obj);
            }
            boolean exceptionDetected = false;
            Field f = null;
            do {
                exceptionDetected = false;
                try {
                    f = cl.getDeclaredField(fieldName);
                    f.setAccessible(true);
                }
                catch (Exception ex) {
                    exceptionDetected = true;
                    cl = cl.getSuperclass();
                }
            } while (exceptionDetected && !cl.equals(Object.class));
            classmap.put(fieldName, f);
            if (f == null) {
                return defaultvalue;
            }
            return (T)f.get(obj);
        }
        catch (Exception ex) {
            return defaultvalue;
        }
    }

    public static <T> boolean setField(Object obj, String fieldName, T value) {
        Class<?> cl = obj.getClass();
        String clName = cl.getName();
        HashMap<String, Field> classmap = ReflectionHelper.classes.computeIfAbsent((String)clName, (Function<String, _FieldsMethods>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$setField$1(java.lang.String ), (Ljava/lang/String;)Lkubatech/api/helpers/ReflectionHelper$_FieldsMethods;)()).fields;
        try {
            if (classmap.containsKey(fieldName)) {
                Field f = classmap.get(fieldName);
                if (f == null) {
                    return false;
                }
                f.set(obj, value);
                return true;
            }
            boolean exceptionDetected = false;
            Field f = null;
            do {
                exceptionDetected = false;
                try {
                    f = cl.getDeclaredField(fieldName);
                    f.setAccessible(true);
                }
                catch (Exception ex) {
                    exceptionDetected = true;
                    cl = cl.getSuperclass();
                }
            } while (exceptionDetected && !cl.equals(Object.class));
            classmap.put(fieldName, f);
            if (f == null) {
                return false;
            }
            f.set(obj, value);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static <T> T getField(Object obj, String fieldName) {
        return ReflectionHelper.getField(obj, fieldName, null);
    }

    public static <T> T callMethod(Object obj, String methodName, T defaultValue, Object ... args) {
        Class<?> cl = obj.getClass();
        String clName = cl.getName();
        HashMap<String, Method> classmap = ReflectionHelper.classes.computeIfAbsent((String)clName, (Function<String, _FieldsMethods>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$callMethod$2(java.lang.String ), (Ljava/lang/String;)Lkubatech/api/helpers/ReflectionHelper$_FieldsMethods;)()).methods;
        StringBuilder builder = new StringBuilder(methodName);
        Class[] argsTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            Class<?> arg = args[i].getClass();
            builder.append(";").append(arg.getSimpleName());
            argsTypes[i] = arg;
        }
        String methodNameUnique = builder.toString();
        try {
            if (classmap.containsKey(methodNameUnique)) {
                Method m = classmap.get(methodNameUnique);
                if (m == null) {
                    return defaultValue;
                }
                return (T)m.invoke(obj, args);
            }
            boolean exceptionDetected = false;
            Method m = null;
            do {
                exceptionDetected = false;
                try {
                    m = cl.getDeclaredMethod(methodName, argsTypes);
                    m.setAccessible(true);
                }
                catch (Exception ex) {
                    exceptionDetected = true;
                    cl = cl.getSuperclass();
                }
            } while (exceptionDetected && !cl.equals(Object.class));
            classmap.put(methodNameUnique, m);
            if (m == null) {
                return defaultValue;
            }
            return (T)m.invoke(obj, args);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    private static /* synthetic */ _FieldsMethods lambda$callMethod$2(String s) {
        return new _FieldsMethods();
    }

    private static /* synthetic */ _FieldsMethods lambda$setField$1(String s) {
        return new _FieldsMethods();
    }

    private static /* synthetic */ _FieldsMethods lambda$getField$0(String s) {
        return new _FieldsMethods();
    }

    private static class _FieldsMethods {
        HashMap<String, Field> fields = new HashMap();
        HashMap<String, Method> methods = new HashMap();

        private _FieldsMethods() {
        }
    }
}

