/*
 * Decompiled with CFR 0.152.
 */
package common.tileentities;

import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import common.Blocks;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_EnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GTMTE_SOFuelCellMK2
extends GT_MetaTileEntity_EnhancedMultiBlockBase<GTMTE_SOFuelCellMK2> {
    private final int OXYGEN_PER_SEC = 2000;
    private final int EU_PER_TICK = 24576;
    private final int STEAM_PER_SEC = 96000;
    private int mCasing = 0;
    private static final int CASING_TEXTURE_ID = 48;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<GTMTE_SOFuelCellMK2> STRUCTURE_DEFINITION = IStructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"ccc", "ccc", "ccc", "ccc", "ccc"}, {"c~c", "geg", "geg", "geg", "cdc"}, {"ccc", "ccc", "ccc", "ccc", "ccc"}})).addElement(Character.valueOf('c'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.onElementPass(te -> ++te.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings4, (int)0)), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addInputToMachineList, (int)48, (int)1), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addMaintenanceToMachineList, (int)48, (int)1), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addOutputToMachineList, (int)48, (int)1)})).addElement(Character.valueOf('d'), (IStructureElement)GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addDynamoToMachineList, (int)48, (int)1)).addElement(Character.valueOf('g'), StructureUtility.ofBlockAnyMeta((Block)GameRegistry.findBlock((String)"IC2", (String)"blockAlloyGlass"))).addElement(Character.valueOf('e'), StructureUtility.ofBlockAnyMeta((Block)Blocks.gdcUnit)).build();

    public GTMTE_SOFuelCellMK2(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GTMTE_SOFuelCellMK2(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity var1) {
        return new GTMTE_SOFuelCellMK2(this.mName);
    }

    public IStructureDefinition<GTMTE_SOFuelCellMK2> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Gas Turbine").addInfo("Oxidizes gas fuels to generate electricity without polluting the environment").addInfo("Consumes up to491520EU worth of fuel with up to 100% efficiency each second").addInfo("Nitrobenzene and other gas fuels above 1M EU/bucket are more efficient").addInfo("Steam production requires the SOFC to heat up completely first").addInfo("Outputs 24576EU/t and 96000L/s Steam").addInfo("Additionally, requires 2000L/s Oxygen gas").addSeparator().beginStructureBlock(3, 3, 5, false).addController("Front center").addCasingInfo("Robust Tungstensteel Machine Casing", 12).addOtherStructurePart("GDC Ceramic Electrolyte Unit", "3x, Center 1x1x3").addOtherStructurePart("Reinforced Glass", "6x, touching the electrolyte units on the horizontal sides").addDynamoHatch("Back center", new int[]{1}).addMaintenanceHatch("Any casing").addInputHatch("Fuel, any casing").addInputHatch("Oxygen, any casing").addOutputHatch("Superheated Steam, any casing").toolTipFinisher("KekzTech");
        return tt;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)48), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER_ACTIVE}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER_ACTIVE_GLOW}).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)48), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER_GLOW}).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)48)};
    }

    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "MultiblockDisplay.png");
    }

    public boolean isCorrectMachinePart(ItemStack stack) {
        return true;
    }

    public boolean checkRecipe(ItemStack stack) {
        ArrayList storedFluids = super.getStoredFluids();
        Collection recipeList = GT_Recipe.GT_Recipe_Map.sTurbineFuels.mRecipeList;
        if (storedFluids.size() > 0 && recipeList != null) {
            for (FluidStack hatchFluid : storedFluids) {
                for (GT_Recipe aFuel : recipeList) {
                    FluidStack liquid = GT_Utility.getFluidForFilledItem((ItemStack)aFuel.getRepresentativeInput(0), (boolean)true);
                    if (liquid == null || !hatchFluid.isFluidEqual(liquid)) continue;
                    liquid.amount = (int)(Math.floor(491520 / aFuel.mSpecialValue) / (double)Math.max(1, aFuel.mSpecialValue / 1000));
                    if (!super.depleteInput(liquid)) continue;
                    if (!super.depleteInput(Materials.Oxygen.getGas(2000L))) {
                        this.mEUt = 0;
                        this.mEfficiency = 0;
                        return false;
                    }
                    this.mEUt = 24576;
                    this.mMaxProgresstime = 20;
                    this.mEfficiencyIncrease = 80;
                    if (this.mEfficiency == this.getMaxEfficiency(null)) {
                        super.addOutput(FluidRegistry.getFluidStack((String)"ic2superheatedsteam", (int)96000));
                    }
                    return true;
                }
            }
        }
        this.mEUt = 0;
        this.mEfficiency = 0;
        return false;
    }

    public boolean checkMachine(IGregTechTileEntity thisController, ItemStack guiSlotItem) {
        this.mCasing = 0;
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 1, 1, 0)) {
            return false;
        }
        return this.mCasing >= 12 && this.mMaintenanceHatches.size() == 1 && this.mInputHatches.size() >= 2;
    }

    public int getMaxEfficiency(ItemStack stack) {
        return 10000;
    }

    public int getPollutionPerTick(ItemStack stack) {
        return 0;
    }

    public int getDamageToComponent(ItemStack stack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack stack) {
        return false;
    }

    public void construct(ItemStack itemStack, boolean b) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, itemStack, b, 1, 1, 0);
    }
}

