/*
 * Decompiled with CFR 0.152.
 */
package common.tileentities;

import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TE_ItemProxyCable
extends TileEntity {
    private static final float THICKNESS = 0.5f;
    private byte connections = 0;
    private byte connectionAllowed = (byte)63;
    private String idCache = null;

    public void func_145845_h() {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity te = super.func_145831_w().func_147438_o(this.field_145851_c + side.offsetX, this.field_145848_d + side.offsetY, this.field_145849_e + side.offsetZ);
            if (te instanceof TE_ItemProxyCable) {
                TE_ItemProxyCable cable = (TE_ItemProxyCable)te;
                this.setConnection(side, cable.isConnectionAllowed(side.getOpposite()));
                continue;
            }
            this.setConnection(side, false);
        }
    }

    public static float getThickness() {
        return 0.5f;
    }

    public String getIdentifier() {
        if (this.idCache == null) {
            this.idCache = "" + this.field_145851_c + this.field_145848_d + this.field_145849_e;
            return this.idCache;
        }
        return this.idCache;
    }

    public boolean setConnection(ForgeDirection side, boolean connected) {
        if (this.isConnectionAllowed(side)) {
            switch (side) {
                case DOWN: {
                    this.connections = (byte)(connected ? this.connections | 1 : this.connections ^ 1);
                    break;
                }
                case UP: {
                    this.connections = (byte)(connected ? this.connections | 2 : this.connections ^ 2);
                    break;
                }
                case NORTH: {
                    this.connections = (byte)(connected ? this.connections | 4 : this.connections ^ 4);
                    break;
                }
                case SOUTH: {
                    this.connections = (byte)(connected ? this.connections | 8 : this.connections ^ 8);
                    break;
                }
                case WEST: {
                    this.connections = (byte)(connected ? this.connections | 0x10 : this.connections ^ 0x10);
                    break;
                }
                case EAST: {
                    this.connections = (byte)(connected ? this.connections | 0x20 : this.connections ^ 0x20);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public boolean isConnected(ForgeDirection side) {
        switch (side) {
            case DOWN: {
                return (this.connections & 1) == 1;
            }
            case UP: {
                return (this.connections & 2) == 2;
            }
            case NORTH: {
                return (this.connections & 4) == 4;
            }
            case SOUTH: {
                return (this.connections & 8) == 8;
            }
            case WEST: {
                return (this.connections & 0x10) == 16;
            }
            case EAST: {
                return (this.connections & 0x20) == 32;
            }
        }
        return false;
    }

    public void setConnectionAllowed(ForgeDirection side, boolean allowed) {
        switch (side) {
            case DOWN: {
                this.connectionAllowed = (byte)(allowed ? this.connectionAllowed | 1 : this.connectionAllowed ^ 1);
                break;
            }
            case UP: {
                this.connectionAllowed = (byte)(allowed ? this.connectionAllowed | 2 : this.connectionAllowed ^ 2);
                break;
            }
            case NORTH: {
                this.connectionAllowed = (byte)(allowed ? this.connectionAllowed | 4 : this.connectionAllowed ^ 4);
                break;
            }
            case SOUTH: {
                this.connectionAllowed = (byte)(allowed ? this.connectionAllowed | 8 : this.connectionAllowed ^ 8);
                break;
            }
            case WEST: {
                this.connectionAllowed = (byte)(allowed ? this.connectionAllowed | 0x10 : this.connectionAllowed ^ 0x10);
                break;
            }
            case EAST: {
                this.connectionAllowed = (byte)(allowed ? this.connectionAllowed | 0x20 : this.connectionAllowed ^ 0x20);
                break;
            }
        }
    }

    public boolean isConnectionAllowed(ForgeDirection side) {
        switch (side) {
            case DOWN: {
                return (this.connectionAllowed & 1) == 1;
            }
            case UP: {
                return (this.connectionAllowed & 2) == 2;
            }
            case NORTH: {
                return (this.connectionAllowed & 4) == 4;
            }
            case SOUTH: {
                return (this.connectionAllowed & 8) == 8;
            }
            case WEST: {
                return (this.connectionAllowed & 0x10) == 16;
            }
            case EAST: {
                return (this.connectionAllowed & 0x20) == 32;
            }
        }
        return false;
    }
}

