/*
 * Decompiled with CFR 0.152.
 */
package common.tileentities;

import common.Blocks;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.GT_RenderedTexture;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import org.joml.Vector3i;

public class GTMTE_ModularNuclearReactor
extends GT_MetaTileEntity_MultiBlockBase {
    private final Block CASING = GregTech_API.sBlockCasings3;
    private final int CASING_META = 12;
    private final int CASING_TEXTURE_ID = 44;
    private final Block CHAMBER_OFF = Blocks.reactorChamberOFF;
    private final Block CHAMBER_ON = Blocks.reactorChamberON;
    private final Block CONTROL_ROD = Blocks.reactorControlRod;
    private boolean euMode = true;

    public GTMTE_ModularNuclearReactor(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GTMTE_ModularNuclearReactor(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity var1) {
        return new GTMTE_ModularNuclearReactor(this.mName);
    }

    public String[] getDescription() {
        return new String[]{"Disabled"};
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] iTextureArray;
        if (aSide == aFacing) {
            ITexture[] iTextureArray2 = new ITexture[2];
            iTextureArray2[0] = Textures.BlockIcons.getCasingTextureForId((int)44);
            iTextureArray = iTextureArray2;
            iTextureArray2[1] = new GT_RenderedTexture((IIconContainer)(aActive ? Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER_ACTIVE : Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER));
        } else {
            ITexture[] iTextureArray3 = new ITexture[1];
            iTextureArray = iTextureArray3;
            iTextureArray3[0] = Textures.BlockIcons.getCasingTextureForId((int)44);
        }
        return iTextureArray;
    }

    public boolean isCorrectMachinePart(ItemStack stack) {
        return true;
    }

    public boolean checkRecipe(ItemStack stack) {
        return false;
    }

    public void onPostTick(IGregTechTileEntity thisController, long aTick) {
        super.onPostTick(thisController, aTick);
        if (super.getBaseMetaTileEntity().isActive()) {
            // empty if block
        }
    }

    public boolean checkMachine(IGregTechTileEntity thisController, ItemStack guiSlotItem) {
        Vector3i pos;
        int h;
        int z;
        int x;
        int dirX = ForgeDirection.getOrientation((int)thisController.getBackFacing()).offsetX;
        int dirZ = ForgeDirection.getOrientation((int)thisController.getBackFacing()).offsetZ;
        int minCasingAmount = 100;
        boolean checklist = true;
        Vector3i center = new Vector3i(thisController.getXCoord(), (int)thisController.getYCoord(), thisController.getZCoord()).add(dirX * 3, 0, dirZ * 3);
        for (x = -3; x <= 3; ++x) {
            for (z = -3; z <= 3; ++z) {
                if ((Math.abs(x) > 1 || Math.abs(z) != 3) && (Math.abs(z) > 1 || Math.abs(x) != 3)) continue;
                for (h = 0; h < 6; ++h) {
                    pos = new Vector3i(center.x() + x, center.y() + h, center.z() + z);
                    if (h == 0 && pos.x() == thisController.getXCoord() && pos.y() == thisController.getYCoord() && pos.z() == thisController.getZCoord()) continue;
                    if (thisController.getBlock(pos.x(), pos.y(), pos.z()) == this.CASING && thisController.getMetaID(pos.x(), pos.y(), pos.z()) == 12) {
                        --minCasingAmount;
                        continue;
                    }
                    checklist = false;
                }
            }
        }
        for (x = -2; x <= 2; ++x) {
            for (z = -2; z <= 2; ++z) {
                if (Math.abs(x) + Math.abs(z) != 4) continue;
                for (h = 0; h < 6; ++h) {
                    pos = new Vector3i(center.x() + x, center.y() + h, center.z() + z);
                    if (h == 0 && pos.x() == thisController.getXCoord() && pos.y() == thisController.getYCoord() && pos.z() == thisController.getZCoord()) continue;
                    if (thisController.getBlock(pos.x(), pos.y(), pos.z()) == this.CASING && thisController.getMetaID(pos.x(), pos.y(), pos.z()) == 12) {
                        --minCasingAmount;
                        continue;
                    }
                    checklist = false;
                }
            }
        }
        for (x = -2; x <= 2; ++x) {
            for (z = -2; z <= 2; ++z) {
                if (thisController.getBlock(center.x() + x, center.y(), center.z() + z) != this.CASING || thisController.getMetaID(center.x() + x, center.y(), center.z() + z) != 12) {
                    checklist = false;
                    continue;
                }
                --minCasingAmount;
            }
        }
        for (x = -2; x <= 2; ++x) {
            for (z = -2; z <= 2; ++z) {
                if (Math.abs(x) == Math.abs(z) && (x != 0 || z != 0) || thisController.getBlock(center.x() + x, center.y() + 1, center.z() + z) == this.CHAMBER_OFF || thisController.getBlock(center.x() + x, center.y() + 1, center.z() + z) == this.CHAMBER_ON) continue;
                checklist = false;
            }
        }
        for (int h2 = 1; h2 < 5; ++h2) {
            for (int x2 = -1; x2 <= 1; ++x2) {
                for (int z2 = -1; z2 <= 1; ++z2) {
                    if (x2 == 0 || z2 == 0 || thisController.getBlock(center.x() + x2, center.y() + h2, center.z() + z2) == this.CONTROL_ROD) continue;
                    checklist = false;
                }
            }
        }
        if (minCasingAmount > 0) {
            checklist = false;
        }
        return checklist;
    }

    public int getMaxEfficiency(ItemStack stack) {
        return 10000;
    }

    public int getPollutionPerTick(ItemStack stack) {
        return 0;
    }

    public int getDamageToComponent(ItemStack stack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack stack) {
        return false;
    }
}

