/*
 * Decompiled with CFR 0.152.
 */
package common.tileentities;

import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_DynamoMulti;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_DynamoTunnel;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_EnergyMulti;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_EnergyTunnel;
import common.Blocks;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Dynamo;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.input.Keyboard;
import util.Vector3i;
import util.Vector3ic;

public class GTMTE_LapotronicSuperCapacitor
extends GT_MetaTileEntity_MultiBlockBase {
    private static final String glassNameBorosilicate = "BW_GlasBlocks";
    private static final Block LSC_PART = Blocks.lscLapotronicEnergyUnit;
    private static final int CASING_META = 0;
    private static final int CASING_TEXTURE_ID = 62;
    private static final BigInteger MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigDecimal PASSIVE_DISCHARGE_FACTOR_PER_TICK = BigDecimal.valueOf(5.787037037037037E-9);
    private final Set<GT_MetaTileEntity_Hatch_EnergyMulti> mEnergyHatchesTT = new HashSet<GT_MetaTileEntity_Hatch_EnergyMulti>();
    private final Set<GT_MetaTileEntity_Hatch_DynamoMulti> mDynamoHatchesTT = new HashSet<GT_MetaTileEntity_Hatch_DynamoMulti>();
    private final Set<GT_MetaTileEntity_Hatch_EnergyTunnel> mEnergyTunnelsTT = new HashSet<GT_MetaTileEntity_Hatch_EnergyTunnel>();
    private final Set<GT_MetaTileEntity_Hatch_DynamoTunnel> mDynamoTunnelsTT = new HashSet<GT_MetaTileEntity_Hatch_DynamoTunnel>();
    private final int[] capacitors = new int[7];
    private BigInteger capacity = BigInteger.ZERO;
    private BigInteger stored = BigInteger.ZERO;
    private BigInteger passiveDischargeAmount = BigInteger.ZERO;
    private BigInteger inputLastTick = BigInteger.ZERO;
    private BigInteger outputLastTick = BigInteger.ZERO;
    private int repairStatusCache = 0;
    private long mMaxEUIn = 0L;
    private long mMaxEUOut = 0L;

    public GTMTE_LapotronicSuperCapacitor(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GTMTE_LapotronicSuperCapacitor(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity var1) {
        return new GTMTE_LapotronicSuperCapacitor(this.mName);
    }

    public String[] getDescription() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Battery Buffer").addInfo("Power storage structure. Does not charge batteries or tools, however.").addInfo("Loses energy equal to 1% of the total capacity every 24 hours.").addInfo("Exception: Ultimate Capacitors only count as Lapotronic Capacitors (UV) for the").addInfo("purposes of passive loss calculation. The full capacity is counted towards the actual power capacity.").addSeparator().addInfo("Glass shell has to be Tier - 2 of the highest capacitor tier").addInfo("UV-tier glass required for TecTech Laser Hatches").addInfo("Add more or better capacitors to increase capacity").addSeparator().beginStructureBlock(5, 4, 5, false).addStructureInfo("Modular height of 4-18 blocks.").addController("Front center bottom").addOtherStructurePart("Lapotronic Super Capacitor Casing", "5x2x5 base (at least 17x)").addOtherStructurePart("Lapotronic Capacitor (EV-UV), Ultimate Capacitor (UHV)", "Center 3x(1-15)x3 above base (9-135 blocks)").addStructureInfo("You can also use the Empty Capacitor to save materials if you use it for less than half the blocks").addOtherStructurePart("Borosilicate Glass (any)", "41-265x, Encase capacitor pillar").addEnergyHatch("Any casing").addDynamoHatch("Any casing").addOtherStructurePart("Laser Target/Source Hatches", "Any casing, must be using UV-tier glass").addStructureInfo("You can have several I/O Hatches").addMaintenanceHatch("Any casing").toolTipFinisher("KekzTech");
        if (!Keyboard.isKeyDown((int)42)) {
            return tt.getInformation();
        }
        return tt.getStructureInformation();
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] sTexture = new ITexture[]{new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.MACHINE_CASING_FUSION_GLASS, Dyes.getModulation((int)-1, (short[])Dyes._NULL.mRGBa))};
        if (aSide == aFacing && aActive) {
            sTexture = new ITexture[]{new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.MACHINE_CASING_FUSION_GLASS_YELLOW, Dyes.getModulation((int)-1, (short[])Dyes._NULL.mRGBa))};
        }
        return sTexture;
    }

    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "MultiblockDisplay.png");
    }

    public boolean isCorrectMachinePart(ItemStack stack) {
        return true;
    }

    public boolean checkRecipe(ItemStack stack) {
        this.mProgresstime = 1;
        this.mMaxProgresstime = 1;
        this.mEUt = 0;
        this.mEfficiencyIncrease = 10000;
        return true;
    }

    public Vector3ic rotateOffsetVector(Vector3ic forgeDirection, int x, int y, int z) {
        Vector3i offset = new Vector3i();
        if (forgeDirection.x() == 0 && forgeDirection.z() == -1) {
            offset.x = x;
            offset.y = y;
            offset.z = z;
        }
        if (forgeDirection.x() == 0 && forgeDirection.z() == 1) {
            offset.x = -x;
            offset.y = y;
            offset.z = -z;
        }
        if (forgeDirection.x() == -1 && forgeDirection.z() == 0) {
            offset.x = z;
            offset.y = y;
            offset.z = -x;
        }
        if (forgeDirection.x() == 1 && forgeDirection.z() == 0) {
            offset.x = -z;
            offset.y = y;
            offset.z = x;
        }
        if (forgeDirection.y() == -1) {
            offset.x = x;
            offset.y = z;
            offset.z = y;
        }
        return offset;
    }

    public boolean checkMachine(IGregTechTileEntity thisController, ItemStack guiSlotItem) {
        double emptyCheck;
        Vector3ic offset;
        int Z;
        int X;
        Vector3i forgeDirection = new Vector3i(ForgeDirection.getOrientation((int)thisController.getBackFacing()).offsetX, ForgeDirection.getOrientation((int)thisController.getBackFacing()).offsetY, ForgeDirection.getOrientation((int)thisController.getBackFacing()).offsetZ);
        boolean formationChecklist = true;
        int minCasingAmount = 16;
        byte firstGlassMeta = -1;
        Arrays.fill(this.capacitors, 0);
        this.mEnergyHatchesTT.clear();
        this.mDynamoHatchesTT.clear();
        this.mEnergyTunnelsTT.clear();
        this.mDynamoTunnelsTT.clear();
        this.mMaxEUIn = 0L;
        this.mMaxEUOut = 0L;
        BigInteger tempCapacity = BigInteger.ZERO;
        for (int Y = 0; Y <= 1; ++Y) {
            for (X = -2; X <= 2; ++X) {
                for (Z = 0; Z >= -4; --Z) {
                    Vector3ic offset2;
                    IGregTechTileEntity currentTE;
                    if (X == 0 && Y == 0 && Z == 0 || super.addMaintenanceToMachineList(currentTE = thisController.getIGregTechTileEntityOffset((offset2 = this.rotateOffsetVector(forgeDirection, X, Y, Z)).x(), offset2.y(), offset2.z()), 62) || this.addEnergyInputToMachineList(currentTE, 62) || this.addDynamoToMachineList(currentTE, 62)) continue;
                    if (thisController.getBlockOffset(offset2.x(), offset2.y(), offset2.z()) == LSC_PART && thisController.getMetaIDOffset(offset2.x(), offset2.y(), offset2.z()) == 0) {
                        --minCasingAmount;
                        continue;
                    }
                    formationChecklist = false;
                }
            }
        }
        int firstGlassHeight = 3;
        for (X = -1; X <= 1; ++X) {
            block4: for (Z = -1; Z >= -3; --Z) {
                for (int Y = 2; Y <= 17; ++Y) {
                    offset = this.rotateOffsetVector(forgeDirection, X, Y, Z);
                    byte meta = thisController.getMetaIDOffset(offset.x(), offset.y(), offset.z());
                    if (thisController.getBlockOffset(offset.x(), offset.y(), offset.z()) == LSC_PART && meta > 0) {
                        tempCapacity = this.calculateTempCapacity(tempCapacity, meta);
                        int n = meta - 1;
                        this.capacitors[n] = this.capacitors[n] + 1;
                        continue;
                    }
                    if (thisController.getBlockOffset(offset.x(), offset.y(), offset.z()).func_149739_a().equals(glassNameBorosilicate)) {
                        firstGlassHeight = Y;
                        continue block4;
                    }
                    formationChecklist = false;
                }
            }
        }
        for (int Y = 2; Y <= firstGlassHeight; ++Y) {
            for (int X2 = -2; X2 <= 2; ++X2) {
                for (int Z2 = 0; Z2 >= -4; --Z2) {
                    offset = this.rotateOffsetVector(forgeDirection, X2, Y, Z2);
                    String blockNameAt = thisController.getBlockOffset(offset.x(), offset.y(), offset.z()).func_149739_a();
                    byte meta = thisController.getMetaIDOffset(offset.x(), offset.y(), offset.z());
                    if (Y < firstGlassHeight) {
                        if (X2 != -2 && X2 != 2 && Z2 != 0 && Z2 != 4) continue;
                        if (glassNameBorosilicate.equals(blockNameAt)) {
                            if (firstGlassMeta == -1) {
                                firstGlassMeta = meta;
                                continue;
                            }
                            if (meta == firstGlassMeta) continue;
                            formationChecklist = false;
                            continue;
                        }
                        formationChecklist = false;
                        continue;
                    }
                    if (glassNameBorosilicate.equals(blockNameAt)) {
                        if (meta == firstGlassMeta) continue;
                        formationChecklist = false;
                        continue;
                    }
                    formationChecklist = false;
                }
            }
        }
        if (minCasingAmount > 0) {
            formationChecklist = false;
        }
        byte colourCorrectedMeta = firstGlassMeta > 5 ? (byte)0 : firstGlassMeta;
        for (int highestCapacitor = this.capacitors.length - 1; highestCapacitor >= 0; --highestCapacitor) {
            if (this.capacitors[highestCapacitor] <= 0 || !formationChecklist) continue;
            formationChecklist = this.checkGlassTier(colourCorrectedMeta, highestCapacitor);
        }
        if (colourCorrectedMeta < 5) {
            if (this.mEnergyTunnelsTT.size() > 0 || this.mDynamoTunnelsTT.size() > 0) {
                formationChecklist = false;
            }
            this.mEnergyTunnelsTT.clear();
            this.mDynamoTunnelsTT.clear();
        }
        if ((emptyCheck = (double)this.capacitors[5] / (double)(this.capacitors[0] + this.capacitors[1] + this.capacitors[2] + this.capacitors[3] + this.capacitors[4] + this.capacitors[6])) > 0.5) {
            formationChecklist = false;
        }
        this.calculateCapacity();
        this.passiveDischargeAmount = new BigDecimal(tempCapacity).multiply(PASSIVE_DISCHARGE_FACTOR_PER_TICK).toBigInteger();
        this.passiveDischargeAmount = this.recalculateLossWithMaintenance(super.getRepairStatus());
        return formationChecklist;
    }

    public BigInteger calculateTempCapacity(BigInteger tempCapacity, int meta) {
        switch (meta) {
            case 1: {
                tempCapacity = tempCapacity.add(BigInteger.valueOf(100000000L));
                this.capacity = this.capacity.add(BigInteger.valueOf(100000000L));
                break;
            }
            case 2: {
                tempCapacity = tempCapacity.add(BigInteger.valueOf(1000000000L));
                this.capacity = this.capacity.add(BigInteger.valueOf(1000000000L));
                break;
            }
            case 3: {
                tempCapacity = tempCapacity.add(BigInteger.valueOf(10000000000L));
                this.capacity = this.capacity.add(BigInteger.valueOf(10000000000L));
                break;
            }
            case 4: {
                tempCapacity = tempCapacity.add(BigInteger.valueOf(100000000000L));
                this.capacity = this.capacity.add(BigInteger.valueOf(100000000000L));
                break;
            }
            case 5: {
                tempCapacity = tempCapacity.add(BigInteger.valueOf(100000000000L));
                this.capacity = this.capacity.add(MAX_LONG);
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                tempCapacity = tempCapacity.add(BigInteger.valueOf(10000000L));
                this.capacity = this.capacity.add(BigInteger.valueOf(10000000L));
                break;
            }
        }
        return tempCapacity;
    }

    public boolean checkGlassTier(int colourCorrectedMeta, int highestCapacitor) {
        Boolean check = true;
        switch (highestCapacitor) {
            case 0: {
                break;
            }
            case 1: {
                if (colourCorrectedMeta >= highestCapacitor) break;
                check = false;
                break;
            }
            case 2: {
                if (colourCorrectedMeta >= highestCapacitor) break;
                check = false;
                break;
            }
            case 3: {
                if (colourCorrectedMeta >= highestCapacitor) break;
                check = false;
                break;
            }
            case 4: {
                if (colourCorrectedMeta >= highestCapacitor) break;
                check = false;
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            default: {
                check = false;
            }
        }
        return check;
    }

    public void calculateCapacity() {
        this.capacity = BigInteger.ZERO;
        block9: for (int i = 0; i < this.capacitors.length; ++i) {
            switch (i) {
                case 0: {
                    this.capacity = this.capacity.add(BigInteger.valueOf(100000000L).multiply(BigInteger.valueOf(this.capacitors[i])));
                    continue block9;
                }
                case 1: {
                    this.capacity = this.capacity.add(BigInteger.valueOf(1000000000L).multiply(BigInteger.valueOf(this.capacitors[i])));
                    continue block9;
                }
                case 2: {
                    this.capacity = this.capacity.add(BigInteger.valueOf(10000000000L).multiply(BigInteger.valueOf(this.capacitors[i])));
                    continue block9;
                }
                case 3: {
                    this.capacity = this.capacity.add(BigInteger.valueOf(100000000000L).multiply(BigInteger.valueOf(this.capacitors[i])));
                    continue block9;
                }
                case 4: {
                    this.capacity = this.capacity.add(MAX_LONG.multiply(BigInteger.valueOf(this.capacitors[i])));
                    continue block9;
                }
                case 5: {
                    continue block9;
                }
                case 6: {
                    this.capacity = this.capacity.add(BigInteger.valueOf(10000000L).multiply(BigInteger.valueOf(this.capacitors[i])));
                    continue block9;
                }
            }
        }
    }

    public boolean addEnergyInputToMachineList(IGregTechTileEntity te, int aBaseCasingIndex) {
        if (te == null) {
            return false;
        }
        IMetaTileEntity mte = te.getMetaTileEntity();
        if (mte instanceof MetaTileEntity) {
            this.mMaxEUIn += ((MetaTileEntity)mte).maxEUInput() * ((MetaTileEntity)mte).maxAmperesIn();
        }
        if (mte instanceof GT_MetaTileEntity_Hatch_Energy) {
            GT_MetaTileEntity_Hatch_Energy tHatch = (GT_MetaTileEntity_Hatch_Energy)mte;
            tHatch.updateTexture(aBaseCasingIndex);
            return this.mEnergyHatches.add(tHatch);
        }
        if (mte instanceof GT_MetaTileEntity_Hatch_EnergyTunnel) {
            GT_MetaTileEntity_Hatch_EnergyTunnel tHatch = (GT_MetaTileEntity_Hatch_EnergyTunnel)mte;
            return this.mEnergyTunnelsTT.add((GT_MetaTileEntity_Hatch_EnergyTunnel)mte);
        }
        if (mte instanceof GT_MetaTileEntity_Hatch_EnergyMulti) {
            GT_MetaTileEntity_Hatch_EnergyMulti tHatch = (GT_MetaTileEntity_Hatch_EnergyMulti)mte;
            tHatch.updateTexture(aBaseCasingIndex);
            return this.mEnergyHatchesTT.add(tHatch);
        }
        return false;
    }

    public boolean addDynamoToMachineList(IGregTechTileEntity te, int aBaseCasingIndex) {
        if (te == null) {
            return false;
        }
        IMetaTileEntity mte = te.getMetaTileEntity();
        if (mte instanceof MetaTileEntity) {
            this.mMaxEUOut += ((MetaTileEntity)mte).maxEUOutput() * ((MetaTileEntity)mte).maxAmperesOut();
        }
        if (mte instanceof GT_MetaTileEntity_Hatch_Dynamo) {
            GT_MetaTileEntity_Hatch_Dynamo tDynamo = (GT_MetaTileEntity_Hatch_Dynamo)mte;
            tDynamo.updateTexture(aBaseCasingIndex);
            return this.mDynamoHatches.add(tDynamo);
        }
        if (mte instanceof GT_MetaTileEntity_Hatch_DynamoTunnel) {
            GT_MetaTileEntity_Hatch_DynamoTunnel tDynamo = (GT_MetaTileEntity_Hatch_DynamoTunnel)mte;
            return this.mDynamoTunnelsTT.add(tDynamo);
        }
        if (mte instanceof GT_MetaTileEntity_Hatch_DynamoMulti) {
            GT_MetaTileEntity_Hatch_DynamoMulti tDynamo = (GT_MetaTileEntity_Hatch_DynamoMulti)mte;
            tDynamo.updateTexture(aBaseCasingIndex);
            return this.mDynamoHatchesTT.add(tDynamo);
        }
        return false;
    }

    public boolean onRunningTick(ItemStack stack) {
        long power;
        long ttLaserWattage;
        long power2;
        this.inputLastTick = BigInteger.ZERO;
        this.outputLastTick = BigInteger.ZERO;
        for (GT_MetaTileEntity_Hatch_Energy gT_MetaTileEntity_Hatch_Energy : this.mEnergyHatches) {
            if (gT_MetaTileEntity_Hatch_Energy == null || gT_MetaTileEntity_Hatch_Energy.getBaseMetaTileEntity().isInvalidTileEntity()) continue;
            long power22 = this.getPowerToDraw(gT_MetaTileEntity_Hatch_Energy.maxEUInput() * gT_MetaTileEntity_Hatch_Energy.maxAmperesIn());
            if (gT_MetaTileEntity_Hatch_Energy.getEUVar() < power22) continue;
            gT_MetaTileEntity_Hatch_Energy.setEUVar(gT_MetaTileEntity_Hatch_Energy.getEUVar() - power22);
            this.stored = this.stored.add(BigInteger.valueOf(power22));
            this.inputLastTick = this.inputLastTick.add(BigInteger.valueOf(power22));
        }
        for (GT_MetaTileEntity_Hatch_Dynamo gT_MetaTileEntity_Hatch_Dynamo : this.mDynamoHatches) {
            if (gT_MetaTileEntity_Hatch_Dynamo == null || gT_MetaTileEntity_Hatch_Dynamo.getBaseMetaTileEntity().isInvalidTileEntity() || (power2 = this.getPowerToPush(gT_MetaTileEntity_Hatch_Dynamo.maxEUOutput() * gT_MetaTileEntity_Hatch_Dynamo.maxAmperesOut())) > gT_MetaTileEntity_Hatch_Dynamo.maxEUStore() - gT_MetaTileEntity_Hatch_Dynamo.getEUVar()) continue;
            gT_MetaTileEntity_Hatch_Dynamo.setEUVar(gT_MetaTileEntity_Hatch_Dynamo.getEUVar() + power2);
            this.stored = this.stored.subtract(BigInteger.valueOf(power2));
            this.outputLastTick = this.outputLastTick.add(BigInteger.valueOf(power2));
        }
        for (GT_MetaTileEntity_Hatch_EnergyMulti gT_MetaTileEntity_Hatch_EnergyMulti : this.mEnergyHatchesTT) {
            if (gT_MetaTileEntity_Hatch_EnergyMulti == null || gT_MetaTileEntity_Hatch_EnergyMulti.getBaseMetaTileEntity().isInvalidTileEntity()) continue;
            power2 = this.getPowerToDraw(gT_MetaTileEntity_Hatch_EnergyMulti.maxEUInput() * gT_MetaTileEntity_Hatch_EnergyMulti.maxAmperesIn());
            if (gT_MetaTileEntity_Hatch_EnergyMulti.getEUVar() < power2) continue;
            gT_MetaTileEntity_Hatch_EnergyMulti.setEUVar(gT_MetaTileEntity_Hatch_EnergyMulti.getEUVar() - power2);
            this.stored = this.stored.add(BigInteger.valueOf(power2));
            this.inputLastTick = this.inputLastTick.add(BigInteger.valueOf(power2));
        }
        for (GT_MetaTileEntity_Hatch_DynamoMulti gT_MetaTileEntity_Hatch_DynamoMulti : this.mDynamoHatchesTT) {
            if (gT_MetaTileEntity_Hatch_DynamoMulti == null || gT_MetaTileEntity_Hatch_DynamoMulti.getBaseMetaTileEntity().isInvalidTileEntity() || (power2 = this.getPowerToPush(gT_MetaTileEntity_Hatch_DynamoMulti.maxEUOutput() * gT_MetaTileEntity_Hatch_DynamoMulti.maxAmperesOut())) > gT_MetaTileEntity_Hatch_DynamoMulti.maxEUStore() - gT_MetaTileEntity_Hatch_DynamoMulti.getEUVar()) continue;
            gT_MetaTileEntity_Hatch_DynamoMulti.setEUVar(gT_MetaTileEntity_Hatch_DynamoMulti.getEUVar() + power2);
            this.stored = this.stored.subtract(BigInteger.valueOf(power2));
            this.outputLastTick = this.outputLastTick.add(BigInteger.valueOf(power2));
        }
        for (GT_MetaTileEntity_Hatch_EnergyTunnel gT_MetaTileEntity_Hatch_EnergyTunnel : this.mEnergyTunnelsTT) {
            if (gT_MetaTileEntity_Hatch_EnergyTunnel == null || gT_MetaTileEntity_Hatch_EnergyTunnel.getBaseMetaTileEntity().isInvalidTileEntity()) continue;
            ttLaserWattage = gT_MetaTileEntity_Hatch_EnergyTunnel.maxEUInput() * (long)gT_MetaTileEntity_Hatch_EnergyTunnel.Amperes - (long)(gT_MetaTileEntity_Hatch_EnergyTunnel.Amperes / 20);
            power = this.getPowerToDraw(ttLaserWattage);
            if (gT_MetaTileEntity_Hatch_EnergyTunnel.getEUVar() < power) continue;
            gT_MetaTileEntity_Hatch_EnergyTunnel.setEUVar(gT_MetaTileEntity_Hatch_EnergyTunnel.getEUVar() - power);
            this.stored = this.stored.add(BigInteger.valueOf(power));
            this.inputLastTick = this.inputLastTick.add(BigInteger.valueOf(power));
        }
        for (GT_MetaTileEntity_Hatch_DynamoTunnel gT_MetaTileEntity_Hatch_DynamoTunnel : this.mDynamoTunnelsTT) {
            if (gT_MetaTileEntity_Hatch_DynamoTunnel == null || gT_MetaTileEntity_Hatch_DynamoTunnel.getBaseMetaTileEntity().isInvalidTileEntity() || (power = this.getPowerToPush(ttLaserWattage = gT_MetaTileEntity_Hatch_DynamoTunnel.maxEUOutput() * (long)gT_MetaTileEntity_Hatch_DynamoTunnel.Amperes - (long)(gT_MetaTileEntity_Hatch_DynamoTunnel.Amperes / 20))) > gT_MetaTileEntity_Hatch_DynamoTunnel.maxEUStore() - gT_MetaTileEntity_Hatch_DynamoTunnel.getEUVar()) continue;
            gT_MetaTileEntity_Hatch_DynamoTunnel.setEUVar(gT_MetaTileEntity_Hatch_DynamoTunnel.getEUVar() + power);
            this.stored = this.stored.subtract(BigInteger.valueOf(power));
            this.outputLastTick = this.outputLastTick.add(BigInteger.valueOf(power));
        }
        if (super.getRepairStatus() != this.repairStatusCache) {
            this.passiveDischargeAmount = this.recalculateLossWithMaintenance(super.getRepairStatus());
        }
        this.stored = this.stored.subtract(this.passiveDischargeAmount);
        this.stored = this.stored.compareTo(BigInteger.ZERO) <= 0 ? BigInteger.ZERO : this.stored;
        IGregTechTileEntity tBMTE = this.getBaseMetaTileEntity();
        tBMTE.injectEnergyUnits((byte)ForgeDirection.UNKNOWN.ordinal(), this.inputLastTick.longValue(), 1L);
        tBMTE.drainEnergyUnits((byte)ForgeDirection.UNKNOWN.ordinal(), this.outputLastTick.longValue(), 1L);
        return true;
    }

    private BigInteger recalculateLossWithMaintenance(int repairStatus) {
        this.repairStatusCache = repairStatus;
        return new BigDecimal(this.passiveDischargeAmount).multiply(BigDecimal.valueOf(1.0 + 0.2 * (double)repairStatus)).toBigInteger();
    }

    private long getPowerToDraw(long hatchWatts) {
        BigInteger remcapActual = this.capacity.subtract(this.stored);
        BigInteger recampLimited = MAX_LONG.compareTo(remcapActual) > 0 ? remcapActual : MAX_LONG;
        return Math.min(hatchWatts, recampLimited.longValue());
    }

    private long getPowerToPush(long hatchWatts) {
        BigInteger remStoredLimited = MAX_LONG.compareTo(this.stored) > 0 ? this.stored : MAX_LONG;
        return Math.min(hatchWatts, remStoredLimited.longValue());
    }

    public String[] getInfoData() {
        IGregTechTileEntity tGTTE = this.getBaseMetaTileEntity();
        ArrayList<String> ll = new ArrayList<String>();
        ll.add(EnumChatFormatting.YELLOW + "Operational Data:" + EnumChatFormatting.RESET);
        ll.add("Used Capacity: " + NumberFormat.getNumberInstance().format(this.stored) + "EU");
        ll.add("Total Capacity: " + NumberFormat.getNumberInstance().format(this.capacity) + "EU");
        ll.add("Passive Loss: " + NumberFormat.getNumberInstance().format(this.passiveDischargeAmount) + "EU/t");
        ll.add("EU IN: " + NumberFormat.getNumberInstance().format(this.inputLastTick) + "EU/t");
        ll.add("EU OUT: " + NumberFormat.getNumberInstance().format(this.outputLastTick) + "EU/t");
        ll.add("Avg EU IN: " + NumberFormat.getNumberInstance().format(tGTTE.getAverageElectricInput()));
        ll.add("Avg EU OUT: " + NumberFormat.getNumberInstance().format(tGTTE.getAverageElectricOutput()));
        ll.add("Maintenance Status: " + (super.getRepairStatus() == super.getIdealStatus() ? EnumChatFormatting.GREEN + "Working perfectly" + EnumChatFormatting.RESET : EnumChatFormatting.RED + "Has Problems" + EnumChatFormatting.RESET));
        ll.add("---------------------------------------------");
        String[] a = new String[ll.size()];
        return ll.toArray(a);
    }

    public void saveNBTData(NBTTagCompound nbt) {
        nbt = nbt == null ? new NBTTagCompound() : nbt;
        nbt.func_74773_a("capacity", this.capacity.toByteArray());
        nbt.func_74773_a("stored", this.stored.toByteArray());
        nbt.func_74773_a("passiveDischargeAmount", this.passiveDischargeAmount.toByteArray());
        super.saveNBTData(nbt);
    }

    public void loadNBTData(NBTTagCompound nbt) {
        nbt = nbt == null ? new NBTTagCompound() : nbt;
        this.capacity = new BigInteger(nbt.func_74770_j("capacity"));
        this.stored = new BigInteger(nbt.func_74770_j("stored"));
        this.passiveDischargeAmount = new BigInteger(nbt.func_74770_j("passiveDischargeAmount"));
        super.loadNBTData(nbt);
    }

    public boolean isGivingInformation() {
        return true;
    }

    public int getMaxEfficiency(ItemStack stack) {
        return 10000;
    }

    public int getPollutionPerTick(ItemStack stack) {
        return 0;
    }

    public int getDamageToComponent(ItemStack stack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack stack) {
        return false;
    }

    public long maxEUStore() {
        return this.capacity.longValue();
    }

    public long getEUVar() {
        return this.stored.longValue();
    }

    public long maxEUInput() {
        return this.mMaxEUIn;
    }

    public long maxAmperesIn() {
        return 1L;
    }

    public long maxEUOutput() {
        return this.mMaxEUOut;
    }

    public long maxAmperesOut() {
        return 1L;
    }

    public boolean isEnetInput() {
        return true;
    }

    public boolean isEnetOutput() {
        return true;
    }
}

