/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;

public class MultiBlockTooltipBuilder {
    private static final String TAB = "   ";
    private static final String COLON = ": ";
    private final List<String> iLines = new LinkedList<String>();
    private final List<String> sLines = new LinkedList<String>();
    private String[] iArray;
    private String[] sArray;
    private static final String KW_dimensions = StatCollector.func_74838_a((String)"mbdesc.beginStructureBlock.Dimensions");
    private static final String KW_structure = StatCollector.func_74838_a((String)"mbdesc.beginStructureBlock.Structure");
    private static final String KW_controller = StatCollector.func_74838_a((String)"mbdesc.addController.Controller");
    private static final String KW_atleast = StatCollector.func_74838_a((String)"mbdesc.addCasing.atleast");
    private static final String KW_energyhatch = StatCollector.func_74838_a((String)"mbdesc.addEnergyHatch.EnergyHatch");
    private static final String KW_dynamohatch = StatCollector.func_74838_a((String)"mbdesc.addDynamoHatch.DynamoHatch");
    private static final String KW_maintenancehatch = StatCollector.func_74838_a((String)"mbdesc.addMaintenanceHatch.MaintenanceHatch");
    private static final String KW_iohatches = StatCollector.func_74838_a((String)"mbdesc.addIOHatches.IOHatches");
    private static final String KW_inputbus = StatCollector.func_74838_a((String)"mbdesc.addInputBus.InputBus");
    private static final String KW_inputhatch = StatCollector.func_74838_a((String)"mbdesc.addInputHatch.InputHatch");
    private static final String KW_outputbus = StatCollector.func_74838_a((String)"mbdesc.addOutputBus.OutputBus");
    private static final String KW_outputhatch = StatCollector.func_74838_a((String)"mbdesc.addOutputHatch.OutputHatch");
    private static final String KW_hold = StatCollector.func_74838_a((String)"mbdesc.signAndFinalize.Hold");
    private static final String KW_todisplay = StatCollector.func_74838_a((String)"mbdesc.signAndFinalize.todisplay");
    private static final String KW_createdby = StatCollector.func_74838_a((String)"mbdesc.signAndFinalize.createdby");

    public MultiBlockTooltipBuilder addInfo(String info) {
        this.iLines.add(info);
        return this;
    }

    public MultiBlockTooltipBuilder addSeparator() {
        this.iLines.add("-----------------------------------------");
        return this;
    }

    public MultiBlockTooltipBuilder beginStructureBlock(int w, int h, int l) {
        this.sLines.add(KW_dimensions + COLON + w + "x" + h + "x" + l + " (WxHxL)");
        this.sLines.add(KW_structure + COLON);
        return this;
    }

    public MultiBlockTooltipBuilder addController(String info) {
        this.sLines.add(TAB + KW_controller + COLON + info);
        return this;
    }

    public MultiBlockTooltipBuilder addCasingInfo(String casingName, int minCount) {
        this.sLines.add(TAB + minCount + "x " + casingName + " " + KW_atleast);
        return this;
    }

    public MultiBlockTooltipBuilder addEnergyHatch(String info) {
        this.sLines.add(TAB + KW_energyhatch + COLON + info);
        return this;
    }

    public MultiBlockTooltipBuilder addDynamoHatch(String info) {
        this.sLines.add(TAB + KW_dynamohatch + COLON + info);
        return this;
    }

    public MultiBlockTooltipBuilder addMaintenanceHatch(String info) {
        this.sLines.add(TAB + KW_maintenancehatch + COLON + info);
        return this;
    }

    public MultiBlockTooltipBuilder addIOHatches(String info) {
        this.sLines.add(TAB + KW_iohatches + COLON + info);
        return this;
    }

    public MultiBlockTooltipBuilder addInputBus(String info) {
        this.sLines.add(TAB + KW_inputbus + COLON + info);
        return this;
    }

    public MultiBlockTooltipBuilder addInputHatch(String info) {
        this.sLines.add(TAB + KW_inputhatch + COLON + info);
        return this;
    }

    public MultiBlockTooltipBuilder addOutputBus(String info) {
        this.sLines.add(TAB + KW_outputbus + COLON + info);
        return this;
    }

    public MultiBlockTooltipBuilder addOutputHatch(String info) {
        this.sLines.add(TAB + KW_outputhatch + COLON + info);
        return this;
    }

    public MultiBlockTooltipBuilder addOtherStructurePart(String name, String info) {
        this.sLines.add(TAB + name + COLON + info);
        return this;
    }

    public void signAndFinalize(String author) {
        this.iLines.add(KW_hold + " " + EnumChatFormatting.BOLD + "[LSHIFT]" + EnumChatFormatting.RESET + EnumChatFormatting.GRAY + " " + KW_todisplay);
        this.iLines.add(KW_createdby + " " + author);
        this.iArray = new String[this.iLines.size()];
        this.sArray = new String[this.sLines.size()];
        this.iLines.toArray(this.iArray);
        this.sLines.toArray(this.sArray);
    }

    public String[] getInformation() {
        return this.iArray;
    }

    public String[] getStructureInformation() {
        return this.sArray;
    }
}

