/*
 * Decompiled with CFR 0.152.
 */
package kekztech;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fluids.FluidStack;

public class MultiFluidHandler {
    public static final int MAX_DISTINCT_FLUIDS = 25;
    private final List<FluidStack> fluids = new ArrayList<FluidStack>(25);
    private int capacityPerFluid;
    private boolean locked = true;
    private boolean doVoidExcess = false;
    private byte fluidSelector = (byte)-1;

    public MultiFluidHandler() {
    }

    public MultiFluidHandler(int capacityPerFluid) {
        this.capacityPerFluid = capacityPerFluid;
    }

    public MultiFluidHandler(int capacityPerFluid, List<FluidStack> fluids) {
        this.capacityPerFluid = capacityPerFluid;
        this.fluids.addAll(fluids);
    }

    public void setLock(boolean state) {
        this.locked = state;
    }

    public void setDoVoidExcess(boolean doVoidExcess) {
        this.doVoidExcess = doVoidExcess;
    }

    public void setFluidSelector(byte fluidSelector) {
        this.fluidSelector = fluidSelector;
    }

    public byte getSelectedFluid() {
        return this.fluidSelector;
    }

    public boolean contains(FluidStack fluid) {
        return !this.locked && this.fluids.contains(fluid);
    }

    public int getCapacity() {
        return this.capacityPerFluid;
    }

    public List<FluidStack> getFluids() {
        return !this.locked ? this.fluids : new ArrayList<FluidStack>();
    }

    public FluidStack getFluid(int slot) {
        return !this.locked && this.fluids.size() > 0 && slot >= 0 && slot < 25 ? this.fluids.get(slot) : null;
    }

    public NBTTagCompound saveNBTData(NBTTagCompound nbt) {
        nbt = nbt == null ? new NBTTagCompound() : nbt;
        nbt.func_74768_a("capacityPerFluid", this.getCapacity());
        int c = 0;
        for (FluidStack f : this.fluids) {
            nbt.func_74782_a("" + c, (NBTBase)f.writeToNBT(new NBTTagCompound()));
            ++c;
        }
        return nbt;
    }

    public void loadNBTData(NBTTagCompound nbt) {
        NBTTagCompound fnbt;
        nbt = nbt == null ? new NBTTagCompound() : nbt;
        this.capacityPerFluid = nbt.func_74762_e("capacityPerFluid");
        this.fluids.clear();
        NBTTagCompound fluidsTag = (NBTTagCompound)nbt.func_74781_a("fluids");
        for (int i = 0; i < 25 && (fnbt = (NBTTagCompound)fluidsTag.func_74781_a("" + i)) != null; ++i) {
            this.fluids.add(FluidStack.loadFluidStackFromNBT((NBTTagCompound)fnbt));
        }
    }

    public ArrayList<String> getInfoData() {
        ArrayList<String> lines = new ArrayList<String>(this.fluids.size());
        lines.add(EnumChatFormatting.YELLOW + "Stored Fluids:" + EnumChatFormatting.RESET);
        for (int i = 0; i < this.fluids.size(); ++i) {
            lines.add(i + " - " + this.fluids.get(i).getLocalizedName() + ": " + this.fluids.get((int)i).amount + "L (" + Math.round(100.0f * (float)this.fluids.get((int)i).amount / (float)this.getCapacity()) + "%)");
        }
        return lines;
    }

    public int pushFluid(FluidStack push, boolean doPush) {
        if (this.locked) {
            return 0;
        }
        if (this.fluids.size() == 25 && !this.contains(push)) {
            return 0;
        }
        if (this.fluids.size() < 25 && !this.contains(push)) {
            int fit = Math.min(this.getCapacity(), push.amount);
            if (doPush) {
                this.fluids.add(new FluidStack(push.getFluid(), fit));
            }
            return this.doVoidExcess ? push.amount : fit;
        }
        FluidStack existing = this.fluids.get(this.fluids.indexOf(push));
        int fit = Math.min(this.getCapacity() - existing.amount, push.amount);
        if (doPush) {
            existing.amount += fit;
        }
        return this.doVoidExcess ? push.amount : fit;
    }

    public int pushFluid(FluidStack push, int slot, boolean doPush) {
        if (this.locked) {
            return 0;
        }
        if (slot < 0 || slot >= 25) {
            return 0;
        }
        if (this.fluids.get(slot) != null && !this.fluids.get(slot).equals((Object)push)) {
            return 0;
        }
        FluidStack existing = this.fluids.get(slot);
        int fit = Math.min(this.getCapacity() - existing.amount, push.amount);
        if (doPush) {
            existing.amount += fit;
        }
        return this.doVoidExcess ? push.amount : fit;
    }

    public int pullFluid(FluidStack pull, boolean doPull) {
        if (this.locked || !this.contains(pull)) {
            return 0;
        }
        FluidStack src = this.fluids.get(this.fluids.indexOf(pull));
        int rec = Math.min(pull.amount, src.amount);
        if (doPull) {
            src.amount -= rec;
        }
        if (src.amount == 0) {
            this.fluids.remove(src);
        }
        return rec;
    }

    public int pullFluid(FluidStack pull, int slot, boolean doPull) {
        if (this.locked) {
            return 0;
        }
        if (slot < 0 || slot >= 25) {
            return 0;
        }
        if (!this.fluids.get(slot).equals((Object)pull)) {
            return 0;
        }
        FluidStack src = this.fluids.get(slot);
        int rec = Math.min(pull.amount, src.amount);
        if (doPull) {
            src.amount -= rec;
        }
        if (src.amount == 0) {
            this.fluids.remove(src);
        }
        return rec;
    }

    public boolean couldPush(FluidStack push) {
        if (this.locked) {
            return false;
        }
        if (this.fluids.size() == 25 && !this.contains(push)) {
            return false;
        }
        if (this.fluids.size() < 25 && !this.contains(push)) {
            return Math.min(this.getCapacity(), push.amount) > 0;
        }
        int remcap = this.getCapacity() - this.fluids.get((int)this.fluids.indexOf((Object)push)).amount;
        return this.doVoidExcess ? true : Math.min(remcap, push.amount) > 0;
    }
}

