/*
 * Decompiled with CFR 0.152.
 */
package common.tileentities;

import common.Blocks;
import java.util.List;
import kekztech.MultiFluidHandler;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TE_TFFTMultiHatch
extends TileEntity
implements IFluidHandler {
    private static final int OUTPUT_PER_SECOND = 1000;
    private MultiFluidHandler mfh;
    private int tickCounter = 0;
    private boolean autoOutput = false;

    public void setMultiFluidHandler(MultiFluidHandler mfh) {
        this.mfh = mfh;
    }

    public void toggleAutoOutput() {
        this.autoOutput = !this.autoOutput;
    }

    public boolean isOutputting() {
        return this.autoOutput;
    }

    public void func_145845_h() {
        if (!this.autoOutput || this.mfh == null) {
            return;
        }
        ++this.tickCounter;
        if (this.tickCounter >= 20) {
            ForgeDirection d = this.getOutwardsFacingDirection();
            if (d == ForgeDirection.UNKNOWN) {
                return;
            }
            TileEntity t = this.func_145831_w().func_147438_o(this.field_145851_c + d.offsetX, this.field_145848_d + d.offsetY, this.field_145849_e + d.offsetZ);
            if (t instanceof IFluidHandler) {
                IFluidHandler fh = (IFluidHandler)t;
                for (FluidStack volume : this.mfh.getFluids()) {
                    int oVolume = volume.amount;
                    if (!fh.canFill(d.getOpposite(), volume.getFluid())) continue;
                    FluidStack copy = volume.copy();
                    copy.amount = Math.min(copy.amount, 1000);
                    copy.amount = this.mfh.pullFluid(copy, false);
                    copy.amount = fh.fill(d.getOpposite(), copy, true);
                    this.mfh.pullFluid(copy, true);
                    if (copy.amount < oVolume) continue;
                    break;
                }
            }
            this.tickCounter = 0;
        }
    }

    private ForgeDirection getOutwardsFacingDirection() {
        for (ForgeDirection direction : ForgeDirection.values()) {
            Block b = this.func_145831_w().func_147439_a(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ);
            if (b == null || !b.equals(Blocks.tfftStorageField1) && !b.equals(Blocks.tfftStorageField2) && !b.equals(Blocks.tfftStorageField3) && !b.equals(Blocks.tfftStorageField4) && !b.equals(Blocks.tfftStorageField5)) continue;
            return direction.getOpposite();
        }
        return ForgeDirection.UNKNOWN;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.mfh != null ? this.mfh.pushFluid(resource, doFill) : 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.mfh != null ? new FluidStack(resource.getFluid(), this.mfh.pullFluid(resource, doDrain)) : null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        FluidStack drain;
        if (this.mfh != null && (drain = this.mfh.getFluid(0)) != null) {
            byte selectedSlot = this.mfh.getSelectedFluid() == -1 ? (byte)0 : this.mfh.getSelectedFluid();
            return new FluidStack(drain.getFluid(), this.mfh.pullFluid(new FluidStack(drain.getFluid(), maxDrain), selectedSlot, doDrain));
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.mfh != null && this.mfh.couldPush(new FluidStack(fluid, 1));
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.mfh != null && this.mfh.contains(new FluidStack(fluid, 1));
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (this.mfh == null) {
            return null;
        }
        List<FluidStack> fluids = this.mfh.getFluids();
        FluidTankInfo[] tankInfo = new FluidTankInfo[fluids.size()];
        for (int i = 0; i < tankInfo.length; ++i) {
            tankInfo[i] = new FluidTankInfo(fluids.get(i), this.mfh.getCapacity());
        }
        return tankInfo;
    }

    public void func_145841_b(NBTTagCompound nbt) {
        nbt = nbt == null ? new NBTTagCompound() : nbt;
        nbt.func_74757_a("autoOutput", this.autoOutput);
        super.func_145841_b(nbt);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        nbt = nbt == null ? new NBTTagCompound() : nbt;
        this.autoOutput = nbt.func_74767_n("autoOutput");
        super.func_145839_a(nbt);
    }
}

